//
// Part of the Content Management System by Declan Brennan ( http://sites.declan.brennan.name )
// Available subject to the conditions in http://www.voyagers.ie/license.htm .
//
using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml;

public partial class _Rss : System.Web.UI.Page 
{
    protected void Page_Load(object sender, EventArgs e)
    {
        string voyagersie = "http://voyagers.ie";
        // string voyagersie = "http://beta-149740.server1.dotnetsandbox.net";

        XmlDocument doc = new XmlDocument();
        doc.LoadXml(
            "<?xml version='1.0' encoding='utf-8'?>\n"+
            "<?xml-stylesheet type='text/xsl' href='rssformat.xsl' version='1.0'?>\n"+
            "<rss xmlns:dc='http://purl.org/dc/elements/1.1/' version='2'>\n"+
            "<channel>\n"+
            "  <title>Voyagers' New Content</title>\n"+
            "  <description>Galleries,Resources,Articles and Links recently added to the Voyagers' site</description>\n"+
            "  <pubDate>Sat, 17 Sept 2005</pubDate>\n"+
            "  <lastBuildDate></lastBuildDate>\n"+
            "  <link>"+voyagersie+"</link>\n"+
            "  <image>\n"+
            "    <title>Voyagers Canoe Club</title>\n"+
            "    <url>"+voyagersie+"/VoyagersSmallLogo.gif</url>\n"+
            "    <width>172</width>\n"+
            "    <height>40</height>\n"+
            "    <link>"+voyagersie+"</link>\n"+
            "  </image>\n"+
            "</channel>\n"+
            "</rss>");

        XmlNode lastBuildDate = doc.SelectSingleNode("/rss/channel/lastBuildDate");
        lastBuildDate.InnerText = System.DateTime.Today.ToString("ddd dd MMMM yyyy");

        System.Collections.ArrayList items = new System.Collections.ArrayList();
        DataAccess.GetDataAsXml(Server, 3, "SELECT TOP 3 'Gallery: '+Title,Description,CreatedOn,UserID,'" + voyagersie + "/gallery.aspx?GalleryId='+Trim(Str(GalleryId)) FROM Gallery LEFT OUTER JOIN Member ON Member.MemberId=Gallery.CreatedBy ORDER BY CreatedOn DESC", doc, items, "item", new string[] { "title", "description", "pubDate", "dc:creator", "link" });
        DataAccess.GetDataAsXml(Server, 3, "SELECT TOP 3 'Event: '+Title,'' As Description,CreatedOn,UserID,'" + voyagersie + "/event.aspx?EventId='+Trim(Str(EventId)) FROM Event LEFT OUTER JOIN Member ON Member.MemberId=Event.CreatedBy ORDER BY CreatedOn DESC", doc, items, "item", new string[] { "title", "description", "pubDate", "dc:creator", "link" });
        DataAccess.GetDataAsXml(Server, 3, "SELECT TOP 3 'Link: '+Title,Description,CreatedOn,UserID,Url FROM Link LEFT OUTER JOIN Member ON Member.MemberId=Link.CreatedBy ORDER BY CreatedOn DESC", doc, items, "item", new string[] { "title", "description", "pubDate", "dc:creator", "link" });
        DataAccess.GetDataAsXml(Server, 3, "SELECT TOP 3 'Resource: '+Title,Description,CreatedOn,UserID,'" + voyagersie + "/Resources.aspx?ResourceId='+Trim(Str(ArticleId)) FROM Article LEFT OUTER JOIN Member ON Member.MemberId=Article.CreatedBy ORDER BY CreatedOn DESC", doc, items, "item", new string[] { "title", "description", "pubDate", "dc:creator", "link" });
        items.Sort(new DataAccess.ItemComparer());
        foreach (DataAccess.Item item in items)
        {
            doc.DocumentElement.FirstChild.AppendChild(item.Element);
        }

        Response.Clear();
        Response.ContentType = "text/xml";
        doc.Save(Response.OutputStream);
    }


 
}