<%@ Control Language="C#" ClassName="SideBarDetails" %>
<%@ OutputCache Duration="100" VaryByParam="None" %>


<script runat="server">
    //
    // Part of the Content Management System by Declan Brennan ( http://sites.declan.brennan.name )
    // Available subject to the conditions in http://www.voyagers.ie/license.htm .
    //

    // This part of SideBar is split out from SideBar so we can cache it
    // We can't cache the whole of SideBar or our Search button won't work most of the time
    
    protected void Page_Load(object sender, EventArgs e)
    {
        /*
        Response.AddCacheDependency(new SideBarCacheDependency());
        // Set additional properties to enable caching.
        Response.Cache.SetExpires(DateTime.Now.AddSeconds(60));
        Response.Cache.SetCacheability(HttpCacheability.Public);
        Response.Cache.SetValidUntilExpires(true);
        */
        if (this.CachePolicy.Dependency==null)
           this.CachePolicy.Dependency = new SideBarCacheDependency();
    }

</script>

<a href="rss.aspx">
    <img border="0" title="News Feed" src="rss_button.gif" /></a>
<fieldset title="Forthcoming Events">
    <legend>What's On</legend>
    <asp:AccessDataSource ID="AccessDataSource1" runat="server" DataFile="~/App_Data/voyagers.mdb"
        SelectCommand="SELECT TOP 6 [EventId], [Title],Description,[Starts] FROM [Event] WHERE [Starts]>=DATE() ORDER BY [Starts]">
    </asp:AccessDataSource>
    <asp:GridView SkinID="MostRecent" PageSize="5" PagerStyle-CssClass="hide" Width="100%"
        ID="GridView1" runat="server" DataSourceID="AccessDataSource1">
        <Columns>
            <asp:TemplateField>
                <ItemTemplate>
                    <asp:HyperLink ID="HyperLink1" CssClass="mostRecentLink" runat="server" NavigateUrl='<%# Eval("EventId", "Event.aspx?EventId={0}") %>'
                         Text='<%# Eval("Title") %>'></asp:HyperLink>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:BoundField DataField="Starts" DataFormatString="{0:ddd dd MMM yy}" HtmlEncode="false">
                <ItemStyle HorizontalAlign="Right" />
            </asp:BoundField>
        </Columns>
        <RowStyle BorderStyle="None" />
        <PagerStyle CssClass="hide" />
        <EmptyDataTemplate>
            Nothing
        </EmptyDataTemplate>
    </asp:GridView>
</fieldset>
<br />
<fieldset title="Content recently added to the site">
    <legend>What's New</legend>
    <h2 class="sideHeading">
        Galleries</h2>
    <asp:AccessDataSource ID="AccessDataSource2" runat="server" DataFile="~/App_Data/voyagers.mdb"
        SelectCommand="SELECT TOP 3 [GalleryId], [Title],[Description] FROM [Gallery] ORDER BY [CreatedOn] DESC">
    </asp:AccessDataSource>
    <asp:GridView SkinID="MostRecent" PagerStyle-CssClass="hide" Width="100%" ID="GridView5"
        runat="server" DataSourceID="AccessDataSource2">
        <Columns>
            <asp:TemplateField>
                <ItemTemplate>
                    <asp:HyperLink CssClass="mostRecentLink" ID="HyperLink1" runat="server" NavigateUrl='<%# Eval("GalleryId", "Gallery.aspx?GalleryId={0}") %>'
                        ToolTip='<%# Eval("Description")%>' Text='<%# Eval("Title") %>'></asp:HyperLink>
                </ItemTemplate>
            </asp:TemplateField>
        </Columns>
        <RowStyle BorderStyle="None" />
        <PagerStyle CssClass="hide" />
    </asp:GridView>
    <a style="font-size: smaller" href="ListGalleries.aspx">More...</a><br />
    <br />
    <asp:AccessDataSource ID="AccessDataSource5" runat="server" DataFile="~/App_Data/voyagers.mdb"
        SelectCommand="SELECT TOP 3 [ArticleId], [Title],[Description] FROM [Article] ORDER BY [CreatedOn] DESC">
    </asp:AccessDataSource>
    <h2 class="sideHeading">
        Resources</h2>
    <asp:GridView SkinID="MostRecent" PagerStyle-CssClass="hide" Width="100%" ID="GridView3"
        runat="server" DataSourceID="AccessDataSource5">
        <Columns>
            <asp:TemplateField>
                <ItemTemplate>
                    <asp:HyperLink ID="HyperLink1" CssClass="mostRecentLink" runat="server" NavigateUrl='<%# Eval("ArticleId", "Resources.aspx?ResourceId={0}") %>'
                        ToolTip='<%# Eval("Description") %>' Text='<%# Eval("Title") %>'></asp:HyperLink>
                </ItemTemplate>
            </asp:TemplateField>
        </Columns>
        <RowStyle BorderStyle="None" />
        <PagerStyle CssClass="hide" />
    </asp:GridView>
    <a style="font-size: smaller" href="Resources.aspx">More...</a><br />
    <br />
    <asp:AccessDataSource ID="AccessDataSource6" runat="server" DataFile="~/App_Data/voyagers.mdb"
        SelectCommand="SELECT TOP 3 Title,Description, [Url] FROM [Link] ORDER BY [CreatedOn] DESC">
    </asp:AccessDataSource>
    <h2 class="sideHeading">
        Links</h2>
    <asp:GridView SkinID="MostRecent" PagerStyle-CssClass="hide" Width="100%" ID="GridView6"
        runat="server" DataSourceID="AccessDataSource6">
        <Columns>
            <asp:TemplateField>
                <ItemTemplate>
                    <asp:HyperLink ID="HyperLink1" CssClass="mostRecentLink" runat="server" NavigateUrl='<%# Eval("Url", "{0}") %>'
                        ToolTip='<%# Eval("Description") %>' Text='<%# Eval("Title") %>'></asp:HyperLink>
                </ItemTemplate>
            </asp:TemplateField>
        </Columns>
        <RowStyle BorderStyle="None" />
        <PagerStyle CssClass="hide" />
    </asp:GridView>
    <a style="font-size: smaller" href="ListLinks.aspx">More...</a><br />
    <br />
    <h2 class="sideHeading">
        Events</h2>
    <asp:AccessDataSource ID="AccessDataSource3" runat="server" DataFile="~/App_Data/voyagers.mdb"
        SelectCommand="SELECT TOP 3 [EventId], [Title],[Description],[Starts] FROM [Event] ORDER BY [CreatedOn] DESC">
    </asp:AccessDataSource>
    <asp:GridView SkinID="MostRecent" PagerStyle-CssClass="hide" Width="100%" ID="GridView2"
        runat="server" DataSourceID="AccessDataSource3">
        <Columns>
            <asp:TemplateField>
                <ItemTemplate>
                    <asp:HyperLink ID="HyperLink1" CssClass="mostRecentLink" runat="server" NavigateUrl='<%# Eval("EventId", "Event.aspx?EventId={0}") %>'
                        Text='<%# Eval("Title") %>'></asp:HyperLink>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:BoundField DataField="Starts" DataFormatString="{0:ddd dd MMM yy}" HtmlEncode="false">
                <ItemStyle HorizontalAlign="Right" />
            </asp:BoundField>
        </Columns>
        <RowStyle BorderStyle="None" />
        <PagerStyle CssClass="hide" />
    </asp:GridView>
    <a style="font-size: smaller" href="ListEvents.aspx">More...</a><br />
    <br />
</fieldset>
