<%@ Page Language="C#" MasterPageFile="~/Default.master" %>

<script runat="server">
    //
    // Part of the Content Management System by Declan Brennan ( http://sites.declan.brennan.name )
    // Available subject to the conditions in http://www.voyagers.ie/license.htm .
    //

    private string SendSMS(string phoneNum,string text)
    {
        System.Text.RegularExpressions.Regex re= new System.Text.RegularExpressions.Regex("[^0-9]");
        phoneNum= re.Replace(phoneNum,"");
        
        if (phoneNum.StartsWith("00"))
            phoneNum = phoneNum.Substring(2);
        else
        {
            if (phoneNum.StartsWith("0"))
                phoneNum = phoneNum.Substring(1);
            if (!phoneNum.StartsWith("353"))
                phoneNum = "353" + phoneNum;
        }

        string s = "";
        try
        {
            System.Net.WebClient client = new System.Net.WebClient();
            client.Headers.Add("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.2; .NET CLR1.0.3705;)");
            client.QueryString.Add("user", "[ENTER USER HERE]");
            client.QueryString.Add("password", "[ENTER PASSWORD HERE]");
            client.QueryString.Add("api_id", "[ENTER API IDENTIFIER HERE]");
            client.QueryString.Add("to", phoneNum);
            client.QueryString.Add("text", text);
            string baseurl = "http://api.clickatell.com/http/sendmsg";
            System.IO.Stream data = client.OpenRead(baseurl);
            System.IO.StreamReader reader = new System.IO.StreamReader(data);
            s = reader.ReadToEnd();
            data.Close();
            reader.Close();
            if (s.StartsWith("ID"))
                s = "Message sent successfully";
            else
                s = "Error: " + s;
        }
        catch (Exception ex)
        {
            s = "Error: " + ex.Message;
        }
        return s+".";
    }

    private string SendGroupSMS(string group, string text)
    {
        if (group == "Members")
            group= "";
        else
            group = " and "+group;
        string rc= "";
        foreach (string phoneNum in GroupMailer.GetList(this.Server, "Activated and Not(NoMobilePhoneMessages)"+group, "MobilePhone").ToArray())
        {
            if (phoneNum.Trim().Length == 0)
                continue;
            rc = SendSMS(phoneNum, text);
            if (rc.StartsWith("Error"))
                break;
        }
        return rc;
    }
    
    protected void Button1_Click(object sender, EventArgs e)
    {
        object[] rc = DataAccess.GetData(Server, "SELECT MobilePhone,UserId FROM Member WHERE MemberId=@MemberId","@MemberId",Session["MemberId"]);

        string prefix = String.Format("{0}@Voyagers ({1}):\n",rc[1],rc[0]);
        
        if (this.Multiview2.ActiveViewIndex == 0)
        {
            Result.Text = SendGroupSMS("WantRiverInvites", prefix+Message.Text);
        }
        else
            Result.Text = SendSMS(PhoneNum.Value, prefix+Message.Text);
        MultiView1.ActiveViewIndex = 1;

    }

    protected string Remember(string p)
    {
        PhoneNum.Value = p;
        return p;
    }

    protected void FormView1_Load(object sender, EventArgs e)
    {
        if (Request.QueryString["MemberId"] != null)
            this.Multiview2.ActiveViewIndex = 1;
    }
</script>

<asp:Content ID="Content1" runat="server" ContentPlaceHolderId="ContentPlaceHolder1">
    <asp:MultiView ID="MultiView1" runat="server" ActiveViewIndex="0">
        <asp:View ID="View1" runat="server">
    
        <asp:Multiview ID="Multiview2" runat="server" ActiveViewIndex="0" >
        <asp:View ID="view21" runat="server" >
        <span class="label">Note:</span><br />You are about to send a <i>group</i> text. If you want to send a text to a single member,
        you can do so by calling up the individual's membership details and choosing the link next to the mobile phone number.<br /><br />
        <span class="label">WARNING:</span><br />This facility should only be used for <u>urgent</u>
         messages to do with river paddling. The message will be sent to everybody in the "Want River Invites" group who isn't refusing mobile phone messages.<br /><br />
    <asp:DropDownList ID="GroupName" Visible="false" runat="server">
        <asp:ListItem>WantRiverInvites</asp:ListItem>
        <asp:ListItem>Members</asp:ListItem>
        <asp:ListItem>Social</asp:ListItem>
        <asp:ListItem>Admin</asp:ListItem>
        <asp:ListItem>Info</asp:ListItem>
    </asp:DropDownList>
    <br />
        </asp:View>
        <asp:View ID="view22" runat="server" >
            <asp:AccessDataSource ID="AccessDataSource1" runat="server" DataFile="~/App_Data/voyagers.mdb"
                SelectCommand="SELECT [Surname], [Forename], [MobilePhone] FROM [Member] WHERE ([MemberId] = ?)">
                <SelectParameters>
                    <asp:QueryStringParameter Name="MemberId" QueryStringField="MemberId" Type="Int32" />
                </SelectParameters>
            </asp:AccessDataSource>
            <asp:FormView Width="100%" ID="FormView1" runat="server" DataSourceID="AccessDataSource1" OnLoad="FormView1_Load">
                <ItemTemplate>
                    You are about to send a text to <asp:Literal ID="SurnameLiteral" runat="server" Text='<%# Eval("Forename")+" "+Eval("Surname") %>'></asp:Literal>
                    at phone number: 
                    <asp:Literal ID="MobilePhoneLabel" runat="server" Text='<%# Remember((string)Eval("MobilePhone")) %>'>
                    </asp:Literal>.<br />
                </ItemTemplate>
            </asp:FormView>
        
        </asp:View>
        </asp:Multiview>    
    
    <span class="label">Message:</span>
    <br />
    <asp:TextBox ID="Message" runat="server" TextMode="MultiLine" Width="100%" MaxLength="250" Rows="3"></asp:TextBox>
    <br />
    <asp:Button ID="Button1" runat="server" Text="Send" OnClick="Button1_Click" /></asp:View>
            <asp:View ID="View2" runat="server">
                <asp:Label ID="Result" runat="server"></asp:Label>
            </asp:View>
    </asp:MultiView>
    <asp:HiddenField ID="PhoneNum" runat="server" />
</asp:Content>