<%@ Page Language="C#" MasterPageFile="~/Default.master" ValidateRequest="false" %>
<%@ Register TagPrefix="uc1" TagName="IfAdmin" Src="IfAdmin.ascx" %>
<%@ Register TagPrefix="uc2" TagName="IfLoggedIn" Src="IfLoggedIn.ascx" %>
<%@ Register TagPrefix="rtb" Namespace="RichTextBoxControl" Assembly="RichTextBox, Version=2.5.0.0, Culture=Neutral, PublicKeyToken=17b15412cfbf13c1" %> 

<script runat="server">
    //
    // Part of the Content Management System by Declan Brennan ( http://sites.declan.brennan.name )
    // Available subject to the conditions in http://www.voyagers.ie/license.htm .
    //
    
    void PopulateNode(Object source, TreeNodeEventArgs e)
    {
        PopulateNode(e.Node);
    }
    
    void PopulateNode(TreeNode parentNode)
    {
        DataAccess.GetDataAsTreeNodes(Server, "SELECT Title,ArticleId as NodeId,'A' as Type,Description from Article WHERE ParentGroup=@id UNION ALL SELECT Title,ArticleGroupId as NodeId, 'G' as Type,Description from ArticleGroup WHERE ParentGroup=@id order by Title", parentNode);

        string list = IdList.Value;
        if (list.Length > 0)
        {
            int p = list.IndexOf(',');
            string id = (p < 0) ? list : list.Substring(0, p);
            IdList.Value = (p < 0) ? "" : list.Substring(p + 1);
            foreach (TreeNode node in parentNode.ChildNodes)
                if (node.Value == id)
                {
                    if (node.SelectAction == TreeNodeSelectAction.SelectExpand)
                    {
                        node.PopulateOnDemand = false;
                        PopulateNode(node);
                        node.Expand();
                        if (p < 0)
                            node.Select();
                    }
                    else
                        node.Select();
                    break;
                }
        }
        else
            parentNode.Select();
    }

    protected void Select(bool reload)
    {
        string suffix = "";
        string suffix2 = "";
        if (reload)
        {
            suffix = "&reload=true";
            suffix2 = "?reload=true";
        }
        
        if (this.TreeView1.SelectedNode != null)
        {
            string id = this.TreeView1.SelectedNode.Value;
            if (id == "0")
                Response.Redirect("Resources.aspx"+suffix2);
            else if (this.TreeView1.SelectedNode.SelectAction == TreeNodeSelectAction.SelectExpand)
                Response.Redirect("Resources.aspx?ResourceGroupId=" + id+suffix);
            else
                Response.Redirect("Resources.aspx?ResourceId=" + id+suffix);
        }
        else
            Response.Redirect("Resources.aspx"+suffix2);
    }
    
    protected void TreeView1_SelectedNodeChanged(object sender, EventArgs e)
    {
        Select(false);
    }

    protected string resourceUrl(object articleExt,object articleId)
    {
        if (articleExt==null || articleExt==System.DBNull.Value || (((string)articleExt).Length == 0))
            articleExt = ".htm";
        return Uploader.Resources.ResourceUrl(this, articleExt, articleId);
    }

    protected string GetContent(object id)
    {
        if (id == null || id == System.DBNull.Value || id.ToString().Length == 0)
            return "";
        return Uploader.Resources.GetContent(this, id.ToString());
    }

    protected void AddGroup(object sender, EventArgs e)
    {
        FormView2.ChangeMode(FormViewMode.Insert);
        MultiView1.ActiveViewIndex = 1;
    }

    protected void AddResource(object sender, EventArgs e)
    {
        FormView1.ChangeMode(FormViewMode.Insert);
        MultiView1.ActiveViewIndex = 0;
    }

    protected bool canDeleteGroup()
    {
        return TreeView1.SelectedNode != null && TreeView1.SelectedNode.Parent != null && TreeView1.SelectedNode.ChildNodes.Count == 0;
    }


    protected void FormView1_Load(object sender, EventArgs e)
    {

    }

    protected Int32 GetParentGroupFromResource(Int32 ResourceId)
    {
        return (Int32)DataAccess.GetData(Server, "SELECT ParentGroup FROM Article WHERE ArticleId=@ArticleId","@ArticleId",ResourceId)[0];
    }

    protected Int32 GetParentGroupFromGroup(Int32 ResourceGroupId)
    {
        return (Int32)DataAccess.GetData(Server, "SELECT ParentGroup FROM ArticleGroup WHERE ArticleGroupId=@ArticleGroupId","@ArticleGroupId",ResourceGroupId)[0];
    }
    
    protected void MultiView1_Load(object sender, EventArgs e)
    {
         
        if (!this.IsPostBack)
        {
            /*
            if (Request.QueryString["reload"] == "true")
            {
                if (Request.QueryString["ResourceId"] != null)
                    this.Response.Redirect("Resources.aspx?ResourceId=" + Request.QueryString["ResourceId"], true);
                else if (Request.QueryString["ResourceGroupId"] != null)
                    this.Response.Redirect("Resources.aspx?ResourceGroupId=" + Request.QueryString["ResourceGroupId"], true);
                else
                    this.Response.Redirect("Resources.aspx", true);
            }
            */

            if (Request.QueryString["ResourceId"] != null || Request.QueryString["ResourceGroupId"] != null)
            {
                Stack ids = new Stack();

                int parentGroup = 0;
                if (Request.QueryString["ResourceId"] != null)
                {
                    this.MultiView1.ActiveViewIndex = 0;
                    int resourceId = Int32.Parse(Request.QueryString["ResourceId"]);
                    ids.Push(resourceId);
                    parentGroup = GetParentGroupFromResource(resourceId);
                }
                else if (Request.QueryString["ResourceGroupId"] != null)
                {
                    parentGroup = Int32.Parse(Request.QueryString["ResourceGroupId"]);
                    if (parentGroup == 0)
                        this.MultiView1.ActiveViewIndex = 2;
                    else
                        this.MultiView1.ActiveViewIndex = 1;
                }
                while (parentGroup != 0)
                {
                    ids.Push(parentGroup);
                    parentGroup = GetParentGroupFromGroup(parentGroup);
                }
                string list = "";
                while (ids.Count > 0)
                {
                    if (list.Length > 0)
                        list += ",";
                    list += ids.Pop().ToString();
                }
                IdList.Value = list;
                updateTreeView();
            }
            else
                setLeftSideBar(true); // Always open the sideBar if there is no document
            handleLeftSideBar();
        }
    }

    protected void handleCommand(string commandName,string commandArgument)
    {
        switch (commandName)
        {
            case "AddResource":
                this.CurrentGroup.Value = commandArgument;
                FormView1.ChangeMode(FormViewMode.Insert);
                MultiView1.ActiveViewIndex = 0;
                break;
            case "AddGroup":
                this.CurrentGroup.Value = commandArgument;
                FormView2.ChangeMode(FormViewMode.Insert);
                MultiView1.ActiveViewIndex = 1;
                break;
            case "ChangeType":
                break;
        }
    }
    
    protected void FormView2_ItemCommand(object sender, FormViewCommandEventArgs e)
    {
        handleCommand(e.CommandName, e.CommandArgument.ToString());
    }

    protected void FormView1_ItemCommand(object sender, FormViewCommandEventArgs e)
    {
        if (e.CommandName == "ChangeType")
        {
            Label ctrl = (Label)this.FormView1.Controls[0].Controls[0].FindControl("TypeLabel");
            if (ctrl.Text == "Text")
                ctrl.Text = "Upload";
            else
                ctrl.Text = "Text";
            // this.FormView1.Controls[0].Controls[0].DataBind();                
            this.FormView1.Controls[0].Controls[0].FindControl("upload").Visible = (ctrl.Text == "Upload");
            this.FormView1.Controls[0].Controls[0].FindControl("ContentTextBox").Visible = (ctrl.Text == "Text");
        }
        else if (FormView1.CurrentMode == FormViewMode.Insert)
            MultiView1.ActiveViewIndex = 1;
    }



    protected void updateContent(string resourceId)
    {
        string content = "";
        foreach (string key in this.Request.Form.AllKeys)
            if (key.EndsWith("ContentTextBox"))
            {
                content = this.Request.Form[key];
                break;
            }
        Uploader.Resources.UpdateContent(this,resourceId, content);
    }

    protected void updateTreeView()
    {
        
        // TreeView1.Nodes.Clear();
        // System.Web.UI.WebControls.TreeNode newNode = new System.Web.UI.WebControls.TreeNode("Articles", "0");
        // newNode.SelectAction = System.Web.UI.WebControls.TreeNodeSelectAction.SelectExpand;
        // newNode.PopulateOnDemand = true;
        // TreeView1.Nodes.Add(newNode);
       
        TreeNode parentNode= null;
        if (this.CurrentGroup.Value != "")
        {
            parentNode = TreeView1.SelectedNode;
            this.CurrentGroup.Value = "";
        }
        else if (this.TreeView1.SelectedNode!=null)
            parentNode = TreeView1.SelectedNode.Parent;
        if (parentNode != null)
        {
            parentNode.ChildNodes.Clear();
            PopulateNode(parentNode);
        }
        else
        {
            TreeView1.Nodes.Clear();
            System.Web.UI.WebControls.TreeNode newNode = new System.Web.UI.WebControls.TreeNode("Resources", "0");
            newNode.SelectAction = System.Web.UI.WebControls.TreeNodeSelectAction.SelectExpand;
            TreeView1.Nodes.Add(newNode);
            PopulateNode(newNode);
        }
    }

    //
    //----| AccessDataSource1= Resources |----------------------------------------------------
    //    
    
    protected void AccessDataSource1_Updating(object sender, SqlDataSourceCommandEventArgs e)
    {
        string ext = Uploader.Resources.UploadExtension(this);
        if (ext.Length > 0)
        {
            // savePicture(e.Command.Parameters["PictureId"].Value) + ext;
            Uploader.Resources.Save(this, e.Command.Parameters["ArticleId"].Value.ToString());
            e.Command.Parameters["ArticleExt"].Value = ext;
        }
    }
    
    protected void AccessDataSource1_Updated(object sender, SqlDataSourceStatusEventArgs e)
    {
        string ext = e.Command.Parameters["ArticleExt"].Value.ToString();
        if (ext.Length == 0)
        {
            updateContent(e.Command.Parameters["ArticleId"].Value.ToString());
        }
        SideBarCacheDependency.Reset();
        Response.Redirect("Resources.aspx?ResourceId=" + e.Command.Parameters["ArticleId"].Value.ToString());
    }

    protected void AccessDataSource1_Inserting(object sender, SqlDataSourceCommandEventArgs e)
    {
        e.Command.Parameters["ArticleExt"].Value = Uploader.Pictures.UploadExtension(this);

    }

    protected void AccessDataSource1_Inserted(object sender, SqlDataSourceStatusEventArgs e)
    {
        string resourceId = DataAccess.Identity(e.Command);
            
        string ext = e.Command.Parameters["ArticleExt"].Value.ToString();
        if (ext.Length > 0)
        {
            Uploader.Resources.Save(this, resourceId);
        }
        else
        {
            updateContent(resourceId);
        }
        SideBarCacheDependency.Reset();
        Response.Redirect("Resources.aspx?ResourceId=" + resourceId);
    }

    protected void AccessDataSource1_Deleted(object sender, SqlDataSourceStatusEventArgs e)
    {
        string id = this.TreeView1.SelectedNode.Parent.Value;
        SideBarCacheDependency.Reset();
        Response.Redirect("Resources.aspx" + ((id != "0") ? ("?ResourceGroupId=" + id) : ""));
    }

    //
    //----| AccessDataSource2= Groups |----------------------------------------------------
    //    
    protected void AccessDataSource2_Inserted(object sender, SqlDataSourceStatusEventArgs e)
    {
        Response.Redirect("Resources.aspx?ResourceGroupId=" + DataAccess.Identity(e.Command));
    }

    protected void AccessDataSource2_Updated(object sender, SqlDataSourceStatusEventArgs e)
    {
        Response.Redirect("Resources.aspx?ResourceGroupId=" + e.Command.Parameters["ArticleGroupId"].Value.ToString());
    }
    
    protected void AccessDataSource2_Deleted(object sender, SqlDataSourceStatusEventArgs e)
    {
        Response.Redirect("Resources.aspx?ResourceGroupId=" + this.TreeView1.SelectedNode.Parent.Value);
    }
    
    
    protected void TopNode_Command(object sender, CommandEventArgs e)
    {
        handleCommand(e.CommandName, e.CommandArgument.ToString());
    }

    protected void ImageButton1_Click(object sender, ImageClickEventArgs e)
    {
        setLeftSideBar(this.ImageButton1.CommandName=="Open");
    }

    protected bool leftSideBarOpen()
    {
        return (Session["LeftSideBar"]==null)||((string)Session["LeftSideBar"] != "off");
    }

    private void setLeftSideBar(bool newState)
    {
        if (newState)
            Session["LeftSideBar"] = "on";
        else
            Session["LeftSideBar"] = "off";
        
        handleLeftSideBar();
    }
      
    private void handleLeftSideBar()
    {
        if (leftSideBarOpen())
        {   // If you use this.leftSideBar.Visible here
            // no children are rendered and we loose the viewstate for the outline
            this.leftSideBar.Style["display"] = "";
            this.ImageButton1.ImageUrl = "~/recordprevious.gif";
            this.ImageButton1.ToolTip = "Close Resource Outline";
            this.ImageButton1.CommandName = "Close";
        }
        else
        {
            this.ImageButton1.ImageUrl = "~/recordnext.gif";
            this.leftSideBar.Style["display"] = "none";
            this.ImageButton1.ToolTip = "Open Resource Outline";
            this.ImageButton1.CommandName = "Open";
        }
        this.ImageButton1.Visible = true;
    }

    private bool isVisible(string value)
    {
        Label ctrl = (Label)this.FormView1.Controls[0].Controls[0].FindControl("TypeLabel");
        return ctrl.Text == value;
    }

    protected enum ResourceTypes { Fragment, Frameable, Embeddable };
    
    protected ResourceTypes ResourceType()
    {
        object ext2= Eval("ArticleExt");
        if (ext2==System.DBNull.Value || ext2==null)
            return ResourceTypes.Fragment;
        string ext = (string)ext2;
        if (ext.Length==0)
            return ResourceTypes.Fragment;
        if (ext == "htm" || ext == "html")
            return ResourceTypes.Frameable;
        
        return ResourceTypes.Embeddable;
    }

    protected bool IsAFile()
    {
        object ext = Eval("ArticleExt");
        if (ext == System.DBNull.Value || ext == null)
            return false;
        if (((string)Eval("ArticleExt")).Length == 0)
            return false;
        return true;
    }

</script>

<asp:Content ID="Content1" runat="server" ContentPlaceHolderID="ContentPlaceHolder1">
    <asp:HiddenField ID="CurrentGroup" runat="server" />
    <asp:HiddenField ID="IdList" runat="server" />
    <span class="smallText">You can navigate through these resources by clicking on items in the outline on the left.</span>
    <table width="100%">
        <tr>
            <td  runat="server" width="25%" id="leftSideBar" valign="top" >
                <asp:TreeView ID="TreeView1" runat="server" OnTreeNodePopulate="PopulateNode" OnSelectedNodeChanged="TreeView1_SelectedNodeChanged" LeafNodeStyle-ImageUrl="article.gif" ParentNodeStyle-ImageUrl="group.gif" ShowLines="True" AutoGenerateDataBindings="False" NodeWrap="True">
                    <Nodes>
                        <asp:TreeNode Text="Resources" SelectAction="SelectExpand" PopulateOnDemand="True"
                            Value="0" />
                    </Nodes>
                    <SelectedNodeStyle BorderColor="#0000C0" BorderWidth="1px" />
                </asp:TreeView>
            </td>
            <td valign="top" style="width: 1px">
            <asp:ImageButton ID="ImageButton1" runat="server" Visible="false" BorderStyle="Outset" BorderWidth="2px"  OnClick="ImageButton1_Click" />
              
                </td>
            <td valign="top">
                <asp:MultiView ID="MultiView1" runat="server" ActiveViewIndex="2" OnLoad="MultiView1_Load">
                    <asp:View ID="View0" runat="server">
                    <asp:AccessDataSource ID="AccessDataSource1" runat="server" DataFile="~/App_Data/voyagers.mdb"
                            SelectCommand="SELECT [ArticleId] AS ArticleId,[ArticleExt],[ParentGroup],[CreatedOn],[CreatedBy],[Title],[Description],[UserID] FROM [Article] LEFT OUTER JOIN [Member] ON Member.MemberId=Article.CreatedBy WHERE Article.ArticleId=@id"
                            OnUpdated="AccessDataSource1_Updated" DeleteCommand="DELETE FROM [Article] WHERE ArticleId=@ArticleId"
                            InsertCommand="INSERT INTO Article(CreatedBy, CreatedOn, Title, Description,ParentGroup,ArticleExt) VALUES (@CreatedBy,DATE(),@Title,@Description,@ParentGroup,@ArticleExt)"
                            UpdateCommand="UPDATE [Article] SET [Title]=@Title,[Description]=@Description,[ArticleExt]=@ArticleExt WHERE [ArticleId]=@ArticleId2"
                            OnInserted="AccessDataSource1_Inserted" OnDeleted="AccessDataSource1_Deleted" OnUpdating="AccessDataSource1_Updating" OnInserting="AccessDataSource1_Inserting" >
                            <SelectParameters>
                                <asp:ControlParameter Name="id" ControlID="TreeView1" DefaultValue="0" PropertyName="SelectedValue"
                                    Type="Int32" />
                            </SelectParameters>
                            <DeleteParameters>
                                <asp:ControlParameter Name="ArticleId" ControlID="TreeView1" DefaultValue="0" PropertyName="SelectedValue"
                                    Type="Int32" />
                           </DeleteParameters>
                            <UpdateParameters>
                                <asp:Parameter Name="Title" Type="String" />
                                <asp:Parameter Name="Description" Type="String" />
                                <asp:Parameter Name="ArticleExt" Type="String" />
                                <asp:ControlParameter Name="ArticleId2" ControlID="TreeView1" DefaultValue="0" PropertyName="SelectedValue"
                                    Type="Int32" />
                            </UpdateParameters>
                            <InsertParameters>
                                <asp:SessionParameter Name="CreatedBy" Type="Int32" SessionField="MemberId" />
                                <asp:Parameter Name="Title" Type="String" />
                                <asp:Parameter Name="Description" Type="String" />
                                <asp:ControlParameter Name="ParentGroup" ControlID="CurrentGroup" PropertyName="Value"
                                    Type="Int32" />
                                <asp:Parameter Name="ArticleExt" Type="String" />
                            </InsertParameters>

                        </asp:AccessDataSource>
                        <asp:FormView Width="100%" ID="FormView1" runat="server" DataKeyNames="ArticleId"
                            DataSourceID="AccessDataSource1" DefaultMode="ReadOnly" OnLoad="FormView1_Load"
                            OnItemCommand="FormView1_ItemCommand">
                            <EditItemTemplate>
                                <fieldset>
                                    <legend>Edit Resource</legend>
                                    <asp:TextBox ID="TextBox3" Visible="false" runat="server" Text='<%# Bind("ArticleExt") %>'></asp:TextBox>
                                    <table border="0" cellpadding="0" cellspacing="0" class="fields">
                                        <tr>
                                            <td class="labelColumn">
                                                Title:</td>
                                            <td class="fieldColumn">
                                                <a style="float: right" href="Resources.aspx?ResourceId=9" rel="Help">About</a>
                                               
                                                <asp:TextBox ID="TitleTextBox" runat="server" Text='<%# Bind("Title") %>'></asp:TextBox>
                                                <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="TitleTextBox"
                                                    Display="Dynamic" ErrorMessage="Title is Required"></asp:RequiredFieldValidator>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="labelColumn">
                                                Description:</td>
                                            <td class="fieldColumn">
                                                <asp:TextBox ID="DescriptionTextBox" runat="server" Text='<%# Bind("Description") %>'></asp:TextBox>
                                                <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ControlToValidate="DescriptionTextBox"
                                                    Display="Dynamic" ErrorMessage="Description is Required"></asp:RequiredFieldValidator>
                                            </td>
                                        </tr>
                                        <tr runat="server" id="upload" Visible='<%# IsAFile() %>'>
                                            <td class="labelColumn">
                                                Upload:</td>
                                            <td class="fieldColumn">
                                                <asp:FileUpload Width="100%" ID="FileUpload1" runat="server" />
                                            </td>
                                        </tr>

                                    </table>
                                </fieldset>
                                <rtb:RichTextBox ID="ContentTextBox" Visible='<%# ! IsAFile() %>' runat="server" Width="100%"
                                    Text='<%# GetContent(Eval("ArticleId")) %>'  EditorWysiwygModeCss="~/App_Themes/Database/Stylesheet.css" HtmlOptionIsEnabled="false" 
                                    ToolbarLayout = "paragraphmenu,indent,outdent,insertimage,fontforecolormenu,bold,italic,underline,separator,bullets,numberedlist,separator,insertlink" 
                                    ></rtb:RichTextBox>
                                
                                <asp:LinkButton ID="UpdateButton" runat="server" CausesValidation="True" CommandName="Update"
                                    Text="Update">
                                </asp:LinkButton>
                                &nbsp;&nbsp;&nbsp;&nbsp;
                                <asp:LinkButton ID="UpdateCancelButton" runat="server" CausesValidation="False" CommandName="Cancel"
                                    Text="Cancel">
                                </asp:LinkButton>
                            </EditItemTemplate>
                            <InsertItemTemplate>
                                <fieldset>
                                    <legend>Add Resource</legend>
                                    <table border="0" cellpadding="0" cellspacing="0" class="fields">
                                        <tr>
                                            <td class="labelColumn">
                                                Title:</td>
                                            <td class="fieldColumn">
                                                <a style="float: right" href="Resources.aspx?ResourceId=9" rel="Help">About</a>

                                                <asp:TextBox ID="TitleTextBox" runat="server" Text='<%# Bind("Title") %>'></asp:TextBox>
                                                <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" Display="Dynamic"
                                                    ControlToValidate="TitleTextBox" ErrorMessage="Title is Required"></asp:RequiredFieldValidator></td>
                                        </tr>
                                        <tr>
                                            <td class="labelColumn" style="height: 49px">
                                                Description:</td>
                                            <td class="fieldColumn" style="height: 49px">
                                                <asp:TextBox ID="DescriptionTextBox" runat="server" Text='<%# Bind("Description") %>'></asp:TextBox>
                                                <asp:RequiredFieldValidator ID="RequiredFieldValidator3" runat="server" ControlToValidate="DescriptionTextBox"
                                                    Display="Dynamic" ErrorMessage="Description is Required"></asp:RequiredFieldValidator></td>
                                        </tr>
                                        <tr>
                                            <td class="labelColumn">
                                                Type:</td>
                                            <td class="fieldColumn">
                                                <asp:Label ID="TypeLabel" runat="server" Text="Text" />&nbsp;&nbsp;<asp:Button ID="Button1" runat="server"
                                                    Text="Change" CommandName="ChangeType" />
                                            </td>
                                      </tr>
                                          <tr runat="server" id="upload" Visible=false>
                                            <td class="labelColumn">
                                                Upload:</td>
                                            <td class="fieldColumn">
                                                <asp:FileUpload Width="100%" ID="FileUpload1" runat="server" />
                                            </td>
                                        </tr>
                                    </table>
                                </fieldset>
                                                                <rtb:RichTextBox ID="ContentTextBox" Visible='<%# ! IsAFile() %>' runat="server" Width="100%"
                                    Text='<%# GetContent(Eval("ArticleId")) %>'  EditorWysiwygModeCss="~/App_Themes/Database/Stylesheet.css" HtmlOptionIsEnabled="false" 
                                    ToolbarLayout = "paragraphmenu,indent,outdent,insertimage,fontforecolormenu,bold,italic,underline,separator,bullets,numberedlist,separator,insertlink" 
                                    ></rtb:RichTextBox>
                                
                                <asp:LinkButton ID="InsertButton" runat="server" CausesValidation="True" CommandName="Insert"
                                    Text="Insert">
                                </asp:LinkButton>
                                &nbsp;&nbsp;&nbsp;&nbsp;
                                <asp:LinkButton ID="InsertCancelButton" runat="server" CausesValidation="False" CommandName="Cancel"
                                    Text="Cancel">
                                </asp:LinkButton>
                            </InsertItemTemplate>
                            <ItemTemplate>
                                <fieldset>
                                    <legend>
                                        <h2>
                                            Resource:
                                            <asp:Literal ID="TitleLiteral" runat="server" Text='<%# Eval("Title")%>' /></h2>
                                    </legend>
                                    <table border="0" cellpadding="0" cellspacing="0" class="fields">
                                        <tr>
                                            <td class="labelColumn">
                                                CreatedBy:</td>
                                            <td class="fieldColumn">
                                                <asp:HyperLink ID="HyperLink2" runat="server" Text='<%# Eval("UserID") %>' NavigateUrl='<%# "Member.aspx?MemberId="+Eval("CreatedBy") %>'>HyperLink</asp:HyperLink>
                                                <asp:Label runat="server" ID="OnLabel" Text='<%# DataAccess.DateStamp(Eval("CreatedOn")) %>'></asp:Label>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="labelColumn">
                                                Description:</td>
                                            <td class="fieldColumn">
                                                <asp:Literal ID="DescriptionLiteral" runat="server" Text='<%# Eval("Description") %>' />
                                            </td>
                                        </tr>
                                    </table>
                                    <asp:Panel Visible='<%# ResourceType()==ResourceTypes.Fragment %>' ScrollBars="Vertical" runat="server" ID="panel1" Width="100%" Height="20em"
                                        CssClass="ContentPanel">
                                        <asp:Literal runat="server" ID="content" Text='<%# GetContent(Eval("ArticleId")) %>'>
                                        </asp:Literal>
                                        
                                    </asp:Panel>
                                    <iframe id="iframe1" runat="server" width="100%" height="600" visible='<%# ResourceType()==ResourceTypes.Frameable %>' src='<%# resourceUrl(Eval("ArticleExt"),Eval("ArticleId")) %>' >
                                    </iframe>
                                    <a runat="server" visible='<%# ResourceType()==ResourceTypes.Embeddable %>' style="float:right" href='<%# Uploader.Resources.Domain(this)+resourceUrl(Eval("ArticleExt"),Eval("ArticleId"))%>'>Show in complete Window</a>
                                    <br runat="server" visible='<%# ResourceType()==ResourceTypes.Embeddable %>' />
                                    <embed id="embed1" runat="server" width="100%" height="600" visible='<%# ResourceType()==ResourceTypes.Embeddable %>' src='<%# Uploader.Resources.Domain(this)+resourceUrl(Eval("ArticleExt"),Eval("ArticleId")) %>' >
                                    </embed>
                                </fieldset>
                                <uc1:IfAdmin PartnerId="Admin2" ID="IfAdmin2" runat="server" CreatedBy='<%# Eval("CreatedBy") %>'
                                    User='<%# Eval("UserId") %>' AbleTo="edit or delete this resource"></uc1:IfAdmin>
                                <span id="Admin2" runat="server">
                                    <asp:LinkButton ID="EditButton" runat="server" CausesValidation="True" CommandName="Edit"
                                        Text="Edit">
                                    </asp:LinkButton>
                                    &nbsp;&nbsp;&nbsp;&nbsp;
                                    <asp:LinkButton ID="DeleteButton" runat="server" CausesValidation="False" CommandName="Delete"
                                        Text="Delete">
                                    </asp:LinkButton><asp:TextBox ID="TextBox5" runat="server" Text='<%# Bind("ArticleId") %>'
                                        Visible="False"></asp:TextBox>
                                </span>
                            </ItemTemplate>
                        </asp:FormView>
                    </asp:View>
                    <asp:View ID="View1" runat="server">
                        <asp:AccessDataSource ID="AccessDataSource2" runat="server" DataFile="~/App_Data/voyagers.mdb"
                            SelectCommand="SELECT [ArticleGroupId],[CreatedOn],[CreatedBy],[Title],[Description],[UserID],[ParentGroup] FROM [ArticleGroup] LEFT OUTER JOIN [Member] ON Member.MemberId=ArticleGroup.CreatedBy WHERE ArticleGroup.ArticleGroupId=@id"
                            OnUpdated="AccessDataSource2_Updated" DeleteCommand="DELETE FROM [ArticleGroup] WHERE ArticleGroupId=@ArticleGroupId"
                            InsertCommand="INSERT INTO ArticleGroup(CreatedBy, CreatedOn, Title, Description,ParentGroup) VALUES (@CreatedBy,DATE(),@Title,@Description,@ParentGroup)"
                            UpdateCommand="UPDATE [ArticleGroup] SET [Title]=@Title,[Description]=@Description WHERE [ArticleGroupId]=@ArticleGroupId"
                            OnInserted="AccessDataSource2_Inserted" OnDeleted="AccessDataSource2_Deleted">
                            <SelectParameters>
                                <asp:ControlParameter Name="id" ControlID="TreeView1" DefaultValue="0" PropertyName="SelectedValue"
                                    Type="Int32" />
                            </SelectParameters>
                            <DeleteParameters>
                                <asp:ControlParameter Name="ArticleGroupId" ControlID="TreeView1" DefaultValue="0" PropertyName="SelectedValue"
                                    Type="Int32" />
                            </DeleteParameters>
                            <UpdateParameters>
                                <asp:Parameter Name="Title" Type="String" />
                                <asp:Parameter Name="Description" Type="String" />
                                <asp:Parameter Name="ArticleGroupId" Type="Int32" />
                            </UpdateParameters>
                            <InsertParameters>
                                <asp:SessionParameter Name="CreatedBy" Type="Int32" SessionField="MemberId" />
                                <asp:Parameter Name="Title" Type="String" />
                                <asp:Parameter Name="Description" Type="String" />
                                <asp:ControlParameter Name="ParentGroup" ControlID="CurrentGroup" PropertyName="Value"
                                    Type="Int32" />
                            </InsertParameters>
                        </asp:AccessDataSource>
                        <asp:FormView Width="100%" ID="FormView2" runat="server" DataKeyNames="ArticleGroupId"
                            DataSourceID="AccessDataSource2" OnItemCommand="FormView2_ItemCommand">
                            <EditItemTemplate>
                                <fieldset>
                                    <legend>Edit Group</legend>
                                    <table border="0" cellpadding="0" cellspacing="0" class="fields">
                                        <tr>
                                            <td class="labelColumn" style="height: 27px">
                                                Title:</td>
                                            <td class="fieldColumn" style="height: 27px">
                                                <asp:TextBox ID="TitleTextBox" runat="server" Text='<%# Bind("Title") %>'></asp:TextBox>
                                                <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" Display="Dynamic"
                                                    ErrorMessage="Title is Required"></asp:RequiredFieldValidator></td>
                                        </tr>
                                        <tr>
                                            <td class="labelColumn">
                                                Description:</td>
                                            <td class="fieldColumn">
                                                <asp:TextBox ID="DescriptionTextBox" runat="server" Text='<%# Bind("Description") %>'></asp:TextBox>
                                                <asp:RequiredFieldValidator ID="RequiredFieldValidator4" runat="server" Display="Dynamic"
                                                    ErrorMessage="Description is Required"></asp:RequiredFieldValidator></td>
                                        </tr>
                                    </table>
                                </fieldset>
                                <asp:LinkButton ID="UpdateButton" runat="server" CausesValidation="True" CommandName="Update"
                                    Text="Update">
                                </asp:LinkButton>
                                <asp:LinkButton ID="UpdateCancelButton" runat="server" CausesValidation="False" CommandName="Cancel"
                                    Text="Cancel">
                                </asp:LinkButton>
                            </EditItemTemplate>
                            <InsertItemTemplate>
                                <fieldset>
                                    <legend>Add Group</legend>
                                    <table border="0" cellpadding="0" cellspacing="0" class="fields">
                                        <tr>
                                            <td class="labelColumn">
                                                Title:</td>
                                            <td class="fieldColumn">
                                                <asp:TextBox ID="TextBox1" runat="server" Text='<%# Bind("Title") %>'></asp:TextBox></td>
                                        </tr>
                                        <tr>
                                            <td class="labelColumn">
                                                Description:</td>
                                            <td class="fieldColumn">
                                                <asp:TextBox ID="TextBox2" runat="server" Text='<%# Bind("Description") %>'></asp:TextBox></td>
                                        </tr>
                                    </table>
                                 </fieldset>
                                    <asp:LinkButton ID="InsertButton" runat="server" CausesValidation="True" CommandName="Insert"
                                        Text="Insert">
                                    </asp:LinkButton>
                                    <asp:LinkButton ID="InsertCancelButton" runat="server" CausesValidation="False" CommandName="Cancel"
                                        Text="Cancel">
                                    </asp:LinkButton>
                            </InsertItemTemplate>
                            <ItemTemplate>
                                <fieldset>
                                    <legend>
                                        <h2>
                                            Group:
                                            <asp:Literal ID="Literal1" runat="server" Text='<%# Eval("Title")%>' ></asp:Literal></h2>
                                    </legend>
                                    <table border="0" cellpadding="0" cellspacing="0" class="fields">
                                        <tr>
                                            <td class="labelColumn">
                                                CreatedBy:</td>
                                            <td class="fieldColumn">
                                                <asp:HyperLink ID="HyperLink1" runat="server" Text='<%# Eval("UserID") %>' NavigateUrl='<%# "Member.aspx?MemberId="+Eval("CreatedBy") %>'>HyperLink</asp:HyperLink>
                                                <asp:Label runat="server" ID="Label1" Text='<%# DataAccess.DateStamp(Eval("CreatedOn")) %>'></asp:Label>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="labelColumn">
                                                Description:</td>
                                            <td class="fieldColumn">
                                                <asp:Literal ID="DescriptionLiteral" runat="server" Text='<%# Eval("Description") %>' />
                                            </td>
                                        </tr>
                                    </table>
                                </fieldset>
                                <uc2:IfLoggedIn PartnerId="LoggedIn" ID="IfLoggedIn1" runat="server" AbleTo="add resources or sub-groups to this group">
                                </uc2:IfLoggedIn>
                                <uc1:IfAdmin PartnerId="Admin1" ID="IfAdmin1" runat="server" CreatedBy='<%# Eval("CreatedBy") %>'
                                    User='<%# Eval("UserId") %>' AbleTo="edit or delete this group"></uc1:IfAdmin>
                                <span id="Admin1" runat="server">
                                    <asp:LinkButton ID="EditButton" runat="server" CausesValidation="False" CommandName="Edit"
                                        Text="Edit">
                                    </asp:LinkButton>
                                    &nbsp;&nbsp;&nbsp;&nbsp;
                                    <asp:LinkButton ID="LinkButton4" runat="server" CausesValidation="False" CommandName="Delete"
                                        Text="Delete" Enabled='<%# canDeleteGroup() %>'>
                                    </asp:LinkButton>
                                    &nbsp;&nbsp;&nbsp;&nbsp;
                                </span>
                                <span id="LoggedIn" runat="server">
                                        <asp:LinkButton ID="LinkButton1" runat="server" Text="Add Resource" CommandName="AddResource"
                                            CommandArgument='<%# Eval("ArticleGroupId") %>' />
                                        &nbsp;&nbsp;&nbsp;&nbsp;
                                        <asp:LinkButton ID="LinkButton2" runat="server" Text="Add Sub-Group" CommandName="AddGroup"
                                            CommandArgument='<%# Eval("ArticleGroupId") %>' /> 
                               </span>
                            </ItemTemplate>
                        </asp:FormView>
                    </asp:View>
                    <asp:View ID="TopNodeView" runat="server">
                                <uc2:IfLoggedIn PartnerId="LoggedIn" ID="IfLoggedIn1" runat="server" AbleTo="add resources or groups">
                                </uc2:IfLoggedIn>
                                <span id="LoggedIn" runat="server">
                                        <asp:LinkButton ID="LinkButton1" runat="server" Text="Add Resource" CommandName="AddResource"
                                            CommandArgument="0" OnCommand="TopNode_Command" />
                                        &nbsp;&nbsp;&nbsp;&nbsp;
                                        <asp:LinkButton ID="LinkButton2" runat="server" Text="Add Group" CommandName="AddGroup"
                                            CommandArgument="0" OnCommand="TopNode_Command" /> 
                               </span>
                    </asp:View>
                </asp:MultiView>
            </td>
        </tr>
    </table>
</asp:Content>
