<%@ Page Language="C#" Theme="Database" %>
<html>
<head runat="server">
<script runat="server">
    //
    // Part of the Content Management System by Declan Brennan ( http://sites.declan.brennan.name )
    // Available subject to the conditions in http://www.voyagers.ie/license.htm .
    //

    private bool showInfo(string infoName)
    {
        if (Session["MemberId"] == null)
            return false;

        return (bool)Session["Admin"] || ((int)this.Eval("MemberId") == (int)Session["MemberId"]) || (bool)Eval(infoName);
    }

</script>
</head>
<body class="printBody">
    <form runat="server" id="form1">
    <asp:AccessDataSource ID="AccessDataSource1" runat="server" DataFile="App_Data/voyagers.mdb" 
    SelectCommand="SELECT [MemberId], [UserId], [Forename], [Surname], [Email], [HomePhone], [WorkPhone], [MobilePhone], [DontSharePhoneNumbers], [DontShareEmail] FROM [Member] ORDER BY [Surname], [Forename]"
    DeleteCommand= "DELETE FROM [Member] WHERE [MemberId]=@MemberId">
    </asp:AccessDataSource>
    <h1>Voyagers' Members</h1>
    <span class="smallText">The information below is confidential and should only be divulged to members of <span runat="server" Visible='<%# (bool)Session["Admin"] %>' id="adminGroup">the admin group at </span>Voyagers (www.voyagers.ie).</span><br /><br />

    <asp:GridView ID="GridView1" SkinId="Print" runat="server" DataSourceID="AccessDataSource1" AutoGenerateColumns="False" BorderColor="Navy" BorderStyle="Solid" BorderWidth="1px" DataKeyNames="MemberId" >
        <Columns>
             <asp:BoundField DataField="UserId"
                HeaderText="UserId" SortExpression="UserId" ItemStyle-HorizontalAlign="Left"
                HeaderStyle-HorizontalAlign="Left" />
           <asp:BoundField DataField="Forename"
                HeaderText="Forename" SortExpression="Forename" ItemStyle-HorizontalAlign="Left"
                HeaderStyle-HorizontalAlign="Left" />
            <asp:BoundField DataField="Surname"
                HeaderText="Surname" SortExpression="Surname" ItemStyle-HorizontalAlign="Left"
                HeaderStyle-HorizontalAlign="Left" />
            <asp:TemplateField HeaderText="Home Phone" SortExpression="HomePhone" ItemStyle-HorizontalAlign="Left"
                HeaderStyle-HorizontalAlign="Left">
                <ItemTemplate>
                    <asp:Label ID="Label1" runat="server" Text='<%# showInfo("DontSharePhoneNumbers")?Eval("HomePhone"):"Private" %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Work Phone" SortExpression="WorkPhone" ItemStyle-HorizontalAlign="Left"
                HeaderStyle-HorizontalAlign="Left">
                <ItemTemplate>
                    <asp:Label ID="Label2" runat="server" Text='<%# showInfo("DontSharePhoneNumbers")?Eval("WorkPhone"):"Private" %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Mobile Phone" SortExpression="MobilePhone" ItemStyle-HorizontalAlign="Left"
                HeaderStyle-HorizontalAlign="Left">
                <ItemTemplate>
                    <asp:Label Visible='<%# !showInfo("DontSharePhoneNumbers") %>' ID="Label3" runat="server" Text="Label">Private</asp:Label>
                    <asp:Label Visible='<%# showInfo("DontSharePhoneNumbers") %>' ID="HyperLink1" runat="server"
                        Text='<%# Eval("MobilePhone") %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Email" ItemStyle-HorizontalAlign="Left"
                HeaderStyle-HorizontalAlign="Left">
                <ItemTemplate>
                    <asp:Label Visible='<%# !showInfo("DontShareEmail") %>' ID="Label4" runat="server" Text="Label">Private</asp:Label>
                    <asp:Label Visible='<%# showInfo("DontShareEmail") %>' ID="HyperLink2" runat="server" 
                        Text='<%# Eval("Email") %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
        </Columns>
        <EmptyDataTemplate>
            No members.
        </EmptyDataTemplate>
        <HeaderStyle BorderColor="Navy" BorderStyle="Solid" BorderWidth="1px" />
    </asp:GridView>
</form>
    
</body>
</html>
