<%@ Page Language="C#" Theme="Database" %>

<html>
<head id="Head1" runat="server">
<script runat="server">
    //
    // Part of the Content Management System by Declan Brennan ( http://sites.declan.brennan.name )
    // Available subject to the conditions in http://www.voyagers.ie/license.htm .
    //
</script>
</head>
<body class="printBody">
    <form runat="server" id="form1">
    
    <asp:AccessDataSource ID="AccessDataSource1" runat="server" DataFile="~/App_Data/voyagers.mdb"
        SelectCommand="SELECT [EventId],[Starts],[Ends], [Title], [Description], [Contact], Member.UserID as ContactID FROM [Event] LEFT OUTER JOIN [Member] ON Member.MemberId=Event.Contact ORDER BY [Starts] DESC">
    </asp:AccessDataSource>

    <h1>Voyagers' Events</h1>
            <span class="smallText">Normally events are only open to members of Voyagers. You can find out more about joining at www.voyagers.ie</span><br /><br />
    <asp:GridView ID="GridView1" runat="server" DataSourceID="AccessDataSource1" AutoGenerateColumns="False" SkinId="Print">
        <EmptyDataTemplate>
            No events.
        </EmptyDataTemplate>
        <Columns>
            <asp:TemplateField HeaderText="Title">
                <ItemTemplate>
                    <asp:HyperLink ID="HyperLink1" runat="server" ToolTip='<%# Eval("Description") %>' NavigateUrl='<%# Eval("EventId", "Event.aspx?EventId={0}") %>'
                        Text='<%# Eval("Title") %>'></asp:HyperLink>
                </ItemTemplate>
                <HeaderStyle HorizontalAlign="Left" />
                <ItemStyle HorizontalAlign="Left" />
            </asp:TemplateField>
            <asp:BoundField DataFormatString="{0:ddd dd MMM yy, hh:mm}" HtmlEncode="false" DataField="Starts" HeaderText="Starts" >
                <HeaderStyle HorizontalAlign="Left" />
                <ItemStyle HorizontalAlign="Left" />
            </asp:BoundField>
            <asp:BoundField DataFormatString="{0:ddd dd MMM yy, hh:mm}" HtmlEncode="false" DataField="Ends" HeaderText="Ends" >
                <HeaderStyle HorizontalAlign="Left" />
                <ItemStyle HorizontalAlign="Left" />
            </asp:BoundField>
            <asp:BoundField DataField="ContactId"
                HeaderText="Contact"  >
                <HeaderStyle HorizontalAlign="Left" />
                <ItemStyle HorizontalAlign="Left" />
            </asp:BoundField>
        </Columns>
    </asp:GridView>
    </form>
</body>
</html>