<%@ Page Language="C#" MasterPageFile="~/Default.master" %>
<%@ Register TagPrefix="uc1" TagName="IfAdmin" Src="IfAdmin.ascx" %>

<script runat="server">
    //
    // Part of the Content Management System by Declan Brennan ( http://sites.declan.brennan.name )
    // Available subject to the conditions in http://www.voyagers.ie/license.htm .
    //

    /*
    private string uploadExtension()
    {
        string rc = "";
        if (this.Request.Files.Count>0)
            rc= System.IO.Path.GetExtension(this.Request.Files[0].FileName);
        return rc;
    }
    */

    private string pictureUrl()
    {
        /*
        string rc = "NoPicture.gif";
        object pictureExt = Eval("PictureExt");
        if (pictureExt == System.DBNull.Value)
            pictureExt = null;
        if (pictureExt!=null && ((string)pictureExt).Length > 0)
            rc = "Pictures\\Picture" + Eval("PictureId").ToString() + (string)pictureExt;
        return rc;
         */
        return Uploader.Pictures.ResourceUrl(this, Eval("PictureExt"), Eval("PictureId")); 
    }

    protected void Button2_Click(object sender, EventArgs e)
    {
        try
        {
            this.FormView1.UpdateItem(false);
        }
        catch (System.Data.OleDb.OleDbException)
        {
            // Field 'Member.Surname' cannot be a zero length string
        }
    }

    protected void DetailsView1_ItemUpdating(object sender, DetailsViewUpdateEventArgs e)
    {
    }

    protected void FormView1_Load(object sender, EventArgs e)
    {
        if (this.Request.QueryString["mode"] == "add")
            this.FormView1.DefaultMode = FormViewMode.Insert;
    }

    protected void FormView1_ItemCommand(object sender, FormViewCommandEventArgs e)
    {
        if (e.CommandName=="Cancel")
            Response.Redirect("Gallery.aspx?GalleryId=" + this.Request.QueryString["GalleryId"], false);
    }

    private string getImagePath(string imageUrl)
    {
        if (imageUrl.Contains("&"))
        {
            int p = imageUrl.IndexOf("FileName=");
            int q = imageUrl.IndexOf("&", p);
            if (q < 0)
                imageUrl = imageUrl.Substring(p + 9);
            else
                imageUrl = imageUrl.Substring(p + 9, q - p - 9);
        }
        return Server.MapPath(imageUrl);
    }
    
    protected void Button_Click(object sender, EventArgs e)
    {
        bool clockwise= ((Button)sender).Text == "Clockwise";
        Image img= (Image)((Button)sender).NamingContainer.FindControl("Image1");
        string imgPath= getImagePath(img.ImageUrl);
        System.Drawing.Bitmap bm = new System.Drawing.Bitmap(imgPath);
        bm.RotateFlip(clockwise?System.Drawing.RotateFlipType.Rotate90FlipNone:System.Drawing.RotateFlipType.Rotate270FlipNone);
        bm.Save(imgPath, System.Drawing.Imaging.ImageFormat.Jpeg);
    }

    /*
    private string getPicturePath(string pictureId)
    {
        string fileName = string.Empty;
        string ext = uploadExtension();
        if (ext.Length > 0)
            fileName = "Pictures\\Picture" + pictureId + ext;
        return fileName;
    }

    private void savePicture(string pictureId)
    {
        string fileName = getPicturePath(pictureId);
        if (fileName.Length > 0)
            this.Request.Files[0].SaveAs(Server.MapPath(fileName));
    }

    private void deletePicture(string pictureId)
    {
        string fileName = getPicturePath(pictureId);
        if (fileName.Length > 0)
            System.IO.File.Delete(fileName);
    }
    */
    
    protected void AccessDataSource1_Inserted(object sender, SqlDataSourceStatusEventArgs e)
    {
        System.Data.Common.DbCommand cmd = e.Command.Connection.CreateCommand();
        cmd.CommandType = System.Data.CommandType.Text;
        cmd.CommandText = "SELECT @@IDENTITY";
        string pictureId = cmd.ExecuteScalar().ToString();
        Uploader.Pictures.Save(this,pictureId);
        Response.Redirect("Gallery.aspx?GalleryId=" + this.Request.QueryString["GalleryId"], false);
    }

    protected void AccessDataSource1_Updating(object sender, SqlDataSourceCommandEventArgs e)
    {
        string ext = Uploader.Pictures.UploadExtension(this);
        if (ext.Length > 0)
        {
            // savePicture(e.Command.Parameters["PictureId"].Value) + ext;
            Uploader.Pictures.Save(this,e.Command.Parameters["PictureId"].Value.ToString());
            e.Command.Parameters["PictureExt"].Value = ext;
        }
    }

    protected void AccessDataSource1_Updated(object sender, SqlDataSourceStatusEventArgs e)
    {

        Response.Redirect("Gallery.aspx?GalleryId=" + this.Request.QueryString["GalleryId"], false);
    }

    protected void AccessDataSource1_Deleted(object sender, SqlDataSourceStatusEventArgs e)
    {
        Uploader.Pictures.Delete(this,e.Command.Parameters["PictureId"].Value.ToString());
        
        Response.Redirect("Gallery.aspx?GalleryId=" + this.Request.QueryString["GalleryId"], false);
    }


    protected void AccessDataSource1_Inserting(object sender, SqlDataSourceCommandEventArgs e)
    {
        e.Command.Parameters["PictureExt"].Value = Uploader.Pictures.UploadExtension(this);
    }


</script>

<asp:Content ID="Content1" runat="server" ContentPlaceHolderId="ContentPlaceHolder1">
        <asp:MultiView ID="MultiView1" runat=server ActiveViewIndex="0">
        <asp:View ID="View1" runat=server>

    <asp:AccessDataSource ID="AccessDataSource1" runat="server" DataFile="App_Data/voyagers.mdb" 
           SelectCommand="SELECT [PictureId],Picture.Title,Picture.Description,Picture.PictureExt AS PictureExt,[Gallery],Gallery.Title AS GalleryTitle,Gallery.CreatedBy as CreatedBy,Member.UserId as UserId FROM [Picture] LEFT OUTER JOIN (Gallery LEFT OUTER JOIN Member ON Member.MemberId=Gallery.CreatedBy) ON Gallery.GalleryId=Picture.Gallery WHERE [PictureId]=@PictureId" 
           UpdateCommand="UPDATE [Picture] SET [Title]=@Title,[Description]=@Description,[PictureExt]=@PictureExt WHERE [PictureId]=@PictureId" OnUpdated="AccessDataSource1_Updated" OnUpdating="AccessDataSource1_Updating" 
           DeleteCommand="DELETE FROM [Picture] WHERE PictureId=@id3" OnDeleted="AccessDataSource1_Deleted"
           InsertCommand="INSERT INTO Picture(Gallery, Title, Description,PictureExt) VALUES (@Gallery,@Title,@Description,@PictureExt)" OnInserted="AccessDataSource1_Inserted" OnInserting="AccessDataSource1_Inserting">
        <InsertParameters>
            <asp:QueryStringParameter Name="Gallery" QueryStringField="GalleryId" Type="Int32" />
            <asp:Parameter Name="Title" Type="String" />
            <asp:Parameter Name="Description" Type="String" />
            <asp:Parameter Name="PictureExt" Type="String" />
       </InsertParameters>
        <SelectParameters>
            <asp:QueryStringParameter Name="PictureId" QueryStringField="PictureId" Type="Int32" DefaultValue="0" />
        </SelectParameters>
        <UpdateParameters>
            <asp:Parameter Name="Title" Type="String" />
            <asp:Parameter Name="Description" Type="String" />
            <asp:Parameter Name="PictureExt" Type="String" />
            <asp:QueryStringParameter Name="PictureId" QueryStringField="PictureId" Type="Int32" DefaultValue="0" />
        </UpdateParameters>
         <DeleteParameters>
            <asp:QueryStringParameter Name="PictureId" QueryStringField="PictureId" Type="Int32" DefaultValue="0" />
        </DeleteParameters>
   </asp:AccessDataSource>
    <asp:FormView Width="100%" ID="FormView1" runat="server" DataSourceID="AccessDataSource1" AllowPaging="False" DataKeyNames="PictureId" OnLoad="FormView1_Load" OnItemCommand="FormView1_ItemCommand">
        <ItemTemplate>
             <fieldset><legend>Picture</legend>
             <asp:HyperLink ID="HyperLink1" runat="server" NavigateUrl='<%# "~/Gallery.aspx?GalleryId="+Eval("Gallery") %>' Text='<%# "Gallery: "+Eval("GalleryTitle") %>' ></asp:HyperLink><br />

            
                <h2><asp:Label runat="server" ID="titleLabel" Text='<%# Eval("Title") %>'></asp:Label></h2>

                    <asp:Image ID="Image2" runat="server" ImageUrl='<%# Uploader.Pictures.Domain(this)+"getThumb.aspx?FileName="+pictureUrl()+"&Scale=500" %>' /><br />
                <asp:HyperLink ID="HyperLink2" runat="server" NavigateUrl='<%# pictureUrl() %>'>Full Resolution Version</asp:HyperLink><br /><br />
                <asp:Label runat="server" ID="descriptionLabel" Text='<%# Eval("Description") %>' />
            </fieldset>
                     <uc1:IfAdmin PartnerId="Admin" id="IfAdmin1" runat="server" CreatedBy='<%# Eval("CreatedBy") %>'
                        User='<%# Eval("UserId") %>' AbleTo="edit or delete this picture">
                    </uc1:IfAdmin>
                    <span id="Admin" runat="server">
                        <asp:LinkButton ID="EditButton" runat="server" CausesValidation="False" CommandName="Edit"
                            Text="Edit">
                        </asp:LinkButton>
            &nbsp;&nbsp;&nbsp;&nbsp;
                        <asp:LinkButton ID="LinkButton1" runat="server" CausesValidation="False" CommandName="Delete"
                            Text="Delete">
                        </asp:LinkButton>
                    </span>

        </ItemTemplate>
        <EditItemTemplate>
            <fieldset><legend>Edit Picture</legend>
            <table border="0" cellpadding="0" cellspacing="0" class="fields">
                            <tr>
                                <td class="labelColumn">
                                    Title:</td>
                                <td class="fieldColumn">
              <a style="float:right" href="Resources.aspx?ArticleId=12" rel="Help">About</a>
            <asp:TextBox ID="TitleTextBox2" runat="server" Text='<%# Bind("Title") %>'>
            </asp:TextBox>
                                </td>
                            </tr>
                            <tr>
                                <td class="labelColumn">
                                    Description:</td>
                                <td class="fieldColumn">
            <asp:TextBox ID="DescriptionTextBox2" runat="server" Text='<%# Bind("Description") %>' Width="29em" Rows="8" TextMode="MultiLine">
            </asp:TextBox>
                                </td>
                            </tr>
            
                            <tr>
                                <td class="labelColumn">
                                    </td>
                                <td class="fieldColumn">
              <asp:Image ID="Image1" runat="server" style="margin:0 auto 0 auto" ImageUrl='<%# Uploader.Pictures.Domain(this)+"getThumb.aspx?FileName="+pictureUrl()+"&Scale=500" %>' BorderWidth="1px" BorderStyle="Solid" />
                <asp:TextBox ID="TextBox1" runat="server" Text='<%# Bind("PictureExt") %>' Visible="False"></asp:TextBox><br />
                                </td>
                            </tr>
                            <tr>
                                <td class="labelColumn">Rotate:
                                    </td>
                                <td class="fieldColumn">
                <asp:Button ID="Button1" runat="server" OnClick="Button_Click" Text="Clockwise" />
                <asp:Button ID="Button2" runat="server" Text="Anticlockwise" OnClick="Button_Click" /><br />
                                </td>
                            </tr>
                            <tr>
                                <td class="labelColumn">Upload:
                                    </td>
                                <td class="fieldColumn">
              <asp:FileUpload style="width:100%" ID="FileUpload2" runat="server" />
                                </td>
                            </tr>
            </table>

            </fieldset>
            <asp:LinkButton ID="UpdateButton" runat="server" CausesValidation="True" CommandName="Update"
                Text="Update">
            </asp:LinkButton>
            &nbsp;&nbsp;&nbsp;&nbsp;
            <asp:LinkButton ID="UpdateCancelButton" runat="server" CausesValidation="False" CommandName="Cancel"
                Text="Cancel">
            </asp:LinkButton>
        </EditItemTemplate>
        <InsertItemTemplate>
            <fieldset><legend>Add Picture</legend>
            <table border="0" cellpadding="0" cellspacing="0" class="fields">
                            <tr>
                                <td class="labelColumn">
                                    Title:</td>
                                <td class="fieldColumn">
              <a style="float:right" href="Resources.aspx?ArticleId=12" rel="Help">About</a>
            <asp:TextBox ID="TitleTextBox2" runat="server" Text='<%# Bind("Title") %>'>
            </asp:TextBox>
                                </td>
                            </tr>
                            <tr>
                                <td class="labelColumn">
                                    Description:</td>
                                <td class="fieldColumn">
            <asp:TextBox ID="DescriptionTextBox2" runat="server" Text='<%# Bind("Description") %>' Rows="8" TextMode="MultiLine">
            </asp:TextBox>
                                </td>
                            </tr>
                            <tr>
                                <td class="labelColumn">
                                    Upload:</td>
                                <td class="fieldColumn">
              <asp:FileUpload style="width:100%" ID="FileUpload3" runat="server" />
                                </td>
                            </tr>
            </table>
              
              
            </fieldset>
            <asp:LinkButton ID="InsertButton" runat="server" CausesValidation="True" CommandName="Insert"
                Text="Add">
            </asp:LinkButton>
            &nbsp;&nbsp;&nbsp;&nbsp;
            <asp:LinkButton ID="UpdateCancelButton3" runat="server" CausesValidation="False" CommandName="Cancel"
                Text="Cancel">
            </asp:LinkButton>
         </InsertItemTemplate>
    
    </asp:FormView>
            </asp:View>
        <asp:View ID="View2" runat=server>
            You don't have permission to add or change content.
        </asp:View>
    </asp:MultiView></asp:Content>
