<%@ Page Language="C#" MasterPageFile="~/Default.master" %>
<%@ Register TagPrefix="uc1" TagName="IfAdmin" Src="IfAdmin.ascx" %>


<script runat="server">
    //
    // Part of the Content Management System by Declan Brennan ( http://sites.declan.brennan.name )
    // Available subject to the conditions in http://www.voyagers.ie/license.htm .
    //

    protected void DetailsView1_ItemUpdating(object sender, DetailsViewUpdateEventArgs e)
    {
    }

 
    protected void Button2_Click(object sender, EventArgs e)
    {
        try
        {
            this.FormView1.UpdateItem(false);
        }
        catch (System.Data.OleDb.OleDbException)
        {
            // Field 'Member.Surname' cannot be a zero length string
        }
    }

    protected void AccessDataSource1_Updated(object sender, SqlDataSourceStatusEventArgs e)
    {
        
    }

    private string uploadExtension()
    {
        string rc = "";
        if (this.Request.Files.Count>0)
            rc= System.IO.Path.GetExtension(this.Request.Files[0].FileName);
        return rc;
    }

    private string pictureUrl()
    {
        return Uploader.MemberPictures.ResourceUrl(this,Eval("PictureExt"),Eval("MemberId"));
        
        /*
        string rc= "NoPicture.gif";
        string pictureExt= this.Eval("PictureExt").ToString();
        if (pictureExt.Length > 0)
            rc = "Pictures\\Member" + Eval("MemberId").ToString() + pictureExt;
        return rc;
         */
    }
    
    protected void AccessDataSource1_Updating(object sender, SqlDataSourceCommandEventArgs e)
    {
        string ext = Uploader.MemberPictures.UploadExtension(this);
        if (ext.Length > 0)
        {
            Uploader.MemberPictures.Save(this, e.Command.Parameters["UpdateMemberId"].Value.ToString());
            e.Command.Parameters["PictureExt"].Value = ext;
        }
        /*
        string ext= uploadExtension();
        if (ext.Length>0)
        {
        string fileName= "Pictures\\Member"+(e.Command.Parameters["UpdateMemberId"].Value)+ext;
        this.Request.Files[0].SaveAs(Server.MapPath(fileName));
        e.Command.Parameters["PictureExt"].Value = ext;
        }
         */
    }

    private bool allowEdit()
    {
        if (Session["MemberId"] == null)
            return false;
        return (bool)Session["Admin"] || ((int)this.Eval("MemberId") == (int)Session["MemberId"]);
    }

    private bool allowAdminEdit()
    {
        // Don't allow editing of your own administration fields in case the last admin commits suicide.
        if (Session["MemberId"] == null)
            return false;
        return (bool)Session["Admin"] && ((int)this.Eval("MemberId") != (int)Session["MemberId"]);
    }

    private bool showInfo(string infoName)
    {
        if (Session["MemberId"] == null)
            return false;
        
        bool rc= (bool)Session["Admin"] || ((int)this.Eval("MemberId") == (int)Session["MemberId"]) || ! (bool)Eval(infoName);
        return rc;
    }

    protected void FormView1_Load(object sender, EventArgs e)
    {
        if (Request.QueryString["mode"] == "current")
            Server.Transfer("Member.aspx?MemberId="+Session["MemberId"].ToString());
    }

    protected void AccessDataSource1_Deleted(object sender, SqlDataSourceStatusEventArgs e)
    {
        Page.Response.Redirect("ListMembers.aspx");
    }
</script>

<asp:Content ID="Content1" runat="server" ContentPlaceHolderId="ContentPlaceHolder1">
   <asp:AccessDataSource ID="AccessDataSource1" runat="server" DataFile="App_Data/voyagers.mdb" 
           SelectCommand="SELECT * FROM [Member] WHERE [MemberId]=@MemberId" 
           UpdateCommand="UPDATE [Member] SET [Surname]=@Surname,[Forename]=@Forename,[Address1]=@Address1,[Address2]=@Address2,[Address3]=@Address3,[HomePhone]=@HomePhone,[WorkPhone]=@WorkPhone,[MobilePhone]=@MobilePhone,
           [Email]=@Email,[ICUNumber]=@ICUNumber,[KayakInstructor]=@KayakInstructor,[WantRiverInvites]=@WantRiverInvites,[Social]=@Social,[Admin]=@Admin,[Info]=@Info,[NoGroupEmails]=@NoGroupEmails,[NoEmailAttachments]=@NoEmailAttachments,[NoMobilePhoneMessages]=@NoMobilePhoneMessages,
           [PictureExt]=@PictureExt,[CanPost]=@CanPost,[CanDoLargeUploads]=@CanDoLargeUploads,[DontSharePhoneNumbers]=@DontSharePhoneNumbers,[DontShareAddress]=@DontShareAddress,[DontShareEmail]=@DontShareEmail,[Biography]=@Biography,[HomePage]=@HomePage WHERE [MemberId]=@UpdateMemberId" OnUpdated="AccessDataSource1_Updated" OnUpdating="AccessDataSource1_Updating" 
               DeleteCommand= "DELETE FROM [Member] WHERE [MemberId]=@DeleteMemberId" OnDeleted="AccessDataSource1_Deleted" >
        <SelectParameters>
            <asp:QueryStringParameter Name="MemberId" QueryStringField="MemberId" Type="Int32" DefaultValue="0" />
        </SelectParameters>
        <DeleteParameters>
            <asp:QueryStringParameter Name="DeleteMemberId" QueryStringField="MemberId" Type="Int32" DefaultValue="0" />
        </DeleteParameters>
        <UpdateParameters>
            <asp:Parameter Name="Surname" Type="String" />
            <asp:Parameter Name="Forename" Type="String" />
            <asp:Parameter Name="Address1" Type="String" />
            <asp:Parameter Name="Address2" Type="String" />
            <asp:Parameter Name="Address3" Type="String" />
            <asp:Parameter Name="HomePhone" Type="String" />
            <asp:Parameter Name="WorkPhone" Type="String" />
            <asp:Parameter Name="MobilePhone" Type="String" />
            <asp:Parameter Name="Email" Type="String" />
            <asp:Parameter Name="ICUNumber" Type="String" />
            <asp:Parameter Name="KayakInstructor" Type="Int32" />
            <asp:Parameter Name="WantRiverInvites" Type="Boolean" />
            <asp:Parameter Name="Social" Type="Boolean" />
            <asp:Parameter Name="Admin" Type="Boolean" />
            <asp:Parameter Name="Info" Type="Boolean" />
            <asp:Parameter Name="NoGroupsEmails" Type="Boolean" />
            <asp:Parameter Name="NoEmailAttachments" Type="Boolean" />
            <asp:Parameter Name="NoMobilePhoneMessages" Type="Boolean" />
            <asp:Parameter Name="PictureExt" Type="String" />
            <asp:Parameter Name="CanPost" Type="Boolean" />
            <asp:Parameter Name="CanDoLargeUploads" Type="Boolean" />
            <asp:Parameter Name="DontSharePhoneNumbers" Type="Boolean" />
            <asp:Parameter Name="DontShareAddress" Type="Boolean" />
            <asp:Parameter Name="DontShareEmail" Type="Boolean" />
            <asp:Parameter Name="Biography" Type="String" />
            <asp:Parameter Name="HomePage" Type="String" />
            
            <asp:QueryStringParameter Name="UpdateMemberId" QueryStringField="MemberId" Type="Int32" DefaultValue="0" />
        </UpdateParameters>
    </asp:AccessDataSource>
    <asp:FormView Width="100%" ID="FormView1" runat="server" DataSourceID="AccessDataSource1" DataKeyNames="MemberId" OnLoad="FormView1_Load">
        <ItemTemplate>
            <asp:HyperLink ID="HyperLink4" runat="server" NavigateUrl='<%# "Content.aspx?MemberId="+Request.QueryString["MemberId"] %>'>View content by this member</asp:HyperLink>
            <fieldset><legend>Name</legend>
            <table border=0 cellpadding=0 cellspacing=0 class="fields">
                <tr>
                    <td class="labelColumn">Forename:</td>
                    <td class="fieldColumn">            <asp:TextBox ID="ForenameTextBox" runat="server" Text='<%# Bind("Forename") %>' ReadOnly="True">
            </asp:TextBox>
</td>
                </tr>
                <tr>
                    <td class="labelColumn">Surname:</td>
                    <td class="fieldColumn">            <asp:TextBox ID="SurnameTextBox" runat="server" Text='<%# Bind("Surname") %>' ReadOnly="True">
            </asp:TextBox>
</td>
                </tr>
            </table>

            </fieldset>
            <fieldset><legend>Picture and Details</legend>
              <asp:Image style="float:left" ID="Image1" runat="server" ImageUrl='<%# Uploader.Pictures.Domain(this)+"getThumb.aspx?FileName="+pictureUrl()+"&Scale=200" %>' BorderWidth="1px" BorderStyle="Solid" /><br />
              <span class="smallText">          
                <asp:Literal Text='<%# Eval("Biography") %>' ID="BiographyLiteral1" runat="server"></asp:Literal>       
                </span>
            </fieldset>
            <fieldset><legend>Address</legend>
                        <table border=0 cellpadding=0 cellspacing=0 class="fields">
                <tr>
                    <td class="labelColumn">Line 1:</td>
                    <td class="fieldColumn">
                                                            <asp:TextBox Visible='<%# !showInfo("DontShareAddress") %>' ID="TextBox9" runat="server" Text="Private" ReadOnly="True"></asp:TextBox>
            <asp:TextBox Visible='<%# showInfo("DontShareAddress") %>' ID="Address1TextBox" runat="server" Text='<%# Bind("Address1") %>' ReadOnly="True">
            </asp:TextBox>
</td>
                </tr>
                <tr>
                    <td class="labelColumn">Line 2:</td>
                    <td class="fieldColumn">
                                                                                <asp:TextBox Visible='<%# !showInfo("DontShareAddress") %>' ID="TextBox10" runat="server" Text="Private" ReadOnly="True"></asp:TextBox>
            <asp:TextBox Visible='<%# showInfo("DontShareAddress") %>' ID="Address2TextBox" runat="server" Text='<%# Bind("Address2") %>' ReadOnly="True">
            </asp:TextBox>
</td>
                </tr>
                <tr>
                    <td class="labelColumn">Line 3:</td>
                    <td class="fieldColumn">
                                                                                <asp:TextBox Visible='<%# !showInfo("DontShareAddress") %>' ID="TextBox11" runat="server" Text="Private" ReadOnly="True"></asp:TextBox>
            <asp:TextBox Visible='<%# showInfo("DontShareAddress") %>' ID="Address3TextBox" runat="server" Text='<%# Bind("Address3") %>' ReadOnly="True">
            </asp:TextBox>
</td>
                </tr>
            </table>

            </fieldset>
            <fieldset><legend>Contact Details</legend>
            <table class="fields" border=0 cellpadding=0 cellspacing=0>
                <tr>
                    <td class="labelColumn">Work Phone:</td>
                    <td class="fieldColumn">
                                        <asp:TextBox Visible='<%# !showInfo("DontSharePhoneNumbers") %>' ID="TextBox6" runat="server" Text="Private" ReadOnly="True"></asp:TextBox>
<asp:TextBox Visible='<%# showInfo("DontSharePhoneNumbers") %>' ID="HomePhoneTextBox" runat="server" Text='<%# Eval("HomePhone") %>' ReadOnly="True"></asp:TextBox></td>
                </tr>
                
                <tr>
                
                    <td class="labelColumn">Home Phone:</td>
                    <td class="fieldColumn">
                    <asp:TextBox Visible='<%# !showInfo("DontSharePhoneNumbers") %>' ID="TextBox5" runat="server" Text="Private" ReadOnly="True"></asp:TextBox>
                    <asp:TextBox Visible='<%# showInfo("DontSharePhoneNumbers") %>' ID="TextBox2" runat="server" Text='<%# Eval("WorkPhone") %>' ReadOnly="True"></asp:TextBox></td>
                </tr>

                <tr>
                    <td class="labelColumn">Mobile Phone:</td>
                    <td class="fieldColumn">
                    <asp:TextBox Visible='<%# !showInfo("DontSharePhoneNumbers") %>' ID="TextBox7" runat="server" Text="Private" ReadOnly="True"></asp:TextBox>
                    <asp:TextBox Visible='<%# showInfo("DontSharePhoneNumbers") %>' ID="TextBox3" runat="server" Text='<%# Eval("MobilePhone") %>' ReadOnly="True"></asp:TextBox><br />
                    <asp:HyperLink Visible='<%# showInfo("DontSharePhoneNumbers") %>' style="float:right" ID="HyperLink2" runat="server" NavigateUrl='<%# "SMS.aspx?MemberId="+Eval("MemberId") %>' >Send Text</asp:HyperLink>
                    </td>
                </tr>

                <tr>
                    <td class="labelColumn">Email:</td>
                    <td class="fieldColumn">
                    <asp:TextBox Visible='<%# !showInfo("DontShareEmail") %>' ID="TextBox8" runat="server" Text="Private" ReadOnly="True"></asp:TextBox>
<asp:HyperLink Visible='<%# showInfo("DontShareEmail") %>' ID="HyperLink1" runat="server" Text='<%# Eval("Email") %>' NavigateUrl='<%# "mailto:"+Eval("Email") %>'></asp:HyperLink></td>
                </tr>

                <tr>
                    <td class="labelColumn">Personal Home Page:</td>
                    <td class="fieldColumn"><asp:HyperLink ID="HyperLink3" runat="server" Text='<%# Eval("HomePage") %>' NavigateUrl='<%# Eval("HomePage") %>'></asp:HyperLink></td>
                </tr>
                
            </table>
            
            </fieldset>
            <fieldset><legend>Experience</legend>
            <table border=0 cellpadding=0 cellspacing=0 class="fields">
                <tr>
                    <td class="labelColumn">ICU Number:</td>
                    <td class="fieldColumn"><asp:TextBox ID="ICUNumberTextBox" ReadOnly="true" runat="server" MaxLength="10" Text='<%# Eval("ICUNumber") %>'></asp:TextBox></td>
                </tr>
                <tr>
                    <td class="labelColumn">Kayak Instructor:
                    </td>
                    <td class="fieldColumn">            <asp:DropDownList Enabled="false" ID="DropDownList1" runat="server" SelectedValue='<%# Bind("KayakInstructor") %>'>
                <asp:ListItem Value="0" Selected="True">None</asp:ListItem>
                <asp:ListItem Value="1">Level 1</asp:ListItem>
                <asp:ListItem Value="2">Level 2</asp:ListItem>
                <asp:ListItem Value="3">Level 3</asp:ListItem>
                <asp:ListItem Value="4">Level 4</asp:ListItem>
                <asp:ListItem Value="5">Level 5</asp:ListItem>
            </asp:DropDownList>
</td>
                </tr>
                <tr>
                    <td class="labelColumn">First Aid:</td>
                    <td class="fieldColumn"><asp:CheckBox Enabled="false" ID="FirstAidCheckBox" runat="server" Checked='<%# Eval("FirstAid") %>' />
            </td>
                </tr>
            </table>
            </fieldset>
            <fieldset><legend>Groups</legend>

            <table border=0 cellpadding=0 cellspacing=0 class="fields">
                <tr>
                    <td class="labelColumn">Want River Invites</td>
                    <td class="fieldColumn">            <a style="float:right" href="Resources.aspx?ResourceId=6">About</a>
            <asp:CheckBox Enabled=false ID="WantRiverInvitesCheckBox" runat="server" Checked='<%# Eval("WantRiverInvites") %>' />
</td>
                </tr>
                <tr>
                    <td class="labelColumn">Social</td>
                    <td class="fieldColumn">
            <asp:CheckBox Enabled=false ID="SocialCheckBox" runat="server" Checked='<%# Eval("Social") %>' />
</td>
                </tr>
                <tr>
                    <td class="labelColumn">Admin</td>
                    <td class="fieldColumn">            <asp:CheckBox Enabled=false ID="AdminCheckBox" runat="server" Checked='<%# Eval("Admin") %>' /></td>
                </tr>
                <tr>
                    <td class="labelColumn">Info</td>
                    <td class="fieldColumn"><asp:CheckBox Enabled=false ID="InfoCheckBox" runat="server" Checked='<%# Eval("Info") %>' /></td>
                </tr>
            </table>
            </fieldset>
            <fieldset><legend>Opt Outs</legend>
            <table width="100%" border=0 cellpadding=0 cellspacing=0>
            <tr>
                <td class="labelColumn">No Group Emails:</td>
                <td class="fieldColumn">
                <a style="float:right" href="Resources.aspx?ResourceId=5" rel="Help">About</a>
                <asp:CheckBox Enabled=false ID="NoGroupEmailsCheckBox" runat="server" Checked='<%# Eval("NoGroupEmails") %>' />
                </td>
            </tr>
            <tr>
                <td class="labelColumn">No Group Mobile Phone Texts:</td>
                <td class="fieldColumn"><asp:CheckBox Enabled=false ID="NoMobilePhoneMessagesCheckBox" runat="server" Checked='<%# Eval("NoMobilePhoneMessages") %>' /></td>
            </tr>
            <tr>
                <td class="labelColumn">Dont Share Address:</td>
                <td class="fieldColumn"><asp:CheckBox Enabled=false ID="DontShareAddressCheckBox" runat="server" Checked='<%# Eval("DontShareAddress") %>' /></td>
            </tr>
            <tr>
                <td class="labelColumn">Dont Share Phone Numbers:</td>
                <td class="fieldColumn"><asp:CheckBox Enabled=false ID="DontSharePhoneNumbersCheckBox" runat="server" Checked='<%# Eval("DontSharePhoneNumbers") %>' /></td>
            </tr>
            <tr>
                <td class="labelColumn">Dont Share Email:</td>
                <td class="fieldColumn"><asp:CheckBox Enabled=false ID="DontShareEmailCheckBox" runat="server" Checked='<%# Eval("DontShareEmail") %>' /></td>
            </tr>
            </table>

            </fieldset>
            <fieldset>
                <legend>Permissions</legend>
                            <table border=0 cellpadding=0 cellspacing=0 class="fields">
                <tr>
                    <td class="labelColumn">Allowed to add Content:</td>
                    <td class="fieldColumn">                <a style="float:right" href="Resources.aspx?ResourceId=7" rel="Help">About</a>
            <asp:CheckBox Enabled=false ID="CheckBox1" runat="server" Checked='<%# Eval("CanPost") %>' />
</td>
                </tr>
                <tr>
                    <td class="labelColumn">Allowed to upload very large files:</td>
                    <td class="fieldColumn">                    
            <asp:CheckBox Enabled=false ID="CheckBox3" runat="server" Checked='<%# Eval("CanDoLargeUploads") %>' />
</td>
                </tr>
            </table>

            </fieldset>
            <span runat="server" style='<%# allowEdit()?";display:none":"" %>'><span class="smallText">If you <a href="Login.aspx">login</a> as an administrator, you will be able to edit or delete this record.</span></span>
                        <asp:LinkButton ID="EditButton" runat="server" Visible='<%# allowEdit() %>' CausesValidation="False" CommandName="Edit"
                            Text="Edit">
                        </asp:LinkButton>
                        &nbsp;&nbsp;&nbsp;&nbsp;
                        <asp:LinkButton ID="LinkButton1" runat="server" Visible='<%# allowEdit() %>' CausesValidation="False" CommandName="Delete"
                            Text="Delete">
                        </asp:LinkButton>

        </ItemTemplate>
        <InsertItemTemplate>
        </InsertItemTemplate>
        <EditItemTemplate>
             <fieldset><legend>Name</legend>
                         <table border=0 cellpadding=0 cellspacing=0 class="fields">
                <tr>
                    <td class="labelColumn">Forename:</td>
                    <td class="fieldColumn">            <asp:TextBox ID="ForenameTextBox" runat="server" Text='<%# Bind("Forename") %>'>
            </asp:TextBox>
</td>
                </tr>
                <tr>
                    <td class="labelColumn">Surname:</td>
                    <td class="fieldColumn">            <asp:TextBox ID="SurnameTextBox" runat="server" Text='<%# Bind("Surname") %>'>
            </asp:TextBox>
</td>
                </tr>
            </table>

            </fieldset>
            <fieldset><legend>Picture and Details</legend>
              <asp:Image ID="Image1" runat="server" ImageUrl='<%# Uploader.Pictures.Domain(this)+"getThumb.aspx?FileName="+pictureUrl()+"&Scale=200" %>' BorderWidth="1px" BorderStyle="Solid" />
                <asp:TextBox ID="TextBox4" runat="server" Text='<%# Bind("PictureExt") %>' Visible="False"></asp:TextBox><br />
              <span class="label">Upload:</span>
              <asp:FileUpload ID="FileUpload1" runat="server" /></fieldset>
              <asp:TextBox Text='<%# Bind("Biography") %>' TextMode=MultiLine Rows=4 ID="BiographyTextBox1" runat="server"></asp:TextBox>       
            <fieldset><legend>Address</legend>
            <table border=0 cellpadding=0 cellspacing=0 class="fields">
                <tr>
                    <td class="labelColumn">Line 1:</td>
                    <td class="fieldColumn">            <asp:TextBox ID="Address1TextBox" runat="server" Text='<%# Bind("Address1") %>'>
            </asp:TextBox>
</td>
                </tr>
                <tr>
                    <td class="labelColumn">Line 2:</td>
                    <td class="fieldColumn">            <asp:TextBox ID="Address2TextBox" runat="server" Text='<%# Bind("Address2") %>'>
            </asp:TextBox>
</td>
                </tr>
                <tr>
                    <td class="labelColumn">Line 3:</td>
                    <td class="fieldColumn">            <asp:TextBox ID="Address3TextBox" runat="server" Text='<%# Bind("Address3") %>'>
            </asp:TextBox>
</td>
                </tr>
            </table>

            </fieldset>
            <fieldset><legend>Contact Details</legend>
                        <table border=0 cellpadding=0 cellspacing=0 class="fields">
                <tr>
                    <td class="labelColumn">Home Phone:</td>
                    <td class="fieldColumn">            <asp:TextBox ID="HomePhoneTextBox" runat="server" Text='<%# Bind("HomePhone") %>'>
            </asp:TextBox>
</td>
                </tr>
                <tr>
                    <td class="labelColumn">Work Phone:</td>
                    <td class="fieldColumn">            <asp:TextBox ID="WorkPhoneTextBox" runat="server" Text='<%# Bind("WorkPhone") %>'>
            </asp:TextBox>
</td>
                </tr>
                <tr>
                    <td class="labelColumn">Mobile Phone:</td>
                    <td class="fieldColumn">            <asp:TextBox ID="MobilePhoneTextBox" runat="server" Text='<%# Bind("MobilePhone") %>'>
            </asp:TextBox>
</td>
                </tr>
                <tr>
                    <td class="labelColumn">Email:</td>
                    <td class="fieldColumn">            <asp:TextBox ID="EmailTextBox" runat="server" Text='<%# Bind("Email") %>'>
            </asp:TextBox>
</td>
                </tr>
                <tr>
                    <td class="labelColumn">Personal Home Page:</td>
                    <td class="fieldColumn">            <asp:TextBox ID="TextBox1" runat="server" Text='<%# Bind("HomePage") %>'>
            </asp:TextBox>
</td>
                </tr>
            </table>

            </fieldset>
            <fieldset><legend>Experience</legend>
                        <table border=0 cellpadding=0 cellspacing=0 class="fields">
                <tr>
                                <tr>
                    <td class="labelColumn">ICU Number:</td>
                    <td class="fieldColumn"><asp:TextBox ID="ICUNumberTextBox" runat="server" MaxLength="10" Text='<%# Bind("ICUNumber") %>'></asp:TextBox></td>
                </tr>

                    <td class="labelColumn">Kayak Instructor:</td>
                    <td class="fieldColumn">            <asp:DropDownList ID="DropDownList1" runat="server" SelectedValue='<%# Bind("KayakInstructor") %>'>
                <asp:ListItem Value="0" Selected="True">None</asp:ListItem>
                <asp:ListItem Value="1">Level 1</asp:ListItem>
                <asp:ListItem Value="2">Level 2</asp:ListItem>
                <asp:ListItem Value="3">Level 3</asp:ListItem>
                <asp:ListItem Value="4">Level 4</asp:ListItem>
                <asp:ListItem Value="5">Level 5</asp:ListItem>
            </asp:DropDownList>
</td>
                </tr>
                <tr>
                    <td class="labelColumn">First Aid:</td>
                    <td class="fieldColumn">            <asp:CheckBox Enabled="false" ID="FirstAidCheckBox" runat="server" Checked='<%# Eval("FirstAid") %>' />
</td>
                </tr>
            </table>

            </fieldset>
            <fieldset><legend>Groups</legend>
            <table border=0 cellpadding=0 cellspacing=0 class="fields">
                <tr>
                    <td class="labelColumn">Want River Invites:</td>
                    <td class="fieldColumn">            <a style="float:right" href="Resources.aspx?ResourceId=6">About</a>
            <asp:CheckBox ID="WantRiverInvitesCheckBox" runat="server" Checked='<%# Bind("WantRiverInvites") %>' />
</td>
                </tr>
                <tr>
                    <td class="labelColumn">Social:</td>
                    <td class="fieldColumn">
            <asp:CheckBox ID="CheckBox2" runat="server" Checked='<%# Bind("Social") %>' />
</td>
                </tr>
                <tr>
                    <td class="labelColumn">Admin:</td>
                    <td class="fieldColumn">            <asp:CheckBox ID="AdminCheckBox" runat="server" Enabled='<%# allowAdminEdit() %>' Checked='<%# Bind("Admin") %>' />
</td>
                </tr>
                <tr>
                    <td class="labelColumn">Info:</td>
                    <td class="fieldColumn">            <asp:CheckBox ID="InfoCheckBox" runat="server" Enabled='<%# allowAdminEdit() %>' Checked='<%# Bind("Info") %>' />
</td>
                </tr>
            </table>
            </fieldset>

            <fieldset><legend>Opt Outs</legend>
            <table width="100%" border=0 cellpadding=0 cellspacing=0>
            <tr>
                <td class="labelColumn">No Group Emails:</td>
                <td class="fieldColumn">
                <a style="float:right" href="Resources.aspx?ResourceId=5" rel="Help">About</a>
                <asp:CheckBox ID="NoGroupEmailsCheckBox" runat="server" Checked='<%# Bind("NoGroupEmails") %>' />
                </td>
            </tr>
            <tr>
                <td class="labelColumn">No Group Mobile Phone Texts:</td>
                <td class="fieldColumn"><asp:CheckBox ID="NoMobilePhoneMessagesCheckBox" runat="server" Checked='<%# Bind("NoMobilePhoneMessages") %>' /></td>
            </tr>
            <tr>
                <td class="labelColumn">Dont Share Address:</td>
                <td class="fieldColumn"><asp:CheckBox ID="DontShareAddressCheckBox" runat="server" Checked='<%# Bind("DontShareAddress") %>' /></td>
            </tr>
            <tr>
                <td class="labelColumn">Dont Share Phone Numbers:</td>
                <td class="fieldColumn"><asp:CheckBox ID="DontSharePhoneNumbersCheckBox" runat="server" Checked='<%# Bind("DontSharePhoneNumbers") %>' /></td>
            </tr>
            <tr>
                <td class="labelColumn">Dont Share Email:</td>
                <td class="fieldColumn"><asp:CheckBox ID="DontShareEmailCheckBox" runat="server" Checked='<%# Bind("DontShareEmail") %>' /></td>
            </tr>
            </table>
            </fieldset>
            <fieldset>
            <legend>Permissions</legend>
            <table border=0 cellpadding=0 cellspacing=0 class="fields">
                <tr>
                    <td class="labelColumn">Allowed to add Content:</td>
                    <td class="fieldColumn">            <asp:CheckBox ID="CanPost" runat="server" Enabled='<%# allowAdminEdit() %>' Checked='<%# Bind("CanPost") %>' /><br />
</td>
                </tr>
                <tr>
                    <td class="labelColumn">Allowed to upload very large files:</td>
                    <td class="fieldColumn">            <asp:CheckBox ID="CheckBox4" runat="server" Enabled='<%# allowAdminEdit() %>' Checked='<%# Bind("CanDoLargeUploads") %>' /><br />
</td>
                </tr>
            </table>
           
            </fieldset>
            <asp:LinkButton ID="UpdateButton" runat="server" CausesValidation="True" CommandName="Update"
                Text="Update">
            </asp:LinkButton>
            <asp:LinkButton ID="UpdateCancelButton" runat="server" CausesValidation="False" CommandName="Cancel"
                Text="Cancel">
            </asp:LinkButton>
      </EditItemTemplate>
    </asp:FormView>
    &nbsp;
    </asp:Content>
