<%@ Page Language="C#" MasterPageFile="~/Default.master" Theme="Database" %>

<script runat=server>
    //
    // Part of the Content Management System by Declan Brennan ( http://sites.declan.brennan.name )
    // Available subject to the conditions in http://www.voyagers.ie/license.htm .
    //

    protected void LogoutButton_Click(object sender, EventArgs e)
    {
        FormsAuthentication.SignOut();
        Session.Remove("MemberId");
        Session.Remove("Admin");
        Session.Remove("CanPost");
        Session.Remove("CanDoLargeUploads");
        Response.Redirect("default.aspx");
    }
    
    protected void LoginButton_Click(object sender, EventArgs e)
    {
        object[] rc = DataAccess.GetData(Server, "SELECT MemberId,Admin,CanPost,CanDoLargeUploads,Activated FROM Member WHERE UserId=@UserId AND Password=@Password", "@UserId", UserId.Text, "@Password", Password.Text);
        
        error1.Text= "";
        if (rc != null && rc.Length == 5)
        {
            if ((bool)rc[4])
            {
                Session["MemberId"] = (int)rc[0];
                Session["Admin"] = (bool)rc[1];
                Session["CanPost"]= (bool)rc[2];
                Session["CanDoLargeUploads"] = (bool)rc[3];
                FormsAuthentication.SetAuthCookie(UserId.Text, false);
                if (FormsAuthentication.GetRedirectUrl(UserId.Text, false).ToLower().EndsWith("default.aspx"))
                {	// creates authentication ticket for user then display confirmation
                    //Response.Redirect("default.aspx");
                    Response.Redirect(ReturnUrl.Value);
                }
                else
                {	// user came here by accessing a secure page, continue
                    // on to the page they were trying to access
                    FormsAuthentication.RedirectFromLoginPage(UserId.Text, false);
                }
            }
            else
                error1.Text = "You are unable to login because your membership is deactivated. Please contact membership@voyagers.ie if you want more details.";
        }
        else
        {
            // FormsAuthentication.SignOut();
            error1.Text = "Login Failed! Please try again.";
        }
            

    }

    protected void MultiView1_Load(object sender, EventArgs e)
    {
        if (! this.IsPostBack)
        {
            if (Request.UrlReferrer!=null)
                ReturnUrl.Value= Request.UrlReferrer.OriginalString;
        }

        if (Request.IsAuthenticated)
        {
            MultiView1.ActiveViewIndex = 1;
        }
    }

</script>

<asp:Content ID="Content1" runat="server" ContentPlaceHolderId="ContentPlaceHolder1">
    <asp:MultiView ID="MultiView1" runat="server" ActiveViewIndex="0" OnLoad="MultiView1_Load">
    <asp:View ID="View1" runat="server">
    <fieldset><legend>Login</legend>
    <asp:Label runat="server" ID="error1" SkinId="error"></asp:Label><br />
    <span class="label">User ID:</span><asp:TextBox ID="UserId" runat="server"></asp:TextBox><br />
    <span class="label">Password:</span><asp:TextBox ID="Password" runat="server" TextMode="Password"></asp:TextBox><br />
        <asp:HyperLink ID="HyperLink1" runat="server" NavigateUrl="LoginForgotten.aspx">Can't remember your login details?</asp:HyperLink><br />
        <asp:HyperLink ID="HyperLink2" runat="server" NavigateUrl="http://www.voyagers.ie/Resources.aspx?ResourceId=49">Not yet a member?</asp:HyperLink>
    </fieldset>
    <asp:Button ID="LoginButton" runat="server" Text="Login" OnClick="LoginButton_Click" />
    <br />
    <br />
    </asp:View>
    <asp:View runat="server" ID="View2">
        <h2>You are currently logged in.</h2>
        <asp:Button ID="LogoutButton" runat="server" Text="Logout" OnClick="LogoutButton_Click" />
    </asp:View>
    </asp:MultiView>
    <asp:HiddenField ID="ReturnUrl" runat="server" Value="default.aspx" />
</asp:Content>
