<%@ Page Language="C#" MasterPageFile="~/Default.master" %>

<script runat="server">
    //
    // Part of the Content Management System by Declan Brennan ( http://sites.declan.brennan.name )
    // Available subject to the conditions in http://www.voyagers.ie/license.htm .
    //
    private bool showInfo(string infoName)
    {
        if (Session["MemberId"] == null)
            return false;

        return (bool)Session["Admin"] || ((int)this.Eval("MemberId") == (int)Session["MemberId"]) || ! (bool)Eval(infoName);
    }

</script>

<asp:Content ID="Content1" runat="server" ContentPlaceHolderId="ContentPlaceHolder1">
    <asp:AccessDataSource ID="AccessDataSource1" runat="server" DataFile="App_Data/voyagers.mdb" 
    SelectCommand="SELECT [MemberId], [Forename], [Surname], [Email], [HomePhone], [WorkPhone], [MobilePhone], [DontSharePhoneNumbers], [DontShareEmail] FROM [Member] ORDER BY [Surname], [Forename]"
    DeleteCommand= "DELETE FROM [Member] WHERE [MemberId]=@MemberId">
    </asp:AccessDataSource>
    <asp:HyperLink style="float:right" ID="HyperLink3" runat="server" NavigateUrl="PrintMembers.aspx">Printer Version</asp:HyperLink>
    <br />
    <asp:GridView ID="GridView1" runat="server" DataSourceID="AccessDataSource1" AutoGenerateColumns="False" AllowPaging="True" PageSize="20" BorderColor="Navy" BorderStyle="Solid" BorderWidth="1px" DataKeyNames="MemberId" >
        <Columns>
            <asp:BoundField DataField="MemberId" HeaderText="MemberId" Visible=False />
            <asp:HyperLinkField DataNavigateUrlFields="MemberId" DataTextField="Forename"
                HeaderText="Forename" SortExpression="Forename" DataNavigateUrlFormatString="Member.aspx?MemberId={0}" >
                <ItemStyle HorizontalAlign="Left" />
                <HeaderStyle HorizontalAlign="Left" />
            </asp:HyperLinkField>
            <asp:HyperLinkField DataNavigateUrlFields="MemberId" DataTextField="Surname"
                HeaderText="Surname" SortExpression="Surname" DataNavigateUrlFormatString="Member.aspx?MemberId={0}" >
                <ItemStyle HorizontalAlign="Left" />
                <HeaderStyle HorizontalAlign="Left" />
            </asp:HyperLinkField>
            <asp:TemplateField HeaderText="Home Phone" SortExpression="HomePhone">
                <ItemTemplate>
                    <asp:Label ID="Label1" runat="server" Text='<%# showInfo("DontSharePhoneNumbers")?Eval("HomePhone"):"Private" %>'></asp:Label>
                </ItemTemplate>
                <ItemStyle HorizontalAlign="Left" />
                <HeaderStyle HorizontalAlign="Left" />
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Work Phone" SortExpression="WorkPhone">
                <ItemTemplate>
                    <asp:Label ID="Label2" runat="server" Text='<%# showInfo("DontSharePhoneNumbers")?Eval("WorkPhone"):"Private" %>'></asp:Label>
                </ItemTemplate>
                <ItemStyle HorizontalAlign="Left" />
                <HeaderStyle HorizontalAlign="Left" />
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Mobile Phone" SortExpression="MobilePhone">
                <ItemTemplate>
                    <asp:Label Visible='<%# !showInfo("DontSharePhoneNumbers") %>' ID="Label3" runat="server" Text="Label">Private</asp:Label>
                    <asp:HyperLink Visible='<%# showInfo("DontSharePhoneNumbers") %>' ID="HyperLink1" runat="server" NavigateUrl='<%# Eval("MemberId", "SMS.aspx?MemberId={0}") %>'
                        Text='<%# Eval("MobilePhone") %>'></asp:HyperLink>
                </ItemTemplate>
                <ItemStyle HorizontalAlign="Left" />
                <HeaderStyle HorizontalAlign="Left" />
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Email">
                <ItemTemplate>
                    <asp:Label Visible='<%# !showInfo("DontShareEmail") %>' ID="Label4" runat="server" Text="Label">Private</asp:Label>
                    <asp:HyperLink Visible='<%# showInfo("DontShareEmail") %>' ID="HyperLink2" runat="server" NavigateUrl='<%# Eval("Email", "mailto:{0}") %>'
                        Text='<%# Eval("Email") %>'></asp:HyperLink>
                </ItemTemplate>
                <ItemStyle HorizontalAlign="Left" />
                <HeaderStyle HorizontalAlign="Left" />
            </asp:TemplateField>
        </Columns>
        <PagerSettings FirstPageImageUrl="~/recordfirst.gif" LastPageImageUrl="~/recordlast.gif"
            Mode="NextPreviousFirstLast" NextPageImageUrl="~/recordnext.gif" PreviousPageImageUrl="~/recordprevious.gif" FirstPageText="First Page" LastPageText="Last Page" NextPageText="Next Page" PreviousPageText="Previous Page" />
        <EmptyDataTemplate>
            No members.
        </EmptyDataTemplate>
        <HeaderStyle BorderColor="Navy" BorderStyle="Solid" BorderWidth="1px" />
    </asp:GridView>
</asp:Content>
