<%@ Page Language="C#" MasterPageFile="~/Default.master" %>
<%@ Register TagPrefix="uc1" TagName="IfLoggedIn" Src="IfLoggedIn.ascx" %>

<script runat="server">
    //
    // Part of the Content Management System by Declan Brennan ( http://sites.declan.brennan.name )
    // Available subject to the conditions in http://www.voyagers.ie/license.htm .
    //
</script>

<asp:Content ID="Content1" runat="server" ContentPlaceHolderID="ContentPlaceHolder1">
    <asp:AccessDataSource ID="AccessDataSource1" runat="server" DataFile="~/App_Data/voyagers.mdb"
        SelectCommand="SELECT [LinkId], [Title], [Url], [UserID], [CreatedBy],[CreatedOn],LinkKind.Name AS KindName FROM ([Link] LEFT OUTER JOIN [Member] ON Member.MemberId=Link.CreatedBy) LEFT OUTER JOIN [LinkKind] ON LinkKind.LinkKindId=Link.Kind WHERE @WhichKind=0 OR Link.Kind=@WhichKind ORDER BY LinkKind.Name,[CreatedOn] DESC">
        <SelectParameters>
            <asp:ControlParameter Name="WhichKind" ControlID="DropDownList1" PropertyName="SelectedValue"
                Type="Int32" />
        </SelectParameters>
    </asp:AccessDataSource>
    <asp:AccessDataSource ID="AccessDataSource2" runat="server" DataFile="~/App_Data/voyagers.mdb"
        SelectCommand="SELECT TOP 1 0 AS LinkKindId,'All' AS Name FROM LinkKind UNION ALL SELECT [LinkKindId], [Name] FROM [LinkKind]">
    </asp:AccessDataSource>
    <span class="label">Display links of Kind:&nbsp;</span>
    <asp:DropDownList ID="DropDownList1" runat="server" AutoPostBack="True" DataSourceID="AccessDataSource2"
        DataTextField="Name" DataValueField="LinkKindId">
    </asp:DropDownList>
    <asp:GridView ID="GridView1" runat="server" AllowPaging="True" DataSourceID="AccessDataSource1"
        AutoGenerateColumns="False" PageSize="20">
        <EmptyDataTemplate>
            No links.
        </EmptyDataTemplate>
        <Columns>
            <asp:BoundField HeaderText="Kind" DataField="KindName" >
                <ItemStyle HorizontalAlign="Left" />
                <HeaderStyle HorizontalAlign="Left" />
            </asp:BoundField>
            <asp:HyperLinkField DataNavigateUrlFields="Url" DataTextField="Title" HeaderText="Link"
                DataNavigateUrlFormatString="{0}" >
                <ItemStyle HorizontalAlign="Left" Width="40%" />
                <HeaderStyle HorizontalAlign="Left" />
            </asp:HyperLinkField>
            <asp:HyperLinkField DataNavigateUrlFields="CreatedBy" DataTextField="UserID" HeaderText="Created By"
                DataNavigateUrlFormatString="Member.aspx?MemberId={0}" >
                <ItemStyle HorizontalAlign="Left" />
                <HeaderStyle HorizontalAlign="Left" />
            </asp:HyperLinkField>
            <asp:BoundField HeaderText="On" DataFormatString="{0:dd MMM yy}" HtmlEncode="False" DataField="CreatedOn" >
                <ItemStyle HorizontalAlign="Left" />
                <HeaderStyle HorizontalAlign="Left" />
            </asp:BoundField>
            <asp:HyperLinkField DataNavigateUrlFields="LinkId" Text="Details" DataNavigateUrlFormatString="Link.aspx?LinkId={0}"
                ShowHeader="False" >
                <ItemStyle HorizontalAlign="Right" />
                <HeaderStyle HorizontalAlign="Right" />
            </asp:HyperLinkField>
        </Columns>
    </asp:GridView>
    <uc1:IfLoggedIn PartnerId="LoggedIn" ID="IfLoggedIn1" runat="server" AbleTo="add links">
    </uc1:IfLoggedIn>
    <span id="LoggedIn" runat="server"><a href="Link.aspx?mode=add">Add a Link</a> </span>
</asp:Content>
