<%@ Page Language="C#" MasterPageFile="~/Default.master" %>
<%@ Register TagPrefix="uc1" TagName="IfLoggedIn" Src="IfLoggedIn.ascx" %>

<script runat="server">
    //
    // Part of the Content Management System by Declan Brennan ( http://sites.declan.brennan.name )
    // Available subject to the conditions in http://www.voyagers.ie/license.htm .
    //
</script>

<asp:Content ID="Content1" runat="server" ContentPlaceHolderId="ContentPlaceHolder1">
    <asp:AccessDataSource ID="AccessDataSource1" runat="server" DataFile="~/App_Data/voyagers.mdb"
        SelectCommand="SELECT [GalleryId],[Title], [Description], [CreatedBy], [CreatedOn], [UserID], [MemberId] FROM [Gallery] LEFT OUTER JOIN [Member] ON Member.MemberId=Gallery.CreatedBy ORDER BY [CreatedOn] DESC">
    </asp:AccessDataSource>
    <asp:GridView Width="100%" ID="GridView1" runat="server" AllowPaging="True" DataSourceID="AccessDataSource1" AutoGenerateColumns="False" PageSize="20">
        <EmptyDataTemplate>
            No Galleries.
        </EmptyDataTemplate>
        <Columns>
            <asp:TemplateField HeaderText="Title">
                <ItemTemplate>
                    <asp:HyperLink ToolTip='<%# Eval("Description") %>' ID="HyperLink1" runat="server" NavigateUrl='<%# Eval("GalleryId", "Gallery.aspx?GalleryId={0}") %>'
                        Text='<%# Eval("Title") %>'></asp:HyperLink>
                </ItemTemplate>
                <HeaderStyle HorizontalAlign="Left" />
                <ItemStyle HorizontalAlign="Left" Width="50%" />
            </asp:TemplateField>
            <asp:HyperLinkField DataNavigateUrlFields="MemberId" DataTextField="UserID"
                HeaderText="Created By" DataNavigateUrlFormatString="Member.aspx?MemberId={0}">
                <HeaderStyle HorizontalAlign="Left" />
                <ItemStyle HorizontalAlign="Left" />
            </asp:HyperLinkField>
            <asp:BoundField DataField="CreatedOn" DataFormatString="{0:dd MMM yy}" HtmlEncode="False" HeaderText="On" >
                <HeaderStyle HorizontalAlign="Left" />
                <ItemStyle HorizontalAlign="Left" />
            </asp:BoundField>
        </Columns>
    </asp:GridView>
    <uc1:IfLoggedIn PartnerId="LoggedIn" id="IfLoggedIn1" runat="server" AbleTo="add galleries"></uc1:IfLoggedIn>
    <span id="LoggedIn" runat="server">
    <a href="Gallery.aspx?mode=add">Add a Gallery</a>
    </span>
</asp:Content>