<%@ Page Language="C#" MasterPageFile="~/Default.master" %>
<%@ Register TagPrefix="uc1" TagName="IfLoggedIn" Src="IfLoggedIn.ascx" %>

<script runat="server">
    //
    // Part of the Content Management System by Declan Brennan ( http://sites.declan.brennan.name )
    // Available subject to the conditions in http://www.voyagers.ie/license.htm .
    //
</script>

<asp:Content ID="Content1" runat="server" ContentPlaceHolderId="ContentPlaceHolder1">
    <asp:AccessDataSource ID="AccessDataSource1" runat="server" DataFile="~/App_Data/voyagers.mdb"
        SelectCommand="SELECT [EventId],[Starts], [Title], [Description], [Contact], Member.UserID as ContactID FROM [Event] LEFT OUTER JOIN [Member] ON Member.MemberId=Event.Contact ORDER BY [Starts] DESC">
    </asp:AccessDataSource>

          <span id="Span1" runat="server" visible='<%# Session["MemberId"]==null %>' >
            <span class="smallText">Normally events are only open to members of Voyagers. You can find out more about joining <a href="http://www.voyagers.ie/Resources.aspx?ResourceId=49">here.</a></span><br /><br />
            </span><br />
    <asp:HyperLink style="float:right" ID="HyperLink3" runat="server" NavigateUrl="PrintEvents.aspx">Printer Version</asp:HyperLink>
    <br />

    <asp:GridView ID="GridView1" runat="server" AllowPaging="True" DataSourceID="AccessDataSource1" AutoGenerateColumns="False" PageSize="20">
        <EmptyDataTemplate>
            No events.
        </EmptyDataTemplate>
        <Columns>
            <asp:TemplateField HeaderText="Title">
                <ItemTemplate>
                    <asp:HyperLink ID="HyperLink1" runat="server" NavigateUrl='<%# Eval("EventId", "Event.aspx?EventId={0}") %>'
                        Text='<%# Eval("Title") %>'></asp:HyperLink>
                </ItemTemplate>
                <HeaderStyle HorizontalAlign="Left" />
                <ItemStyle HorizontalAlign="Left" />
            </asp:TemplateField>
            <asp:BoundField DataFormatString="{0:ddd dd MMM yy}" HtmlEncode="False" DataField="Starts" HeaderText="Starts" >
                <HeaderStyle HorizontalAlign="Left" />
                <ItemStyle HorizontalAlign="Left" />
            </asp:BoundField>
            <asp:HyperLinkField DataNavigateUrlFields="Contact" DataTextField="ContactId"
                HeaderText="Contact" DataNavigateUrlFormatString="Member.aspx?MemberId={0}" >
                <HeaderStyle HorizontalAlign="Left" />
                <ItemStyle HorizontalAlign="Left" />
            </asp:HyperLinkField>
        </Columns>
    </asp:GridView>
    
        <uc1:IfLoggedIn PartnerId="LoggedIn" id="IfLoggedIn1" runat="server" AbleTo="add events"></uc1:IfLoggedIn>
    <span id="LoggedIn" runat="server">
    <a href="Event.aspx?mode=add">Add an Event</a>
    </span>

</asp:Content>