<%@ Page Language="C#" MasterPageFile="~/Default.master" %>
<%@ Register TagPrefix="uc1" TagName="IfAdmin" Src="IfAdmin.ascx" %>

<script runat="server">
    //
    // Part of the Content Management System by Declan Brennan ( http://sites.declan.brennan.name )
    // Available subject to the conditions in http://www.voyagers.ie/license.htm .
    //

    /*
    protected void Button1_Click(object sender, EventArgs e)
    {
        DetailsView1.UpdateItem(true);
    }
     */

    protected void DetailsView1_ItemUpdating(object sender, DetailsViewUpdateEventArgs e)
    {
    }

    protected void Button2_Click(object sender, EventArgs e)
    {
        try
        {
            this.FormView1.UpdateItem(false);
        }
        catch (System.Data.OleDb.OleDbException)
        {
            // Field 'Member.Surname' cannot be a zero length string
        }
    }

    /*
    private bool allowEdit()
    {
        if (this.Session["MemberId"]==null)
            return false;
        return (bool)Session["Admin"] || ((int)this.Eval("UploadedBy") == (int)Session["MemberId"]);
    }
    */

    protected void FormView1_Load(object sender, EventArgs e)
    {
        if (this.Request.QueryString["mode"] == "add")
        {
            /*
            if (!(bool)Session["Admin"])
                this.MultiView1.ActiveViewIndex = 1;
            else
             */
            this.FormView1.DefaultMode = FormViewMode.Insert;
        }
    }

    protected void FormView1_ItemCommand(object sender, FormViewCommandEventArgs e)
    {
        if (e.CommandName == "Cancel")
            Response.Redirect("ListLinks.aspx", false);
    }

    
    
    protected void AccessDataSource1_Updating(object sender, SqlDataSourceCommandEventArgs e)
    {
    }

    protected void AccessDataSource1_Updated(object sender, SqlDataSourceStatusEventArgs e)
    {
        SideBarCacheDependency.Reset();
        Response.Redirect("ListLinks.aspx", false);
        
    }

    protected void AccessDataSource1_Deleted(object sender, SqlDataSourceStatusEventArgs e)
    {
        SideBarCacheDependency.Reset();
        Response.Redirect("ListLinks.aspx", false);
    }

    protected void AccessDataSource1_Inserting(object sender, SqlDataSourceCommandEventArgs e)
    {
    }
    
    protected void AccessDataSource1_Inserted(object sender, SqlDataSourceStatusEventArgs e)
    {
        SideBarCacheDependency.Reset();
        Response.Redirect("ListLinks.aspx", false);
    }
    
</script>

<asp:Content ID="Content1" runat="server" ContentPlaceHolderId="ContentPlaceHolder1">
    <asp:MultiView ID="MultiView1" runat=server ActiveViewIndex="0">
        <asp:View ID="View1" runat=server>
    <asp:AccessDataSource ID="AccessDataSource1" runat="server" DataFile="App_Data/voyagers.mdb" 
           SelectCommand="SELECT [LinkId],[Title],[Kind],[Description],[CreatedOn],[CreatedBy],[UserID],[Url],LinkKind.Name as KindName FROM ([Link] LEFT OUTER JOIN [Member] ON Member.MemberId=Link.CreatedBy) LEFT OUTER JOIN [LinkKind] ON LinkKind.LinkKindId=Link.Kind WHERE [LinkId]=@Link " 
           UpdateCommand="UPDATE [Link] SET [Title]=@Title,[Description]=@Description,[Url]=@Url,[Kind]=@Kind WHERE [LinkId]=@LinkId" OnUpdated="AccessDataSource1_Updated" OnUpdating="AccessDataSource1_Updating" 
           DeleteCommand="DELETE FROM [Link] WHERE LinkId=@LinkId" OnDeleted="AccessDataSource1_Deleted"
           InsertCommand="INSERT INTO Link(CreatedBy, CreatedOn, Title, Description, Url, Kind) VALUES (@CreatedBy,Date(),@Title,@Description,@Url,@Kind)" OnInserted="AccessDataSource1_Inserted" OnInserting="AccessDataSource1_Inserting">
        <InsertParameters>
            <asp:SessionParameter Name="CreatedBy" SessionField="MemberId" Type="Int32" />
            <asp:Parameter Name="Title" Type="String" />
            <asp:Parameter Name="Description" Type="String" />
            <asp:Parameter Name="Url" Type="String" />
            <asp:Parameter Name="Kind" Type="Int32" />
        </InsertParameters>
        <SelectParameters>
            <asp:QueryStringParameter Name="id" QueryStringField="LinkId" Type="Int32" DefaultValue="0" />
        </SelectParameters>
        <UpdateParameters>
            <asp:Parameter Name="Title" Type="String" />
            <asp:Parameter Name="Description" Type="String" />
            <asp:Parameter Name="Url" Type="String" />
            <asp:Parameter Name="Kind" Type="Int32" />
            <asp:QueryStringParameter Name="LinkId" QueryStringField="LinkId" Type="Int32" DefaultValue="0" />
        </UpdateParameters>
         <DeleteParameters>
            <asp:QueryStringParameter Name="LinkId" QueryStringField="LinkId" Type="Int32" DefaultValue="0" />
        </DeleteParameters>
   </asp:AccessDataSource>
            <asp:AccessDataSource ID="AccessDataSource2" runat="server" DataFile="~/App_Data/voyagers.mdb"
                SelectCommand="SELECT TOP 1 NULL As [LinkKindId],'' AS [Name] FROM [LinkKind] UNION ALL SELECT [LinkKindId], [Name] FROM [LinkKind]"></asp:AccessDataSource>
    <asp:FormView Width="100%" ID="FormView1" runat="server" DataSourceID="AccessDataSource1" AllowPaging="True" DataKeyNames="LinkId" OnLoad="FormView1_Load" OnItemCommand="FormView1_ItemCommand">
        <EditItemTemplate>
            <fieldset><legend>Edit Link</legend>
                        <table border=0 cellpadding=0 cellspacing=0 class="fields">
                <tr>
                    <td class="labelColumn">Created By:</td>
                    <td class="fieldColumn">            <asp:HyperLink ID="HyperLink1" runat="server" Text='<%# Eval("UserID") %>' NavigateUrl='<%# "Member.aspx?MemberId="+Eval("CreatedBy") %>' Width="100%" ></asp:HyperLink>
</td>
                </tr>
                <tr>
                    <td class="labelColumn" style="height: 70px">Kind:</td>
                    <td class="fieldColumn" style="height: 70px">
                        <asp:DropDownList ID="KindDropDownList" runat="server" DataSourceID="AccessDataSource2"
                            DataTextField="Name" DataValueField="LinkKindId" SelectedValue='<%# Bind("Kind") %>' Width="100%">
                        </asp:DropDownList>
                        <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="KindDropDownList"
                            Display="Dynamic" ErrorMessage="Kind is Required" Width="100%"></asp:RequiredFieldValidator></td>
                </tr>
                <tr>
                    <td class="labelColumn">Title:</td>
                    <td class="fieldColumn">            <asp:TextBox ID="TitleTextBox" runat="server" Text='<%# Bind("Title") %>' Width="100%"></asp:TextBox>
                        <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ControlToValidate="TitleTextBox"
                            Display="Dynamic" ErrorMessage="Title is Required" Width="100%"></asp:RequiredFieldValidator>
</td>
                </tr>
                <tr>
                    <td class="labelColumn">Url:</td>
                    <td class="fieldColumn">              <asp:TextBox ID="UrlTextBox" runat="server" Text='<%# Bind("Url") %>' Width="100%" ></asp:TextBox>
                        <asp:RequiredFieldValidator ID="RequiredFieldValidator3" runat="server" ControlToValidate="UrlTextBox"
                            Display="Dynamic" ErrorMessage="Url is Required" Width="100%"></asp:RequiredFieldValidator>
                        <asp:RegularExpressionValidator ID="RegularExpressionValidator2" runat="server" ControlToValidate="UrlTextBox"
                            Display="Dynamic" ErrorMessage="A valid url should start with http://" ValidationExpression="http(s)?://([\w-]+\.)+[\w-]+(/[\w- ./?%&=]*)?" Width="100%"></asp:RegularExpressionValidator>
                    </td>
                    </tr>

                <tr>
                    <td class="labelColumn">Description:</td>
                    <td class="fieldColumn">            <asp:TextBox ID="DescriptionTextBox" runat="server" Text='<%# Bind("Description") %>' Rows="8" TextMode="MultiLine" Width="100%"></asp:TextBox>
                        <asp:RequiredFieldValidator ID="RequiredFieldValidator4" runat="server" ControlToValidate="DescriptionTextBox"
                            Display="Dynamic" ErrorMessage="Description is Required"></asp:RequiredFieldValidator>
</td>
                </tr>
                    </table>
                    
                    </fieldset>
            <asp:LinkButton ID="UpdateButton" runat="server" CausesValidation="True" CommandName="Update"
                Text="Update">
            </asp:LinkButton>
                                    &nbsp;&nbsp;&nbsp;&nbsp;
<asp:LinkButton ID="UpdateCancelButton" runat="server" CausesValidation="False" CommandName="Cancel"
                Text="Cancel">
            </asp:LinkButton>
        </EditItemTemplate>
        <InsertItemTemplate>
            <fieldset><legend>Add Link</legend>
                        <table border=0 cellpadding=0 cellspacing=0 class="fields" width="100%">
                <tr>
                    <td class="labelColumn" style="width: 1px; padding-right: 3px;">Title:</td>
                    <td class="fieldColumn" style="width: 100%">            <asp:TextBox ID="TitleTextBox" runat="server" Text='<%# Bind("Title") %>' Width="100%"></asp:TextBox>
                        <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="TitleTextBox"
                            Display="Dynamic" ErrorMessage="Title is Required" Width="100%"></asp:RequiredFieldValidator>
</td>
                </tr>
                <tr>
                    <td class="labelColumn" style="width: 1px; padding-right: 3px;">Kind:</td>
                    <td class="fieldColumn" style="width: 100%">
                        <asp:DropDownList ID="KindDropDownList" runat="server" SelectedValue='<%# Bind("Kind") %>' DataSourceID="AccessDataSource2" DataTextField="Name" DataValueField="LinkKindId" Width="100%">
                        </asp:DropDownList>
                        <asp:RequiredFieldValidator ID="RequiredFieldValidator5" runat="server" ControlToValidate="KindDropDownList"
                            Display="Dynamic" ErrorMessage="Kind is Required" Width="100%"></asp:RequiredFieldValidator>
</td>
                </tr>

                <tr>
                    <td class="labelColumn" style="width: 1px; padding-right: 3px;">Url:</td>
                    <td class="fieldColumn" style="width: 100%">            <asp:TextBox ID="UrlTextBox" runat="server" Text='<%# Bind("Url") %>' Width="100%" ></asp:TextBox>
                        <asp:RequiredFieldValidator ID="RequiredFieldValidator6" runat="server" ControlToValidate="UrlTextBox"
                            Display="Dynamic" ErrorMessage="Url is Required" Width="100%"></asp:RequiredFieldValidator>
                        <asp:RegularExpressionValidator ID="RegularExpressionValidator1" runat="server" ControlToValidate="UrlTextBox"
                            Display="Dynamic" ErrorMessage="A valid url should start with http://" ValidationExpression="http(s)?://([\w-]+\.)+[\w-]+(/[\w- ./?%&=]*)?" Width="100%"></asp:RegularExpressionValidator></td>
                </tr>

                <tr>
                    <td class="labelColumn" style="width: 1px; padding-right: 3px;">Description:</td>
                    <td class="fieldColumn" style="width: 100%">            <asp:TextBox ID="DescriptionTextBox" runat="server" Text='<%# Bind("Description") %>' Rows="8" TextMode="MultiLine" Width="100%"></asp:TextBox>
                        <asp:RequiredFieldValidator ID="RequiredFieldValidator7" runat="server" ControlToValidate="DescriptionTextBox"
                            Display="Dynamic" ErrorMessage="Description is Required"></asp:RequiredFieldValidator>
</td>
                </tr>

            </table>

            <asp:LinkButton ID="InsertButton" runat="server" CausesValidation="True" CommandName="Insert"
                Text="Add">
            </asp:LinkButton>                        &nbsp;&nbsp;&nbsp;&nbsp;

            <asp:LinkButton ID="UpdateCancelButton" runat="server" CausesValidation="False" CommandName="Cancel"
                Text="Cancel">
            </asp:LinkButton>
         </InsertItemTemplate>
        <ItemTemplate>
            <fieldset><legend>Link</legend>
                        <table border=0 cellpadding=0 cellspacing=0 class="fields">
                <tr>
                    <td class="labelColumn" style="height: 22px">Created By:</td>
                    <td class="fieldColumn" style="height: 22px">            <asp:HyperLink ID="HyperLink1" runat="server" Text='<%# Eval("UserID") %>' NavigateUrl='<%# "Member.aspx?MemberId="+Eval("CreatedBy") %>' Width="100%" ></asp:HyperLink>
</td>
                </tr>
                <tr>
                    <td class="labelColumn" style="height: 27px">Kind:</td>
                    <td class="fieldColumn" style="height: 27px">            <asp:TextBox ReadOnly=true ID="KindTextBox" runat="server" Text='<%# Bind("KindName") %>' Width="100%" ></asp:TextBox></td>
                </tr>
                <tr>
                    <td class="labelColumn">Title:</td>
                    <td class="fieldColumn">            <asp:Hyperlink ID="TitleHyperlink" runat="server" Text='<%# Eval("Title") %>' NavigateUrl='<%# Eval("Url") %>' Width="100%" /></td>
                </tr>
                <tr>
                <tr>
                    <td class="labelColumn">Description:</td>
                    <td class="fieldColumn">            <asp:TextBox ReadOnly=true ID="DescriptionTextBox" runat="server" Text='<%# Bind("Description") %>' Rows="8" TextMode="MultiLine">
            </asp:TextBox>&nbsp;
</td>
                </tr>

            </table>

                     <uc1:IfAdmin PartnerId="Admin" id="IfAdmin1" runat="server" CreatedBy='<%# Eval("CreatedBy") %>'
                        User='<%# Eval("UserId") %>' AbleTo="edit or delete this link">
                    </uc1:IfAdmin>
                    <span id="Admin" runat="server">
                        <asp:LinkButton ID="EditButton" runat="server" CausesValidation="False" CommandName="Edit"
                            Text="Edit">
                        </asp:LinkButton>
                                                &nbsp;&nbsp;&nbsp;&nbsp;
                        <asp:LinkButton ID="LinkButton1" runat="server" CausesValidation="False" CommandName="Delete"
                            Text="Delete">
                        </asp:LinkButton>
                    </span>
     </ItemTemplate>
    </asp:FormView>
        </asp:View>
        <asp:View ID="View2" runat=server>
            You are not authorized to add links.
        </asp:View>
    </asp:MultiView>
    </asp:Content>
