<%@ Control Language="c#" AutoEventWireup="true" TargetSchema="http://schemas.microsoft.com/intellisense/ie5"%>

<script runat="server">
    //
    // Part of the Content Management System by Declan Brennan ( http://sites.declan.brennan.name )
    // Available subject to the conditions in http://www.voyagers.ie/license.htm .
    //
    public string AbleTo
    {
        get
        {
            return label1.Text;
        }
        set
        {
            label1.Text = value;
            label3.Text = value;
        }
    }

    public string MaintenanceUser
    {
        get
        {
            return label4.Text.Substring(4);
        }
        set
        {
            label4.Text = " or "+value;
        }
    }

    public object User
    {
        get
        {
            return label2.Text;
        }
        set
        {
            label2.Text = value.ToString();
        }
    }

    public string PartnerId
    {
        get
        {
            return this.Attributes["PartnerId"];
        }
        set
        {
            this.Attributes["PartnerId"] = value;
        }
    }

    public object CreatedBy
    {
        get
        {
            return Int32.Parse(this.Attributes["CreatedBy"]);
        }
        set
        {
            this.Attributes["CreatedBy"] = value.ToString();
            doInit();
        }
    }

    public object MaintainedBy
    {
        get
        {
            string attr = this.Attributes["MaintainedBy"];
            if (attr == null || attr.Length == 0)
                return -1;
            return Int32.Parse(attr);
        }
        set
        {
            this.Attributes["MaintainedBy"] = value.ToString();
            doInit();
        }
    }

    private Int32 CreatedByInt
    {
        get
        {
            int rc = -1;
            Int32.TryParse(this.Attributes["CreatedBy"], out rc);
            return rc;
        }
    }

    private Int32 MaintainedByInt
    {
        get
        {
            int rc = -1;
            Int32.TryParse(this.Attributes["MaintainedBy"], out rc);
            return rc;
        }
    }


    private bool authorized()
    {
        if (this.Session["MemberId"] == null)
            return false;
        bool rc= ((bool)Session["Admin"] || (CreatedByInt == (Int32)Session["MemberId"]) || MaintainedByInt==(Int32)Session["MemberId"]);
        if (rc)
        {   if (!(bool)this.Session["CanPost"])
            {
                Multiview1.ActiveViewIndex = 1;
                rc = false;
            }
        }
        return rc;
    }
 
    void doInit()
    {
        this.Visible = ! authorized();
        this.NamingContainer.FindControl(PartnerId).Visible = !this.Visible;
    }

</script>
<asp:MultiView ID="Multiview1" runat="server" ActiveViewIndex="0">
<asp:View ID="View0" runat="server">
<span class="smallText">If you&nbsp;<a href="Login.aspx">login</a>&nbsp;as an administrator or as <asp:Label runat="server" ID="label2"></asp:Label><asp:Label runat="server" ID="label4"></asp:Label>, you will be able to 
<asp:Label style="width:auto" ID="label1" runat=server></asp:Label>.</span>
</asp:View>
<asp:View ID="View1" runat="server">
<span class="smallText">If you had permission to add content, you would be able to <asp:Label style="width:auto" ID="label3" runat=server></asp:Label>. You can contact <a href="mailto:info@voyagers.ie">info@voyagers.ie</a>to request this permission.</span>

</asp:View>
</asp:MultiView>
