//
// Part of the Content Management System by Declan Brennan ( http://sites.declan.brennan.name )
// Available subject to the conditions in http://www.voyagers.ie/license.htm .
//

using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml;

public partial class _getThumb : System.Web.UI.Page 
{
    protected void Page_Load(object sender, EventArgs e)
    {
        string fileName = Request.QueryString["FileName"];
        if (fileName == null)
            return;
        string s = Request.QueryString["Scale"];
        if (s == null || s.Length == 0)
            s = "0";
        int scale = Int32.Parse(s); // The length to set the longest dimension to.

        Response.Clear();
        Response.ContentType = "image/jpeg";

        string realFileName = Server.MapPath(fileName);
        if (!System.IO.File.Exists(realFileName))
            realFileName = Server.MapPath("NoPicture.gif");
        System.Drawing.Bitmap bm = new System.Drawing.Bitmap(realFileName);
        if (scale > 0)
        {
            int width; int height;
            if (bm.Width > bm.Height)
            {
                width = scale; height = (bm.Height * width) / bm.Width;
            }
            else
            {
                height = scale; width = (bm.Width * height) / bm.Height;
            }

            // System.Drawing.Image img = bm.GetThumbnailImage(width, height, null, IntPtr.Zero);
            System.Drawing.Image img = new System.Drawing.Bitmap(bm, new System.Drawing.Size(width, height));
            img.Save(Response.OutputStream, System.Drawing.Imaging.ImageFormat.Jpeg);
        }
        else
            bm.Save(Response.OutputStream, System.Drawing.Imaging.ImageFormat.Jpeg);
    }
 
}