<%@ Page Language="C#" MasterPageFile="~/Default.master" Theme="Database"%>
<%@ Register TagPrefix="uc1" TagName="IfAdmin" Src="IfAdmin.ascx" %>

<script runat="server">
    //
    // Part of the Content Management System by Declan Brennan ( http://sites.declan.brennan.name )
    // Available subject to the conditions in http://www.voyagers.ie/license.htm .
    //

    protected void DetailsView1_ItemUpdating(object sender, DetailsViewUpdateEventArgs e)
    {
    }

    protected void Button2_Click(object sender, EventArgs e)
    {
        try
        {
            this.FormView1.UpdateItem(false);
        }
        catch (System.Data.OleDb.OleDbException)
        {
            // Field 'Member.Surname' cannot be a zero length string
        }
    }

    protected void AccessDataSource1_Updated(object sender, SqlDataSourceStatusEventArgs e)
    {
        SideBarCacheDependency.Reset();
        
    }

    protected void AccessDataSource1_Updating(object sender, SqlDataSourceCommandEventArgs e)
    {
    }

    protected void AccessDataSource1_Deleted(object sender, SqlDataSourceStatusEventArgs e)
    {
        SideBarCacheDependency.Reset();
        Response.Redirect("ListGalleries.aspx", false);
    }

    protected void FormView1_Load(object sender, EventArgs e)
    {
        if (this.Request.QueryString["mode"] == "add")
        {
            /*
            if (Session["Admin"]==null || !(bool)Session["Admin"])
                this.MultiView1.ActiveViewIndex = 1;
            else
            */
                this.FormView1.DefaultMode = FormViewMode.Insert;
        }
    }

    protected void AccessDataSource1_Inserted(object sender, SqlDataSourceStatusEventArgs e)
    {
        SideBarCacheDependency.Reset();
        Response.Redirect("Gallery.aspx?GalleryId=" + DataAccess.Identity(e.Command));        
    }

    protected void FormView1_ItemCommand(object sender, FormViewCommandEventArgs e)
    {
        if (e.CommandName=="Cancel")
            Response.Redirect("ListGalleries.aspx", false);
    }

    /*
    private string pictureUrl()
    {
        string rc= Uploader.Pictures.ResourceUrl(this,this.Eval("PictureExt"), this.Eval("PictureId"));
        if (rc.Length == 0)
            rc = "NoPicture.gif";
        return rc;
     */
        /*
        string rc = "NoPicture.gif";
        object pictureExt = this.Eval("PictureExt");
        if (pictureExt == System.DBNull.Value)
            pictureExt = null;
        if (pictureExt != null && ((string)pictureExt).Length > 0)
            rc = "Pictures\\Picture" + Eval("PictureId").ToString() + (string)pictureExt;
        return rc;
        */
    // }


    protected void AccessDataSource1_Deleting(object sender, SqlDataSourceCommandEventArgs e)
    {
        string id= e.Command.Parameters["id3"].Value.ToString();
        object[] pictureIds = DataAccess.GetData(Server, "SELECT PictureId FROM Picture WHERE Gallery=@GalleryId","@GalleryId",id );
        if (pictureIds!=null)
            foreach (string pictureId in pictureIds)
                Uploader.Pictures.Delete(this, pictureId);
        DataAccess.GetData(Server, "DELETE FROM Picture WHERE Gallery=@GalleryId","@GalleryId",id);
    }
</script>

<asp:Content ID="Content1" runat="server" ContentPlaceHolderId="ContentPlaceHolder1">
    <asp:MultiView ID="MultiView1" runat=server ActiveViewIndex="0">
        <asp:View ID="View1" runat=server>
    <asp:AccessDataSource ID="AccessDataSource1" runat="server" DataFile="App_Data/voyagers.mdb" 
           SelectCommand="SELECT [GalleryId],[Title],[CreatedBy],[CreatedOn],[Description],[UserID],[SeeAlsoTitle],[SeeAlsoUrl] FROM [Gallery] LEFT OUTER JOIN [Member] ON Member.MemberId=Gallery.CreatedBy WHERE GalleryId=@id" 
           UpdateCommand="UPDATE [Gallery] SET [Title]=@Title,[Description]=@Description,[SeeAlsoTitle]=@SeeAlsoTitle,[SeeAlsoUrl]=@SeeAlsoUrl WHERE [GalleryId]=@id2" OnUpdated="AccessDataSource1_Updated" OnUpdating="AccessDataSource1_Updating" 
           DeleteCommand="DELETE FROM [Gallery] WHERE GalleryId=@id3" OnDeleted="AccessDataSource1_Deleted"
           InsertCommand="INSERT INTO Gallery(CreatedBy,CreatedOn,Title, Description,SeeAlsoTitle,SeeAlsoUrl) VALUES (@CreatedBy,Date(),@Title,@Description,@SeeAlsoTitle,@SeeAlsoUrl)" OnInserted="AccessDataSource1_Inserted" OnDeleting="AccessDataSource1_Deleting">
        <InsertParameters>
            <asp:SessionParameter Name="CreatedBy" SessionField="MemberId" Type="Int32" />
            <asp:Parameter Name="Title" Type="String" />
            <asp:Parameter Name="Description" Type="String" />
            <asp:Parameter Name="SeeAlsoTitle" Type="String" />
            <asp:Parameter Name="SeeAlsoUrl" Type="String" />
        </InsertParameters>
        <SelectParameters>
            <asp:QueryStringParameter Name="id" QueryStringField="GalleryId" Type="Int32" DefaultValue="0" />
        </SelectParameters>
        <UpdateParameters>
            <asp:Parameter Name="Title" Type="String" />
            <asp:Parameter Name="Description" Type="String" />
            <asp:Parameter Name="SeeAlsoTitle" Type="String" />
            <asp:Parameter Name="SeeAlsoUrl" Type="String" />
            <asp:QueryStringParameter Name="id2" QueryStringField="GalleryId" Type="Int32" DefaultValue="0" />
        </UpdateParameters>
         <DeleteParameters>
            <asp:QueryStringParameter Name="id3" QueryStringField="GalleryId" Type="Int32" DefaultValue="0" />
        </DeleteParameters>
   </asp:AccessDataSource>
            <asp:AccessDataSource ID="AccessDataSource2" runat="server" DataFile="~/App_Data/voyagers.mdb"
                SelectCommand="SELECT [PictureId], [Title], [Description], [PictureExt] FROM [Picture] WHERE ([Gallery] = ?)">
                <SelectParameters>
                    <asp:QueryStringParameter DefaultValue="0" Name="Gallery" QueryStringField="GalleryId"
                        Type="Int32" />
                </SelectParameters>
            </asp:AccessDataSource>
    <asp:FormView ID="FormView1" Width="100%" runat="server" DataSourceID="AccessDataSource1" AllowPaging="True" DataKeyNames="GalleryId" OnLoad="FormView1_Load" OnItemCommand="FormView1_ItemCommand">
        <EditItemTemplate>
            <fieldset><legend>Gallery</legend>
                        <table border="0" cellpadding="0" cellspacing="0" class="fields">
                            <tr>
                                <td class="labelColumn">
                                    Title:</td>
                                <td class="fieldColumn">
              <a style="float:right" href="Resources.aspx?ArticleId=11" rel="Help">About</a>
            <asp:TextBox ID="TitleTextBox" runat="server" Text='<%# Bind("Title") %>'>
            </asp:TextBox>
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="TitleTextBox"
                                        Display="Dynamic" ErrorMessage="Title is Required" Width="100%"></asp:RequiredFieldValidator>
                                </td>
                            </tr>
                            <tr>
                                <td class="labelColumn">
                                    Description:</td>
                                <td class="fieldColumn">
            <asp:TextBox ID="DescriptionTextBox" runat="server" Text='<%# Bind("Description") %>' Rows="8" TextMode="MultiLine" Height="165px" Width="225px"></asp:TextBox>
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ControlToValidate="DescriptionTextBox"
                                        Display="Dynamic" ErrorMessage="Description is Required" Width="100%"></asp:RequiredFieldValidator>
                                </td>
                            </tr>
                            <tr>
                                <td class="labelColumn">
                                    "See Also" Title:</td>
                                <td class="fieldColumn">
            <asp:TextBox ID="SeeAlsoTitleTextBox" runat="server" Text='<%# Bind("SeeAlsoTitle") %>' Width="100%" ></asp:TextBox>
                                </td>
                            </tr>
                            <tr>
                                <td class="labelColumn">
                                    "See Also" Url:</td>
                                <td class="fieldColumn">
            <asp:TextBox ID="SeeAlsoUrlTextBox" runat="server" Text='<%# Bind("SeeAlsoUrl") %>' Width="100%" ></asp:TextBox>
                                    <asp:RegularExpressionValidator ID="RegularExpressionValidator1" runat="server" ControlToValidate="seeAlsoUrlTextBox"
                                        ErrorMessage="A valid url should start with http://" Width="100%"></asp:RegularExpressionValidator>
                                </td>
                            </tr>
            </table>
            
            </fieldset>
            <asp:LinkButton ID="UpdateButton" runat="server" CausesValidation="True" CommandName="Update"
                Text="Update">
            </asp:LinkButton>
                        &nbsp;&nbsp;&nbsp;&nbsp;

            <asp:LinkButton ID="UpdateCancelButton" runat="server" CausesValidation="False" CommandName="Cancel"
                Text="Cancel">
            </asp:LinkButton>
        </EditItemTemplate>
        <InsertItemTemplate>
           <fieldset><legend>Gallery</legend>
                        <table border="0" cellpadding="0" cellspacing="0" class="fields">
                            <tr>
                                <td class="labelColumn" style="height: 49px">
                                    Title:</td>
                                <td class="fieldColumn" style="height: 49px">
              <a style="float:right" href="Resources.aspx?ArticleId=11" rel="Help">About</a>
            <asp:TextBox ID="TitleTextBox" runat="server" Text='<%# Bind("Title") %>' Width="100%"></asp:TextBox>
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="TitleTextBox"
                                        Display="Dynamic" ErrorMessage="Title is Required" Width="100%"></asp:RequiredFieldValidator>
                                </td>
                            </tr>
                            <tr>
                                <td class="labelColumn" style="height: 188px">
                                    Description:</td>
                                <td class="fieldColumn" style="height: 188px">
            <asp:TextBox ID="DescriptionTextBox" runat="server" Text='<%# Bind("Description") %>' Rows="8" TextMode="MultiLine">
            </asp:TextBox>
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidator3" runat="server" ControlToValidate="DescriptionTextBox"
                                        Display="Dynamic" ErrorMessage="Description is Required" Width="100%"></asp:RequiredFieldValidator></td>
                            </tr>
                            <tr>
                                <td class="labelColumn">
                                    "See Also" Title:</td>
                                <td class="fieldColumn">
            <asp:TextBox ID="SeeAlsoTitleTextBox" runat="server" Text='<%# Bind("SeeAlsoTitle") %>' Width="100%" ></asp:TextBox>
                                </td>
                            </tr>
                            <tr>
                                <td class="labelColumn">
                                    "See Also" Url:</td>
                                <td class="fieldColumn">
            <asp:TextBox ID="SeeAlsoUrlTextBox" runat="server" Text='<%# Bind("SeeAlsoUrl") %>' Width="100%" ></asp:TextBox>
                                    <asp:RegularExpressionValidator ID="RegularExpressionValidator2" runat="server" ControlToValidate="SeeAlsoUrlTextBox"
                                        ErrorMessage="Valid urls should start with http://" Width="100%"></asp:RegularExpressionValidator>
                                </td>
                            </tr>
            </table>
            <asp:LinkButton ID="InsertButton" runat="server" CausesValidation="True" CommandName="Insert"
                Text="Add">
            </asp:LinkButton>
            &nbsp;&nbsp;&nbsp;&nbsp;
            <asp:LinkButton ID="UpdateCancelButton" runat="server" CausesValidation="False" CommandName="Cancel"
                Text="Cancel">
            </asp:LinkButton>
         </InsertItemTemplate>
        <ItemTemplate>
            <fieldset><legend>Gallery</legend>
            <span class="label">Created By:</span>
            <asp:HyperLink ID="HyperLink2" runat="server" Text='<%# Eval("UserID") %>' NavigateUrl='<%# "Member.aspx?MemberId="+Eval("CreatedBy") %>' >HyperLink</asp:HyperLink>
            <asp:label runat="server" ID="OnLabel" Text='<%# DataAccess.DateStamp(Eval("CreatedOn")) %>'></asp:label><br />

            <span class="label">Title:</span>
            <asp:TextBox ID="TitleTextBox" runat="server" Text='<%# Eval("Title") %>' ReadOnly="true">
            </asp:TextBox><br />
            <span class="label" style="vertical-align:top">Description:</span>
            <asp:TextBox ID="DescriptionTextBox" runat="server" Text='<%# Eval("Description") %>' Rows="8" TextMode="MultiLine" ReadOnly="true">
            </asp:TextBox><br />
            <span class="label" style="vertical-align:top">See Also:</span>
            <asp:HyperLink ID="HyperLink3" runat="server" Text='<%# Eval("SeeAlsoTitle") %>' NavigateUrl='<%# Eval("SeeAlsoUrl") %>' >HyperLink</asp:HyperLink><br />
            <span class="label" style="vertical-align:top">View As:</span>
            <asp:HyperLink style="float:right" ID="SlideshowHyperLink" runat="server" NavigateUrl="~/nyi.aspx">Run Slideshow</asp:HyperLink>
                <asp:DropDownList ID="DropDownList1" runat="server">
                    <asp:ListItem>Thumbnails</asp:ListItem>
                    <asp:ListItem>FilmStrip</asp:ListItem>
                </asp:DropDownList>
                
            <asp:DataList SkinID="Photos" ID="DataList1" runat="server" DataKeyField="PictureId"
                DataSourceID="AccessDataSource2" RepeatColumns="4" RepeatDirection="Horizontal" ItemStyle-VerticalAlign="Bottom" ItemStyle-HorizontalAlign="Center">
                <ItemTemplate>
                    <a style="cursor:hand" href='<%# "picture.aspx?GalleryId="+Request.QueryString["GalleryId"]+"&amp;PictureId="+Eval("PictureId") %>'>
                    <asp:Label CssClass="photoLink" Width='<%# Uploader.Pictures.PictureWidth(this,Eval("PictureExt"),Eval("PictureId"),150) %>' ID="TitleLabel" runat="server" Text='<%# Eval("Title") %>'></asp:Label><br />
                    </a>
                    <table border=0 cellpadding=0 cellspacing=0>
                    <tr>
                        <td>
                    <a style="cursor:hand" href='<%# "picture.aspx?GalleryId="+Request.QueryString["GalleryId"]+"&amp;PictureId="+Eval("PictureId") %>'>
                    <div class="photoFrame">
                    <asp:Image ID="Image1" runat="server" AlternateText='<%# Eval("Description") %>'
                        ImageUrl='<%# Uploader.Pictures.Domain(this)+"getThumb.aspx?FileName="+Uploader.Pictures.ResourceUrl(this,Eval("PictureExt"),Eval("PictureId"))+"&Scale=150" %>' Width='<%# Uploader.Pictures.PictureWidth(this,Eval("PictureExt"),Eval("PictureId"),150) %>' Height='<%# Uploader.Pictures.PictureHeight(this,Eval("PictureExt"),Eval("PictureId"),150) %>' />
                    </div>
                    </a>
                        </td>
                    </tr>
                    </table>
                </ItemTemplate>
            </asp:DataList><br />
            
                                 <uc1:IfAdmin PartnerId="Admin2" id="IfAdmin2" runat="server" CreatedBy='<%# Eval("CreatedBy") %>'
                        User='<%# Eval("UserId") %>' AbleTo="add pictures to this gallery">
                    </uc1:IfAdmin>
                    <span id="Admin2" runat="server">
            <asp:HyperLink ID="HyperLink4" runat="server" NavigateUrl='<%# "Picture.aspx?GalleryId="+Request.QueryString["GalleryId"]+"&amp;mode=add" %>'>Add Picture</asp:HyperLink><br />
                    </span>

            </fieldset>

                     <uc1:IfAdmin PartnerId="Admin" id="IfAdmin1" runat="server" CreatedBy='<%# Eval("CreatedBy") %>'
                        User='<%# Eval("UserId") %>' AbleTo="edit or delete this gallery">
                    </uc1:IfAdmin>
                    <span id="Admin" runat="server">
                        <asp:LinkButton ID="EditButton" runat="server" CausesValidation="False" CommandName="Edit"
                            Text="Edit">
                        </asp:LinkButton>
            &nbsp;&nbsp;&nbsp;&nbsp;
                        <asp:LinkButton ID="LinkButton1" runat="server" CausesValidation="False" CommandName="Delete"
                            Text="Delete">
                        </asp:LinkButton>
                    </span>
      </ItemTemplate>
    </asp:FormView>
        </asp:View>
        <asp:View ID="View2" runat=server>
            You are not authorized to add galleries.
        </asp:View>
    </asp:MultiView>
    </asp:Content>
