<%@ Page Language="C#" MasterPageFile="~/Default.master" Theme="Database" ValidateRequest="false" %>
<%@ Register TagPrefix="uc1" TagName="IfAdmin" Src="IfAdmin.ascx" %>
<%@ Register TagPrefix="rtb" Namespace="RichTextBoxControl" Assembly="RichTextBox, Version=2.5.0.0, Culture=Neutral, PublicKeyToken=17b15412cfbf13c1" %> 

<script runat="server">
    //
    // Part of the Content Management System by Declan Brennan ( http://sites.declan.brennan.name )
    // Available subject to the conditions in http://www.voyagers.ie/license.htm .
    //
    
    protected void DetailsView1_ItemUpdating(object sender, DetailsViewUpdateEventArgs e)
    {
    }

    private bool attending()
    {
        if (Session["MemberId"] == null)
            return false;
        return DataAccess.GetData(Server, "SELECT * FROM Attendees WHERE Member=@MemberId and Event=@EventId","@MemberId",Session["MemberId"],"@Event",Request.QueryString["EventId"])!=null;
    }

    private void addAttendee()
    {
        DataAccess.GetData(Server,"INSERT INTO Attendees(Member,Event) VALUES ("+Session["MemberId"]+","+Request.QueryString["EventId"]+")");
    }

    private void removeAttendee()
    {
        DataAccess.GetData(Server,"DELETE FROM Attendees WHERE Member="+Session["MemberId"]+" and Event="+Request.QueryString["EventId"]);
    }

    protected void AttendanceButton_Click(object sender, EventArgs e)
    {
        if (((LinkButton)sender).Text.Contains("NOT"))
            removeAttendee();
        else
            addAttendee();
        this.DataBind();
    }

    protected void Button2_Click(object sender, EventArgs e)
    {
        try
        {
            this.FormView1.UpdateItem(false);
        }
        catch (System.Data.OleDb.OleDbException)
        {
            // Field 'Member.Surname' cannot be a zero length string
        }
    }

    protected void AccessDataSource1_Updated(object sender, SqlDataSourceStatusEventArgs e)
    {
        if (e.Exception != null)
        {
            this.Error1.Text = e.Exception.Message;
            e.ExceptionHandled = true;
        }
        else
        {
            SideBarCacheDependency.Reset();
            Response.Redirect("ListEvents.aspx", false);
        }
    }

    protected void AccessDataSource1_Updating(object sender, SqlDataSourceCommandEventArgs e)
    {
    }

    protected void AccessDataSource1_Deleted(object sender, SqlDataSourceStatusEventArgs e)
    {
        if (e.Exception != null)
        {
            this.Error1.Text = e.Exception.Message;
            e.ExceptionHandled = true;
        }
        else
        {
            SideBarCacheDependency.Reset();
            Response.Redirect("ListEvents.aspx", false);
        }
    }

    protected void FormView1_Load(object sender, EventArgs e)
    {
        if (this.Request.QueryString["mode"] == "add")
        {
            /*
            if (!(bool)Session["Admin"])
                this.MultiView1.ActiveViewIndex = 1;
            else
             */
                this.FormView1.DefaultMode = FormViewMode.Insert;
        }
    }

    protected void AccessDataSource1_Inserted(object sender, SqlDataSourceStatusEventArgs e)
    {
        if (e.Exception != null)
        {
            this.Error1.Text = e.Exception.Message;
            e.ExceptionHandled = true;
        }
        else
        {
            SideBarCacheDependency.Reset();
            Response.Redirect("ListEvents.aspx", false);
        }
    }

    protected void FormView1_ItemCommand(object sender, FormViewCommandEventArgs e)
    {
        if (e.CommandName == "Cancel")
            Response.Redirect("ListEvents.aspx", false);
        else if (e.CommandName == "PickDate")
        {
            Control c = (Control)e.CommandSource;
            Calendar cal= (Calendar)c.NamingContainer.FindControl("Calendar1");
            if (cal.SelectedDate!=null && cal.SelectedDate.Year>=2005)
                ((TextBox)(c.NamingContainer.FindControl((string)e.CommandArgument))).Text = cal.SelectedDate.ToString();
        }
    }

    protected void CustomValidator1_ServerValidate(object source, ServerValidateEventArgs args)
    {
       DateTime dt;
       args.IsValid = System.DateTime.TryParse(args.Value, out dt);
    }
</script>

<asp:Content ID="Content1" runat="server" ContentPlaceHolderID="ContentPlaceHolder1">
    <asp:MultiView ID="MultiView1" runat="server" ActiveViewIndex="0">
        <asp:View ID="View1" runat="server">
            <asp:AccessDataSource ID="AccessDataSource1" runat="server" DataFile="App_Data/voyagers.mdb"
                SelectCommand="SELECT [EventId],Starts,Ends,[Title],[CreatedBy],[CreatedOn],[Description],Member.UserID as UserID,Event.Contact AS Contact,Contact.UserID as ContactID FROM ([Event] LEFT OUTER JOIN [Member] ON Member.MemberId=Event.CreatedBy) LEFT OUTER JOIN [Member] AS Contact ON Contact.MemberId=Event.Contact  WHERE [EventId]=@id"
                UpdateCommand="UPDATE [Event] SET [Starts]=@Starts,[Ends]=@Ends,[Title]=@Title,[Description]=@Description,[Contact]=@Contact WHERE [EventId]=@id2"
                OnUpdated="AccessDataSource1_Updated" OnUpdating="AccessDataSource1_Updating"
                DeleteCommand="DELETE FROM [Event] WHERE EventId=@id3" OnDeleted="AccessDataSource1_Deleted"
                InsertCommand="INSERT INTO Event(CreatedBy, CreatedOn, Starts, Ends, Title, Description,Contact) VALUES (@CreatedBy,Date(),@Starts,@Ends,@Title,@Description,@Contact)"
                OnInserted="AccessDataSource1_Inserted">
                <InsertParameters>
                    <asp:SessionParameter Name="CreatedBy" SessionField="MemberId" Type="Int32" />
                    <asp:Parameter Name="Starts" Type="DateTime" />
                    <asp:Parameter Name="Ends" Type="DateTime" />
                    <asp:Parameter Name="Title" Type="String" />
                    <asp:Parameter Name="Description" Type="String" />
                    <asp:Parameter Name="Contact" Type="Int32" />
                </InsertParameters>
                <SelectParameters>
                    <asp:QueryStringParameter Name="id" QueryStringField="EventId" Type="Int32" DefaultValue="0" />
                </SelectParameters>
                <UpdateParameters>
                    <asp:Parameter Name="Starts" Type="DateTime" />
                    <asp:Parameter Name="Ends" Type="DateTime" />
                    <asp:Parameter Name="Title" Type="String" />
                    <asp:Parameter Name="Description" Type="String" />
                    <asp:Parameter Name="Contact" Type="Int32" />
                  <asp:QueryStringParameter Name="id2" QueryStringField="EventId" Type="Int32" />
                </UpdateParameters>
                <DeleteParameters>
                    <asp:QueryStringParameter Name="id3" QueryStringField="EventId" Type="Int32" DefaultValue="0" />
                </DeleteParameters>
            </asp:AccessDataSource>
            <asp:AccessDataSource ID="AccessDataSource2" runat="server" DataFile="~/App_Data/voyagers.mdb"
                SelectCommand="SELECT TOP 1 0 AS [MemberId], '' AS [UserID] FROM [Member] UNION ALL SELECT [MemberId], [UserID] FROM [Member]"></asp:AccessDataSource>
            <asp:AccessDataSource ID="AccessDataSource3" runat="server" DataFile="~/App_Data/voyagers.mdb"
                SelectCommand="SELECT Member.UserId As UserId,Member FROM [Attendees] LEFT OUTER JOIN [Member] ON Member.MemberId=Attendees.Member WHERE Attendees.Event=@EventId ORDER BY Member.UserId">
                                <SelectParameters>
                    <asp:QueryStringParameter Name="EventId" QueryStringField="EventId" Type="Int32" DefaultValue="0" />
                </SelectParameters>

                </asp:AccessDataSource>
            
            <span runat="server" visible='<%# Session["MemberId"]==null %>' >
            <span class="smallText">Normally events are only open to members of Voyagers. You can find out more about joining <a href="http://www.voyagers.ie/Resources.aspx?ResourceId=49">here.</a></span><br /><br />
            </span>
            <asp:FormView ID="FormView1" runat="server" DataSourceID="AccessDataSource1" AllowPaging="True"
                DataKeyNames="EventId" OnLoad="FormView1_Load" OnItemCommand="FormView1_ItemCommand"
                Width="100%">
                <EditItemTemplate>
                    <fieldset style="width: 100%">
                    <legend>Edit Event</legend>
                                            <table border="0" cellpadding="0" cellspacing="0" class="fields">
                            <tr>
                                <td class="labelColumn">
                                    Title:</td>
                                <td class="fieldColumn" colspan=2>
                                                            <a style="float: right" href="Resources.aspx?ArticleId=8" rel="Help">About</a>
<asp:TextBox Style="width: 100%" ID="TitleTextBox" runat="server" Text='<%# Bind("Title") %>'
                                        ></asp:TextBox>
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidator5" runat="server" ControlToValidate="TitleTextBox"
                                        Display="Dynamic" ErrorMessage="Title is Required"></asp:RequiredFieldValidator>
                                </td>
                            </tr>
                            <tr>
                                <td class="labelColumn">
                                    Starts:</td>
                                <td class="fieldColumn">
                      <asp:ImageButton style="float:right" ID="ImageButton1" runat="server"  CausesValidation="false" CommandName="PickDate" CommandArgument="StartDate" ToolTip="Pick Start Date from Calendar" ImageUrl = "~/recordprevious.gif" BorderStyle="Outset" BorderWidth="2px" />
                               
                                    <asp:TextBox Style="width: 100%" ID="StartDate" runat="server" Text='<%# Bind("Starts") %>' Width="100%"
                                        ></asp:TextBox>
                                                                        <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ErrorMessage="You must enter a Start Date and Time" ControlToValidate="StartDate" Display="Dynamic" SetFocusOnError="True" Width="100%"></asp:RequiredFieldValidator>
<asp:CustomValidator ID="CustomValidator2" runat="server" ErrorMessage="Invalid Date Time format"
                                       OnServerValidate="CustomValidator1_ServerValidate" ControlToValidate="StartDate" SetFocusOnError="True" Width="100%"></asp:CustomValidator>
                                </td>
                                                        <td rowspan=4 valign="top">
                                <asp:Calendar ID="Calendar1" runat="server" SelectedDate='<%# Eval("Starts") %>'></asp:Calendar>
                            </td>
                            </tr>

                            <tr>
                                <td class="labelColumn">
                                    Ends:</td>
                                <td class="fieldColumn">
                       <asp:ImageButton style="float:right" ID="ImageButton3" runat="server"  CausesValidation="false" CommandName="PickDate" CommandArgument="EndDate" ToolTip="Pick End Date from Calendar" ImageUrl = "~/recordprevious.gif" BorderStyle="Outset" BorderWidth="2px" />
                                   <asp:TextBox Style="width: 100%" ID="EndDate" runat="server" Text='<%# Bind("Ends") %>'
                                        >
                                    </asp:TextBox>
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidator3" runat="server" ErrorMessage="You must enter an End Date and Time" ControlToValidate="EndDate" Display="Dynamic" SetFocusOnError="True" Width="100%"></asp:RequiredFieldValidator>
<asp:CustomValidator ID="CustomValidator1" runat="server" ErrorMessage="Invalid Date Time format"
                                       OnServerValidate="CustomValidator1_ServerValidate" ControlToValidate="EndDate" SetFocusOnError="True" Width="100%"></asp:CustomValidator>
                                </td>
                            </tr>
                            <tr>
                                <td class="labelColumn">
                                    Contact:</td>
                                <td class="fieldColumn">
                                    <asp:DropDownList ID="DropDownList1" runat="server" SelectedValue='<%# Bind("Contact") %>' DataSourceID="AccessDataSource2" DataTextField="UserID" DataValueField="MemberId" Width="100%">
                                    </asp:DropDownList>
                                </td>
                            </tr>
                            <tr>
                                <td class="labelColumn">
                                    Description:</td>
                                <td class="fieldColumn">
 
                                 <rtb:RichTextBox ID="ContentTextBox" runat="server" Width="100%"
                                    Text='<%# Bind("Description") %>'  EditorWysiwygModeCss="~/App_Themes/Database/Stylesheet.css" HtmlOptionIsEnabled="false" 
                                    ToolbarLayout = "paragraphmenu,indent,outdent,insertimage,fontforecolormenu,bold,italic,underline,separator,bullets,numberedlist,separator,insertlink" 
                                    ></rtb:RichTextBox>
                                </td>
                            </tr>
                        </table>

                    </fieldset>
                    <asp:LinkButton ID="UpdateButton" runat="server" CausesValidation="True" CommandName="Update"
                        Text="Update">
                    </asp:LinkButton>
            &nbsp;&nbsp;&nbsp;&nbsp;
                    <asp:LinkButton ID="UpdateCancelButton" runat="server" CausesValidation="False" CommandName="Cancel"
                        Text="Cancel">
                    </asp:LinkButton>
                </EditItemTemplate>
                <InsertItemTemplate>
                    <fieldset style="width: 100%">
                        <legend>Add Event</legend>
                            <table border="0" cellpadding="0" cellspacing="0" class="fields">
                            <tr>
                                <td class="labelColumn">
                                    Title:</td>
                                <td class="fieldColumn" colspan=2>
                                                            <a style="float: right" href="Resources.aspx?ArticleId=8" rel="Help">About</a>
<asp:TextBox Style="width: 100%" ID="TitleTextBox" runat="server" Text='<%# Bind("Title") %>'
                                    ></asp:TextBox>
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidator4" runat="server" ControlToValidate="TitleTextBox"
                                        Display="Dynamic" ErrorMessage="Title is Required"></asp:RequiredFieldValidator>
                                </td>
                            </tr>
                            <tr>
                                <td class="labelColumn">
                                    Starts:</td>
                                <td class="fieldColumn">
                     <asp:ImageButton style="float:right" ID="ImageButton1" runat="server"  CausesValidation="false" CommandName="PickDate" CommandArgument="StartDate" ToolTip="Pick Start Date from Calendar" ImageUrl = "~/recordprevious.gif" BorderStyle="Outset" BorderWidth="2px" />
                       <asp:TextBox Style="width: 100%" ID="StartDate" runat="server" Text='<%# Bind("Starts") %>' Width="100%"></asp:TextBox>
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ErrorMessage="You must enter a Start Date and Time" ControlToValidate="StartDate" Display="Dynamic" SetFocusOnError="True" Width="100%"></asp:RequiredFieldValidator>
                                <asp:CustomValidator ID="CustomValidator1" runat="server" ErrorMessage="Invalid Date Time format"
                                       OnServerValidate="CustomValidator1_ServerValidate" ControlToValidate="StartDate" SetFocusOnError="True" Display="Dynamic" Width="100%"></asp:CustomValidator>
                                </td>
                            <td rowspan=4 valign="top">
                                <asp:Calendar ID="Calendar1" runat="server" ></asp:Calendar>
                            </td>
                                
                            </tr>
                            <tr>
                                <td class="labelColumn">
                                    Ends:</td>
                                <td class="fieldColumn">
                     <asp:ImageButton style="float:right" ID="ImageButton2" runat="server"  CausesValidation="false" CommandName="PickDate" CommandArgument="EndDate" ToolTip="Pick End Date from Calendar" ImageUrl = "~/recordprevious.gif" BorderStyle="Outset" BorderWidth="2px" />
                                    <asp:TextBox Style="width: 100%" ID="EndDate" runat="server" Text='<%# Bind("Ends") %>' Width="100%"></asp:TextBox>
                                    
                                    <asp:RequiredFieldValidator  ID="RequiredFieldValidator2" runat="server" ErrorMessage="You must enter an End Date and Time" ControlToValidate="EndDate" SetFocusOnError="True" Display="Dynamic" Width="100%"></asp:RequiredFieldValidator>
<asp:CustomValidator ID="CustomValidator3" runat="server" ErrorMessage="Invalid Date Time format"
                                       OnServerValidate="CustomValidator1_ServerValidate" ControlToValidate="EndDate" SetFocusOnError="True" Display="Dynamic" Width="100%"></asp:CustomValidator>                                </td>
                            </tr>
                            <tr>
                                <td class="labelColumn">
                                    Contact:</td>
                                <td class="fieldColumn">
                                    <asp:DropDownList ID="DropDownList1" runat="server" SelectedValue='<%# Bind("Contact") %>' DataSourceID="AccessDataSource2" DataTextField="UserID" DataValueField="MemberId" Width="100%">
                                    </asp:DropDownList>
                                </td>
                            </tr>
                            <tr>
                                <td class="labelColumn">
                                    Description:</td>
                                <td class="fieldColumn">
                                <rtb:RichTextBox ID="ContentTextBox"  runat="server" Width="100%"
                                    Text='<%# Bind("Description") %>'  EditorWysiwygModeCss="~/App_Themes/Database/Stylesheet.css" HtmlOptionIsEnabled="false" 
                                    ToolbarLayout = "paragraphmenu,indent,outdent,insertimage,fontforecolormenu,bold,italic,underline,separator,bullets,numberedlist,separator,insertlink" 
                                    ></rtb:RichTextBox>
                                </td>
                            </tr>
                        </table>


                    </fieldset>
                    <asp:LinkButton ID="InsertButton" runat="server" CausesValidation="True" CommandName="Insert"
                        Text="Add">
                    </asp:LinkButton>
            &nbsp;&nbsp;&nbsp;&nbsp;
                    <asp:LinkButton ID="UpdateCancelButton" runat="server" CausesValidation="False" CommandName="Cancel"
                        Text="Cancel">
                    </asp:LinkButton>
                </InsertItemTemplate>
                <ItemTemplate>
                    <fieldset style="width: 100%">
                        <legend>Event</legend>
                        <table border="0" cellpadding="0" cellspacing="0" class="fields">
                            <tr>
                                <td class="labelColumn">
                                    Created By:</td>
                                <td class="fieldColumn">
                                    <asp:HyperLink ID="HyperLink2" runat="server" Text='<%# Eval("UserID") %>' NavigateUrl='<%# "Member.aspx?MemberId="+Eval("CreatedBy") %>'>HyperLink</asp:HyperLink>&nbsp;&nbsp;
                                    <asp:Label SkinID="addendum" runat="server" ID="OnLabel" Text='<%# DataAccess.DateStamp(Eval("CreatedOn")) %>'></asp:Label>
                                </td>
                            </tr>
                            <tr>
                                <td class="labelColumn">
                                    Title:</td>
                                <td class="fieldColumn">
                                     <asp:TextBox Style="width: 100%" ID="TextBox5" runat="server" Text='<%# Bind("Title") %>'
                                        ReadOnly="true" />
                               </td>
                            </tr>
                            <tr>
                                <td class="labelColumn">
                                    Starts:</td>
                                <td class="fieldColumn">
                                    <asp:TextBox Style="width: 100%" ID="TitleTextBox" runat="server" Text='<%# Bind("Starts") %>'
                                        ReadOnly="true" />
                                </td>
                            </tr>
                            <tr>
                                <td class="labelColumn">
                                    Ends:</td>
                                <td class="fieldColumn">
                                    <asp:TextBox Style="width: 100%" ID="EndsTextBox" runat="server" Text='<%# Bind("Ends") %>'
                                        ReadOnly="true">
                                    </asp:TextBox>
                                </td>
                            </tr>
                            <tr>
                                <td class="labelColumn">
                                    Contact:</td>
                                <td class="fieldColumn">
                                    <asp:HyperLink ID="HyperLink3" runat="server" Text='<%# Eval("ContactID") %>' NavigateUrl='<%# "Member.aspx?MemberId="+Eval("Contact") %>'>HyperLink</asp:HyperLink>
                                </td>
                            </tr>
                            <tr>
                                <td class="labelColumn">
                                    Description:</td>
                                <td class="fieldColumn">
                                    <asp:Panel ScrollBars="Vertical" runat="server" ID="panel1" Width="100%" Height="20em"
                                        CssClass="ContentPanel">
                                        <asp:Literal runat="server" ID="content" Text='<%# Bind("Description") %>'>
                                        </asp:Literal>
                                        
                                    </asp:Panel>
                                </td>
                            </tr>
                             <tr>
                                <td class="labelColumn">
                                    Attendees:</td>
                                <td class="fieldColumn">
                                    <asp:DataList SkinId="Simple" ID="GridView1" runat="server" DataSourceID="AccessDataSource3" HeaderStyle-CssClass="hide" RepeatColumns="4" ItemStyle-Width="15em">
                                        <ItemTemplate>
                                            <asp:HyperLink runat="server" NavigateUrl='<%# "Member.aspx?MemberId="+Eval("Member") %>' Text='<%#Eval("UserId") %>' />&nbsp;&nbsp;
                                        </ItemTemplate>
                                        <HeaderStyle CssClass="hide" />
                                    </asp:DataList>
                                    <span id="span1" runat="server" visible='<%# Session["MemberId"]==null %>'>
                                    <span class="smallText">If you <a href="Login.aspx">login</a> you will be able to change your attendance at this event.</span>
                                    </span>
                                    <asp:LinkButton Visible='<%# Session["MemberId"]!=null %>' Text='<%# attending()?"I will NOT be attending this event":"I will be attending this event" %>' ID="AttendanceButton" runat="server" OnClick="AttendanceButton_Click" />
                                </td>
                            </tr>
                       </table>
                    </fieldset>
                     <uc1:IfAdmin PartnerId="Admin" id="IfAdmin1" runat="server" CreatedBy='<%# Eval("CreatedBy") %>'
                        User='<%# Eval("UserId") %>' MaintenanceUser='<%# Eval("ContactId") %>' MaintainedBy= '<%# Eval("Contact") %>' AbleTo="edit or delete this event">
                    </uc1:IfAdmin>
                    <span id="Admin" runat="server">
                        <asp:LinkButton ID="EditButton" runat="server" CausesValidation="False" CommandName="Edit"
                            Text="Edit">
                        </asp:LinkButton>
                                    &nbsp;&nbsp;&nbsp;&nbsp;
                        <asp:LinkButton ID="LinkButton1" runat="server" CausesValidation="False" CommandName="Delete"
                            Text="Delete">
                        </asp:LinkButton>
                    </span>
                </ItemTemplate>
                <EmptyDataTemplate>
                    None
                </EmptyDataTemplate>
            </asp:FormView>
            <br />
 <asp:Label CssClass="error" ID="Error1" runat="server"></asp:Label>
        </asp:View>
        <asp:View ID="View2" runat="server">
            You are not authorized to add events.
        </asp:View>
    </asp:MultiView></asp:Content>
