//
// Part of the Content Management System by Declan Brennan ( http://sites.declan.brennan.name )
// Available subject to the conditions in http://www.voyagers.ie/license.htm .
//
using System.Data;
using System.Web;
using System.Xml;


public class Uploader
{
    string mBasePath;
    string mDefaultUrl;

    public Uploader(string basePath,string defaultUrl)
    {
        mBasePath = basePath;
        mDefaultUrl = defaultUrl;
    }

    private string fileServer(System.Web.UI.Page page)
    {
        if (isTestBed(page))
            return "http://localhost/GroupMailer/";
        else
            return "http://www.voyagers.ie/";
    }

    public string UploadExtension(System.Web.UI.Page page)
    {
        string rc = "";
        if (page.Request.Files.Count > 0)
            rc = System.IO.Path.GetExtension(page.Request.Files[0].FileName);
        return rc;
    }

    private string getPath(System.Web.UI.Page page,string pictureId)
    {
        string fileName = string.Empty;
        string ext = UploadExtension(page);
        if (ext.Length > 0)
            fileName = mBasePath + pictureId + ext;
        return fileName;
    }

    bool isTestBed(System.Web.UI.Page page)
    {
        return page.Server.MachineName=="DEC";
    }

    bool isSandbox(System.Web.UI.Page page)
    {
        return false;
        // http://beta-149740.server1.dotnetsandbox.net/default.aspx
        if (isTestBed(page))
            return true;
        else
            return (page.Request.Url.OriginalString.Contains("dotnetsandbox"));
    }

    private string contentPath(string id)
    {
        return mBasePath + id+".htm";
    }

    public string GetContent(System.Web.UI.Page page,string id)
    {
        if (id == null)
            return "";
        if (isSandbox(page))
        {
            System.Net.WebClient wc = new System.Net.WebClient();
            wc.QueryString["password"]= "[Enter Password Here]";
            wc.QueryString["id"] = id;
            System.IO.Stream s= wc.OpenRead(fileServer(page)+"GetContent.aspx");
            using (System.IO.TextReader reader= new System.IO.StreamReader(s))
                return reader.ReadToEnd();
        }
        else
        {
            string path = contentPath(id);
            string serverPath = page.Server.MapPath(path);
            if (System.IO.File.Exists(serverPath))
                return System.IO.File.ReadAllText(serverPath);
            return "";
        }
    }

  
    public void UpdateContent(System.Web.UI.Page page,string id,string content)
    {
        if (isSandbox(page))
        {
            System.Net.WebClient wc = new System.Net.WebClient();
            System.IO.Stream s = wc.OpenWrite(fileServer(page) + "UpdateContent.aspx", "POST");
            System.IO.BinaryWriter bw = new System.IO.BinaryWriter(s);
            bw.Write("[ENTER PASSWORD HERE]");
            bw.Write(id);
            bw.Write(content);
            bw.Close();

        }
        else
        {
            string path = contentPath(id);
            System.IO.File.WriteAllText(page.Server.MapPath(path), content);
        }

    }

    public void Save(System.Web.UI.Page page,string id)
    {
        if (page.Request.Files.Count == 0)
            return;

        string fileName = getPath(page,id);
            
        if (isSandbox(page))
        {
            System.Net.WebClient wc = new System.Net.WebClient();
            System.IO.Stream s = wc.OpenWrite(fileServer(page)+"Upload.aspx", "POST");
            System.IO.BinaryWriter bw = new System.IO.BinaryWriter(s);
            bw.Write("[ENTER PASSWORD HERE]");
            bw.Write(fileName);
            HttpPostedFile file= page.Request.Files[0];
            int len= file.ContentLength;
            byte[] data= new byte[len];
            file.InputStream.Read(data,0,len);  
            bw.Write((System.Int32)len);
            bw.Write(data,0,len);
            //bw.Write((Int32)page.Request.Files[0].InputStream(
            // bw.Write(data);
            bw.Close();
        }
        else
        {
            if (fileName.Length > 0)
            {
                string realFileName = page.Server.MapPath(fileName);
                foreach (string oldFile in System.IO.Directory.GetFiles(System.IO.Path.GetDirectoryName(realFileName),
                                    System.IO.Path.GetFileNameWithoutExtension(realFileName)+".*"))
                    System.IO.File.Delete(oldFile);
                
                page.Request.Files[0].SaveAs(realFileName);
            }
        }
    }

    public void Delete(System.Web.UI.Page page,string pictureId)
    {
        string fileName = getPath(page, pictureId);
        if (isSandbox(page))
        {
            System.Net.WebClient wc = new System.Net.WebClient();
            System.IO.Stream s = wc.OpenWrite(fileServer(page)+"Delete.aspx", "POST");
            System.IO.BinaryWriter bw = new System.IO.BinaryWriter(s);
            bw.Write("[ENTER PASSWORD HERE]");
            bw.Write(fileName);
            bw.Close();
        }
        else
        {
            if (fileName.Length > 0)
                System.IO.File.Delete(fileName);
        }
    }

    public string ResourceUrl(System.Web.UI.Page page,object resourceExt,object resourceId)
    {
        string rc = "";

        if (resourceExt == System.DBNull.Value)
            resourceExt = null;

        if (resourceExt != null && ((string)resourceExt).Length > 0)
            rc= mBasePath + resourceId.ToString() + (string)resourceExt;
        return rc;
    }

    private string mPrevId;
    private System.Drawing.Size mPrevSize;
    

    public int pictureDim(System.Web.UI.Page page, object resourceExt, object resourceId,int maxDim,bool wantHeight)
    {
        if (mPrevId != resourceId.ToString())
        {
            mPrevId = resourceId.ToString();

            if (isSandbox(page))
            {
                System.Net.WebClient wc = new System.Net.WebClient();
                wc.QueryString["password"] = "[ENTER PASSWORD HERE]";
                wc.QueryString["id"] = resourceId.ToString();
                wc.QueryString["ext"] = resourceExt.ToString();
                System.IO.Stream s = wc.OpenRead(fileServer(page) + "GetSize.aspx");
                using (System.IO.TextReader reader = new System.IO.StreamReader(s))
                {
                    string w= reader.ReadLine();
                    string h = reader.ReadLine();
                    mPrevSize = new System.Drawing.Size(System.Int32.Parse(w), System.Int32.Parse(h));
                }
            }
            else
            {
                string url = ResourceUrl(page, resourceExt, resourceId);
                System.Drawing.Bitmap bm = new System.Drawing.Bitmap(page.Server.MapPath(url));
                mPrevSize = bm.Size;
                bm.Dispose();
            }
        }
        int width = 0;
        int height = 0;
        if (mPrevSize.Width > mPrevSize.Height)
        {
            width = maxDim;
            height = mPrevSize.Height * maxDim / mPrevSize.Width;
        }
        else
        {
            height = maxDim;
            width = mPrevSize.Width * maxDim / mPrevSize.Height;
        }

        return wantHeight?height:width;
    }

    public int PictureWidth(System.Web.UI.Page page, object resourceExt, object resourceId,int maxDim)
    {
        return pictureDim(page, resourceExt, resourceId, maxDim, false);
    }
    
    public int PictureHeight(System.Web.UI.Page page, object resourceExt, object resourceId,int maxDim)
    {
        return pictureDim(page, resourceExt, resourceId, maxDim, true);
    }

    public string Domain(System.Web.UI.Page page)
    {
        return isSandbox(page) ? fileServer(page) : "";
    }



    public static Uploader Pictures= new Uploader("Pictures\\Picture","NoPicture.gif");
    public static Uploader Resources = new Uploader("Resources\\Resource","");
    public static Uploader MemberPictures = new Uploader("Pictures\\Member","NoPicture.gif");

}

