//
// Part of the Content Management System by Declan Brennan ( http://sites.declan.brennan.name )
// Available subject to the conditions in http://www.voyagers.ie/license.htm .
//
using System.Threading;
using aspNetEmail;
using aspNetPOP3;
using aspNetMime;

using System.Data;
using System.Collections.Generic;
using System.Web;
using System;

public static class GroupMailer
{
    private static string mDatabasePath = null;

    public static string SendActivation(HttpServerUtility server,string memberId)
    {
        object[] rc = DataAccess.GetData(server, "SELECT ActivationKey,lcase(Email),Forename,Surname,UserID FROM Member WHERE MemberId=@MemberId","@MemberId", memberId);
        string fullName = rc[2].ToString() + " " + rc[3].ToString();
        string email = rc[1].ToString();
        string userId = rc[4].ToString();
        string text;
        string queryStrings = "MemberId=" + memberId + "&ActivationKey=" + rc[0].ToString();

        if (userId.Length==0)
            text= "Hello " + fullName + ",\n\nYou are now a member of www.voyagers.ie. \n\nPlease visit http://www.voyagers.ie/ActivateMember.aspx?" + queryStrings + " to activate your membership.";
        else
            text = "Hello " + fullName + ",\n\nYou are receiving this email because you requested a reactivation of your membership for www.voyagers.ie. \n\nPlease visit http://www.voyagers.ie/ActivateMember.aspx?" + queryStrings + " to reactivate your membership.";

        EmailMessage mail = new EmailMessage();
        mail.Server = "mail.voyagers.ie";
        mail.To = email;
        mail.FromAddress = "info@voyagers.ie";
        mail.Subject = "[Voyagers] Actiation Information";
        mail.TextBodyPart = text;
        mail.Send();
        return fullName;
    }


    static bool mProcessing = false;

    private delegate int processDelegate(HttpServerUtility server);

    public static int Process(HttpServerUtility server)
    {
        lock (typeof(GroupMailer))
        {
            if (!mProcessing)
            {
                // if (mDatabasePath == null)
                //    mDatabasePath = server.MapPath("App_Data//voyagers.mdb");
                mProcessing = true;
                processDelegate pd = new processDelegate(ProcessNow);
                pd.BeginInvoke(server,new AsyncCallback(processEnds), new Object());

            }
        }
        return -1;
    }

    [System.Runtime.Remoting.Messaging.OneWay()]
    private static void processEnds(IAsyncResult ar)
    {
        processDelegate fd = (processDelegate)((System.Runtime.Remoting.Messaging.AsyncResult)ar).AsyncDelegate;
        try
        {
            fd.EndInvoke(ar);
        }
        catch (Exception)
        {
        }
        lock (typeof(GroupMailer)) mProcessing = false;
    }
    
    public static int ProcessNow(HttpServerUtility server)
    {
		int rc= 0;
        List<string> authorizedAddresses = null;
        foreach (string group in new string[] { "Members", "Social", "WantRiverInvites", "Admin", "Info" })
        {
            List<string> toAddresses = null;
            // string[] toAddressesRefuseAttachments = null;
            string groupAddress = group + "@voyagers.ie";

            POP3 pop = new POP3("mail.voyagers.ie", groupAddress, "[ENTER PASSWORD]");
            pop.LogInMemory = true;
            pop.Connect();

            //get the number of messages and the size of the inbox
            pop.PopulateInboxStats();

            if (pop.InboxMessageCount > 0)
            {
				rc+= pop.InboxMessageCount;

                string whereClause = "Activated and not NoGroupEmails and Email is not null";
                switch (group)
                {
                    case "Social": whereClause += " and Social"; break;
                    case "WantRiverInvites": whereClause += " and WantRiverInvites"; break;
                    case "Admin": whereClause += " and Admin"; break;
                    case "Info": whereClause += " and Info"; break;
                }
                toAddresses = GetList(server,whereClause + " and not NoEmailAttachments","lcase(Email)");
                // toAddressesRefuseAttachments = GetList(server,whereClause + " and NoEmailAttachments","Email");

				if (authorizedAddresses==null)
				{
					authorizedAddresses= GetList(server,whereClause,"lcase(Email)");
				}
            }

            for (int i = 0; i < pop.InboxMessageCount; i++)
            {
                MimeMessage msg = pop.GetMessage(i);
                string sender= msg.From.EmailAddress;
                if (group=="info" || authorizedAddresses.Contains(sender.ToLower()))
                {

                    //now send the email
                    EmailMessage email = new EmailMessage();
                    email.Server = "mail.voyagers.ie";
                    email.FromAddress = sender;
                    // email.Cc = groupAddress;
                    // email.AddHeader("Mailing-List", "list " + groupAddress);
                    email.Subject = "[Voyagers]"+msg.Subject.RawValue;
                    if (msg.TextMimePart!=null)
                        email.TextBodyPart = msg.TextMimePart.DecodedText();
                    if (msg.HtmlMimePart!=null)
                        email.HtmlBodyPart = msg.HtmlMimePart.DecodedText();

                    MimePartCollection attachments = msg.Attachments;

                    /*
                    foreach (string toAddress in toAddressesRefuseAttachments)
                        if (toAddress.Length > 0)
                        {
                            email.To = toAddress;
                            email.Send();
                        }
                     */

					/*
                    foreach (MimePart attachment in msg.Attachments)
                        email.AddAttachment(new Attachment(attachment.Data(), attachment.Name));
					*/
					if (msg.Attachments.Count>0)
					{
						sendErrorMessage(sender,"Attachments cannot be sent to Voyagers' email groups. Post your pictures or other resources to http://www.voyagers.ie and send links to them in your email instead.",msg.Subject.RawValue,groupAddress);
					}
					else
					{
						foreach (string toAddress2 in toAddresses)
							if (toAddress2.Length > 0)
							{
								email.To = toAddress2;
								email.Send();
							}
					}
                    email.Dispose();
                }
                else
                {
                    sendErrorMessage(sender,"You are not authorized to send email to Voyagers' email groups from this address("+sender+"). See http://www.voyagers.ie for further details.",msg.Subject.RawValue,groupAddress);
                }
            }

            pop.DeleteAll();
            pop.Disconnect();
        }
		return rc;
    }

	static void sendErrorMessage(string toAddress,string text,string subject,string fromAddress)
	{
		EmailMessage errMessage= new EmailMessage();
		errMessage.Server = "mail.voyagers.ie";
		errMessage.FromAddress = fromAddress;
		errMessage.Subject = "[Voyagers Bounce]" + subject;
		errMessage.TextBodyPart = text;
		errMessage.To = toAddress;
		errMessage.Send();
	}

    public static System.Collections.Generic.List<string> GetList(HttpServerUtility server,string whereClause,string colName)
    {
        if (mDatabasePath == null)
            mDatabasePath = server.MapPath("App_Data//voyagers.mdb");
        System.Collections.Generic.List<string> list = new System.Collections.Generic.List<string>();
        using (System.Data.OleDb.OleDbConnection connection = new System.Data.OleDb.OleDbConnection("Provider=Microsoft.Jet.OLEDB.4.0;Data Source=\"" + mDatabasePath + "\";Persist Security Info=True"))
        {
            connection.Open();
            using (System.Data.OleDb.OleDbCommand command = new System.Data.OleDb.OleDbCommand("SELECT "+colName+" FROM Member WHERE " + whereClause, connection))
               using (System.Data.IDataReader reader = command.ExecuteReader())
            {
                while (reader.Read())
                    list.Add(reader.GetString(0));
            }
        }
        return list;
    }

    public static void SendActivationToEverybody(HttpServerUtility server)
    {
        foreach (string memberId in GetList(server, "NOT Activated", "TRIM(STR(MemberId))"))
            SendActivation(server,memberId);
    }
}