//
// Part of the Content Management System by Declan Brennan ( http://sites.declan.brennan.name )
// Available subject to the conditions in http://www.voyagers.ie/license.htm .
//
using System.Data;
using System.Web;
using System.Xml;

public static class DataAccess
{
    public static string Identity(System.Data.Common.DbCommand command)
    {
        System.Data.Common.DbCommand cmd = command.Connection.CreateCommand();
        cmd.CommandType = System.Data.CommandType.Text;
        cmd.CommandText = "SELECT @@IDENTITY";

        return cmd.ExecuteScalar().ToString();
    }

    public static object[] GetData(HttpServerUtility server,string commandText,params object[] p)
    {
        object[] rc = null;

        string databasePath= server.MapPath("App_Data/voyagers.mdb");

        using (System.Data.OleDb.OleDbConnection connection = new System.Data.OleDb.OleDbConnection("Provider=Microsoft.Jet.OLEDB.4.0;Data Source=\"" + databasePath + "\";Persist Security Info=True"))
        {
            connection.Open();
            using (System.Data.OleDb.OleDbCommand command = new System.Data.OleDb.OleDbCommand(commandText, connection))
            {
                int i= 0;
                while (i < p.Length)
                {
                    command.Parameters.AddWithValue(p[i].ToString(), p[i + 1]);
                    i += 2;
                }
                using (System.Data.IDataReader reader = command.ExecuteReader())
                {
                    if (reader.Read())
                    {
                        rc = new object[reader.FieldCount];
                        reader.GetValues(rc);
                    }
                }
            }
        }

        return rc;
    }

    public static void GetDataAsTreeNodes(HttpServerUtility server, string commandText, System.Web.UI.WebControls.TreeNode parentNode)
    {
        string databasePath = server.MapPath("App_Data/voyagers.mdb");

        using (System.Data.OleDb.OleDbConnection connection = new System.Data.OleDb.OleDbConnection("Provider=Microsoft.Jet.OLEDB.4.0;Data Source=\"" + databasePath + "\";Persist Security Info=True"))
        {
            connection.Open();
            string cmd = commandText.Replace("@id", parentNode.Value);
            using (System.Data.OleDb.OleDbCommand command = new System.Data.OleDb.OleDbCommand(cmd, connection))
            using (System.Data.IDataReader reader = command.ExecuteReader())
            {
                while (reader.Read())
                {
                    System.Web.UI.WebControls.TreeNode newNode = new System.Web.UI.WebControls.TreeNode(reader.GetValue(0).ToString(),reader.GetInt32(1).ToString());
                    if (reader.GetString(2) == "G")
                    {
                        newNode.SelectAction = System.Web.UI.WebControls.TreeNodeSelectAction.SelectExpand;
                        newNode.Expanded = false;
                        newNode.PopulateOnDemand = true;
                    }
                    else
                    {
                        newNode.SelectAction = System.Web.UI.WebControls.TreeNodeSelectAction.Select;
                        newNode.PopulateOnDemand = false;
                    }
                    newNode.ToolTip = reader.GetValue(3).ToString();
                    parentNode.ChildNodes.Add(newNode);
                }
            }
        }
    }


    public class Item
    {
        private XmlElement mElement;
        private System.DateTime mKey;

        public Item(XmlElement element, System.DateTime key)
        {
            mElement = element;
            mKey = key;
        }

        public System.DateTime Key
        {
            get
            {
                return mKey;
            }
        }

        public XmlElement Element
        {
            get
            {
                return mElement;
            }
        }
    }

    public class ItemComparer : System.Collections.IComparer
    {
        public int Compare(object x, object y)
        {
            // Reverse order
            return System.DateTime.Compare(((Item)y).Key, ((Item)x).Key);
        }
    }

    public static void GetDataAsXml(HttpServerUtility server, int maxRecords, string commandText,XmlDocument doc,System.Collections.ArrayList items,string itemNodeName,string[] elementNames)
    {
        string databasePath = server.MapPath("App_Data/voyagers.mdb");

        using (System.Data.OleDb.OleDbConnection connection = new System.Data.OleDb.OleDbConnection("Provider=Microsoft.Jet.OLEDB.4.0;Data Source=\"" + databasePath + "\";Persist Security Info=True"))
        {
            connection.Open();
            using (System.Data.OleDb.OleDbCommand command = new System.Data.OleDb.OleDbCommand(commandText, connection))
            using (System.Data.IDataReader reader = command.ExecuteReader())
            {
                while (reader.Read())
                {
                    XmlElement item = doc.CreateElement(itemNodeName);
                    System.DateTime key = System.DateTime.Today;

                    for (int i = 0; i < reader.FieldCount; i++)
                    {
                        int pc = elementNames[i].IndexOf(':');
                        string prefix = null;
                        if (pc>=0)
                            prefix= elementNames[i].Substring(0, pc);
                        XmlElement el = null;
                        if (prefix == null)
                            el = doc.CreateElement(elementNames[i]);
                        else
                        {
                            string namespaceUri = doc.DocumentElement.GetNamespaceOfPrefix(prefix);
                            el = doc.CreateElement(elementNames[i], namespaceUri);
                        }
                        object v = System.DBNull.Value;
                        if (! reader.IsDBNull(i))
                            v= reader.GetValue(i);

                        if (v is System.DateTime)
                        {   key= (System.DateTime)v;
                            v = key.ToString("ddd dd MMMM yyyy");
                        }
                        if (! (v is System.DBNull))
                            el.InnerText = (string)v;
                        item.AppendChild(el);
                        // "ddd dd MMMM yyyy"
                        // el.SetAttribute(itemNames[i], reader.GetValue(i).ToString());
                    }
                    items.Add(new Item(item, key));
                    maxRecords--;
                    if (maxRecords == 0)
                        break;
                }
            }
        }

    }


    public static string DateStamp(object dt)
    {
        if (dt == System.DBNull.Value)
            return "";
        return " On: "+((System.DateTime)dt).ToString("ddd dd MMM yy");
    }

}