//
// Part of the Content Management System by Declan Brennan ( http://sites.declan.brennan.name )
// Available subject to the conditions in http://www.voyagers.ie/license.htm .
//
using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

/// <summary>
/// Summary description for CacheDependency
/// </summary>
public class SideBarCacheDependency:System.Web.Caching.CacheDependency
{
    private static SideBarCacheDependency sDependency;
    private bool mDisposed = false;

    public SideBarCacheDependency()
    {
        sDependency = this;
    }

    public bool Disposed
    {
        get
        {
            return mDisposed;
        }
        set
        {
            mDisposed = value;
            if (mDisposed)
                sDependency = null;
        }
    }

    public void ResetDependency()
    {
        if (this.HasChanged == false)
        {
            SetUtcLastModified(DateTime.MinValue);
            NotifyDependencyChanged(this, EventArgs.Empty);
        }
    }

    public static void Reset()
    {
        if (sDependency!=null)
            sDependency.ResetDependency();
    }

    protected override void DependencyDispose()
    {
        Disposed= true;
    }
}
