<%@ Page Language="C#" MasterPageFile="~/Default.master" %>

<script runat="server">

    //
    // Part of the Content Management System by Declan Brennan ( http://sites.declan.brennan.name )
    // Available subject to the conditions in http://www.voyagers.ie/license.htm .
    //

    protected void Button1_Click(object sender, EventArgs e)
    {

        MultiView1.ActiveViewIndex = 1;
    }

    protected void AccessDataSource1_Inserted(object sender, SqlDataSourceStatusEventArgs e)
    {
        string email= e.Command.Parameters["Email"].Value.ToString();
        // object[] rc= DataAccess.GetData(Server, "SELECT MemberId FROM Member ORDER BY MemberId DESC");
        // object[] rc= DataAccess.GetData(Server, "SELECT @@IDENTITY");
        System.Data.Common.DbCommand cmd= e.Command.Connection.CreateCommand();
        cmd.CommandType = System.Data.CommandType.Text;
        cmd.CommandText = "SELECT @@IDENTITY";
        string memberId = cmd.ExecuteScalar().ToString();
        
        // string memberId = rc[0].ToString();
        FullNameLabel.Text= GroupMailer.SendActivation(Server,memberId);
        MultiView1.ActiveViewIndex = 1;
    }

    protected void MultiView1_Load(object sender, EventArgs e)
    {

        if (Session["Admin"] == null || (bool)Session["Admin"]==false)
        {
            MultiView1.ActiveViewIndex = 2;
        }
    }

    protected void AccessDataSource1_Inserting(object sender, SqlDataSourceCommandEventArgs e)
    {
        if (Application["Random"] == null)
            Application["Random"] = new Random();
        Random rnd = (Random)Application["Random"];
        e.Command.Parameters["ActivationKey"].Value = (int)(rnd.NextDouble() * 100000);

    }
</script>

<asp:Content ID="Content1" runat="server" ContentPlaceHolderId="ContentPlaceHolder1">
    
    <asp:MultiView ID="MultiView1" runat="server" ActiveViewIndex="0" OnLoad="MultiView1_Load">
        <asp:View ID="View1" runat="server">
            <asp:AccessDataSource ID="AccessDataSource1" runat="server" DataFile="~/App_Data/voyagers.mdb"
                SelectCommand="" InsertCommand="INSERT INTO Member(Forename, Surname, Email, ActivationKey, CanPost) VALUES (@Forename,@Surname,@Email,@ActivationKey,true)" OnInserted="AccessDataSource1_Inserted" OnInserting="AccessDataSource1_Inserting" >
                <InsertParameters>
                    <asp:Parameter DefaultValue="" Name="Forename" />
                    <asp:Parameter Name="Surname" />
                    <asp:Parameter Name="Email" />
                    <asp:Parameter Name="ActivationKey" />
                </InsertParameters>
            </asp:AccessDataSource>
            <asp:FormView Width="100%" ID="FormView1" DefaultMode="Insert" runat="server" DataKeyNames="MemberId" DataSourceID="AccessDataSource1">
                 <InsertItemTemplate>
                                <fieldset>
            <legend>Add a member</legend>

                             <table border=0 cellpadding=0 cellspacing=0 class="fields">
                <tr>
                    <td class="labelColumn">Forename:</td>
                    <td class="fieldColumn">                    <asp:TextBox ID="ForenameTextBox" runat="server" Text='<%# Bind("Forename") %>'>
                    </asp:TextBox>
</td>
                </tr>
                <tr>
                    <td class="labelColumn">Surname:</td>
                    <td class="fieldColumn">                    <asp:TextBox ID="SurnameTextBox" runat="server" Text='<%# Bind("Surname") %>'>
                    </asp:TextBox>
</td>
                </tr>
                <tr>
                    <td class="labelColumn">Email:</td>
                    <td class="fieldColumn">                    <asp:TextBox ID="EmailTextBox" runat="server" Text='<%# Bind("Email") %>'>
                    </asp:TextBox>
</td>
                </tr>
            </table>
            </fieldset>
                    <asp:LinkButton ID="InsertButton" runat="server" CausesValidation="True" CommandName="Insert"
                        Text="Insert">
                    </asp:LinkButton>
                    <asp:LinkButton ID="InsertCancelButton" runat="server" CausesValidation="False" CommandName="Cancel"
                        Text="Cancel">
                    </asp:LinkButton>
                </InsertItemTemplate>
           </asp:FormView>
            </asp:View>
            <asp:View ID="View2" runat="server">
                <asp:Label ID="FullNameLabel" runat="server"></asp:Label>&nbsp;
                        has been sent an email with details on how to complete activation.
            </asp:View>
            <asp:View ID="view3" runat="server">
            Only administrators can add new members.
            </asp:View>
    </asp:MultiView></asp:Content>