<%@ Page Language="C#" MasterPageFile="~/Default.master" %>


<script runat="server">
    //
    // Part of the Content Management System by Declan Brennan ( http://sites.declan.brennan.name )
    // Available subject to the conditions in http://www.voyagers.ie/license.htm .
    //

    protected void AccessDataSource1_Selected(object sender, SqlDataSourceStatusEventArgs e)
    {
        /*
         * TODO: Getting at the current value of ActivationKey here causes problems !!!!!
        try
        {
            e.Command.Connection.Open();
            using (System.Data.IDataReader reader = e.Command.ExecuteReader())
            {
                if (reader.GetString(2) != this.Request.QueryString["ActivationKey"])
                    this.Multiview1.ActiveViewIndex = 2;
            }
        }
        finally
        {
            e.Command.Connection.Close();
        }
         */
        object[] rc= null;
        string memberId= Request.QueryString["MemberId"];
        if (memberId!=null && memberId.Length>0)
            rc = DataAccess.GetData(Server, "SELECT ActivationKey FROM Member WHERE MemberId=@MemberId","@MemberId",Request.QueryString["MemberId"]);
        if (rc==null || rc.Length!=1 || rc[0].ToString()!=Request.QueryString["ActivationKey"])
            this.Multiview1.ActiveViewIndex= 2;
    }

    protected void AccessDataSource1_Updated(object sender, SqlDataSourceStatusEventArgs e)
    {
        if (e.Exception!=null && e.Exception.Message.Contains("duplicate"))
        {
            e.ExceptionHandled = true;
            Error1.Text = "The User ID '"+e.Command.Parameters["UserID"].Value.ToString()+"' is already in use. Please choose another.";
        }
        else
        {
            HyperLink1.NavigateUrl = "Member.aspx?MemberId=" + this.Request.QueryString["MemberId"];
            object[] rc = DataAccess.GetData(Server, "SELECT MemberId,Admin,CanPost,CanDoLargeUploads,Activated FROM Member WHERE MemberId=@MemberId","@MemberId", this.Request.QueryString["MemberId"]);
                Session["MemberId"] = (int)rc[0];
                Session["Admin"] = (bool)rc[1];
                Session["CanPost"]= (bool)rc[2];
                Session["CanDoLargeUploads"] = (bool)rc[3];
            FormsAuthentication.SetAuthCookie(e.Command.Parameters["UserID"].Value.ToString(), false);

            this.Multiview1.ActiveViewIndex = 1;
        }
    }

    bool isPasswordValid(string password)
    {
        bool foundLetter = false;
        bool foundNonLetter = false;
        for (int i = 0; i < password.Length; i++)
        {
            if (Char.IsLetter(password[i]))
                foundLetter = true;
            else
                foundNonLetter = true;
        }
        return password.Length >= 6 && foundLetter && foundNonLetter;
    }

    protected void AccessDataSource1_Updating(object sender, SqlDataSourceCommandEventArgs e)
    {
        string password = (string)e.Command.Parameters["Password"].Value;
        this.Error1.Text = "";
        if (!isPasswordValid(password))
        {
            e.Cancel = true;
            Error1.Text = "A password must be over 5 characters in length. It must contain at least one letter and one non-letter.";
        }
    }
</script>

<asp:Content ID="Content1" runat="server" ContentPlaceHolderId="ContentPlaceHolder1">
    <h2>Member Activation</h2>
    <asp:MultiView ID="Multiview1" runat="server" ActiveViewIndex="0">
        <asp:View ID="View0" runat="server">
            <asp:AccessDataSource ID="AccessDataSource1" runat="server" DataFile="App_Data/voyagers.mdb" SelectCommand="SELECT [Forename],[Surname],[UserID],'' AS [Password],[ActivationKey] FROM [Member] WHERE [MemberId]=@id" 
           UpdateCommand="UPDATE [Member] SET [ActivationKey]=NULL, [Activated]=true, [UserID]=@UserID,[Password]=@Password WHERE [MemberId]=@id2" OnSelected="AccessDataSource1_Selected" OnUpdated="AccessDataSource1_Updated" OnUpdating="AccessDataSource1_Updating" >
        <SelectParameters>
            <asp:QueryStringParameter Name="id" QueryStringField="MemberId" Type="Int32" />
            <asp:QueryStringParameter Name="ActivationKey" QueryStringField="ActivationKey" Type="Int32" DefaultValue="0" />
        </SelectParameters>
        <UpdateParameters>
            <asp:Parameter Name="UserID" Type="String" />
            <asp:Parameter Name="Password" Type="String" />
            <asp:QueryStringParameter Name="id2" QueryStringField="MemberId" Type="Int32"/>
        </UpdateParameters>
    </asp:AccessDataSource>
<asp:FormView ID="FormView1" runat="server" DataSourceID="AccessDataSource1" DefaultMode="Edit">
                <EditItemTemplate>
                    <h2>Welcome <asp:Label runat="server" text='<%# Eval("Forename")+" "+Eval("Surname") %>'></asp:Label></h2>
                    <br />
                                <fieldset><legend>Choose Login Information</legend>
              <a style="float:right" href="Resources.aspx?ResourceId=19" rel="Help">About</a>

            <span class="label">User ID:</span>
            <asp:TextBox ID="UserIDTextBox" runat="server" Text='<%# Bind("UserID") %>'>
            </asp:TextBox>&nbsp;
            <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server"
                ControlToValidate="UserIDTextBox" ErrorMessage="Required" ToolTip="Required"></asp:RequiredFieldValidator>
            <br />
            <span class="label">Password:</span>
            <asp:TextBox ID="PasswordTextBox" runat="server" Text='<%# Bind("Password") %>' TextMode="Password">
            </asp:TextBox>&nbsp;
            <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server"
                ControlToValidate="PasswordTextBox" ErrorMessage="Required"></asp:RequiredFieldValidator>
                                               </fieldset>
            <asp:LinkButton ID="UpdateButton" runat="server" CausesValidation="True" CommandName="Update"
                Text="Activate">
            </asp:LinkButton>
 
                </EditItemTemplate>
            </asp:FormView>
            <br />
 <asp:Label CssClass="error" ID="Error1" runat="server"></asp:Label>
        </asp:View>
        <asp:View ID="View1" runat="server">
            <p>You have now been activated and logged in to the site. You should now 
                <asp:HyperLink  ID="HyperLink1" runat="server" Text="edit your details" ></asp:HyperLink></p>
        </asp:View>
        <asp:View ID="View2" runat="server">
            <p>There is a problem with your account activation attempt. Please email <a href="mailto:info@voyagers.ie">info@voyagers.ie</a> so it can be resolved.</p>
        </asp:View>
    </asp:MultiView></asp:Content>