using System;
using System.Data;
using System.Configuration;
using System.Text.RegularExpressions;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class _Default : System.Web.UI.Page
{
	#region Instance Methods -- Event Handlers

	/// <summary>
	/// When not a PostBack, if there is a query string parameter named "q" that is not empty, 
	/// put its contents in the "q" textbox so that the user can see what they last searched for.
	/// </summary>
	/// <param name="sender"></param>
	/// <param name="e"></param>
	protected void Page_Load (Object sender, EventArgs e)
    {
		if (!IsPostBack)
		{
			String query = Request.QueryString["q"];
			if (!String.IsNullOrEmpty (query))
			{
				q.Text = SanitizeUserInput (HttpUtility.UrlDecode (query.Trim ()));
			}
		}
	}

	/// <summary>
	/// Using the Google form field values, redirect to this page with those values in the URL's
	/// query string.  Google's JavaScript will pick up these parameters, perform the search, and
	/// display the results on your page.
	/// </summary>
	/// <param name="sender"></param>
	/// <param name="e"></param>
	protected void _btnSearch_Click (Object sender, EventArgs e)
	{
		if (!IsValid)
			return;

		Response.Redirect (
			String.Format(
				"Default.aspx?q={0}&cx={1}&cof={2}",
				HttpUtility.UrlEncode (SanitizeUserInput (q.Text.Trim ())),
				HttpUtility.UrlEncode (cx.Value),
				HttpUtility.UrlEncode (cof.Value)
				),
			false
			);

		Context.ApplicationInstance.CompleteRequest ();
	}

	/// <summary>
	/// Strip tags from user input.
	/// </summary>
	/// <param name="text"></param>
	/// <returns></returns>
	private String SanitizeUserInput (String text)
	{
		if (String.IsNullOrEmpty (text))
			return String.Empty;

		String rxPattern = "<(?>\"[^\"]*\"|'[^']*'|[^'\">])*>";
		Regex rx = new Regex (rxPattern);
		String output = rx.Replace (text, String.Empty);

		return output;
	}

	#endregion
}
