﻿using System;
using System.Data;
using System.Configuration;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml.Linq;
using System.Collections.Generic;
using System.Collections;

public class Student
{
    public string First { get; set; }
    public string Last { get; set; }
    public int ID { get; set; }
    public List<int> Scores;
}
public class StudentAverage
{
    public int ID;
    public string First;
    public string Last;
    public double ScoreAverage;
}


public class StudentData
{
    static List<Student> students = new List<Student>
    {
       new Student {First="Svetlana", Last="Omelchenko", ID=111, Scores= new List<int> {97, 92, 81, 60}},
       new Student {First="Claire", Last="O’Donnell", ID=112, Scores= new List<int> {75, 84, 91, 39}},
       new Student {First="Sven", Last="Mortensen", ID=113, Scores= new List<int> {88, 94, 65, 91}},
       new Student {First="Cesar", Last="Garcia", ID=114, Scores= new List<int> {97, 89, 85, 82}},
       new Student {First="Debra", Last="Garcia", ID=115, Scores= new List<int> {35, 72, 91, 70}},
       new Student {First="Fadi", Last="Fakhouri", ID=116, Scores= new List<int> {99, 86, 90, 94}},
       new Student {First="Hanying", Last="Feng", ID=117, Scores= new List<int> {93, 92, 80, 87}},
       new Student {First="Hugo", Last="Garcia", ID=118, Scores= new List<int> {92, 90, 83, 78}},
       new Student {First="Lance", Last="Tucker", ID=119, Scores= new List<int> {68, 79, 88, 92}},
       new Student {First="Terry", Last="Adams", ID=120, Scores= new List<int> {99, 82, 81, 79}},
       new Student {First="Eugene", Last="Zabokritski", ID=121, Scores= new List<int> {96, 85, 91, 60}},
       new Student {First="Michael", Last="Tucker", ID=122, Scores= new List<int> {94, 92, 91, 91} }
    };
    public IEnumerable GetData
    {
        get
        {
            var studentMarks = from student in StudentData.students where student.ID > 110 select new { ID = student.ID, First = student.First, Last = student.Last, ScoreTotal = student.Scores.Sum() };
            foreach (var s in studentMarks)
                yield return s.ID + ", " + s.Last + ", " + s.First + ", " + s.ScoreTotal;
        }
    }
    public static int studentID;
    public IEnumerable<int> GetStudentTotal = from student in StudentData.students where student.ID == StudentData.studentID select student.Scores.Sum();
    public IEnumerable<int> GetStudentList = from student in StudentData.students select student.ID;
    public IEnumerable<StudentAverage> studentAverageMarks = from student in StudentData.students
                                                             where student.Scores[0] > 90 
                                                             select new StudentAverage { ID=student.ID, First=student.First, Last=student.Last, ScoreAverage = student.Scores.Average()};

}
