﻿using System;
using System.Data;
using System.Configuration;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

/// <summary>
/// Summary description for DatabaseHepler
/// </summary>
public class DatabaseHepler
{
    public const string ConnectionStringName = "TestDBConnectionString";
    public static TestDatabaseDataContext GetDatabaseData()
    {
        var db = new TestDatabaseDataContext(ConfigurationManager.ConnectionStrings[ConnectionStringName].ConnectionString);
        return db;
    }
    public static bool Insert<T>(T obj) where T : class
    {
        using (var db = GetDatabaseData())
        {
            db.GetTable<T>().InsertOnSubmit(obj);
            db.SubmitChanges();
            return true;
        }
    }
    public static void Update<T>(T obj, Action<T> update) where T : class
    {
        using (var db = GetDatabaseData())
        {
            db.GetTable<T>().Attach(obj);
            update(obj);
            db.SubmitChanges();
        }
    }

    public static void Delete<T>(T obj) where T : class, new()
    {
        using (var db = GetDatabaseData())
        {
            db.GetTable<T>().Attach(obj);
            db.GetTable<T>().DeleteOnSubmit(obj);
            db.SubmitChanges();
        }
    }
}
