using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Net.Sockets;
using System.Threading;
using System.Collections;
using System.Data.OleDb;
using System.Net;

public partial class _Default : System.Web.UI.Page
{
	protected int StartPort;
	protected int EndPort;
	public static string log;
	static string ipAdres;
	public static DataTable dt;
	static string cnn;

	bool http;

	protected void Page_Load(object sender, EventArgs e)
	{
		cnn = "Provider=Microsoft.Jet.OleDb.4.0;Data Source=" + HttpContext.Current.Request.MapPath("~/App_Data/ports.mdb") + ";";
	}
	protected void Button1_Click(object sender, EventArgs e)
	{
		DataSet ds = new DataSet("dataset");
		dt = new DataTable("Ports");
		dt.Columns.Add(new DataColumn("PortNoLink"));
		dt.Columns.Add(new DataColumn("Type"));
		dt.Columns.Add(new DataColumn("Name"));
		dt.Columns.Add(new DataColumn("Spec"));
		dt.Columns.Add(new DataColumn("PortNo"));

		StartPort = Convert.ToInt32(numStart.Text);
		EndPort = Convert.ToInt32(numEnd.Text);
		ipAdres = txtIP.Text;
		Thread[] pool = new Thread[(EndPort - StartPort) + 1];
		int i = 0;
		log = "";
		DateTime start = DateTime.Now;
		// Loop through the ports between start port and end port
		for (int CurrPort = StartPort; CurrPort <= EndPort; CurrPort++)
		{
			Thread th = new Thread(new System.Threading.ParameterizedThreadStart(portAc));
			//NOTE: better to leave to system.
			// th.Priority = ThreadPriority.AboveNormal;
			th.Start(CurrPort);
			pool[i] = th;
			i++;
		}
		#region thread pool
		int k = --i;
		int retryCount = 0;
		for (; i >= 0; i--)
		{
			if (pool[i].IsAlive)
			{
				i = k;
				retryCount++;
				continue;
			}
			if (retryCount == 1000)
			{
				break;
			}
		}
		#endregion

		ds.Tables.Add(dt);
		DataView dv = new DataView(dt);
		GridView1.DataSource = dv;
		(GridView1.Columns[0] as HyperLinkField).DataTextField = "PortNo";
		(GridView1.Columns[0] as HyperLinkField).DataNavigateUrlFields = new string[] { "PortNoLink" };
		(GridView1.Columns[1] as BoundField).DataField = "Type";
		(GridView1.Columns[2] as BoundField).DataField = "Name";
		(GridView1.Columns[3] as BoundField).DataField = "Spec";

		GridView1.DataBind();

		#region httpfinger
		if (http)
		{
			// Create a request for the URL. 		
			WebRequest request = WebRequest.Create("http://" + txtIP.Text);
			// If required by the server, set the credentials.
			request.Credentials = CredentialCache.DefaultCredentials;
			// Get the response.
			try{
                HttpWebResponse response = (HttpWebResponse)request.GetResponse();
    
                string serverType = response.Headers["server"];
                if (serverType.Contains("IIS"))
                {
                    lblServer.Text = "Windows System ";
                    if (serverType.Contains("5."))
                    {
                        lblServer.Text += "XP/2000";
                    }
                    if (serverType.Contains("6."))
                    {
                        lblServer.Text += "2003";
                    }
                }
                if (serverType.ToLower().Contains("apache"))
                {
                    lblServer.Text += "probably linux";
                }
                lblServer.Text += "<br>" + serverType;
            }
            catch(Exception Err){
                //sometime which returns 404 and it makes a problem.
            }
		}
		#endregion

		DateTime end = DateTime.Now;
		TimeSpan sonuc = end - start;
		lblzaman.Text = sonuc.TotalSeconds + " total secs";
	}

	public void portAc(object portNoObj)
	{
		int portNo = (int)portNoObj;
		TcpClient TcpScan = new TcpClient();
		try
		{
			// Try to connect
			TcpScan.Connect(ipAdres, portNo);

			if (!TcpScan.Connected) return;
			// If there's no exception, we can say the port is open
			log += "Port " + portNo + " open\r\n";

			switch (portNo)
			{
				case 80: http = true; break;
			}

			// Datareader object
			OleDbDataReader objReader;
			// Opening the connection    
			OleDbConnection objConn = new OleDbConnection(cnn);
			// Creating new command object
			OleDbCommand objCmd = new OleDbCommand();
			// Assigning command text
			objCmd.CommandText = "SELECT distinct [portNo], [Type], [Name], [Spec] FROM [Neo-ports] WHERE ([portNo] = " + portNo + ")";
			// Assigning the connection to command object connection attribute
			objCmd.Connection = objConn;

			try
			{
				objConn.Open();
				objReader = objCmd.ExecuteReader();
				while (objReader.Read())
				{
					DataRow dr = dt.NewRow();
					dr[0] = "http://www.portsdb.org/bin/portsdb.cgi?portnumber=" + objReader.GetValue(0).ToString() + "&protocol=ANY&String=";
					dr[1] = objReader.GetValue(1).ToString();
					dr[2] = objReader.GetValue(2).ToString();
					dr[3] = objReader.GetValue(3).ToString();
					dr[4] = objReader.GetValue(0).ToString();
					dt.Rows.Add(dr);
				}   // Ends While
			} // Ends Try

			catch (Exception Err)
			{
				throw Err;
			}
			finally
			{
				objConn.Close();
			}
		}
		catch
		{
			// An exception occured, thus the port is probably closed
		}
	}
}