using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Reflection;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Drawing;
using Microsoft.SharePoint;
using Microsoft.SharePoint.Utilities;
using Microsoft.SharePoint.WebControls;
using Microsoft.SharePoint.Administration;
// This sample code creates a Web Parts control that acts as a consumer of row data.
namespace AJAXWebPart
{

    public sealed class RowConsumerWebPart : WebPart
    {
        private IWebPartRow _provider;
        private ICollection _tableData;
        private string strUrl =string.Empty;

        Label lblName;
        TextBox txtUrl;
        Button btnSubmit;
        GridView dg;
        LinkButton lnkExport;
        DropDownList ddlReport;
        Button btnGetReport;
        Label lblReports;
        Label tstLable;

        private void GetRowData(object rowData)
        {
            _tableData = (ICollection)rowData;
        }

        protected override void OnPreRender(EventArgs e)
        {
            if (_provider != null)
            {
                _provider.GetRowData(new RowCallback(GetRowData));
            }
        }

        protected override void CreateChildControls()
        {
            base.CreateChildControls();

            lblName = new Label();
            lblName.Text = "Enter Site URL: ";

            tstLable = new Label();
            

            txtUrl = new TextBox();

            btnSubmit = new Button();
            btnSubmit.Text = "Search";
            btnSubmit.Click += new EventHandler(btnSubmit_Click);
            btnSubmit.Width = 75;
            
            dg = new GridView();
            // Set the display properties for the DataGrid.

            dg.GridLines = GridLines.Vertical;
            dg.CellPadding = 2;
            dg.Width = Unit.Percentage(100);
            //dg.ItemStyle.ForeColor = Color.Black;
            //dg.ItemStyle.BackColor = Color.AliceBlue;
            //dg.ItemStyle.Font.Size = FontUnit.Smaller;
            //dg.ItemStyle.Font.Name = "Tahoma";
            dg.HeaderStyle.BackColor = Color.LightSteelBlue;
            dg.HeaderStyle.ForeColor = Color.Navy;
            dg.HeaderStyle.Font.Bold = true;
            dg.HeaderStyle.HorizontalAlign = HorizontalAlign.Center;
            dg.HeaderStyle.Font.Name = "Tahoma";
            dg.HeaderStyle.Font.Size = FontUnit.Medium;

            dg.RowDataBound += new GridViewRowEventHandler(dg_RowDataBound);
            
            dg.AllowSorting = true;
            dg.Sorting += new GridViewSortEventHandler(dg_Sorting);
            
            
            dg.AllowPaging = true;
            dg.PagerSettings.Mode = PagerButtons.Numeric;
            dg.PagerSettings.Visible = true;
            dg.PageIndexChanging += new GridViewPageEventHandler(dg_PageIndexChanging);
            dg.PageSize = 2;
            dg.PagerSettings.Position = PagerPosition.Bottom;
            dg.PagerSettings.PageButtonCount = 5;
            dg.EmptyDataText = "No Data Available";

            lnkExport = new LinkButton();
            lnkExport.Click += new EventHandler(lnkExport_Click);
            lnkExport.Text = " Export To Excel";

            lblReports = new Label();
            lblReports.Text = "Reports: ";

            ddlReport = new DropDownList();
            ddlReport.Items.Add("No Autodesk Master Page");
            ddlReport.Items.Add("Quota Exceeded");

            btnGetReport = new Button();
            btnGetReport.Click += new EventHandler(btnGetReport_Click);
            btnGetReport.Text = "Report";
            btnGetReport.Width = 75;

            this.Controls.Add(txtUrl);
            this.Controls.Add(btnSubmit);
            this.Controls.Add(dg);
            this.Controls.Add(lblReports);
            this.Controls.Add(btnGetReport);
            this.Controls.Add(ddlReport);
            this.Controls.Add(lnkExport);
            this.Controls.Add(lblName);
            this.Controls.Add(tstLable);
        }

        void dg_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                for (int i = 0; i < e.Row.Cells.Count; i++)
                {
                    if (e.Row.Cells[i].Text.ToString().IndexOf("&lt;a") != -1)
                    {
                        e.Row.Cells[i].Text = Context.Server.HtmlDecode
                        (e.Row.Cells[i].Text);
                    }
                }
            }
        }

        void dg_Sorting(object sender, GridViewSortEventArgs e)
        {
            GridViewSortExpression = e.SortExpression;
            int pageIndex = dg.PageIndex;
            try
            {
                if (ddlReport.SelectedIndex == 0)
                {
                    dg.DataSource = SortDataTable(NoAutodesk() as DataTable, false);
                    dg.DataBind();
                }
                else if (ddlReport.SelectedIndex == 1)
                {
                    dg.DataSource = SortDataTable(Quotaexceeded() as DataTable, false);
                    dg.DataBind();
                }
                else
                    Page.Response.Write("Invalid Selection");
            }
            catch (Exception ex)
            {
                Page.Response.Write(ex.ToString());
            }
            dg.PageIndex = pageIndex;
        }

        protected DataView SortDataTable(DataTable dataTable, bool isPageIndexChanging)
        {
            if (dataTable != null)
            {
                DataView dataView = new DataView(dataTable);
                if (GridViewSortExpression != string.Empty)
                {
                    if (isPageIndexChanging)
                    {
                        dataView.Sort = string.Format("{0} {1}", GridViewSortExpression, GridViewSortDirection);
                    }
                    else
                    {
                        dataView.Sort = string.Format("{0} {1}", GridViewSortExpression, GetSortDirection());
                    }
                }
                return dataView;
            }
            else
            {
                return new DataView();
            }
        }

        private string GridViewSortDirection
        {
            get { return ViewState["SortDirection"] as string ?? "ASC"; }
            set { ViewState["SortDirection"] = value; }
        }

        private string GridViewSortExpression
        {
            get { return ViewState["SortExpression"] as string ?? string.Empty; }
            set { ViewState["SortExpression"] = value; }
        }

        private string GetSortDirection()
        {
            switch (GridViewSortDirection)
            {
                case "ASC":
                    GridViewSortDirection = "DESC";
                    break;

                case "DESC":
                    GridViewSortDirection = "ASC";
                    break;
            }
            return GridViewSortDirection;
        }

        void dg_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            try
            {
                if (ddlReport.SelectedIndex == 0)
                {
                    dg.DataSource = NoAutodesk();
                    dg.PageIndex = e.NewPageIndex;
                    dg.DataBind();
                }
                else if (ddlReport.SelectedIndex == 1)
                {
                    dg.DataSource = Quotaexceeded();
                    dg.PageIndex = e.NewPageIndex;
                    dg.DataBind();
                }
                else
                    Page.Response.Write("Invalid Selection");
            }
            catch (Exception ex)
            {
                Page.Response.Write(ex.ToString());
            }
        }

        void btnGetReport_Click(object sender, EventArgs e)
        {
            try
            {
                if (ddlReport.SelectedIndex == 0)
                {
                    dg.DataSource = NoAutodesk();
                    dg.DataBind();
                }
                else if (ddlReport.SelectedIndex == 1)
                {
                    dg.DataSource = Quotaexceeded();
                    dg.DataBind();
                }
                else
                    Page.Response.Write("Invalid Selection");
            }
            catch (Exception ex)
            {
                Page.Response.Write(ex.ToString());
            }
        }

        private DataTable Quotaexceeded()
        {
            SPWebApplication wa = SPControl.GetContextWebApplication(Context);//Get Url from HTTP context
            SPSiteCollection sc = wa.Sites;
            DataTable dt = new DataTable();
            DataColumn dtCol = new DataColumn();
            DataRow dtRow;

            dtCol.ColumnName = "Site Collection Name";
            dtCol.ReadOnly = true;
            dt.Columns.Add(dtCol);

            dtCol = new DataColumn();
            dtCol.ColumnName = "URL";
            dtCol.ReadOnly = true;
            dt.Columns.Add(dtCol);

            dtCol = new DataColumn();
            dtCol.ColumnName = "Primary Owner";
            dtCol.ReadOnly = true;
            dt.Columns.Add(dtCol);

            dtCol = new DataColumn();
            dtCol.ColumnName = "Secondary Owner";
            dtCol.ReadOnly = true;
            dt.Columns.Add(dtCol);

            dtCol = new DataColumn();
            dtCol.ColumnName = "Current storage used";
            dtCol.ReadOnly = true;
            dt.Columns.Add(dtCol);

            dtCol = new DataColumn();
            dtCol.ColumnName = "Maximum storage allowed";
            dtCol.ReadOnly = true;
            dt.Columns.Add(dtCol);

            dtCol = new DataColumn();
            dtCol.ColumnName = "Template";
            dtCol.ReadOnly = true;
            dt.Columns.Add(dtCol);

            dtCol = new DataColumn();
            dtCol.ColumnName = "Master Page";
            dtCol.ReadOnly = true;
            dt.Columns.Add(dtCol);

            dtCol = new DataColumn();
            dtCol.ColumnName = "Theme";
            dtCol.ReadOnly = true;
            dt.Columns.Add(dtCol);

            dtCol = new DataColumn();
            dtCol.ColumnName = "Content Database Name";
            dtCol.ReadOnly = true;
            dt.Columns.Add(dtCol);

            foreach (SPSite site in sc)
            {
                foreach (SPWeb oWeb in site.AllWebs)
                {
                    SPSite.UsageInfo usageInfo = site.Usage;
                    double storageUsed = usageInfo.Storage;
                    SPQuota quota = site.Quota;
                    double MB = 1048576;//1 MB =1024*1024 Bytes
                    double percentage = 0;

                    if (quota.StorageMaximumLevel != 0)
                        percentage = ((storageUsed / MB) / (quota.StorageMaximumLevel / MB) * 100);

                    if (percentage >= 80)
                    {
                        dtRow = dt.NewRow();
                        dtRow["Site Collection Name"] = oWeb.Title;
                        dtRow["URL"] = "<a href=" + oWeb.Url + ">" + oWeb.Url + "</a>";

                        string mySiteURL = "https://share.autodesk.com/My/Person.aspx?accountname=";

                        dtRow["Primary Owner"] = "<a href=" + mySiteURL + site.Owner.LoginName + ">" + site.Owner.Name + "</a>";
                        if (site.SecondaryContact == null)
                            dtRow["Secondary Owner"] = "NONE";
                        else
                            dtRow["Secondary Owner"] = "<a href=" + mySiteURL + site.SecondaryContact.LoginName + ">" + site.SecondaryContact.Name + "</a>";

                        if (storageUsed < MB)
                        {
                            dtRow["Current storage used"] = "Less than 1 MB";
                        }
                        else
                        {
                            dtRow["Current storage used"] = Convert.ToInt32(storageUsed / MB).ToString() + "MB";
                        }

                        dtRow["Maximum storage allowed"] = (quota.StorageMaximumLevel / MB).ToString() + " MB";

                        dtRow["Template"] = oWeb.WebTemplate;

                        string strMaster = oWeb.MasterUrl.ToString();
                        strMaster = strMaster.Remove(0, strMaster.LastIndexOf('/') + 1);
                        dtRow["Master Page"] = strMaster;

                        if (oWeb.Theme == "")
                            dtRow["Theme"] = "Default Theme";

                        else
                            dtRow["Theme"] = oWeb.Theme;

                        string strCDB = site.ContentDatabase.ToString();
                        strCDB = strCDB.Remove(strCDB.IndexOf("Parent"));
                        strCDB = strCDB.Remove(0, strCDB.IndexOf('=') + 1);
                        dtRow["Content Database Name"] = strCDB;

                        dt.Rows.Add(dtRow);
                    }
                }

            }
            return dt;
        }

        private DataTable NoAutodesk()
        {
            SPWebApplication wa = SPControl.GetContextWebApplication(Context);//Get Url from HTTP context
            SPSiteCollection sc = wa.Sites;
            DataTable dt = new DataTable();
            DataColumn dtCol = new DataColumn();
            DataRow dtRow;

            dtCol.ColumnName = "Site Collection Name";
            dtCol.ReadOnly = true;
            dt.Columns.Add(dtCol);

            dtCol = new DataColumn();
            dtCol.ColumnName = "URL";
            dtCol.ReadOnly = true;
            dt.Columns.Add(dtCol);

            dtCol = new DataColumn();
            dtCol.ColumnName = "Primary Owner";
            dtCol.ReadOnly = true;
            dt.Columns.Add(dtCol);

            dtCol = new DataColumn();
            dtCol.ColumnName = "Secondary Owner";
            dtCol.ReadOnly = true;
            dt.Columns.Add(dtCol);

            dtCol = new DataColumn();
            dtCol.ColumnName = "Current storage used";
            dtCol.ReadOnly = true;
            dt.Columns.Add(dtCol);

            dtCol = new DataColumn();
            dtCol.ColumnName = "Maximum storage allowed";
            dtCol.ReadOnly = true;
            dt.Columns.Add(dtCol);

            dtCol = new DataColumn();
            dtCol.ColumnName = "Template";
            dtCol.ReadOnly = true;
            dt.Columns.Add(dtCol);

            dtCol = new DataColumn();
            dtCol.ColumnName = "Master Page";
            dtCol.ReadOnly = true;
            dt.Columns.Add(dtCol);

            dtCol = new DataColumn();
            dtCol.ColumnName = "Theme";
            dtCol.ReadOnly = true;
            dt.Columns.Add(dtCol);

            dtCol = new DataColumn();
            dtCol.ColumnName = "Content Database Name";
            dtCol.ReadOnly = true;
            dt.Columns.Add(dtCol);

            foreach (SPSite site in sc)
            {
                foreach (SPWeb oWeb in site.AllWebs)
                {
                    SPSite.UsageInfo usageInfo = site.Usage;
                    double storageUsed = usageInfo.Storage;
                    SPQuota quota = site.Quota;
                    double MB = 1048576;//1 MB =1024*1024 Bytes
                    string strMaster = oWeb.MasterUrl.ToString();
                    strMaster = strMaster.Remove(0, strMaster.LastIndexOf('/') + 1);

                    if (strMaster != "Autodesk.master")
                    {
                        dtRow = dt.NewRow();
                        dtRow["Site Collection Name"] = oWeb.Title;
                        dtRow["URL"] = "<a href=" + oWeb.Url + ">" + oWeb.Url + "</a>";

                        string mySiteURL = "https://share.autodesk.com/My/Person.aspx?accountname=";

                        dtRow["Primary Owner"] = "<a href=" + mySiteURL + site.Owner.LoginName + ">" + site.Owner.Name + "</a>";
                        if (site.SecondaryContact == null)
                            dtRow["Secondary Owner"] = "NONE";
                        else
                            dtRow["Secondary Owner"] = "<a href=" + mySiteURL + site.SecondaryContact.LoginName + ">" + site.SecondaryContact.Name + "</a>";

                        if (storageUsed < MB)
                        {
                            dtRow["Current storage used"] = "Less than 1 MB";
                        }
                        else
                        {
                            dtRow["Current storage used"] = Convert.ToInt32(storageUsed / MB).ToString() + "MB";
                        }

                        dtRow["Maximum storage allowed"] = (quota.StorageMaximumLevel / MB).ToString() + " MB";

                        dtRow["Template"] = oWeb.WebTemplate;

                        dtRow["Master Page"] = strMaster;

                        if (oWeb.Theme == "")
                            dtRow["Theme"] = "Default Theme";

                        else
                            dtRow["Theme"] = oWeb.Theme;

                        string strCDB = site.ContentDatabase.ToString();
                        strCDB = strCDB.Remove(strCDB.IndexOf("Parent"));
                        strCDB = strCDB.Remove(0, strCDB.IndexOf('=') + 1);
                        dtRow["Content Database Name"] = strCDB;

                        dt.Rows.Add(dtRow);
                    }
                }

            }
            return dt;
        }

        void lnkExport_Click(object sender, EventArgs e)
        {
            Page.Response.Clear();
            Page.Response.AddHeader("content-disposition", string.Format("attachment; filename={0}", "SiteInfo.xls"));
            Page.Response.ContentType = "application/ms-excel";
            System.IO.StringWriter oStringWriter = new System.IO.StringWriter();
            System.Web.UI.HtmlTextWriter oHtmlTextWriter = new System.Web.UI.HtmlTextWriter(oStringWriter);
            dg.RenderControl(oHtmlTextWriter);
            Page.Response.Write(oStringWriter.ToString());
            Page.Response.Flush();
            Page.Response.End();
        }

        void btnSubmit_Click(object sender, EventArgs e)
        {
            strUrl = txtUrl.Text.Trim();
        }

        void GetSiteInfo(string WebUrl)
        {
            #region "try"
            try
            {
                SPSite mySite = new SPSite(WebUrl);
                DataTable dt = new DataTable();

                DataColumn dtCol = new DataColumn();
                DataRow dtRow;

                using (SPWeb curWeb = mySite.OpenWeb())
                {

                    SPSite.UsageInfo usageInfo = mySite.Usage;
                    double storageUsed = usageInfo.Storage;
                    SPQuota quota = mySite.Quota;
                    double MB = 1048576;//1 MB =1024*1024 Bytes
                    double percentage = 0;

                    dtCol.ColumnName = "Site Collection Name";
                    dtCol.ReadOnly = true;
                    dt.Columns.Add(dtCol);

                    dtCol = new DataColumn();
                    dtCol.ColumnName = "URL";
                    dtCol.ReadOnly = true;
                    dt.Columns.Add(dtCol);

                    dtCol = new DataColumn();
                    dtCol.ColumnName = "Primary Owner";
                    dtCol.ReadOnly = true;
                    dt.Columns.Add(dtCol);

                    dtCol = new DataColumn();
                    dtCol.ColumnName = "Secondary Owner";
                    dtCol.ReadOnly = true;
                    dt.Columns.Add(dtCol);

                    dtCol = new DataColumn();
                    dtCol.ColumnName = "Current storage used";
                    dtCol.ReadOnly = true;
                    dt.Columns.Add(dtCol);

                    dtCol = new DataColumn();
                    dtCol.ColumnName = "Maximum storage allowed";
                    dtCol.ReadOnly = true;
                    dt.Columns.Add(dtCol);

                    dtCol = new DataColumn();
                    dtCol.ColumnName = "Template";
                    dtCol.ReadOnly = true;
                    dt.Columns.Add(dtCol);

                    dtCol = new DataColumn();
                    dtCol.ColumnName = "Master Page";
                    dtCol.ReadOnly = true;
                    dt.Columns.Add(dtCol);

                    dtCol = new DataColumn();
                    dtCol.ColumnName = "Theme";
                    dtCol.ReadOnly = true;
                    dt.Columns.Add(dtCol);

                    dtCol = new DataColumn();
                    dtCol.ColumnName = "Content Database Name";
                    dtCol.ReadOnly = true;
                    dt.Columns.Add(dtCol);

                    dtRow = dt.NewRow();
                    dtRow["Site Collection Name"] = curWeb.Title;
                    dtRow["URL"] = "<a href=" + curWeb.Url + ">" + curWeb.Url + "</a>";
                    
                    string mySiteURL = "https://share.autodesk.com/My/Person.aspx?accountname=";

                    dtRow["Primary Owner"] = "<a href=" + mySiteURL + mySite.Owner.LoginName + ">" + mySite.Owner.Name + "</a>";
                    if (mySite.SecondaryContact == null)
                        dtRow["Secondary Owner"] = "NONE";
                    else
                        dtRow["Secondary Owner"] = "<a href=" + mySiteURL + mySite.SecondaryContact.LoginName + ">" + mySite.SecondaryContact.Name + "</a>";

                    if (storageUsed < MB)
                    {
                        dtRow["Current storage used"] = "Less than 1 MB";
                    }
                    else
                    {
                        dtRow["Current storage used"] = Convert.ToInt32(storageUsed / MB).ToString() + "MB";
                    }

                    dtRow["Maximum storage allowed"] = (quota.StorageMaximumLevel / MB).ToString() + " MB";

                    dtRow["Template"] = curWeb.WebTemplate;

                    string strMaster = curWeb.MasterUrl.ToString();
                    strMaster = strMaster.Remove(0, strMaster.LastIndexOf('/') + 1);
                    dtRow["Master Page"] = strMaster;

                    if (curWeb.Theme == "")
                        dtRow["Theme"] = "Default Theme";

                    else
                        dtRow["Theme"] = curWeb.Theme;

                    string strCDB = mySite.ContentDatabase.ToString();
                    strCDB = strCDB.Remove(strCDB.IndexOf("Parent"));
                    strCDB = strCDB.Remove(0, strCDB.IndexOf('=') + 1);
                    dtRow["Content Database Name"] = strCDB;

                    dt.Rows.Add(dtRow);
                    
                    dg.DataSource = dt;
                    dg.DataBind();

                    if (quota.StorageMaximumLevel != 0)
                        percentage = ((storageUsed / MB) / (quota.StorageMaximumLevel / MB) * 100);

                    if (percentage >= 80)
                        dg.Rows[0].Cells[4].BackColor = Color.PaleGreen;

                    if (!(dg.Rows[0].Cells[7].Text.Contains("Autodesk")))
                        dg.Rows[0].Cells[7].BackColor = Color.PaleGreen;

                    if (!(dg.Rows[0].Cells[8].Text.Contains("Autodesk")))
                        dg.Rows[0].Cells[8].BackColor = Color.PaleGreen;
                }
            }

            catch (Exception EX)
            {
                //Page.Response.Write(EX.ToString());
            }
            #endregion
        }

        protected override void RenderContents(HtmlTextWriter writer)
        {
            if (_provider != null)
            {
                if (strUrl.Equals(string.Empty))
                {
                    PropertyDescriptorCollection props = _provider.Schema;
                    int count = 0;

                    if (props != null && props.Count > 0 && _tableData != null)
                    {
                        foreach (PropertyDescriptor prop in props)
                        {
                            foreach (DataRow o in _tableData)
                            {
                                strUrl = o[count].ToString();
                                count = count + 1;
                            }
                        }
                    }
                    else
                    {
                        writer.Write("No data");
                    }
                }
                
                if (strUrl != string.Empty)
                {
                    tstLable.Text = strUrl;
                    GetSiteInfo(strUrl);
                }

            }
            else
            {
                writer.Write("Not connected");
            }

            writer.Write("<Table>");

            writer.Write("<tr>");
            writer.Write("<td>");
            lblName.RenderControl(writer);
            tstLable.RenderControl(writer);
            writer.Write("</td>");
            writer.Write("<td>");
            txtUrl.RenderControl(writer);
            writer.Write("</td>");
            writer.Write("<td>");
            btnSubmit.RenderControl(writer);
            writer.Write("</td>");
            writer.Write("</tr>");
            writer.Write("<tr>");
            writer.Write("<td>");
            lblReports.RenderControl(writer);
            writer.Write("</td>");
            writer.Write("<td>");
            ddlReport.RenderControl(writer);
            writer.Write("</td>");
            writer.Write("<td>");
            btnGetReport.RenderControl(writer);
            writer.Write("</td>");
            writer.Write("</tr>");
            writer.Write("<tr>");
            writer.Write("<td colspan=3>");
            dg.RenderControl(writer);
            writer.Write("</td>");
            writer.Write("</tr>");
            writer.Write("<tr>");
            writer.Write("<td>");
            lnkExport.RenderControl(writer);
            writer.Write("</td>");
            writer.Write("</tr>");
            writer.Write("</Table>");

        }
        [ConnectionConsumer("Row")]
        
        public void SetConnectionInterface(IWebPartRow provider)
        {
            _provider = provider;
        }
    }

}
