using System;
using System.Text;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using Microsoft.SharePoint;
using Microsoft.SharePoint.Utilities;
using Microsoft.SharePoint.WebControls;
using Microsoft.SharePoint.Administration;
using System.Reflection;
using System.Data;
using System.Collections;
using System.ComponentModel;
using System.Data;

namespace AJAXWebPart
{
    public sealed class AJAXWebPart : WebPart, IWebPartRow
    {
        System.Text.StringBuilder html = new System.Text.StringBuilder();
        SPTreeView sptv ;//= new SPTreeView();// SharePoint display TreeView
        private DataTable _table;
        //UpdatePanel up;// = new UpdatePanel();

        protected override void CreateChildControls()
        {
            base.CreateChildControls();

            this.EnsureUpdatePanelFixups();
            UpdatePanel up = new UpdatePanel();
            ScriptManager scriptManager = new ScriptManager();
            scriptManager.ID = "scriptManager";
            scriptManager.AsyncPostBackTimeout = 180;
            up.ID = "UpdatePanel1";
            up.ChildrenAsTriggers = true;
            up.UpdateMode = UpdatePanelUpdateMode.Conditional;
            
            sptv = new SPTreeView();
            //sptv.ExpandAll();
            //TreeView treeView = new TreeView();
            bool check = this.Page.IsPostBack;
            GetSiteCollection(); //Function to Fill all Site Collection Only..
            //if (check == false)
            //{
            //    sptv.CollapseAll();
            //}
            sptv.SelectedNodeChanged += new EventHandler(sptv_SelectedNodeChanged);
            sptv.TreeNodeExpanded += new TreeNodeEventHandler(sptv_TreeNodeExpanded); 
            up.ContentTemplateContainer.Controls.Add(sptv);
            this.Controls.Add(scriptManager);
            this.Controls.Add(up);
        }

        void sptv_TreeNodeExpanded(object sender, TreeNodeEventArgs e)
        {
            //GetTreeView();
            TreeNode CurNode = new TreeNode();
            string strWebNode = e.Node.Text;
            CurNode = e.Node;
            CurNode.ChildNodes.Clear();
            CreateTreeOnExpandNode(strWebNode, CurNode);
        }

        void sptv_SelectedNodeChanged(object sender, EventArgs e)
        {
            _table = new DataTable();

            DataColumn col = new DataColumn();
            col.DataType = typeof(string);
            col.ColumnName = "Url";
            _table.Columns.Add(col);

            DataRow row = _table.NewRow();
            row["Url"] = sptv.SelectedNode.Text;
            _table.Rows.Add(row);
        }

        //void sptv_TreeNodeCollapsed(object sender, TreeNodeEventArgs e)
        //{
        //    //e.Node.CollapseAll();
        //    TreeNode CurNode = new TreeNode();
        //    CurNode = e.Node;
        //    CurNode.CollapseAll();
        //}


        public void CreateTreeOnExpandNode(string URL,TreeNode nodeExpanded)
        {
            SPSite site = new SPSite(URL);
            SPWeb web = null;
            if (site.Url == URL)
            {
                web = site.OpenWeb();
            }
            else
            {
                URL = URL.Replace(site.Url, "");
                web = site.OpenWeb(URL);
            }
            foreach (SPWeb web1 in web.Webs)
            {
                TreeNode childnode = new TreeNode(web1.Url);
                GetChild(web1, childnode);
                nodeExpanded.ChildNodes.Add(childnode);
            }
        }

        private void GetChild(SPWeb web1, TreeNode refnode)
        {
            foreach (SPWeb web2 in web1.Webs)
            {
                TreeNode subsitenode = new TreeNode(web2.Url);
                refnode.ChildNodes.Add(subsitenode);
                GetChild(web2, subsitenode);
            }
        }

        public void GetSiteCollection()
        {
            SPWebApplication wa;
            wa = SPControl.GetContextWebApplication(Context);//Get Url from HTTP context
            SPSiteCollection wasites = wa.Sites;
            TreeNode rootnode;
            sptv.RootNodeStyle.ImageUrl = "/_layouts/1033/IMAGES/USM.gif";
            foreach (SPSite site in wasites)
            {
                SPWeb web = site.OpenWeb();
                rootnode = new TreeNode(web.Url);
                if (web.Webs.Count > 0)
                {
                    TreeNode emptyNode = new TreeNode();
                    rootnode.ChildNodes.Add(emptyNode);
                }
                sptv.Nodes.Add(rootnode);
            }
        }


        #region OnNodeSelect
        //public void GetTreeView()
        //{
        //    EnsureChildControls();
        //    SPWebApplication wa;
        //    if (strSPWebApplication == string.Empty) //Web Part Property is not set
        //    {
        //        wa = SPControl.GetContextWebApplication(Context);//Get Url from HTTP context
        //    }
        //    else
        //    {

        //        wa = SPWebApplication.Lookup(new Uri(strSPWebApplication));
        //    }

        //    SPSiteCollection wasites = wa.Sites;
        //    TreeNode rootnode;
        //    rootnode = new TreeNode(wa.Name);
        //    sptv.Nodes.Add(rootnode);
        //    sptv.RootNodeStyle.ImageUrl = "/_layouts/1033/IMAGES/USM.gif";
        //    foreach (SPSite site in wasites)
        //    {
        //        SPWeb web = site.RootWeb;
        //        CreateTree(web, rootnode);
        //    }
        //}

        //private void CreateTree(SPWeb curWeb, TreeNode ParentNode)
        //{
        //    if (curWeb.Webs.Count > 0)
        //    {

        //        TreeNode childNode = new TreeNode(curWeb.Url.ToString());
        //        SPWebCollection subWebs = curWeb.Webs;

        //        foreach (SPWeb subWeb in subWebs)
        //        {
        //            CreateTree(subWeb, childNode);
        //        }
        //        ParentNode.ChildNodes.Add(childNode);
        //    }
        //    else
        //    {
        //        TreeNode firstchild = new TreeNode(curWeb.Url);
        //        ParentNode.ChildNodes.Add(firstchild);
        //    }
        //}

        #endregion

        private void EnsureUpdatePanelFixups()
        {
            if (this.Page.Form != null)
            {
                string formOnSubmitAtt = this.Page.Form.Attributes["onsubmit"];
                if (formOnSubmitAtt == "return _spFormOnSubmitWrapper();")
                {
                    this.Page.Form.Attributes["onsubmit"] = "_spFormOnSubmitWrapper();";
                }
            }

            ScriptManager.RegisterStartupScript(this, typeof(AJAXWebPart), "UpdatePanelFixup", "_spOriginalFormAction = document.forms[0].action; _spSuppressFormOnSubmitWrapper=true;", true);
        }

        public AJAXWebPart()
        {
            _table = new DataTable();

            DataColumn col = new DataColumn();
            col.DataType = typeof(string);
            col.ColumnName = "Url";
            _table.Columns.Add(col);

            DataRow row = _table.NewRow();
            row["Url"] = string.Empty;
            _table.Rows.Add(row); 
           
        }
        [ConnectionProvider("Row")]
        public IWebPartRow GetConnectionInterface()
        {
            return this;
        }
        public PropertyDescriptorCollection Schema
        {
            get
            {
                return TypeDescriptor.GetProperties(_table.DefaultView[0]);
            }
        }
        public void GetRowData(RowCallback callback)
        {
            callback(_table.Rows);
        }


    }

}
