﻿using System;
using System.Data;
using System.Configuration;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Collections.Generic;
using Demo.DataModel;

/// <summary>
/// Summary description for CustomerPresentationModel
/// </summary>
public class CustomerPresentationModel : Demo.PresentationModel.CustomerPresentationModel
{
    public static CustomerPresentationModel Instance
    {
        get
        {
            CustomerPresentationModel instance = HttpContext.Current.Session["_c_"] as CustomerPresentationModel;
            if (instance == null)
            {
                instance = new CustomerPresentationModel();
                HttpContext.Current.Session["_c_"] = instance;
            }
            return instance;
        }
    }

    public IEnumerable<Customer> GetCustomerList()
    {
        return Items;
    }

    public Customer GetCustomer()
    {
        return SelectedItem;
    }
    
    public void SelectCustomer(DataKey dataKey)
    {
        SelectCustomer(dataKey.Value.ToString());
    }

    public void SelectCustomer(string id)
    {
        var items = from item in Items
                    where item.Id.Equals(id)
                    select item;

        SelectedItem = items.Count() > 0 ? items.First() : null;
    }
}
