﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;

namespace Demo.PresentationModel
{
    public abstract class PresentationModel<T> : INotifyPropertyChanged
    {
        #region INotifyPropertyChanged Members

        public event PropertyChangedEventHandler PropertyChanged;
        protected void NotifyPropertyChanged(string propertyName)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
            }
        }

        #endregion

        protected int itemCount;
        public int ItemCount
        {
            get { return itemCount; }
            set { itemCount = value; NotifyPropertyChanged("ItemCount"); }
        }

        protected IEnumerable<T> items;
        public virtual IEnumerable<T> Items
        {
            get { return GetItems(); }
            set { items = value; NotifyPropertyChanged("Items"); }
        }

        protected abstract IEnumerable<T> GetItems();

        private T selectedItem;
        public virtual T SelectedItem
        {
            get { return selectedItem; }
            set { selectedItem = value; NotifyPropertyChanged("SelectedItem"); }
        }

        protected void Reset()
        {
            Items = null;
            SelectedItem = default(T);
        }

    }

}
