﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Demo.DataModel
{
    public class CustomerService : ICustomerService
    {
        #region ICustomerService Members

        public IEnumerable<Customer> GetAllCustomers()
        {
            return new List<Customer>
            {
                new Customer{
                    FirstName = "Jesper",
                    LastName = "Aaberg",
                    Address = "One Microsoft Way, Redmond WA 98052",
                    Comments = "CAB Rocks!",
                },

                new Customer{
                    FirstName = "Martin", 
                    LastName = "Bankov",
                    Address = "Two Microsoft Way, Redmond WA 98052",
                    Comments = "This is awesome",
                },

                new Customer{
                    FirstName = "Shu",
                    LastName = "Ito",
                    Address = "Three Microsoft Way, Redmond WA 98052",
                    Comments = "N/A",
                },

                new Customer{
                    FirstName = "Kim", 
                    LastName = "Ralls",
                    Address = "Four Microsoft Way, Redmond WA 98052",
                    Comments = "N/A",
                },


                new Customer{
                    FirstName = "John", 
                    LastName = "Kane", 
                    Address = "Five Microsoft Way, Redmond WA 98052",
                    Comments = "N/A",
                },
            };
        }

        public IEnumerable<Customer> GetSearchCustomers(string name)
        {
            return from customer in GetAllCustomers()
                   where customer.FirstName.Contains(name) || customer.LastName.Contains(name)
                   select customer;
        }

        #endregion
    }
}
