using System;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;
using System.Data;
using System.Data.SqlClient;

public partial class _Default : System.Web.UI.Page 
{
    private void BindGrid()
    {
        List<Customer> items = new List<Customer>(5);
        for (int i = 0; i < 5; i++)
        {
            Customer c = new Customer();
            items.Add(c);
        }
        GridView1.DataSource = items;
        GridView1.DataBind();
    }

    SqlConnection cnn = new SqlConnection("data source=.;initial catalog=northwind;user id=sa;password=sa");
    SqlCommand cmd = new SqlCommand();

    private void BeginAdd()
    {
        cnn.Open();
        SqlTransaction tran= cnn.BeginTransaction();
        cmd.Connection = cnn;
        cmd.Transaction = tran;
        cmd.CommandText = "insert into customers(customerid,companyname,contactname,country) values(@custid,@company,@contact,@country)";
        SqlParameter p1 = new SqlParameter("@custid",SqlDbType.VarChar);
        SqlParameter p2 = new SqlParameter("@company", SqlDbType.VarChar);
        SqlParameter p3 = new SqlParameter("@contact", SqlDbType.VarChar);
        SqlParameter p4 = new SqlParameter("@country", SqlDbType.VarChar);
        cmd.Parameters.Add(p1);
        cmd.Parameters.Add(p2);
        cmd.Parameters.Add(p3);
        cmd.Parameters.Add(p4);
    }

    private void CompleteAdd()
    {
        try
        {
            cmd.Transaction.Commit();
            Label1.Text = "Customers added successfully!";
        }
        catch(Exception ex)
        {
            Label1.Text = "Error completing the operation!";
        }
        finally
        {
            cnn.Close();
        }
    }

    private void AddCustomer(string custid, string company, string contact, string country)
    {
        try
        {
            cmd.Parameters[0].Value = custid;
            cmd.Parameters[1].Value = company;
            cmd.Parameters[2].Value = contact;
            cmd.Parameters[3].Value = country;
            cmd.ExecuteNonQuery();
        }
        catch
        {
            cmd.Transaction.Rollback();
        }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if(!IsPostBack)
        {
            BindGrid();
        }
    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        BeginAdd();
        foreach (GridViewRow row in GridView1.Rows)
        {
            if (row.RowType == DataControlRowType.DataRow)
            {
                string custid = ((TextBox)row.FindControl("TextBox1")).Text;
                string company = ((TextBox)row.FindControl("TextBox2")).Text;
                string contact = ((TextBox)row.FindControl("TextBox3")).Text;
                string country = ((TextBox)row.FindControl("TextBox4")).Text;
                if (custid != "")
                {
                    AddCustomer(custid, company, contact, country);
                }
            }
        }
        CompleteAdd();
    }
    protected void Button2_Click(object sender, EventArgs e)
    {
        BindGrid();
    }
}
