﻿Type.registerNamespace("Demo");

Demo.SlideShow=function()
{
    this._slides=new Array();
    this._delay=10;
    this._currentIndex=0;
    this._pause=false;
}

Demo.SlideShow.prototype=
{
    get_Slides:function()
    {
        return this._slides;
    },
    
    set_Slides:function(value)
    {
        this._slides=value;
    },
    
    get_Delay:function()
    {
        return this._delay;
    },
    
    set_Delay:function(value)
    {
        this._delay=value;
    },
    
    get_CurrentIndex:function()
    {
        return this._currentIndex;
    },
    
    set_CurrentIndex:function(value)
    {
        if(value<0)
        {
            this._currentIndex=this._slides.length-1;
            return;
        }
        if(value>=this._slides.length)
        {
            this._currentIndex=0;
        }
        else
        {
            this._currentIndex=value;
        }
    },
    
    get_IsPaused:function()
    {
        return this._pause;
    },
    
    set_IsPaused:function(value)
    {
        this.pause=value;
    },
    
    Pause:function()
    {
        this._pause=true;
    },
    
    Play:function()
    {
        this._pause=false;
        window.setTimeout("slideshow.ShowImage()",this.get_Delay());
    },
    
    ShowFirst:function()
    {
        this._currentIndex=0;
        this.ShowImage();
    },
    
    ShowLast:function()
    {
        this._currentIndex=this._slides.length-1;
        this.ShowImage();
    },
    
    ShowNext:function()
    {
        var newIndex=this._currentIndex +1;
        this.set_CurrentIndex(newIndex);
        this.ShowImage();
    },
    
    ShowPrevious:function()
    {
        var newIndex=this._currentIndex -1;
        this.set_CurrentIndex(newIndex);
        this.ShowImage();
    },
    
    ShowImage:function()
    {
        var img=$get("Image1");
        if(img.style.visibility=="hidden")
        {
            img.style.visibility="visible";
        }
        var slides=this.get_Slides();
        var curIndex=this.get_CurrentIndex();
        img.src=slides[curIndex];
        if(this.get_IsPaused()==false)
        {
            this.set_CurrentIndex(curIndex+1);
            this.Play();
        }
    }
}


Demo.SlideShow.registerClass("Demo.SlideShow");

var slideshow=new Demo.SlideShow();