﻿Imports System.Data
Imports System.Data.oleDB
Imports System.IO
Imports System.Configuration
Partial Class _Default
    Inherits System.Web.UI.Page
    Dim objConn As OleDbConnection
    ' istanziamo la classe pagedDataSource
    Public pagedData As New PagedDataSource()

    ' funzione che estrae i dati delle foto e la assegno ad un DataTable che mi restituisce il dataset
    Public Function GetFoto() As DataTable

        'recupero la stringa di connessione dal web.config
        Dim qualeProvider As String = System.Configuration.ConfigurationManager.ConnectionStrings("db1ConnectionString").ConnectionString
        Dim MioDs As DataSet = New DataSet()
        objConn = New OleDbConnection(qualeProvider)
        Try
            objConn.Open()
            Dim sqlStr As String = "SELECT * FROM Gallery "
            'utilizzo un OleDbDataAdapter  e il metodo Fill
            Dim MyAdapter As OleDbDataAdapter = New OleDbDataAdapter(sqlStr, objConn)

            MyAdapter.Fill(MioDs, "Gallery")

        Catch ex As Exception
            Response.Write(ex.ToString)
        Finally
            objConn.Dispose()
        End Try

        'restituisco il datatable
        Return MioDs.Tables("Gallery").Copy
    End Function

    Sub dopaging()
      
        'Assegno alla classe pageddatasource la sorgente dati 
        pagedData.DataSource = GetFoto().DefaultView
        'Attivo il Paging e imposto il numero di record da mostrare per ogni pagina 
        pagedData.AllowPaging = True
        pagedData.PageSize = 3
        'le eccezioni
        Try
            pagedData.CurrentPageIndex = Int32.Parse(Request.QueryString("Page")).ToString()
        Catch ex As Exception
            pagedData.CurrentPageIndex = 0
        End Try
        ' visibili o invisibili i pulsanti di navigazione next e prev

        lbtnPrev.Visible = (Not pagedData.IsFirstPage)
        lbtnNext.Visible = (Not pagedData.IsLastPage)
        
        'collego la sorgente dati al datalist 
        dlGallery.DataSource = pagedData
        dlGallery.DataKeyField = "Image_ID"
        dlGallery.DataBind()

    End Sub

    Private Sub Prev_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles lbtnPrev.Click
        'passo i parametri
        Response.Redirect(Request.CurrentExecutionFilePath & "?Page=" & (pagedData.CurrentPageIndex - 1))
    End Sub
    Private Sub Next_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles lbtnNext.Click
        'passo i parametri
        Response.Redirect(Request.CurrentExecutionFilePath & "?Page=" & (pagedData.CurrentPageIndex + 1))
    End Sub

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        dopaging()
    End Sub
End Class
