<%
Dim JMailboxVersion
JMailboxVersion = "0.8.2"

'===========================================================
' Put anything here that is used by two or more other files
'===========================================================
MyUsername = Session("USERNAME")
MyPassword = Session("PASSWORD")
POP3Server = Session("MAILSERVER")
SMTPServer = Session("SMTPSERVER")

If debugLevel = 0 OR debugLevel = "" Then
  Session("DEBUG") = ""
Else  
  Session("DEBUG") = debugLevel
End If  

If MyAddresses = "" Then
  If Instr(MyUsername, "@") > 0 Then
    MyAddresses = MyUsername
  ElseIf Instr(MyUsername, "%") > 0 Then
    MyAddresses = Replace(MyUsername, "%", "@")
  ElseIf MyDomain <> "" Then
    MyAddresses = MyUsername & "@" & MyDomain
  End If  
  If MyAddresses <> "" Then
    If InStr( MyAddresses, "/" ) > 0 Then MyAddresses = Replace( MyAddresses, "/", "\" )
    If Instr( MyAddresses, "\" ) > 0 Then MyAddresses = GetRightSide( MyAddresses, "\" )
  End If
End If

Dim arrAddresses
If MyAddresses <> "" AND Instr(MyAddresses, " ") <> 0 Then arrAddresses = split(MyAddresses, " ")

'======================================
' Dealing with the all the user folders
'======================================

Dim RootFolder
RootFolder = GetRootFolder

Dim usersDir
Dim usersPath
usersDir = getPhysicalPath(RootFolder) & "users"
usersPath = usersDir & "/"

Dim usersPhysicalPath
usersPhysicalPath = getPhysicalPath(usersPath)

Dim strSessionUSERNAME
strSessionUSERNAME = Session("USERNAME")
strSessionUSERNAME = Replace(strSessionUSERNAME, "\", "_")
strSessionUSERNAME = Replace(strSessionUSERNAME, "/", "_")

Dim userInboxFile
userInboxFile = usersPhysicalPath & strSessionUSERNAME & ".inbox" 

Dim userDataFile
userDataFile = usersPhysicalPath & strSessionUSERNAME & ".data" 

Dim userSignatureFile
userSignatureFile = usersPhysicalPath & strSessionUSERNAME & ".signature" 

Dim userNameFile
userNameFile = usersPhysicalPath & strSessionUSERNAME & ".name" 

'==============================================================
' Eliminate problem usernames for attachment and upload folders
'==============================================================
Function getFolderName( strUser )
  Dim strTempUser
  strTempUser = strUser 
  strTempUser = Replace(strTempUser, ".", "_")
  strTempUser = Replace(strTempUser, "%", "_")
  strTempUser = Replace(strTempUser, " ", "_")
  strTempUser = Replace(strTempUser, "@", "_")
  strTempUser = Replace(strTempUser, "/", "_")
  strTempUser = Replace(strTempUser, "\", "_")  
  getFolderName = strTempUser
End Function

Dim strUsername
strUsername = getFolderName( Session("USERNAME") )

Dim uploadRoot, attachmentRoot, attachmentVRoot
uploadRoot = getPhysicalPath(RootFolder) & "upload/"
attachmentRoot = getPhysicalPath(RootFolder) & "attachments/"
attachmentVRoot = RootFolder & "attachments/"

Dim uploadDir, uploadPath
uploadDir = uploadRoot & strUsername
uploadPath = uploadDir & "/"

Dim attachmentDir, attachmentPath, attachmentVDir, attachmentVPath
attachmentDir = attachmentRoot & strUsername
attachmentPath = attachmentDir & "/"
attachmentVDir = attachmentVRoot & strUsername
attachmentVPath = attachmentVDir & "/"

'=======================================================
' If MyName isn't hard coded in CONFIG.ASP see if there 
' is a .name file to get a valid name for this user.
'=======================================================
If MyName = "" Then
  If Session("MYNAME") = "" Then
    Dim arrNameFile, oNameFile
    Set FSO = server.CreateObject("Scripting.FileSystemObject")
    If FSO.FileExists( userNameFile ) Then
      Set oNameFile = FSO.OpenTextFile(userNameFile, 1)  
      Session("MYNAME") = oNameFile.ReadLine
    End If
    Set FSO=nothing
  End If  
Else
  Session("MYNAME") = MyName  
End If

'===============================================================================
' The inbox is cached to a temp file and the different fields are labelled thus:
'===============================================================================
Const cacheTOKEN = "::="
Const cacheIDPrefix = "#"
Const cacheID = 0
Const cacheFROM = 1
Const cacheATTACHMENT = 2
Const cacheUNIQUEURL = 3
Const cacheSUBJECT = 4
Const cacheDATE = 5
Const cacheSTRREPLYFROM = 6
Const cacheSTATUS = 7
Const cacheMESSAGEUID = 8

'==========================================
' Stops the app and prints a debug message
'==========================================
Sub DebugStr( strMsg )
  Response.Write strMsg
  Response.End
End Sub

'=====================
' Easily popup alerts
'=====================
Sub ShowMessage( strMsg )
  Response.Write "<SCRIPT>alert(""" & CStr(strMsg) & """)</SCRIPT>"
End Sub

'==============================================
' Easily insert comments in code for debugging
'==============================================
Sub Comment( strComment )
  Response.Write vbCrLf & vbCrLf & "<!-- " & strComment & " (" & Time & ") -->" & vbCrLf
End Sub

Function formatEmailAddress( strToTrim )
  Dim tempOutStr
  tempOutStr = strToTrim
  If Instr( tempOutStr, "=" ) > 0 Then
    If showFullSender = 1 Then
      tempOutStr = Replace(tempOutStr, "=", "<BR>&nbsp;<small>") & "</small>"    
    Else
      tempOutStr = GetLeftSide( tempOutStr, "=" )    
    End If
  End If  

  formatEmailAddress = tempOutStr  
End Function

'===================================
' Adds slash to the end of the path
'===================================
Function addSlash(path, slash)
	If Right(path, 1) <> slash Then
        	addSlash = path & slash
	Else
		addSlash = path
	End If
End Function

'============================================
' Formats numBytes into  b, KB, MB or GB
'============================================
Function formatBytes (numBytes)
	If (numBytes < 1024) Then
		formatBytes = numBytes & " b"
	ElseIf (numBytes < 1024*1024) Then
		formatBytes = FormatNumber(numBytes/1024,2) & " Kb"
	ElseIf (numBytes < 1024*1024*1024) Then
		formatBytes = FormatNumber(numBytes/(1024*1024),2) & " Mb"
	Else
		formatBytes = FormatNumber(numBytes/(1024*1024*1024),2) & " Gb"
	End If
End Function

'==================================================
' Converts the given virtual path to physical path
'==================================================
Function getPhysicalPath(strPath)
	Dim path
	path = replace(strPath,"/","\")
	If Left(path,1) = "\" Then
		on error resume next
		getPhysicalPath = addSlash(server.MapPath(path),"\")
		If err.Number<>0 Then getPhysicalPath = strPath
	Else
		If InStr(1,path, ":", 1) <> 0 Then
			getPhysicalPath = addSlash(path,"\")
		Else
			getPhysicalPath = strPath & "?"
		End If
	End If
End Function	

'============================================
' Converts a textfile to an array of strings
'============================================

Function fileToArray( fName )
  If fName = "" Then Exit Function
  On Error Resume Next
  Dim objFSO, objFile
  Set objFSO = CreateObject("Scripting.FileSystemObject")
  Set objFile = objFSO.OpenTextFile(fName, 1)  
  fileToArray = split(objFile.ReadAll, vbCrLf)
  objFile.close
  Set objFile = Nothing
  Set objFSO = Nothing
End Function

'============================================
' Converts contents of a textfile to a string
'============================================

Function fileToString( fName )
  If fName = "" Then Exit Function
  On Error Resume Next
  Dim objFSO, objFile
  Set objFSO = CreateObject("Scripting.FileSystemObject")
  Set objFile = objFSO.OpenTextFile(fName, 1)  
  fileToString = objFile.ReadAll
  objFile.close
  Set objFile = Nothing
  Set objFSO = Nothing
End Function

'========================
' Save the string to file
'========================
function stringToFile(byval str, strFilename)
  dim i
  Set FSO = server.CreateObject("Scripting.FileSystemObject")
  Set foSaveFile = FSO.CreateTextFile(strFilename, true)  
  foSaveFile.writeLine( str )
  foSaveFile.close
  set foSaveFile = nothing  
end function

'======================
' Detect browser type.
'======================
user_agent = request.servervariables("HTTP_USER_AGENT")
browserID = "IE"
isOpera = false
isMAC = false
If InStr( LCase(user_agent), "opera") <> 0 Then
  isOpera = true
  browserID = "OP"
ElseIf InStr( LCase(user_agent), "gecko") <> 0 Then
  browserID = "GE"
ElseIf InStr( LCase(user_agent), "msie") <> 0 Then  
  browserID = "IE"
Else
  browserID = "NS"  
End If

If InStr( LCase(user_agent), " mac") <> 0 Then
  isMAC = true
End If 

'===========================================================
' Get the first valid FROM address from a list of addresses
'===========================================================
Function GetFromAddress( strEmail )
  arrayAddresses = split(MyAddresses, " ")
  For i=0 To ubound(arrayAddresses)
    If InStr(LCase(strEmail), LCase(arrayAddresses(i)) ) > 0 Then
      GetFromAddress = arrayAddresses(i)
      Exit Function
    End If
  Next
  GetFromAddress = ""
End function

Function DateToNumber( sDate )
  Dim sYear,sMonth,sDay,sTime,sHour,sMinute,sSecond
  sYear = Year(sDate)
  sMonth = Right("00" & Month(sDate), 2)
  sDay = Right("00" & Day(sDate), 2)
  sHour = Right("00" & Hour(sDate), 2)
  sMinute = Right("00" & Minute(sDate), 2)
  sSecond = Right("00" & Second(sDate), 2)
  DateToNumber = sYear & sMonth & sDay & sHour & sMinute & sSecond
End Function

Function GetDomainName( strEmail )
  GetDomainName = Right( strEmail, Len(strEmail) - Instr(strEmail, "@") )
End Function

Function GetRightSide( strWhole, strToken )
  GetRightSide = Right( strWhole, Len(strWhole) - Instr(strWhole, strToken) )
End Function

Function GetLeftSide( strWhole, strToken )
  GetLeftSide = Left( "" & strWhole, InStrRev("" & strWhole, strToken)-1 )
End Function

Function GetRootFolder
  Dim strTemp
  strTemp = Request.ServerVariables("PATH_INFO")
  strTemp = Replace(strTemp, "\", "/")
  GetRootFolder = Left( strTemp, InStrRev(strTemp, "/") )
End Function

Function stripTags( strTags )
    strTags = Replace(strTags, "<", "&lt;", vbTextCompare)
    strTags = Replace(strTags, ">", "&gt;", vbTextCompare)
    strTags = Replace(strTags, "<iframe", "", vbTextCompare)
    strTags = Replace(strTags, "/iframe>", "", vbTextCompare)
    stripTags = strTags
End Function

'====================================================================================
' Draw the buttons using image backgrounds so that the text can be modified easily.
' This useful to internationalise JMailbox. Each button has the text you want on it.
'====================================================================================
Sub drawGlyphButton( btnCaption, btnType, btnURL )
  Dim btnColor
  If btnType = "logout" Then
    btnColor = "red"
  Else
    btnColor = "blue"  
  End If
  
  If browserID = "NS" Then 
    showButtonBorder = 0
    showButtonGlyph = 0  
  End If  
  
  '======================================================
  ' MAC users don't want things looking like Windows ;-)
  '======================================================
  If isMAC Then
    showButtonBorder = 0
  End If  
  
  If showButtonBorder = 1 Then
    Response.Write "<td align=left background=""btn_" & btnColor & "left.gif"">" & vbCrLf
  Else  
    Response.Write "<td align=left>" & vbCrLf
  End If
  If showButtonBorder = 1 Then  
    Response.Write "<A class=buttonLink href=""" & btnURL & """ onfocus=""if (document.all) this.blur()"">" 
  Else
    Response.Write "<A class=textLink href=""" & btnURL & """ onfocus=""if (document.all) this.blur()"">" 
  End If
  If showButtonGlyph = 1 Then
    If showButtonBorder <> 1 AND btnType = "logout" Then
      Response.Write "<img align=absmiddle border=0 src=""btn_logout_red.gif"" alt=""" & btnCaption & """>" & vbCrLf
    Else 
      Response.Write "<img align=absmiddle border=0 src=""btn_" & btnType & ".gif"" alt=""" & btnCaption & """>" & vbCrLf
    End If
  Else  
    Response.Write "&nbsp;&nbsp;" & vbCrLf  
  End If
  Response.Write btnCaption  & "</A>" & vbCrLf
  If showButtonBorder = 1 Then
    Response.Write "<img align=absmiddle border=0 src=""btn_" & btnColor & "end.gif"" alt=""" & btnCaption & """>" & vbCrLf
  Else
    If btnType = "logout" Then
      Response.Write "&nbsp;" & vbCrLf 
    Else  
      Response.Write "&nbsp;|" & vbCrLf 
    End If  
  End If   
  Response.Write "</TD>" & vbCrLf

End Sub

'==========================================================
' Write any browser specific stylesheet properties here
' The browser types are: IE, NS, GE (Gecko) and OP (Opera)
'==========================================================
Sub writeExtraStyles
  Comment "browserID: " & browserID
  If browserID = "GE" Then
    Response.Write "<STYLE> .buttonLink { vertical-align: middle; } </STYLE>" & vbCrLf
  End If
End Sub

'==========================
' Array handling functions
'==========================

'=========================
' Chech if array has dups
'=========================
function arrayHasDups(byref theArray)
	dim d, item, ber
	ber = false
	set d = createobject("scripting.dictionary")
	on error resume next
	for each item in theArray
		d.add item, ""
		if err then 
			ber = true
			exit for
		end if
	next
	on error goto 0
	d.removeall
	set d = nothing
	arrayHasDups = ber
end function

'========================
' Remove duplicate items
'========================
function arrayRemDups(byref theArray)
	dim d, item, ber, arrayOut()
	dim i, a
	i = 0
	redim arrayOut(ubound(theArray))
	ber = false
	set d = createobject("scripting.dictionary")
	on error resume next
	for each item in theArray
		d.add item, ""
	next
	on error goto 0
	a = d.keys
	d.removeall
	set d = nothing
	arrayRemDups = a
	theArray = a
end function

'==================
' Reverse an array
'==================
function arrayReverse(byref arrayinput)
	dim i, ubnd
	dim arrayOut()
	ubnd = ubound( arrayinput )
	redim arrayOut(ubnd)
	for i = 0 to ubound( arrayinput )
		arrayOut( ubnd - i ) = arrayinput( i )
	next
	arrayReverse = arrayOut
	arrayinput = arrayOut
end function

'=======================================
' Two functions to order an inbox array
'=======================================
Function GetInboxItemID( strInboxItem )
  Dim returnVal
  If strInboxItem <> "" AND  InStr("" & strInboxItem, cacheTOKEN) <> 0 Then
    returnVal = Left( "" & strInboxItem, InStr("" & strInboxItem, cacheTOKEN) - 1 )
  Else
    returnVal = ""  
  End If
  GetInboxItemID = Replace( returnVal, "#", "" )  
End Function

function inboxOrder(byref unsortedInbox)
	dim front, back, loc, temp, inboxSize, strIDFront, strFront, strIDBack, strBack
	inboxSize = ubound(unsortedInbox)
	for front = 0 to inboxSize - 1
		loc = front
		for back = front to inboxSize
		  strFront = "" &  unsortedInbox(loc) 
		  strBack = "" & unsortedInbox(back)
		  strIDFront = GetInboxItemID( strFront )
		  strIDBack = GetInboxItemID( strBack )
		  If strIDFront <> "" AND strIDBack <> "" Then
		    If CDbl(strIDFront) < CDbl(strIDBack) Then
		      loc = back
		    End If  
		  End iF  
		next
		temp = unsortedInbox(loc)
		unsortedInbox(loc) = unsortedInbox(front)
		unsortedInbox(front) = temp
	next
	inboxOrder = unsortedInbox
end function

'===============
' Sort an array
'===============
function arraySort(byref unsortedarray)
	dim front, back, loc, temp, arrsize
	arrsize = ubound(unsortedarray)
	for front = 0 to arrsize - 1
		loc = front
			for back = front to arrsize
				if unsortedarray(loc) > _
				    unsortedarray(back) then
					loc = back
				end if
			next
			temp = unsortedarray(loc)
			unsortedarray(loc) = unsortedarray(front)
			unsortedarray(front) = temp
		next
	arraySort = unsortedarray
end function

'========================
' Save the array to file
'========================
function arraySave(byval arr, arrayFilename)
  dim i
  Set FSO = server.CreateObject("Scripting.FileSystemObject")
  Set foSaveFile = FSO.CreateTextFile(arrayFilename, true)  
  for i = 0 to ubound(arr)
    if arr(i) <> "" Then
      foSaveFile.writeLine( arr(i) )
    End If  
  next
  foSaveFile.close
  set foSaveFile = nothing  
end function

'========================
' For debugging use only
'========================
function arrayShow(byval arr)
	dim i
	for i = 0 to ubound(arr)
		response.write arr(i) & "<BR>"
	next
	response.write "<BR>"
end function
%>


