<%
'''TODO for you! Configuration:
sql="select stats_folder from siteoptions"
set rs=cn.execute(sql)

Function GetStatDir()
	 GetStatDir = rs("Stats_Folder")
			'Change this to your data directory path.
			'The most ideal spot for this would be under your
			'statMentor directory as I have shown in the example above.
		
	   '--GetStatDir = Server.MapPath("data/")
			'I forgot that when an ASP page includes this file, it will actually
			'try to map the path from its own location, instead of incstats.asp's location.
			'To fix the problem, just change GetStatDir to a full directory, like my
			'example above. This should fix the problem. (-;
	
	If Right(GetStatDir,1) <> "/" Or Right(GetStatDir,1) <> "\" Then
		GetStatDir = GetStatDir & "\"
	End If
End Function


''''  Modifications:
'''''''''''*	Date: 3.20.2000 Monday		
'''''''''''	Name: Austin Barnes 		
'''''''''''	Email: austinlb@home.com
'''''''''''	Site: ChatOn.com (Under Development) - temp. "http://chaton.webhostme.com"
'''''''''''	Modification Type: Annoyance Fix
'''''''''''	Description: Sets the "Select Period" information to the first 
'''''''''''	  recorded date and the present date by default
'''''''''''	Side Effects: None
'''''''''''	Functions Created: GetFirstRecordedDate()
'''''''''''	Comments: This function is called from the selectperiod.asp page
'''''''''''	  to set the first date default to the first recorded date, and
'''''''''''	  from defualt.asp to set the first date selection to the first
'''''''''''	  recorded date initially
'''''''''''*	Date: 4.19.2000 Wednesday
'''''''''''	Name: Austin Barnes 		
'''''''''''	Email: austinlb@home.com
'''''''''''	Site: ChatOn.com (Under Development)  - temp. "http://chaton.webhostme.com"
'''''''''''	Modification Type: Bug Fix
'''''''''''	Description: Removed the Server.MapPath("/data") reference of GetStatDir, 
'''''''''''	  which was causing ASP pages in any other directory than the
'''''''''''	  statMentor directory to throw an error about an object not being able
'''''''''''	  to be created
'''''''''''	Side Effects: You must now put in your data directory manually
'''''''''''	Comments: This was a mistake on my part in my original modification
'''''''''''	 of the StatMentor code and I am completely responsible. Please
'''''''''''	 update your installation as soon as possible to fix this problem

''Some constants for file handling
'Const File_OpenForReading = 1, File_OpenForWriting = 2, File_OpenForAppending = 8

Function GetFirstRecordedDate()
Dim allDates, tempKey, tempYear, tempMonth, tempDay, tempCurrentDate, tempLowDate
tempLowDate = ""
Set allDates = GetExistingDates()
	tempLowDate =  DateAdd( "d", -1, Now() )
	For Each tempKey In allDates.Keys 
	tempYear = Left(tempKey, 4)		'gets the number of the year
	tempMonth = Mid(tempKey, 5, 2)		'gets the number of the month
	tempDay = Right(tempKey, 2)		'gets the number of the day
	tempCurrentDate = cDate(tempMonth & "/" & tempDay & "/" & tempYear) 
						'creates a formated date
						' based on the name of the file
		If tempLowDate = "" Then
			tempLowDate = tempCurrentDate
			Else
				If tempLowDate > tempCurrentDate Then
				tempLowDate = tempCurrentDate
				End If
		End If
	Next
GetFirstRecordedDate = tempLowDate
End Function

Function GetExistingDates()
On error resume next 

	'Walk through all files
	Dim nCount
    Dim fs, f, f1, fc, s
	
	nCount = 0
	Set oRet = Server.CreateObject("Scripting.Dictionary")
	
    Set fs = CreateObject("Scripting.FileSystemObject")
    Set f = fs.GetFolder(GetStatDir())
    Set fc = f.Files
    For Each f1 in fc
    	If Left( f1.name,7) = "PVPAGE_" Then
    		nCount = nCount + 1
    		oRet.Add Mid( f1.name, 8, 8 ), ""
    	End If
    Next	
    Set GetExistingDates = oRet
End Function

Function DeleteFilesFromDate( sDate )
	'
	' Now we should delete all files from that date
    Dim fs 
    Set fs = CreateObject("Scripting.FileSystemObject")
    On Error Resume Next
    fs.DeleteFile GetStatDir() & "PVPAGE_" & sDate & ".log"
    fs.DeleteFile GetStatDir() & "PVSUM_" & sDate & ".log"
    fs.DeleteFile GetStatDir() & "REF_" & sDate & ".log"
    fs.DeleteFile GetStatDir() & "VI_" & sDate & ".log"
	
End Function


Function GetFormattedDate( dDate )
	Dim sMonth, sDay
	sMonth = DatePart( "m", dDate)
	If Len(sMonth) = 1 Then
		sMonth = "0" & sMonth
	End If
	sDay = DatePart( "d", dDate)
	If Len(sDay) = 1 Then
		sDay = "0" & sDay
	End If
	GetFormattedDate = DatePart( "yyyy", dDate ) & sMonth & sDay
End Function

Sub LogVisit()
On error resume next
	
	'1. What should the file be called
	Dim sFileName, oFile, nCount
	
	sFileName = GetStatDir() & "VI_" & GetFormattedDate( Now() ) & ".log" 
	Set oFile = File_OpenExistingOrCreate( sFileName, 1 )
	If oFile.AtEndOfStream = True Then
		nCount = 0		
	Else
		nCount = oFile.ReadLine()
	End If
	oFile.Close
	nCount = nCount + 1	
	Set oFile = File_OpenExistingOrCreate( sFileName, 2 )
	oFile.WriteLine nCount
	oFile.Close
'	Response.Write sFileName

	
End Sub

Sub LogPageView()
On error resume next

	'1. What should the file be called
	Dim sFileName, oFile, nCount
	
	sFileName = GetStatDir() & "PVSUM_" & GetFormattedDate( Now() ) & ".log" 
	Set oFile = File_OpenExistingOrCreate( sFileName, 1 )
	If oFile.AtEndOfStream = True Then
		nCount = 0		
	Else
		nCount = oFile.ReadLine()
	End If
	oFile.Close
	nCount = nCount + 1	
	Set oFile = File_OpenExistingOrCreate( sFileName, 2 )
	oFile.WriteLine nCount
	oFile.Close
	' Now one for each pageview...
	sFileName = GetStatDir() & "PVPAGE_" & GetFormattedDate( Now() ) & ".log" 
	Set oFile = File_OpenExistingOrCreate( sFileName, 8 )
	oFile.WriteLine Request.ServerVariables("SCRIPT_NAME")
	oFile.Close
	
End Sub

Sub LogExternalReferer()
On error resume next

	Dim sFileName, oFile
	
	sFileName = GetStatDir() & "REF_" & GetFormattedDate( Now() ) & ".log" 
	Set oFile = File_OpenExistingOrCreate( sFileName, 8 )
	oFile.WriteLine Request.ServerVariables("HTTP_REFERER")
	oFile.Close
End Sub


Sub StatLog()
'1. Find out if 
' Where are we coming from?
Dim sReferer, sHost

sHost = lcase("http://" & Request.ServerVariables("SERVER_NAME"))
sReferer = lcase(Request.ServerVariables("HTTP_REFERER"))
If sReferer = "" Then
	LogVisit
Else
	If Left( sReferer,  Len(sHost) ) <> sHost   Then
		LogVisit
		If sReferer <> "" Then
			LogExternalReferer
		End If
	Else
	End If
End If
LogPageView
End  Sub


Function File_OpenExistingOrCreate( strPath, nAccess )
	' strPath = the path to file
	' nAccess should be one of the constants above
	On Error Resume Next
	
	Dim objFileObj
	Dim objFile
	
	Set objFileObj = Server.CreateObject("Scripting.FileSystemObject")
	Set objFile = objFileObj.OpenTextFile( strPath, nAccess, True, False )
	If Err = 0 Then
		Set File_OpenExistingOrCreate = objFile
	Else
		Set File_OpenExistingOrCreate = Nothing
	End If
End Function




Function GetVisitorsCount( dDate1, dDate2 )
	If dDate1 = "" Then
		dDate1 = "1900-01-01"
	End If
	If dDate2 = "" Then
		dDate2 = "2020-01-01"
	End If
	Dim sName1, sName2
	sName1 = "VI_" & GetFormattedDate( dDate1 ) & ".log"
	sName2 = "VI_" & GetFormattedDate( dDate2 ) & ".log"
	
	'Walk through all files
    Dim fs, f, f1, fc, s, nCount
    Set fs = CreateObject("Scripting.FileSystemObject")
    Set f = fs.GetFolder(GetStatDir())
    Set fc = f.Files
	nCount = 0
	GetVisitorsCount = 0
    For Each f1 in fc
    	If Left( f1.name,3) = "VI_" Then
    		If f1.name >= sName1 AND f1.name <= sName2 Then
    			'Loop through it
			nCount = CInt(GetCount( f1.name ))
    			GetVisitorsCount = GetVisitorsCount + nCount
    		End If
    	End If
    Next	
End Function

Sub AddPageViews( sFileName, ByRef oDictionary )
	Dim oFile, sText
	Set oFile = File_OpenExistingOrCreate( GetStatDir() & sFileName , 1 )
	While Not oFile.AtEndOfStream
		sText = oFile.ReadLine()
		If sText <> "" Then
			If oDictionary.Exists( sText )	Then
				oDictionary.Item( sText )	= oDictionary.Item( sText ) + 1
			Else
				oDictionary.Add sText, 1 
			End If
		End If
	Wend
End Sub

Function GetPageViewCount2( dDate1, dDate2 )
	Dim oRet
	
	Set oRet = Server.CreateObject("Scripting.Dictionary")
	
	If dDate1 = "" Then
		dDate1 = "1900-01-01"
	End If
	If dDate2 = "" Then
		dDate2 = "2020-01-01"
	End If
	Dim sName1, sName2
	sName1 = "PVPAGE_" & GetFormattedDate( dDate1 )  & ".log"
	sName2 = "PVPAGE_" & GetFormattedDate( dDate2 )  & ".log"
	
	
	'Walk through all files
    Dim fs, f, f1, fc, s
    Set fs = CreateObject("Scripting.FileSystemObject")
    Set f = fs.GetFolder(GetStatDir())
    Set fc = f.Files
    For Each f1 in fc
    	If Left( f1.name,7) = "PVPAGE_" Then
    		If f1.name >= sName1 AND f1.name <= sName2 Then
    			AddPageViews f1.name, oRet 
    		End If
    	End If
    Next	
    Set GetPageViewCount2 = oRet
End Function



Function GetRefererCount( dDate1, dDate2 )
	Dim oRet
	
	Set oRet = Server.CreateObject("Scripting.Dictionary")
	
	If dDate1 = "" Then
		dDate1 = "1900-01-01"
	End If
	If dDate2 = "" Then
		dDate2 = "2020-01-01"
	End If
	Dim sName1, sName2
	sName1 = "REF_" & GetFormattedDate( dDate1 )  & ".log"
	sName2 = "REF_" & GetFormattedDate( dDate2 )  & ".log"
	
	
	'Walk through all files
    Dim fs, f, f1, fc, s
    Set fs = CreateObject("Scripting.FileSystemObject")
    Set f = fs.GetFolder(GetStatDir())
    Set fc = f.Files
    For Each f1 in fc
    	If Left( f1.name,4) = "REF_" Then
    		If f1.name >= sName1 AND f1.name <= sName2 Then
    			AddPageViews  f1.name, oRet 
    		End If
    	End If
    Next	
    Set GetRefererCount = oRet
End Function




Function GetCount( sFile )
	Dim sFileName, oFile, nCount, sText
	
	sFileName = GetStatDir() & sFile 
	Set oFile = File_OpenExistingOrCreate( sFileName, 1 )
	If oFile.AtEndOfStream Then
		nCount = 0
	Else
		nCount = oFile.ReadLine()
	End If
	oFile.Close
	GetCount = nCount
End Function


''''Date routines
Function Date_GetYear( dDate )
	Date_GetYear = DatePart( "yyyy", dDate )
End Function

Function Date_GetMonthNo( dDate )
	Date_GetMonthNo = DatePart( "m", dDate )
End Function

Function Date_GetDayNo( dDate )
	Date_GetDayNo = DatePart( "d", dDate )
End Function

Function Date_GetMonthName( nMonthNo )
	Select Case nMonthNo
		Case 1
			Date_GetMonthName = "Jan"			
		Case 2
			Date_GetMonthName = "Feb"			
		Case 3
			Date_GetMonthName = "Mar"			
		Case 4
			Date_GetMonthName = "Apr"			
		Case 5
			Date_GetMonthName = "May"			
		Case 6
			Date_GetMonthName = "Jun"			
		Case 7
			Date_GetMonthName = "Jul"			
		Case 8
			Date_GetMonthName = "Aug"			
		Case 9
			Date_GetMonthName = "Sep"			
		Case 10
			Date_GetMonthName = "Oct"			
		Case 11
			Date_GetMonthName = "Nov"			
		Case 12
			Date_GetMonthName = "Dec"			
	End Select
End Function



Sub Date_FillBoxWithYears( nFirst, nLast, nDefault )
	Dim nYear
	If nDefault = "" Then
		nDefault = Date_GetYear( Now() ) 
	End If	
	For nYear = nFirst To nLast
		Response.Write "<option" 
		If nYear = nDefault Then
			Response.Write " selected=yes"
		End If
		Response.Write ">" & nYear  & "</option>"
	Next
End Sub

Sub Date_FillBoxWithDays( nDefault )
	Dim nDay
	If nDefault = "" Then
		nDefault = Date_GetDayNo( Now() )
	End If
	For nDay = 1 To 31
		Response.Write "<option" 
		If nDay = nDefault Then
			Response.Write " selected=yes"
		End If
		Response.Write ">" & nDay & "</option>"
	Next
End Sub


Sub Date_FillBoxWithMonths( nDefault, fUseNumbersAsValue )
	Dim nMonth
	If nDefault = "" Then
		nDefault = Date_GetMonthNo( Now() ) 
	End If	
	For nMonth = 1 To 12
		Response.Write "<option" 
		If nMonth = nDefault Then
			Response.Write " selected=yes"
		End If
		If fUseNumbersAsValue = True Then
			Response.Write " value=" & nMonth  
		End If
		Response.Write ">" & Date_GetMonthName(nMonth)  & "</option>"
	Next
End Sub

Function DomainFromReq( sText )
	'
	Dim nIndex
	If LCase(Left( sText, 7 )) = "http://" Then
		sText = Mid( sText, 	8 )
	End If
	If LCase(Left( sText, 8 )) = "https://" Then
		sText = Mid( sText, 	9 )
	End If
	nIndex = InStr( sText, "/")
	If nIndex > 0 Then
		sText = Left( sText, nIndex - 1 )	
	End If
	DomainFromReq = sText
End Function


Function DomainRefFromPageRef( oDict )
	Dim oRet, oKey, sPage, sDomain
	Set oRet = Server.CreateObject("Scripting.Dictionary")
	'Now get the domain name from all
	For Each oKey In oDict.Keys
		sPage = oKey
		If LCase(Left( oKey, 7 )) <> "http://" And LCase(Left( oKey, 8 )) <> "http://s" Then
			sDomain = "Unknown"
		Else
			sDomain = DomainFromReq( sPage )
		End If
		If oRet.Exists( sDomain )	Then
			oRet.Item( sDomain )	= oRet.Item( sDomain ) + oDict.Item(oKey) 
		Else
			oRet.Add sDomain, oDict.Item(oKey) 
		End If
	Next	
	Set DomainRefFromPageRef = oRet
End Function

%>