
<%

set objFS = server.CreateObject("Scripting.FileSystemObject")

sub ShowDriveList

	dim d

   	set objDrives = objFS.Drives
	for each d in objDrives
		if d.DriveType = 3 then
			n = d.ShareName
		elseif d.IsReady then
			n = d.VolumeName
			dl = d.DriveLetter & ":\"
			response.write "<a href='" & request.ServerVariables("SCRIPT_NAME") & "?list_folder=" & dl & "'>" & dl & "</a><br>"
		end If
	next
	set objDrives = NOTHING

end sub

sub ShowPath(folderspec)

	if inStr(folderspec,"\") = 0 then folderspec = server.mappath(folderspec)
	aDirs = split(folderspec,"\")
	
	for i = 0 to (uBound(aDirs))
		if i > 0 then
			response.write "\"
			parentDir = parentDir & "\"
		end if
		parentDir = parentDir & "" & aDirs(i) & ""
		%>
		<a href="<% =request.ServerVariables("SCRIPT_NAME") %>?list_folder=<% =server.URLEncode(parentDir) %>"><% =trim(aDirs(i)) %></a>
		<%
	next

end sub
	
sub ShowFolderList(folderspec)

    dim f, fc, fPath, fName
	
	if inStr(folderspec,"\") = 0 then folderspec = server.mappath(folderspec)
		
	on error resume next
	set f = objFS.GetFolder(folderspec)
		if err.number <> 0 then
			error_list.add "patherror" ,"The path does not exist or you do not have access."
			b_error = true
			exit sub
		end if
	on error goto 0
	set fc = f.SubFolders
	if fc.Count > 0 then
		for each fl in fc
		fName = fl.Name
		Link = folderspec & "\" & fName & ""
		%>
		/<a href="<% =request.ServerVariables("SCRIPT_NAME") %>?ret_field=<% =request("ret_field") %>&ret_form=<% =request("ret_form") %>&list_folder=<% =Link %>"><% =fName %></a><br>
		<%
		next
	end if 
	set f = NOTHING
	set fc = NOTHING

end sub
	
sub ShowFileList(folderspec)
    
	dim f, f1, fc
	
	if inStr(folderspec,"\") = 0 then folderspec = server.mappath(folderspec)

	set f = objFS.GetFolder(folderspec)
	set fc = f.Files
	
		%>
		<table border="0" cellpadding="1" cellspacing="1" width="100%" bgcolor="#000000">
		<tr bgcolor="#ffffff">
			<td> </td>
			<td><b>name</b></td>
			<td><b>size</b></td>
			<td><b>last modified</b></td>
		</tr>
    	<%
		
		for each fl in fc
			
		sSize = fl.Size
		sDate = fl.DateLastModified
		sName = fl.Name
		sType = fl.Type
		'sLink = replace(lcase(folderspec),lcase(server.mappath("/")),"") & "\" & sName

		%>
		<tr bgcolor="#ffffff">
			<td><input type="checkbox" name="f_name" value="<% =folderspec & "\" & sName %>"></td>
			<td><font size=1><% =left(sName,30) %>..</font></td>
			<td><font size=1><% =sSize %></font></td>
			<td><font size=1><% =sDate %></font></td>
		</tr>
		
		<% next %>
		
		</table>
		<%
		
	set f = NOTHING
	set fc = NOTHING

end sub

sub CopyFolder(source, destination)

	objFS.CopyFolder source, destination, true

	''' must write to files to show change for refresh in browser
	set f = objFS.GetFolder(destination)
	set fc = f.Files
	for each fl in fc
		Set Out = fl.OpenAsTextStream (8, -1)
		Out.Write ""
		Out.Close
	next
	
end sub

sub CreateFolder(filespec)

	objFS.CreateFolder(filespec)

end sub

sub DeleteFolder(filespec)

	if objFS.FolderExists(filespec) then objFS.DeleteFolder(filespec)

end sub

sub DeleteFile(filespec)

	objFS.DeleteFile(filespec)

end sub

%>