<% @Language = "VBScript" %>
<%'============================================================
' APP:            LogLog
' AUTHOR:      www.u229.no
' CREATED:    June 2005
' VERSION:     1.5
'============================================================
' COMMENT: This app will save data about the visitors to a text file on the web server.
'============================================================
' ROUTINES:

' Sub SaveVisitorData(sFullPath, sData)
' Function FriendlyDate
' Function MakePath(sFullPath)
'============================================================
' HOW TO USE THIS CODE: See ReadMe.html
'============================================================
Option Explicit

Const ForAppending = 8
Const TristateUseDefault = -2

Dim m_sDomain
Dim m_sFriendlyDate

Call Main


'------------------------------------------------------------------------------------------------------------
' Comment: Build the data string to be logged.
'------------------------------------------------------------------------------------------------------------
Sub Main()
    On Error Resume Next

	Dim d, sData, sFullPath

	d = Chr(94)                                                      '// ^

'// LOG THE INFORMATION YOU NEED:
    Dim sUri, sDate, sTime, sBN, sB, bSW, sFlash, bQT, bRP, bWMP, sJs
	Dim bCookies, sScrW, sScrH, sCD, sPF, sOS, sBLang, sSLang, sRef, sIP

	m_sDomain = Request.QueryString("a")                 '// Domain: Should not contain illegal characters because it is used in the log file name.
	sUri = Request.QueryString("b")                             '// Page visited
	sDate = FriendlyDate                                             '// FriendlyDate returns: YYYYMMDD (20030920)
	sTime = CStr(FormatDateTime(Time, 4))                 '// Ex: 8:00
	sBN = Request.QueryString("c")                              '// Browser Name
	sB = Request.QueryString("d")                                '// Browser
	bSW = CStr(CBool(Request.QueryString("e")))         '// ShockWave supported?
	sFlash = Request.QueryString("f")                           '// Flash version. Empty if no Flash is supported.
	bQT = CStr(CBool(Request.QueryString("g")))          '// QuickTime supported?
	bRP = CStr(CBool(Request.QueryString("h")))          '// Real Player supported?
	bWMP = CStr(CBool(Request.QueryString("i")))        '// Windows Media Player supported?
	sJs = Request.QueryString("j")                                '// Javascript Version.
	bCookies = CStr(CBool(Request.QueryString("k")))  '// Cookies enabled?
	sScrW = Request.QueryString("l")                            '// Screen.width
	sScrH = Request.QueryString("m")                           '// Screen.height
	sCD = Request.QueryString("n")                             '// Screen.ColorDepth
	sPF = Request.QueryString("o")                              '// Platform (Win32, Mac)
	sOS = Request.QueryString("p")                             '// Operative System
	sBLang = Request.ServerVariables("HTTP_ACCEPT_LANGUAGE")    '// Language defined in the Browser. Ex: no
	sSLang = Request.QueryString("r")                         '// System Language in OS. Ex: en-us
	sRef = Request.QueryString("s")                             '// Referrer. If user clicked a link: The URI the user came from, otherwise empty.
	sIP = Request.ServerVariables("REMOTE_ADDR")     '// Visitor's ip number
	
'// BUILD THE STRING YOU ARE LOGGING:
    sData = (m_sDomain & d &  sUri & d & sDate & d & sTime & d & sBN & d & sB & d & bSW & d & sFlash & d & bQT & d & bRP & d & _
				  bWMP & d & sJs & d & bCookies & d & sScrW & d & sScrH & d & sCD & d & sPF & d & sOS & d & sBLang & d & sSLang & d & _
				  sRef & d & sIP & vbCrLf)

	sFullPath = Server.MapPath(Request.ServerVariables("SCRIPT_NAME"))
	sFullPath = MakePath(sFullPath)                                                                          '// MakePath returns path to log file

	Call SaveVisitorData(sFullPath, sData)                                                                 '// Save the data we have collected to text file

	Response.ContentType = "image/GIF"
	Response.Redirect "log.gif"

End Sub


'------------------------------------------------------------------------------------------------------------
' Comment: Write the data to a text file on the web server.
'                 The file name will change dynamically every month.
'------------------------------------------------------------------------------------------------------------
Sub SaveVisitorData(sFullPath, sData)
    On Error Resume Next

	Dim oFSO, oFile

    Set oFSO = Server.CreateObject("Scripting.FileSystemObject")
    Set oFile = oFSO.OpenTextFile(sFullPath, ForAppending, True, TristateUseDefault)

    oFile.Write sData

	Set oFile = Nothing
    Set oFSO = Nothing

End Sub


'------------------------------------------------------------------------------------------------------------
' Comment: Returns a friendly date in the format: YYYYMMDD.
'------------------------------------------------------------------------------------------------------------
Function FriendlyDate()
    On Error Resume Next

	Dim sMonth, sDay

    sMonth = CStr(Month(Date))
	sDay = CStr(Day(Date))

    If Len(sMonth) = 1 Then sMonth = ("0" & sMonth)    
	If Len(sDay) = 1 Then sDay = ("0" & sDay)

	m_sFriendlyDate = (CStr(Year(Date)) & "_" & sMonth)                                   '// Creates new log file every month: 2003_11. 
	'm_sFriendlyDate = (Year(Date) & "_week_" & DatePart("ww", Date))     '// Creates new log file every week: 2003_week_48. 
	'm_sFriendlyDate = (Year(Date) & "_" & sMonth & "_" & sDay)               '// Creates new log file every day: 2003_11_29.

	FriendlyDate = (CStr(Year(Date)) & sMonth & sDay)

End Function

'------------------------------------------------------------------------------------------------------------
' Comment: Return the full physical path to the log file.
'------------------------------------------------------------------------------------------------------------
Function MakePath(sFullPath)
    On Error Resume Next

    MakePath = Mid(sFullPath, 1, InStrRev(sFullPath, "\", -1)) & (m_sDomain & "_" & m_sFriendlyDate & ".log")

End Function

%>