<%
'#################################################################################
'## IIS Admin Control Panel v 1.0
'#################################################################################
'## Copyright (C) 2005 Jake Gardner, Chris Hood
'##  from now on, referred to as "we" or "us"
'##
'##   This is a legally binding agreement between you and us, the developers
'## of the software program ("IIS Admin Control Panel") which you are about to
'## accept through electronic distribution (downloading).  By downloading and
'## using this software you are agreeing and will have agreed to be bound by
'## the terms set forth below.
'##
'##   License Grant and Restrictions. We grant you and you accept a
'## non-exclusive license to use the IIS Admin Control Panel but you do not
'## acquire any rights of ownership or distribution in whole or part. We are
'## the exclusive owners of the IIS Admin Control Panel which is copyrighted.
'## This license permits you to use and modify the IIS Admin Control Panel for
'## your personal or company. You may not rent, lease, sub-license, assign,
'## loan, create a derivative work based on content or otherwise use or
'## transfer use of the Software or any part thereof to others. You may not
'## reverse engineer, reverse compile, disassemble or otherwise modify the
'## Software in any way.  You may not remove any proprietary notices that are
'## provided with or within the software and/or sourcecode.  Neither the
'## Software nor any underlying information or technology may be exported or
'## re-exported into any country to which the United States has prohibited
'## export.
'##
'##   No Warranties. You acknowledge that the software has been provided to you
'## free of charge for your personal use and evaluation. You assume
'## responsibility for the selection of the software to achieve your intended
'## results and for the proper installation, use and results obtained from use
'## of the IIS Admin Control Panel. WE MAKE NO REPRESENTATION OR WARRANTY OF
'## ANY KIND WITH RESPECT TO THE SOFTWARE OR THE RESULTS OBTAINED OR TO BE
'## OBTAINED FROM ITS USE. WE DO NOT WARRANT THAT YOUR USE OF THE SOFTWARE WILL
'## BE UNINTERRUPTED, ERROR-FREE OR VIRUS-FREE.  ALL WARRANTIES, EXPRESS OR
'## IMPLIED, INCLUDING THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
'## PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE HEREBY EXPRESSLY DISCLAIMED.
'## WE EXPRESSLY DISCLAIM ANY IMPLIED WARRANTY THAT ANY OTHER PRODUCT
'## (INCLUDING WITHOUT LIMITATION ANY COPY OF THE SOFTWARE YOU MAY SUBSEQUENTLY
'## PURCHASE) WILL CONFORM TO THE SOFTWARE PROVIDED TO YOU UNDER THIS
'## AGREEMENT.
'##
'##   IN NO EVENT SHALL WE OR THEIR SUPPLIERS OR DISTRIBUTOR(S) OR AGENTS BE
'## LIABLE FOR ANY DAMAGE ARISING OUT OF OR RELATED TO THE USE OF THIS PRODUCT,
'## INCLUDING WITHOUT LIMITATION ACTUAL, DIRECT, SPECIAL, CONSEQUENTIAL,
'## INDIRECT, EXEMPLARY OR PUNITIVE DAMAGES, WHETHER OR NOT SUCH DAMAGES WERE
'## FORESEEABLE AND EVEN IF WE WERE ADVISED THAT SUCH DAMAGES WERE LIKELY OR
'## POSSIBLE.
'##
'## Support can be obtained from our support forums at:
'## http://www.iisactive.com
'##
'## Correspondence and Marketing Questions can be sent to:
'## iacp@iisactive.com
'##
'#################################################################################
%>

<!-- #INCLUDE FILE="common\Functions.inc" -->
<!-- #INCLUDE FILE="common\Functions_Logging.inc" -->
<!-- #INCLUDE FILE="common\IPFuncs.inc" -->
<%
If Len(request("return")) Then
  If Request("site") = 0 Then
    Response.Redirect ("manage_W3SVC_master.asp")
  Else
    Response.Redirect ("manage_W3SVC.asp?site=" & Request("site"))
  End If
End If

If Len(Request("ap")) Then Call AppProc()
If LCase(Request("action")) = "do_delete" Then Call Do_Delete() 'Bypass head.inc file

message = ""
If Len(Request("tc")) Then
  Select Case Request("tc")
	Case "1"
	  message = "<TR><TH colspan=""2""><font color=""#99FFFF"">Task Completed</font></TH></TR>"
	Case "0"
	  message = "<TR><TH colspan=""2""><font color=""#FF3300"">Task Not Completed</font></TH></TR>"
  End Select
End If

%>
<!-- #INCLUDE FILE="common\head.inc" -->
<DIV id="maincontent">
<%

errs = ""

Select Case LCase(Request("action"))
  Case "sitecomment"
    Call SiteComment(errs)
  Case "change_sitecomment"
    Call Change_SiteComment(errs)
    Call SiteComment(errs)
  Case "homedir"
    Call HomeDir()
  Case "change_homedir"
    Call ChangeHomeDir()
  Case "logpath"
    Call LogDir()
  Case "change_logdir"
    Call ChangeLogDir()
  Case "change_auth"
    Call Change_Auth()
  Case  "auth"
    Call Auth()
  Case "frontpage"
    Call FrontPage()
  Case "change_httpredir"
    Call Change_HTTPRedir(errs)
    Call HTTPRedir(errs)
  Case "httpredir"
    Call HTTPRedir(errs)
  Case "change_docfoot"
    Call Change_DocFoot(errs)
    Call DocFoot(errs)
  Case "docfoot"
    Call DocFoot(errs)
  Case "change_scriptmap"
    If Len(Request("edit")) Then
      If Request("CurSM").count > 1 Then
        errs = "<SPAN Class=""err"">Please select only one entry to edit at a time.</SPAN>"
        Call ScriptMap(errs)
      Else
        Call EditScriptMap(errs)
      End If
    End If
    If Len(Request("add")) Then
      Call AddScriptMap(errs)
      Call ScriptMap(errs)
    End If
    If Len(Request("rem")) Then
      Call RemoveScriptMap(errs)
      Call ScriptMap(errs)
    End If
  Case "update_scriptmap"
    If Len(Request("manscript")) Then
      Call ScriptMap(errs)
    Else
      Call UpdateScriptMap(errs)
      Call ScriptMap(errs)
    End If
  Case "scriptmap"
    Call ScriptMap(errs)
  Case "change_app_props"
    Call Change_AppProps(errs)
    Call AppProps(errs)
  Case "app_props"
    Call AppProps(errs)
  Case "change_app_props_master"
    Call Change_AppProps_master(errs)
    Call AppProps_Master(errs)
  Case "app_props_master"
    Call AppProps_Master(errs)
  Case "change_cgito"
    Call Change_CGITimeout(errs)
    Call CGITimeout(errs)
  Case "cgito"
    Call CGITimeout(errs)
  Case "change_conto"
    Call Change_ConnectionTimeout(errs)
    Call ConnectionTimeout(errs)
  Case "conto"
    Call ConnectionTimeout(errs)
  Case "change_ipdomrest"
    Call Change_IPDomRestrictions(errs)
    Call IPDomRestrictions(errs)
  Case "ipdomrest"
    Call IPDomRestrictions(errs)
  Case "change_defdoc"
    Call ChangeDefDoc(errs)
    Call DefDoc(errs)
  Case "defdoc"
    Call DefDoc(errs)
  Case "change_hosthead"
    Call ChangeHostHead(errs)
    Call HostHead(errs)
  Case "hosthead"
    Call HostHead(errs)
  Case "change_maxcon"
    If Len(Request.Form("MCS")) Then
      Call MaxConnections(errs)
    Else 'it must have been the Update button
      Call Change_MaxConnections(errs)
      Call MaxConnections(errs)
    End If
  Case "maxcon"
    Call MaxConnections(errs)
  Case "maxrea"
    Call MaxREA(errs)
  Case "change_logging"
    Call Change_Logging(errs)
    Call Logging(errs)
  Case "logging"
    Call Logging(errs)
  Case "delete"
    Call Show_Delete()
End Select


Sub DefDoc(errs)
  If Request("Site") = 0 Then
    Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/W3SVC")
    ServerComment = "Master WWW"
  Else
    Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site"))
    Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/root")
    ServerComment = objSite.ServerComment
  End If
  If InStr(objSiteRoot.DefaultDoc,",") Then
    DefDocArr = Split(objSiteRoot.DefaultDoc,",")
  Else
    Dim DefDocArr(0)
    DefDocArr(0) = objSiteRoot.DefaultDoc
  End If

  DefDocOut = "<SELECT MULTIPLE NAME=""defdoc"" size=""" & Ubound(DefDocArr)+1 & """>"
  For x = 0 to UBound(DefDocArr)
    DefDocOut = DefDocOut & "<OPTION Value=""" & DefDocArr(x) & """>" & DefDocArr(x) & "</OPTION>"
  Next
  DefDocOut = DefDocOut & "</SELECT>"
%>

<form name="theform" method="post" action="w3svc_site_config.asp?action=change_defdoc">

<TABLE width="75%">
  <Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TR><TH colspan=2>Manage Defalt Documents and Ordering for <%=ServerComment%></TH></TR>
  <TR><TD colspan="2">&nbsp;<%=errs%></TD></TR>
  <TR><TH>Current Default Documents</TH><TD>&nbsp;</TD></TR>
  <TR>
    <TD><%= DefDocOut%></TD>
    <TD>
      <input type="submit" name="moveup" value="Move Up">
      <br><br>
      <input type="submit" name="movedown" value="Move Down">
      <br><br>
      <input type="submit" name="remdefdoc" value="Remove">
    </TD>
  </TR>
  <TR><TH>Add a Document</TH><TD>&nbsp;</TD></TR>
  <TR>
    <TD><input type="text" name="NewDefDoc" id="GiveMeFocus" size="15"></TD>
    <TD>
      <input type="submit" name="adddefdoc" value="Add">
    </TD>
  </TR>

  <TR><TD colspan="2">&nbsp;</TD></TR>
  <TR><TD colspan="2"><input type="submit" name="return" value="Manage Site"></TD></TR>
</table>
</form>
<%
End Sub

Sub SiteComment(errs)
On Error Resume Next
  Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site"))
  ServerComment = objSite.ServerComment

%>
<form name="theform" method="post" action="w3svc_site_config.asp?action=change_sitecomment">
  <Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TABLE>
    <TR><TH>Manage <%=ServerComment%></TH></TR>
    <TR><TD>&nbsp;<%=errs%></TD></TR>
    <TR><TH>Current</TH></TR>
    <TD><%= objSite.ServerComment%></TD></TR>
    <TR><TD>&nbsp;</TD></TR>
    <TR><TH>New</TH></TR>
    <TD><input type="text" name="sitename" id="GiveMeFocus" value="<%=objSite.ServerComment%>" size="50"></TD></TR>
    <TR><TD>&nbsp;</TD></TR>
    <TR><TD><input type="submit" Value="Commit Modifications" >&nbsp;&nbsp;<input type="submit" name="return" value="Manage Site"></TD></TR>
  </TABLE>
</form>
<%
End Sub

Sub ConnectionTimeOut(errs)
On Error Resume Next
  If Request("site") = 0 Then
    Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC")
    ServerComment = "Master WWW"
  Else
    Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site"))
    ServerComment = objSite.ServerComment
  End If

%>
<form name="theform" method="post" action="w3svc_site_config.asp?action=change_conto">
  <Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TABLE>
    <TR><TH>Manage <%=ServerComment%> Connection Timeout</TH></TR>
    <TR><TD>&nbsp;<%=errs%></TD></TR>
    <TR><TH>Current</TH></TR>
    <TD><%= objSite.ConnectionTimeout%> seconds</TD></TR>
    <TR><TD>&nbsp;</TD></TR>
    <TR><TH>New</TH></TR>
    <TD><input type="text" name="conntime" id="GiveMeFocus" value="<%=objSite.connectiontimeout%>" size="5"></TD></TR>
    <TR><TD>&nbsp;</TD></TR>
    <TR><TD><input type="submit" Value="Commit Modifications" >&nbsp;&nbsp;<input type="submit" name="return" value="Manage Site"></TD></TR>
  </TABLE>
</form>
<%
End Sub

Sub CGITimeOut(errs)
On Error Resume Next
  If Request("site") = 0 Then
    Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC")
    ServerComment = "Master WWW"
  Else
    Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site"))
    ServerComment = objSite.ServerComment
  End If

%>
<form name="theform" method="post" action="w3svc_site_config.asp?action=change_cgito">
  <Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TABLE>
    <TR><TH>Manage <%=ServerComment%> CGI Timeout</TH></TR>
    <TR><TD>&nbsp;<%=errs%></TD></TR>
    <TR><TH>Current</TH></TR>
    <TD><%= objSite.CGITimeout%> seconds</TD></TR>
    <TR><TD>&nbsp;</TD></TR>
    <TR><TH>New</TH></TR>
    <TD><input type="text" name="cgitime" id="GiveMeFocus" value="<%=objSite.cgitimeout%>" size="5"></TD></TR>
    <TR><TD>&nbsp;</TD></TR>
    <TR><TD><input type="submit" Value="Commit Modifications" >&nbsp;&nbsp;<input type="submit" name="return" value="Manage Site"></TD></TR>
  </TABLE>
</form>
<%
End Sub

Sub HomeDir()
On Error Resume Next
  Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site"))
  Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/root")
ThePath = objSiteRoot.path
If err Then ThePath = "Empty or Invalid path, please enter a path"
err.clear

%>
<form name="theform" method="post" action="w3svc_site_config.asp?action=change_homedir">
  <Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TABLE width="75%">
    <TR><TH colspan=2>Manage <%=objSite.ServerComment%> Root File Directory</TH></TR>
    <TR><TH>Current</TH><TD><%= objSiteRoot.path%></TD></TR>
    <TR><TH>New</TH><TD><input type="text" name="newhd" id="GiveMeFocus" value="<%=objSiteRoot.path%>" size="75"></TD></TR>
    <TR><TH>&nbsp;</TH><TD>There is no need for a trailing slash.	If the physical path does not exist the site will not start.</TD></TR>
    <TR><TH>&nbsp;</TH><TD><input type="submit" Value="Commit Modifications" >&nbsp;&nbsp;<input type="submit" name="return" value="Manage Site"></TD></TR>
  </TABLE>
</form>
<%
End Sub

Sub HostHead(errs)
  Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site"))

  hhip = objSite.ServerBindings

  HHOut = "<SELECT MULTIPLE Name=""CurHH"" size=""" & Ubound(hhip) + 1 & """>"
  For x = 0 to Ubound(hhip)
	  HHOut = HHOut & "<option value=""" & hhip(x) & """>" & hhip(x) & "</option>"
  Next
  HHOut = HHOut & "</SELECT>"
  SelectedValue = ""
%>
<form name="theform" method="post" action="w3svc_site_config.asp?action=change_hosthead">
<Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TABLE width="75%">
    <TR><TH colspan=2>Manage Site's Host Headers and IP addresses</TH></TR>
    <TR><TD colspan="2">&nbsp;<%=errs%></TD></TR>
    <TR><TH>Current Entries</TH><TD>&nbsp;</TD></TR>
    <TR>
      <TD><%= HHOut%></TD>
      <TD>
        <input type="submit" name="rem" value="Remove">
      </TD>
    </TR>
    <TR><TH>Add an entry</TH><TD>&nbsp;</TD></TR>
    <TR>
      <TD><%= ReturnNextFreeIPAddress(SelectedValue) %>&nbsp;:&nbsp;<input type="text" name="NewPort" size="2" value="80">&nbsp;:&nbsp;<input type="text" name="NewHH" id="GiveMeFocus" size="20"></TD>
      <TD>
        <input type="submit" name="add" value="Add">
      </TD>
    </TR>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <TR><TD colspan="2"><input type="submit" name="return" value="Manage Site"></TD></TR>
  </table>
</form>
<%
End Sub

Sub ScriptMap(errs)
  If Request("site") = 0 Then
    Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/W3SVC")
    ServerComment = "Master WWW"
  Else
    Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site"))
    Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/ROOT")
    ServerComment = objSite.ServerComment
  End If

  ScriptMaps = objSiteRoot.ScriptMaps
  If Ubound(ScriptMaps) <= 9 Then selectsize = Ubound(ScriptMaps) + 1 else selectsize = 10
  SMOut = "<SELECT MULTIPLE Name=""CurSM"" size=""" & selectsize & """>"
  For x = 0 to Ubound(ScriptMaps)
    Script = Split(ScriptMaps(x),",")
	  SMOut = SMOut & "<option value=""" & Script(0) & """>" & Script(0) & "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" & Script(1) & "</option>"
  Next
  SMOut = SMOut & "</SELECT>"

%>
<form name="theform" method="post" action="w3svc_site_config.asp?action=change_scriptmap">
<Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TABLE width="75%">
    <TR><TH colspan=2>Manage <%=ServerComment%> Script Mappings</TH></TR>
    <TR><TD colspan="2">&nbsp;<%=errs%></TD></TR>
    <TR><TH>Current Entries</TH><TD>&nbsp;</TD></TR>
    <TR>
      <TD><%= SMOut%></TD>
      <TD>
        &nbsp;<input type="submit" name="rem" value="Remove">&nbsp;<BR><BR>
        <input type="submit" name="edit" value="Edit">
      </TD>
    </TR>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <TR><TH>Add an entry</TH><TD>&nbsp;</TD></TR>
    <TR>
      <TD>
       <p align="left">
        Executable: <input type="text" name="scriptpath" size="40"><BR>
        Extension: &nbsp;&nbsp;<input type="text" name="scripttext" size="10"><BR><BR>
        <input type="radio" name="verb" value="all" CHECKED> All Verbs<BR>
        <input type="radio" name="verb" value="limit"> Limit to: <input type="text" name="limitverbs" size="40"><br><BR>
        <input type="checkbox" name="scripteng" value="yes" Checked> Script Engine<br>
        <input type="checkbox" name="verify" value="yes" Checked> Verify that file exists<br>
        </p>
      </TD>
      <TD>
        <input type="submit" name="add" value="Add">
      </TD>
    </TR>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <TR><TD colspan="2"><input type="submit" name="return" value="Manage Site"></TD></TR>
  </table>
</form>
<%
End Sub

Sub EditScriptMap(errs)
' On Error Resume Next
  If Request("site") = 0 Then
    Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/W3SVC")
    ServerComment = "Master WWW"
  Else
    Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site"))
    Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/ROOT")
    ServerComment = objSite.ServerComment
  End If

  ScriptMaps = objSiteRoot.ScriptMaps
  For x = 0 to Ubound(ScriptMaps)
    Script = Split(ScriptMaps(x),",")
    If Script(0) = Request("CurSM") Then Exit For
  Next

  scriptpath = Script(1)
  scripttext = Script(0)
  If Script(2) = 4 or Script(2) = 5 Then verify = "CHECKED"
  If Script(2) = 1 or Script(2) = 5 Then scripteng = "CHECKED"
  If UBound(Script) > 2 Then
    limitverbs = "CHECKED"
    For i = 3 To UBound(Script)
      verbs = verbs & script(i) & ","
    Next
    verbs = Left(verbs,Len(verbs)-1)
  Else
    allverbs = "CHECKED"
  End If

%>
<form name="theform" method="post" action="w3svc_site_config.asp?action=update_scriptmap">
<Input type="Hidden" name="site" value="<%=Request("site")%>">
<Input type="Hidden" name="scripttext" value="<%=scripttext%>">
  <TABLE width="75%">
    <TR><TH colspan=2>Manage <%=ServerComment%> Script Mappings</TH></TR>
    <TR><TD colspan="2">&nbsp;<%=errs%></TD></TR>
    <TR><TH>Edit entry</TH><TD>&nbsp;</TD></TR>
    <TR>
      <TD>
       <p align="left">
        Executable: <input type="text" name="scriptpath" size="40" value="<%=scriptpath%>"><BR>
        Extension: &nbsp;&nbsp;<%=scripttext%><BR><BR>
        <input type="radio" name="verb" value="all" <%=allverbs%>> All Verbs<BR>
        <input type="radio" name="verb" value="limit" <%=limitverbs%>> Limit to: <input type="text" name="limitverbs" size="40" value="<%=verbs%>"><br><BR>
        <input type="checkbox" name="scripteng" value="yes" <%=scripteng%>> Script Engine<br>
        <input type="checkbox" name="verify" value="yes" <%=verify%>> Verify that file exists<br>
        </p>
      </TD>
      <TD>
        <input type="submit" name="update" value="Update">
      </TD>
    </TR>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <TR><TD colspan="2"><input type="submit" name="return" value="Manage Site">&nbsp;&nbsp;<input type="submit" name="manscript" value="Manage Script Maps"></TD></TR>
  </table>
</form>
<%
End Sub

Sub LogDir()
  Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site"))
	If objSite.LogFileDirectory = "" Then
	  curld = objSite.LogFileDirectory & "\w3svc" & Request("site")
	Else
	  curld = objSite.LogFileDirectory
	End If
%>
<form  name="theform"method="post" action="w3svc_site_config.asp?action=change_logdir">
<Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TABLE width="75%">
    <TR><TH colspan=2>Manage Site's Log File Directory</TH></TR>
    <TR><TH>Current</TH><TD><%=curld%>\W3SVC<%=Request("site")%></TD></TR>
    <TR><TH>New</TH><TD><input type="text" name="newld" id="GiveMeFocus" value="<%=curld%>" size="75">\W3SVC<%=Request("site")%></TD></TR>
    <TR><TH>&nbsp;</TH><TD>There is no need for a trailing slash.	The \w3svc# is automatically appended by IIS.</TD></TR>
    <TR><TH>&nbsp;</TH><TD><input type="submit" Value="Commit Modifications" >&nbsp;&nbsp;<input type="submit" name="return" value="Manage Site"></TD></TR>
  </table>
</Form>
<%
End Sub

Sub Auth()
  If Request("site") = 0 Then
    Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC")
    ServerComment = "Master WWW"
    AuthFlags = objSite.AuthFlags
  Else
    Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site"))
    Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/root")
    ServerComment = objSite.ServerComment
    AuthFlags = objSiteRoot.AuthFlags
  End If
%>
  <form name="theform" method="post" action="w3svc_site_config.asp?action=change_auth">
	<Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TABLE>
    <TR><TH colspan=2>Manage Authentication Methods for <%=ServerComment%></TH></TR>
    <TR>
      <TH>Current</TH>
      <TD>
	    <%
	      Select Case authflags
		      Case 0
		        Response.Write "No Access"
		      Case 1
		        Response.Write "Anonymous Only"
		      Case 2
		        Response.Write "Basic(Clear Text) Only, No Anonymous"
		      Case 3
		        Response.Write "Basic(Clear Text) and Anonymous"
		      Case 4
		        Response.Write "NTLM Only"
		      Case 5
		        Response.Write "NTLM and Anonymous"
		      Case 6
		        Response.Write "Basic and NTLM, No Anonymous"
		      Case 7
		        Response.Write "Basic, NTLM, and Anonymous"
		      Case Else
		        Response.Write "Error getting AuthFlags" & authflags
	      End Select
	    %>
      </TD>
    </TR>
    <TR>
      <TH>New</TH>
      <TD>
	    <select name="authlev" id="GiveMeFocus">
	      <OPTION value=0 <%if authflags = 0 then response.write "SELECTED" %>>No Access</option>
	      <OPTION value=1 <%if authflags = 1 then response.write "SELECTED" %>>Anonymous Only</option>
	      <OPTION value=2 <%if authflags = 2 then response.write "SELECTED" %>>Basic(Clear Text) Only, No Anonymous</option>
	      <OPTION value=3 <%if authflags = 3 then response.write "SELECTED" %>>Basic(Clear Text) and Anonymous</option>
	      <OPTION value=4 <%if authflags = 4 then response.write "SELECTED" %>>NTLM Only</option>
	      <OPTION value=5 <%if authflags = 5 then response.write "SELECTED" %>>NTLM and Anonymous</option>
	      <OPTION value=6 <%if authflags = 6 then response.write "SELECTED" %>>Basic and NTLM, No Anonymous</option>
	      <OPTION value=7 <%if authflags = 7 then response.write "SELECTED" %>>Basic, NTLM, and Anonymous</option>
	    </select>
      </TD>
    </TR>
    <TR><TH>&nbsp;</TH><TD>&nbsp;</TD></TR>
    <TR><TH>&nbsp;</TH><TD><input type="submit" Value="Commit Modifications" >&nbsp;&nbsp;<input type="submit" name="return" value="Manage Site"></TD></TR>
</table>
</form>
<%
End Sub

Sub AppProps(errs)

  Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site"))
  Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/root")
%>
<form method="post" action="w3svc_site_config.asp?action=change_app_props">
	<Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TABLE width="75%">
    <TR>
	    <TH colspan="2">Manage Application Options for <%=objSite.ServerComment%></TH>
    </TR>
    <TR><TD colspan="2">&nbsp;<%=errs%></TD></TR>
    <TR>
	    <TH>Application Process</TH>
	    <TD>
	    <%
	      AppProcStat = objSiteRoot.AppGetStatus2
    		If AppProcStat = APP_NOT_CREATED Then
		      Response.write "<a href=""w3svc_site_config.asp?ap=create&site=" & Request("site") & """>Create</a>"
		    ElseIf AppProcStat = APP_DISABLED Then
		      Response.write "<a href=""w3svc_site_config.asp?ap=remove&site=" & Request("site") & """>Remove</a>"
		    Else 'AppProcStat = APP_ENABLED
		      Response.write "<a href=""w3svc_site_config.asp?ap=unload&site=" & Request("site") & """>Unload</a>"
		      Response.write "&nbsp;|&nbsp;"
		      Response.write "<a href=""w3svc_site_config.asp?ap=remove&site=" & Request("site") & """>Remove</a>"
		    End If
	    %>
	    </TD>
    </TR>
<% If AppProcStat = APP_ENABLED OR AppProcStat = APP_DISABLED Then %>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <TR>
	    <TH>App. Friendly Name</TH>
	    <TD><br><input type="text" name="appfname" value="<%=objSiteRoot.appfriendlyname%>" size="25"><br><br></TD>
    </TR>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <TR>
	    <TH>App. Memory Space</TH>
	    <TD><br>
	    <%
	      If Application("IISVer") = "5" Then
      %>
		    <select name="applev" id="GiveMeFocus">
			    <option value="0" <% If objSiteRoot.AppIsolated = "0" Then response.write " SELECTED" %>>Low (IIS Process)</option>
			    <option value="2" <% If objSiteRoot.AppIsolated = "2" Then response.write " SELECTED" %>>Medium (Pooled Process)</option>
			    <option value="1" <% If objSiteRoot.AppIsolated = "1" Then response.write " SELECTED" %>>High (Isolated)</option>
		    </select>
		    <br><br>
		  <%
		    ElseIf Application("IISVer") = "6" Then
		      Set AppPools = GetObject("IIS://" & Application("SERVER") & "/w3svc/AppPools")
	  	    Response.write "<select name=""applev"" id=""GiveMeFocus"">"
          For Each AppPool in AppPools
            Response.write "<option value=""" & AppPool.Name & """ "
            If objSiteRoot.AppPoolId = AppPool.Name Then response.write " SELECTED"
            Response.Write ">" & AppPool.Name & "</option>"
          Next
  		    Response.write "</select>"
		    Response.write "<br><br><a class=""man_link"" href=""manage_app_pools.asp?appname=" & Server.URLEncode(objSiteRoot.AppPoolID) & """>Manage " & objSiteRoot.AppPoolID & "</a><br><br>"
		    End If
      %>
	    </TD>
    </TR>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <TR>
    	<TH>Application Options</TH>
	    <TD>
	    <br>
        <input type="checkbox" name="sessionstate" value="yes" <% If objSiteRoot.AspAllowSessionState <> False Then Response.write "Checked" %>>Session State
		<input type="checkbox" name="aspbuffer" value="yes" <% If objSiteRoot.AspBufferingOn <> False Then Response.write "Checked" %>>Buffering
		<input type="checkbox" name="parentpath" value="yes" <% If objSiteRoot.AspEnableParentPaths <> False Then Response.write "Checked" %>>Parent Paths
        <br>
        <input type="checkbox" name="cdebug" value="yes" <% If objSiteRoot.AppAllowClientDebug <> False Then Response.write "CHECKED" %>>Client Side Debugging
		<input type="checkbox" name="sdebug" value="yes" <% If objSiteRoot.AppAllowDebugging <> False Then Response.write "Checked" %>>Server Side Debugging
		<br><br>
  	  </TD>
    </TR>
<% End If %>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <TR>
	    <TH>Access Permissions</TH>
	    <TD>
	      <br>
	      <input type="checkbox" name="Read" value="yes" <% If objSiteRoot.AccessRead <> False Then Response.write "Checked" %>>Read
	      <input type="checkbox" name="Write" value="yes" <% If objSiteRoot.AccessWrite <> False Then Response.write "Checked" %>>Write
	      <input type="checkbox" name="DirBrowse" value="yes" <% If objSiteRoot.EnableDirBrowsing <> False Then Response.write "Checked" %>>Directory Browsing
	      <br>
	      <input type="checkbox" name="Script" value="yes" <% If objSiteRoot.AccessScript <> False Then Response.write "Checked" %>>Script
	      <input type="checkbox" name="Execute" value="yes" <% If objSiteRoot.AccessExecute <> False Then Response.write "Checked" %>>Execute
	      <input type="checkbox" name="ContentIndex" value="yes" <% If objSiteRoot.ContentIndexed <> False Then Response.write "Checked" %>>Content Indexed
	      <br><br>
	    </TD>
    </TR>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <TR><TD colspan="2"><input type="submit" Value="Commit Modifications" >&nbsp;&nbsp;<input type="submit" name="return" value="Manage Site"></TD></TR>
  </table>
</form>
<%
End Sub

Sub AppProps_Master(errs)

  Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC")
%>
  <form method="post" action="w3svc_site_config.asp?action=change_app_props_master">
	<Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TABLE width="75%">
    <TR>
	    <TH colspan="2">Manage Application Options for Master WWW</TH>
    </TR>
    <TR><TD colspan="2">&nbsp;<%=errs%></TD></TR>
    <TR>
      <TH>App. Memory Space</TH>
      <TD><br>
      <% If Application("IISVer") = 5 Then  %>
	    <select name="applev" id="GiveMeFocus">
		    <option value="0" <% If objSite.AppIsolated = "0" Then response.write " SELECTED" %>>Low (IIS Process)</option>
		    <option value="2" <% If objSite.AppIsolated = "2" Then response.write " SELECTED" %>>Medium (Pooled Process)</option>
		    <option value="1" <% If objSite.AppIsolated = "1" Then response.write " SELECTED" %>>High (Isolated)</option>
	    </select>
       <%
	    ElseIf Application("IISVer") = 6 Then
	      Set AppPools = GetObject("IIS://" & Application("SERVER") & "/w3svc/AppPools")
  	      Response.write "<select name=""applev"" id=""GiveMeFocus"">"
              For Each AppPool in AppPools
                Response.write "<option value=""" & AppPool.Name & """ "
                If objSite.AppPoolId = AppPool.Name Then response.write " SELECTED"
                Response.Write ">" & AppPool.Name & "</option>"
              Next
	      Response.write "</select>"
              Response.write "<br><br><a class=""man_link"" href=""manage_app_pools.asp?appname=" & Server.URLEncode(objSite.AppPoolID) & """>Manage " & objSite.AppPoolID & "</a><br><br>"
	    End If
      %>
      </TD>
    </TR>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <TR>
	    <TH>Application Options</TH>
	    <TD>
        <input type="checkbox" name="sessionstate" value="yes" <% If objSite.AspAllowSessionState <> False Then Response.write "Checked" %>>Session State
			  <input type="checkbox" name="aspbuffer" value="yes" <% If objSite.AspBufferingOn <> False Then Response.write "Checked" %>>Buffering
			  <input type="checkbox" name="parentpath" value="yes" <% If objSite.AspEnableParentPaths <> False Then Response.write "Checked" %>>Parent Paths
        <br>
        <input type="checkbox" name="cdebug" value="yes" <% If objSite.AppAllowClientDebug <> False Then Response.write "Checked" %>>Client Side Debugging
			  <input type="checkbox" name="sdebug" value="yes" <% If objSite.AppAllowDebugging <> False Then Response.write "Checked" %>>Server Side Debugging
  	  </TD>
    </TR>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <TR>
    	<TH>Access Permissions</TH>
	    <TD>
	      <input type="checkbox" name="Read" value="yes" <% If objSite.AccessRead <> False Then Response.write "Checked" %>>Read
	      <input type="checkbox" name="Write" value="yes" <% If objSite.AccessWrite <> False Then Response.write "Checked" %>>Write
	      <input type="checkbox" name="DirBrowse" value="yes" <% If objSite.EnableDirBrowsing <> False Then Response.write "Checked" %>>Directory Browsing
	      <br>
	      <input type="checkbox" name="Script" value="yes" <% If objSite.AccessScript <> False Then Response.write "Checked" %>>Script
	      <input type="checkbox" name="Execute" value="yes" <% If objSite.AccessExecute <> False Then Response.write "Checked" %>>Execute
	      <input type="checkbox" name="ContentIndex" value="yes" <% If objSite.ContentIndexed <> False Then Response.write "Checked" %>>Content Indexed
	    </TD>
    </TR>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <TR><TD colspan="2"><input type="submit" Value="Commit Modifications" >&nbsp;&nbsp;<input type="submit" name="return" value="Manage Site"></TD></TR>
</table>

</form>
<%
End Sub

Sub FrontPage()
On Error Resume Next
Dim errs
errs = ""
  Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site"))
  Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/root")
%>

  <form method="post" action="fpaction.asp">
  <Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TABLE>
    <TR><TH colspan=2>FrontPage Settings for <%=objSite.ServerComment%></TH></TR>
    <TR>
      <TH>&nbsp;</TH>
	    <TD>
	      <input type="submit" value="Enable" Name="enable">
		    <%
		      fptype = "none"
		      If objSiteRoot.FrontPageWeb = True Then
			    Set objSiteFP = GetObject("IIS://" & Application("Server") & "/W3SVC" & "/" & Request("site") & "/root/_vti_bin")
			    If err then errs = err.description
			      err.clear
			      If InStr(objSiteFP.path, "40") then fptype = "2000"
			      If InStr(objSiteFP.path, "50") then fptype = "2002"
		      End If
		    %>
	      <Select Name="fptype" id="GiveMeFocus">
		      <option value="2000" <%if fptype = "2000" then response.write "SELECTED" %>>2000</option>
		      <option value="2002" <%if fptype = "2002" then response.write "SELECTED" %>>2002</option>
		      <option value=none <%if fptype = "none" then response.write "SELECTED" %>>None</option>
	      </Select>
	    </TD>
    </TR>
    <%
	  If Request("i") <> "1" Then
	  %>
		<TR>
		  <TH>&nbsp;</TH>
		  <TD>
			  <Input type="submit" value="Recalculate" Name="recalculate">
			  <Input type="submit" value="Disable" Name="disable">
		  </TD>
		</TR>
	  <%
	  End If
	  If errs <> "" Then response.write "<TR><TH colspan=""2"">" & errs & "</TH></TR>"
    %>
    <TR><TH>&nbsp;</TH><TD><input type="submit" name="return" value="Manage Site"></TD></TR>
</form>
</Table>

<%
End Sub

Sub IPDomRestrictions(errs)
' Set up variables.
  If Request("site") = 0 Then
    Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/W3SVC")
    ServerComment = "Master WWW"
  Else
    Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site"))
    Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/ROOT")
    ServerComment = objSite.ServerComment
  End If

  Set IIsIPSecurityObj = objSiteRoot.IPSecurity

If True = IIsIPSecurityObj.GrantByDefault Then
  output = "By Default All IP's and Domains are Granted access"
  SwitchButton = "<input type=""submit"" name=""switch"" value=""Deny by Default"">"

  Set IIsIPSecurityObj = objSiteRoot.IPSecurity
  IPList = IIsIPSecurityObj.IPDeny

  If UBound(IPList) >= 0 Then
    IPListOut = "<SELECT MULTIPLE Name=""IPList"" size=""" & Ubound(IPList) + 1 & """>"
    For x = 0 to Ubound(IPList)
	    IPListOut = IPListOut & "<option value=""" & IPList(x) & """>" & IPList(x) & "</option>"
    Next
    IPListOut = IPListOut & "</SELECT>"
    IPRemButton = "<input type=""submit"" name=""remIP"" value=""Remove"">"
  Else
    IPListOut = "Nothing is being denied"
    IPRemButton = "&nbsp;"
  End If

  DomList = IIsIPSecurityObj.DomainDeny

  If UBound(DomList) >= 0 Then
    DomListOut = "<SELECT MULTIPLE Name=""DomList"" size=""" & Ubound(DomList) + 1 & """>"
    For x = 0 to Ubound(DomList)
	    DomListOut = DomListOut & "<option value=""" & DomList(x) & """>" & DomList(x) & "</option>"
    Next
    DomListOut = DomListOut & "</SELECT>"
    DomRemButton = "<input type=""submit"" name=""remDom"" value=""Remove"">"
  Else
    DomListOut = "Nothing is being denied"
    DomRemButton = "&nbsp;"
  End If

Else

  output = "By Default All IP's and Domains are Denied access"
  SwitchButton = "<input type=""submit"" name=""switch"" value=""Grant by Default"">"

  Set IIsIPSecurityObj = objSiteRoot.IPSecurity
  IPList = IIsIPSecurityObj.IPGrant

  If UBound(IPList) >= 0 Then
    IPListOut = "<SELECT MULTIPLE Name=""IPList"" size=""" & Ubound(IPList) + 1 & """>"
    For x = 0 to Ubound(IPList)
	    IPListOut = IPListOut & "<option value=""" & IPList(x) & """>" & IPList(x) & "</option>"
    Next
    IPListOut = IPListOut & "</SELECT>"
    IPRemButton = "<input type=""submit"" name=""remIP"" value=""Remove"">"
  Else
    IPListOut = "Nothing is being granted access"
    IPRemButton = "&nbsp;"
  End If

  DomList = IIsIPSecurityObj.DomainGrant

  If UBound(DomList) >= 0 Then
    DomListOut = "<SELECT MULTIPLE Name=""DomList"" size=""" & Ubound(DomList) + 1 & """>"
    For x = 0 to Ubound(DomList)
	    DomListOut = DomListOut & "<option value=""" & DomList(x) & """>" & DomList(x) & "</option>"
    Next
    DomListOut = DomListOut & "</SELECT>"
    DomRemButton = "<input type=""submit"" name=""remDom"" value=""Remove"">"
  Else
    DomListOut = "Nothing is being granted access"
    DomRemButton = "&nbsp;"
  End If

End if
%>
  <form method="post" action="w3svc_site_config.asp?action=change_ipdomrest">
  <Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TABLE>
    <TR><TH colspan="3">Manage <%=ServerComment%> IP Address and Domain Restrictions</TH></TR>
    <TR><TD colspan="3">&nbsp;<%=errs%></TD></TR>
    <TR><TH colspan="3"><%=output%></TH></TR>
    <TR><TD colspan="3">Switch to: <%=SwitchButton%></TD></TR>
    <TR><TD colspan="3">&nbsp;</TD></TR>
    <TR>
      <TH colspan="3">Current Entries</TH>
    </TR>
    <TR>
      <TD colspan="2"><%=IPListOut%></TD>
      <TD><%=IPRemButton%></TD>
    </TR>
    <TR>
      <TD colspan="2"><%=DomListOut%></TD>
      <TD><%=DomRemButton%></TD>
    </TR>
    <TR><TD colspan="3">&nbsp;</TD></TR>
    <TR>
      <TH colspan="3">Add an Entry</TH>
    </TR>
    <TR>
      <TH>Single IP</TH>
      <TD>IP Address: <input type="text" name="ipadd" size="15"></TD>
      <TD Rowspan="3">
        <input type="submit" name="add" value="Add">
      </TD>
    </TR>
    <TR>
      <TH>IP Range</TH>
      <TD>Network ID: <input type="text" name="netid" size="15">&nbsp;&nbsp;Subnet: <input type="text" name="subnet" size="15"></TD>
    </TR>
    <TR>
      <TH>Domain Name:</TH>
      <TD>Domain Name: <input type="text" name="domain" size="40"></TD>
    </TR>
    <TR><TD colspan="3">&nbsp;</TD></TR>
    <TR><TD colspan="3"><input type="submit" name="return" value="Manage Site"></TD></TR>
  </table>
</form>

<%
End Sub



Sub Show_Delete()
  Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site"))
  Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/ROOT")
  
  If Application("IISVer") = "6" Then
    a = 0
    Set AppPools = GetObject("IIS://" & Application("SERVER") & "/w3svc/AppPools")
    For Each AppPool in AppPools
  	  If LCase(AppPool.Name) = LCase(objSITE.ServerComment) Then a = 1
    Next
  
    If a = 0 Then
  	  aselect = "<TD>App Pool: <select name=""appname"">"
  	  For Each AppPool in AppPools
  		aselect = aselect & "<option value=""" & AppPool.name & """>" & AppPool.name & "</option>"
  	  Next
  	  aselect = aselect & "</select></TD>"
    Else
  	  aselect = "<Input Type=Hidden Name=appname Value=""" & objSITE.ServerComment & """>"
  	  aselect = aselect & "<TD>App Pool: " & objSITE.ServerComment & "</TD>"
    End If
  End If
%>
	<form method="POST" action="w3svc_site_config.asp">
	  <Input Type=Hidden Name=site Value="<%=Request("site")%>">
	  <Input Type=Hidden Name=action Value="do_delete">
<TABLE>
  <TR><TH colspan="3">Delete&nbsp;<%=objSITE.ServerComment%></TH></TR>

  <TR>
    <TH>&nbsp;</TH>
	  <Input Type=Hidden Name=homedir Value="<%=objSiteRoot.Path%>">
	  <TD>Files: <%=objSiteRoot.Path%></TD>
	  <TD>
		<select name="fileyn">
			<option value="delete">Delete</option>
			<option value="move" SELECTED>Trash</option>
			<option value="nothing">Nothing</option>
		</select>
	  </TD>
  </TR>

  <% If Application("IISVer") = "6" Then %>
    <TR>
      <TH>&nbsp;</TH>
  	  <%=aselect%>
  	  <TD>
  		<select name="apppoolyn">
  		  <option <% If a = 1 Then response.write "SELECTED" %> value="delete">Delete</option>
  		  <option value="stop">Stop</option>
  			<option <% If a = 0 Then response.write "SELECTED" %> value="nothing">Nothing</option>
  		</select>
  	  </TD>
    </TR>
  <% End If %>

  <TR><TH>&nbsp;</TH><TD colspan="2"><input type="submit" value="Delete" Name="JakeIsDaMan">&nbsp;&nbsp;<input type="submit" name="return" value="Manage Site"></TD></TR>
  <%=errmsg%>
</TABLE>

</form>

<%
End Sub

Sub MaxConnections(errs)
On Error Resume Next
  If Request("site") = 0 Then
    Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC")
    ServerComment = "Master WWW"
  Else
    Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site"))
    ServerComment = objSite.ServerComment
  End If

  maxcons = objSite.MaxConnections
  MaxConsUlimit = 2000000000


  If maxcons = -1 or maxcons >= MaxConsUlimit Then
    If Len(Request("MCS")) Then 'Turn ON/OFF value entry textbox
      If Request("MCSFlag") = 0 Then showhide = 0 Else showhide = 1
    Else
      showhide = 1
    End If
  Else 'not unlimited
    If Len(Request("MCS")) Then 'Turn ON/OFF value entry textbox
      If Request("MCSFlag") = 0 Then
        showhide = 0
        MaxConsUlimit = MaxCons
      Else
        showhide = 1
'         MaxConsUlimit = MaxCons
      End If
    Else
      showhide = 0
      MaxConsUlimit = MaxCons
    End If
  End If

  Select Case ShowHide
    Case 0 'Show
      maxconDisplay = "<TD>" & MaxConsUlimit & "</TD>"
      maxconButton = "<TD><input type=""submit"" name=""MCS"" value=""Switch to Unlimited""></TD></TR>"
      maxconValue = "<TR><TH>Enter a value</TH><TD>&nbsp;</TD></TR>"
      maxconValue = maxconValue & "<TR><TD><input type=""text"" name=""MCValue"" value=""" & MaxConsUlimit & """></TD>"
      maxconValue = maxconValue & "<TD><input type=""submit"" name""MCUpdate"" value=""Update""></TD></TR>"
      maxconValue = maxconValue & "<Input type=""Hidden"" name=""MCSFlag"" value=""1"">"

    Case 1 'Hide
      maxconDisplay = "<TR><TD>Unlimited</TD>"
      maxconButton = "<TD><input type=""submit"" name=""MCS"" value=""Enter a Value""></TD></TR>"
      maxconButton = maxconButton & "<TR><TD colspan=""2"">&nbsp;</TD></TR><TR><TD>&nbsp;</TD>"
      maxconButton = maxconButton & "<TD><input type=""submit"" name""MCUpdate"" value=""Update""></TD></TR>"
      maxconValue = "<Input type=""Hidden"" name=""MCValue"" value=""" & MaxConsUlimit & """><Input type=""Hidden"" name=""MCSFlag"" value=""0"">"

  End Select



%>
<form name="theform" method="post" action="w3svc_site_config.asp?action=change_maxcon">
  <Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TABLE>
    <TR><TH colspan="2">Manage <%=ServerComment%> Max Connections</TH></TR>
    <TR><TD colspan="2">&nbsp;<%=errs%></TD></TR>
    <TR><TH>Current Connections</TH><TD>&nbsp;</TD></TR>
    <%= MaxConDisplay%><%=MaxConButton%>
    <%=MaxConValue%>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <TR><TD colspan="2"><input type="submit" name="return" value="Manage Site"></TD></TR>
  </TABLE>
</form>
<%
End Sub


Sub MaxREA(errs)
' On Error Resume Next
  If Request("site") = 0 Then
    Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC")
    ServerComment = "Master WWW"
    objMaxREA = objSite.MaxRequestEntityAllowed
    aspmaxREA = objSite.AspMaxRequestEntityAllowed
  Else
    Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site"))
    ServerComment = objSite.ServerComment
    objMaxREA = objSite.MaxRequestEntityAllowed
    aspmaxREA = objSite.AspMaxRequestEntityAllowed
  End If

  If objMaxREA = -1 Then objMaxREA = 4294967295


%>
<form name="theform" method="post" action="w3svc_site_config.asp?action=change_maxrea">
  <Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TABLE>
    <TR><TH colspan="2">Manage <%=ServerComment%> Max Request Entity Allowed</TH></TR>
    <TR><TD colspan="2">&nbsp;<%=errs%></TD></TR>
    <TR><TH>Current</TH><TD><%=objMaxREA%> bytes</TD></TR>
    <TR><TH>New</TH><TD><input type="text" name="newmaxrea" value="<%=objMaxREA%>"> bytes</TD></TR>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <TR><TH>Current</TH><TD><%=aspmaxREA%> bytes</TD></TR>
    <TR><TH>New</TH><TD><input type="text" name="newaspmaxrea" value="<%=aspmaxrea%>"> bytes</TD></TR>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <TR><TD colspan="2">4294967295 is unlimited</TD></TR>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <TR><TD colspan="2"><input type="submit" name="commit" Value="Commit Modifications" >&nbsp;&nbsp;<input type="submit" name="return" value="Manage Site"></TD></TR>
  </TABLE>
</form>
<%
End Sub

Sub HTTPRedir(errs)
On Error Resume Next
  If Request("site") = 0 Then errs = "Invalid Site"

  Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site"))
  Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/ROOT")
  ServerComment = objSite.ServerComment
  
  httpRedirect = objSiteRoot.HTTPRedirect

  Dim httpRedirStr, httpRedirExURL, httpRedirDirBelow, httpRedirPerm
  httpRedirExURL = ""
  httpRedirDirBelow = ""
  httpRedirPerm = ""

  If httpRedirect = "" Then
    httpRedir_Current = "HTTP Redirection is not Enabled"
    httpRedirStr = "http://"
  Else
    httpRedir_Current = "HTTP Redirection is Enabled"
    Dim httRedirValues
    If InStr(httpRedirect,",") Then
      httpRedirValues = Split(httpRedirect,",")
    Else
      ReDim httpRedirValues(0)
      httpRedirValues(0) = httpRedirect
    End If

    httpRedirStr = httpRedirValues(0)
    For i = 1 to UBound(httpRedirValues)
      Select Case Trim(httpRedirValues(i))
        Case "EXACT_DESTINATION"
          httpRedirExURL = "CHECKED"
        Case "CHILD_ONLY"
          httpRedirDirBelow = "CHECKED"
        Case "PERMANENT"
          httpRedirPerm = "CHECKED"
        Case "TEMPORARY"
          httpRedirExURL = ""
      End Select
    Next
  End If

%>
<form name="theform" method="post" action="w3svc_site_config.asp?action=change_httpredir">
  <Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TABLE>
    <TR><TH colspan="2">Manage <%=ServerComment%> HTTP Redirect</TH></TR>
    <TR><TD colspan="2">&nbsp;<%=errs%></TD></TR>
    <TR><TH colspan="2"><%= HTTPRedir_Current%></TH></TR>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <TR>
      <TD>
        <p align="left">
        Redirect To: <input type="text" name="httpredirstr" id="GiveMeFocus" value="<%=httpRedirStr%>" size="40"><BR>
        <BR>
        <input type="checkbox" name="httpRedirExURL" value="yes" <%=httpRedirExURL%>> The Exact URL Entered Above<BR>
        <input type="checkbox" name="httpRedirDirBelow" value="yes" <%=httpRedirDirBelow%>>A directory below URL Entered<BR>
        <input type="checkbox" name="httpRedirPerm" value="yes" <%=httpRedirPerm%>>A permanent Redirection for this resource<BR>
        <BR>
        </P>
      </TD>
      <TD>
        <input type="submit" name="remove" Value="Remove">
        <BR><BR>
        <input type="submit" Value="Update">
      </TD>
    </TR>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <TR><TD colspan="2"><input type="submit" name="return" value="Manage Site"></TD></TR>
  </TABLE>
</form>
<%
End Sub

Sub DocFoot(errs)
On Error Resume Next
  If Request("Site") = 0 Then
    Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/W3SVC")
    ServerComment = "Master WWW"
  Else
    Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site"))
    Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/root")
    ServerComment = objSite.ServerComment
  End If

  If objSiteRoot.EnableDocFooter = True Then
    DocFoot_Current = Right(objSiteRoot.DefaultDocFooter,(Len(objSiteRoot.DefaultDocFooter)-5))
    DocFoot_Message = "Document Footer is currently set to:<BR>" & Right(objSiteRoot.DefaultDocFooter,(Len(objSiteRoot.DefaultDocFooter)-5))
  Else
    DocFoot_Current = ""
    DocFoot_Message = "Document Footer is currently disabled."
  End If

%>
<form name="theform" method="post" action="w3svc_site_config.asp?action=change_docfoot">
  <Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TABLE>
    <TR><TH colspan="2">Manage <%=ServerComment%> Document Footer</TH></TR>
    <TR><TD colspan="2">&nbsp;<%=errs%></TD></TR>
    <TR><TD colspan="2"><%= DocFoot_Message%></TD></TR>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <TR>
      <TD>
        <input type="text" name="docfootstr" id="GiveMeFocus" value="<%=DocFoot_Current%>" size="50"><BR>
      </TD>
      <TD>
        <input type="submit" name="remove" Value="Remove">
        <BR><BR>
        <input type="submit" name="update" Value="Update">
      </TD>
    </TR>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <TR><TD colspan="2"><input type="submit" name="return" value="Manage Site"></TD></TR>
  </TABLE>
</form>
<%
End Sub

Sub Logging(errs)
On Error Resume Next
  If Request("site") = 0 Then
    Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC")
    ServerComment = "Master WWW"
  Else
    Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site"))
    ServerComment = objSite.ServerComment
  End If
  Session("svc") = "W3SVC"

  curLogType = objSite.LogPluginClsid
  If curLogType = "{FF160663-DE82-11CF-BC0A-00AA006111E0}" Then Session("rollover") = objSite.LogFileLocaltimeRollover
  If curLogType <> "{FF16065B-DE82-11CF-BC0A-00AA006111E0}" Then 
    Session("fileperiod") = objSite.LogFilePeriod
    Session("filesize") = objSite.LogFileTruncateSize
  Else
    Session("LogODBCDataSource") = objSite.LogODBCDataSource
    Session("LogODBCTableName") = objSite.LogODBCTableName
    Session("LogODBCUserName") = objSite.LogODBCUserName
    Session("LogODBCPassword") = objSite.LogODBCPassword
  End If

  logen = "enabled"
  logen_button = "<input type=""submit"" name=""logen"" value=""Disable"">"
  If objSite.LogType = 0 Then
    logen = "disabled"
    logen_button = "<input type=""submit"" name=""logen"" value=""Enable"">"
  End If

%>
<form name="theform" method="post" action="w3svc_site_config.asp?action=change_logging">
  <Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TABLE>
    <TR><TH colspan="2">Manage <%=ServerComment%> Logging Options</TH></TR>
    <TR><TD colspan="2">&nbsp;<%=errs%></TD></TR>
    <TR><TD>Logging is <%=logen%></TD><TD><%=logen_button%></TD></TR>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <TR><TD><%=GetLogTypes(curLogType)%></TD><TD><input type="submit" name="switchlogtype" value="Switch"></TD></TR>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <%= LogOptionsDisplay(curLogType) %>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <TR><TD colspan="2"><input type="submit" name="commit" Value="Commit Modifications" >&nbsp;&nbsp;<input type="submit" name="return" value="Manage Site"></TD></TR>
  </TABLE>
</form>
<%

End Sub

%>
</div>
</Body>
</HTML>




<%

'##########
'Below is where the action takes place. All subs will redirect back to the site's display page.

Sub ChangeDefDoc(errs)
  On Error Resume Next
  If Request("Site") = 0 Then
    Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/W3SVC")
  Else
    Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/root")
  End If

  If Len(Request("adddefdoc")) Then
    If InStr(objSiteRoot.DefaultDoc,",") Then
      bFound = False
      DefDocArr = Split(objSiteRoot.DefaultDoc,",")
      For x = 0 To Ubound(DefDocArr)
        If DefDocArr(x) = Request("newdefdoc") Then bFound = True
      Next
    Else
      If objSiteRoot.DefaultDoc = Request("newdefdoc") Then bFound = True
    End If
    If bFound Then
      errs = "There was an error!<br>Err: File already in list!"
    Else
      ObjSiteRoot.DefaultDoc = ObjSiteRoot.DefaultDoc & "," & Trim(Request("newdefdoc"))
    End If
  End If

  If Len(Request("remdefdoc")) Then
    If InStr(objSiteRoot.DefaultDoc,",") Then
      DefDocArr = Split(objSiteRoot.DefaultDoc,",")
      Dim NewDDArr()
      i = UBound(DefDocArr)-Request("defdoc").Count
      ReDim NewDDArr(i)
      cnt = 0
      For x = 0 To Ubound(DefDocArr)
        bFound = False
        For i = 1 to Request("defdoc").Count
          If DefDocArr(x) = Request("defdoc").Item(i) Then bFound = True
        Next
        If bFound = False Then
          NewDDArr(cnt) = DefDocArr(x)
          cnt = cnt + 1
        End If
      Next
      For x = 0 To Ubound(NewDDArr)
        NewDD = NewDD & "," & NewDDArr(x)
      Next
      NewDD = Right(NewDD,Len(NewDD)-1)
      ObjSiteRoot.DefaultDoc = NewDD
    Else
      errs = "There was an error!<br>Err: You can't remove the last file!"
    End If
  End If

  If Len(Request("moveup")) Then
    If InStr(objSiteRoot.DefaultDoc,",") Then
      DefDocArr = Split(objSiteRoot.DefaultDoc,",")
      'Loop through the form selections
      For i = 1 to Request("defdoc").Count
        'Find the original position
        For x = 0 To Ubound(DefDocArr)
          If LCase(DefDocArr(x)) = LCase(Request("defdoc").Item(i)) Then PosA = x
        Next
        'Switch the Positions
        If PosA = 0 Then
          errs = "There was an error!<br>Err: File at Top of list already!"
        Else
          PosB = PosA - 1
        End If
        If errs = "" Then
          tmpPos = DefDocArr(PosB)
          DefDocArr(PosB) = DefDocArr(PosA)
          DefDocArr(PosA) = tmpPOS
        End If
      Next
      'Rebuild the Default Doc string based on our new array
      For x = 0 To Ubound(DefDocArr)
        NewDD = NewDD & "," & DefDocArr(x)
      Next
      NewDD = Right(NewDD,Len(NewDD)-1)
      ObjSiteRoot.DefaultDoc = NewDD
    Else
      errs = "There was an error!<br>Err: There is only 1 file!"
    End If
  End If

  If Len(Request("movedown")) Then
    If InStr(objSiteRoot.DefaultDoc,",") Then
      DefDocArr = Split(objSiteRoot.DefaultDoc,",")
      If LCase(DefDocArr(UBound(DefDocArr))) = LCase(Request("defdoc").Item(Request("defdoc").Count)) Then
        errs = "There was an error!<br>Err: File(s) at End of list already!"
      Else
        Dim tmpArr()
        ReDim tmpArr(UBound(DefDocArr))
        i = UBound(tmpArr)
        For z = 0 to UBound(DefDocArr)
          tmpArr(z) = DefDocArr(i)
          i = i - 1
        Next
        DefDocArr = TmpArr

        Dim FormArr()
        ReDim FormArr(Request("defdoc").Count-1)
        i = Request("defdoc").Count
        For z = 0 to UBound(FormArr)
          FormArr(z) = Request("defdoc").Item(i)
          i = i - 1
        Next

        'Loop through the form selections
        For i = 0 to UBound(FormArr)
          'Find the original position
          For x = 0 To Ubound(DefDocArr)
            If LCase(DefDocArr(x)) = LCase(FormArr(i)) Then PosA = x
          Next
          'Switch the Positions
          PosB = PosA - 1
          If errs = "" Then
            tmpPos = DefDocArr(PosB)
            DefDocArr(PosB) = DefDocArr(PosA)
            DefDocArr(PosA) = tmpPOS
          End If
        Next

        'Rebuild the Default Doc string based on our new array
        ReDim tmpArr(UBound(DefDocArr))
        i = UBound(tmpArr)
        For z = 0 to UBound(DefDocArr)
          tmpArr(z) = DefDocArr(i)
          i = i - 1
        Next
        DefDocArr = TmpArr
        For x = 0 To Ubound(DefDocArr)
          NewDD = NewDD & "," & DefDocArr(x)
        Next
        NewDD = Right(NewDD,Len(NewDD)-1)
        ObjSiteRoot.DefaultDoc = NewDD
      End If
    Else
      errs = "There was an error!<br>Err: There is only 1 file!"
    End If
  End If

  If err Then errs = "There was an error!<br>Err: " & Err.description

  objSiteRoot.SetInfo
  Set objSiteRoot = nothing
End Sub

Sub ChangeHomeDir()
  Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/root")
  objSiteRoot.Path = Trim(Request("newhd"))
  objSiteRoot.SetInfo
  Set objSiteRoot = nothing
  Response.Redirect ("manage_W3SVC.asp?site=" & Request("site") & "&tc=1")
End Sub

Sub ChangeHostHead(errs)
' On Error Resume Next
  Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site"))
  curHHArr = ObjSite.ServerBindings

  If Len(Request("rem")) Then
    If UBound(curHHArr) > 0 Then
      Dim NewHHArr()
      i = UBound(CurHHArr) - Request("CurHH").Count
      ReDim NewHHArr(i)
      cnt = 0
      For x = 0 To UBound(CurHHArr)
        bFound = False
        For i = 1 to Request("CurHH").Count
          If CurHHArr(x) = Request("CurHH").Item(i) Then bFound = True
        Next
  
        If bFound = False Then
          NewHHArr(cnt) = CurHHArr(x)
          cnt = cnt + 1
        End If
      Next
      objSite.ServerBindings = NewHHArr
      objSite.SetInfo
    Else
      errs = "There was an error!<br>Err: You can't remove the last entry!"
    End If
  End If


  If Len(Request("add")) Then
    i = UBound(CurHHArr) + 1
    ReDim Preserve CurHHArr(i)
    NewHH = Request("ipadd") & ":" & Request("newport") & ":" & Request("newhh")
    bFound = False
    For x = 0 To Ubound(CurHHArr)
      If CurHHArr(x) = newHH Then bFound = True
    Next

    If bFound = False Then
      CurHHArr(UBound(CurHHArr)) = NewHH
      objSite.ServerBindings = CurHHArr
      objSite.SetInfo
    Else
      errs = "There was an error!<br>Err: Entry Already exists!"
    End If

  End If

  Set objSite = nothing

  If err Then errs = "There was an error!<br>Err: " & Err.description

End Sub

Sub ChangeLogDir()
  Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site"))
  objSite.LogFileDirectory = Trim(Request("newld"))
  objSite.SetInfo
  Set objSite = nothing
  Response.Redirect ("manage_W3SVC.asp?site=" & Request("site") & "&tc=1")
End Sub

Sub Change_Auth()
If Request("Site") = 0 Then
  Set objSite = GetObject("IIS://" & Application("Server") & "/w3svc")
	objSite.AuthFlags = Request("authlev")
	objSite.SetInfo
  Set objSite = Nothing
  Response.Redirect ("manage_W3SVC_master.asp?tc=1")
Else
  Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/w3svc/" & Request("site") & "/ROOT")
	objSiteRoot.AuthFlags = Request("authlev")
		objSiteRoot.SetInfo
  Set objSiteRoot = Nothing
  Response.Redirect ("manage_W3SVC.asp?site=" & Request("site") & "&tc=1")
End If

End Sub

Sub Change_AppProps(errs)
On Error Resume Next

  Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/w3svc/" & Request("site") & "/ROOT")
  If LCase(Request("sessionstate")) = "yes" Then objSiteRoot.AspAllowSessionState = True Else objSiteRoot.AspAllowSessionState = False
  If LCase(Request("aspbuffer")) = "yes" Then objSiteRoot.AspBufferingOn = True	Else objSiteRoot.AspBufferingOn = False
  If LCase(Request("parentpath")) = "yes" Then objSiteRoot.AspEnableParentPaths = True Else objSiteRoot.AspEnableParentPaths = False
  If LCase(Request("cdebug")) = "yes" Then objSiteRoot.AppAllowClientDebug = True Else objSiteRoot.AppAllowClientDebug = False
  If LCase(Request("sdebug")) = "yes" Then objSiteRoot.AppAllowDebugging = True Else objSiteRoot.AppAllowDebugging = False
  If LCase(Request("Read")) = "yes" Then objSiteRoot.AccessRead = True Else objSiteRoot.AccessRead = False
  If LCase(Request("Write")) = "yes" Then objSiteRoot.AccessWrite = True Else objSiteRoot.AccessWrite = False
  If LCase(Request("Execute")) = "yes" Then objSiteRoot.AccessExecute = True Else objSiteRoot.AccessExecute = False
  If LCase(Request("Script")) = "yes" Then objSiteRoot.AccessScript = True Else objSiteRoot.AccessScript = False
  If LCase(Request("DirBrowse")) = "yes" Then objSiteRoot.EnableDirBrowsing = True Else objSiteRoot.EnableDirBrowsing = False
  If LCase(Request("ContentIndex")) = "yes" Then objSiteRoot.ContentIndexed = True Else objSiteRoot.ContentIndexed = False

  If Application("IISVer") = 5 Then
    objSiteRoot.AppFriendlyName = Request("appfname")
    err.clear
    CurAppLev = ObjSiteRoot.AppIsolated
    objSiteRoot.AppCreate2 Request("applev")
    If err then objSiteRoot.AppCreate2 CurAppLev
  End If

  objSiteRoot.SetInfo

  If Application("IISVer") = 6 Then
    'Change name
    If objSiteRoot.AppFriendlyName <> Request("appfname") Then
      objSiteRoot.AppFriendlyName = Request("appfname")
      objSiteRoot.SetInfo
    End If
    'Change Pool
    If ObjSiteRoot.AppPoolID <> Request("applev") Then
      ObjSiteRoot.AppPoolId = Request("applev")
      objSiteRoot.SetInfo
    End If

  End If

  Set objSiteRoot = Nothing

  If err Then errs = "There was an error!<br>Err: " & Err.description Else errs = "Updated!"

End Sub

Sub Change_AppProps_Master(errs)
On Error Resume Next

  Set objSite = GetObject("IIS://" & Application("Server") & "/w3svc")
	If LCase(Request("sessionstate")) = "yes" Then objSite.AspAllowSessionState = True Else objSite.AspAllowSessionState = False
	If LCase(Request("aspbuffer")) = "yes" Then objSite.AspBufferingOn = True	Else objSite.AspBufferingOn = False
  If LCase(Request("parentpath")) = "yes" Then objSite.AspEnableParentPaths = True Else objSite.AspEnableParentPaths = False
  If LCase(Request("cdebug")) = "yes" Then objSite.AppAllowClientDebug = True Else objSite.AppAllowClientDebug = False
  If LCase(Request("sdebug")) = "yes" Then objSite.AppAllowDebugging = True Else objSite.AppAllowDebugging = False
  If LCase(Request("Read")) = "yes" Then objSite.AccessRead = True Else objSite.AccessRead = False
  If LCase(Request("Write")) = "yes" Then objSite.AccessWrite = True Else objSite.AccessWrite = False
  If LCase(Request("Script")) = "yes" Then objSite.AccessScript = True Else objSite.AccessScript = False
  If LCase(Request("Execute")) = "yes" Then objSite.AccessExecute = True Else objSite.AccessExecute = False
  If LCase(Request("DirBrowse")) = "yes" Then objSite.EnableDirBrowsing = True Else objSite.EnableDirBrowsing = False
  If LCase(Request("ContentIndex")) = "yes" Then objSite.ContentIndexed = True Else objSite.ContentIndexed = False

  If Application("IISVer") = 5 Then
    err.clear
    CurAppLev = ObjSite.AppIsolated
    objSite.AppCreate2 Request("applev")
    If err then objSite.AppCreate2 CurAppLev
	End If

  If Application("IISVer") = 6 Then
    If ObjSite.AppPoolID <> Request("applev") Then ObjSite.AppPoolId = Request("applev")
  End If

  objSite.SetInfo
  Set objSite = Nothing

  If err Then errs = "There was an error!<br>Err: " & Err.description Else errs = "Updated!"

End Sub


Sub Do_Delete()
On Error Resume Next
Dim errlev, HomeDir
errlev = ""

  Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/w3svc/" & Request("site") & "/ROOT")
  Set objFTPRoot = GetObject("IIS://" & Application("Server") & "/MSFTPSVC/1/root")

  'Check for FTP virtual dirs to delete
  For Each ftpsvc In objFTPRoot
	If ftpsvc.Path = objSiteRoot.Path Then objFTPRoot.Delete "IIsFtpVirtualDir", ftpsvc.Name
  Next
  If err then errlev = errlev & "ftp:"
	err.clear

 'Delete the WWW site
  Set w3del = GetObject("IIS://" & Application("Server") & "/w3svc")
	w3del.Delete "IIsWebServer", Request("site")
  If err then errlev = errlev & "w3svc:"
	err.clear

  'Delete/Disable the user
  If LCase(Request("useryn")) <> "nothing" Then
	  Select Case LCase(Request("useryn"))
		Case "delete"
			Set objServer = GetObject("WinNT://" & Application("domain") & "/" & Application("Server"))
			  objServer.Delete "user", Request("user")
		Case "disable"
			set ObjUser = GetObject("WinNT://" & Application("domain") & "/" & Application("Server") & "/" & Request("user"))
				ObjUser.AccountDisabled = True
			  ObjUser.SetInfo
	  End Select
  End If
  If err then errlev = errlev & "user:"
	err.clear

  'Delete/Move the files/folders
  If LCase(Request("fileyn")) <> "nothing" Then
	  Set fso = Server.CreateObject("Scripting.FileSystemObject")
	  HomeDir = Request("homedir")
	  If Right(HomeDir,1) = "\" Then HomeDir = Left(HomeDir,(Len(HomeDir)-1))
	  If fso.folderexists(HomeDir) Then
		  Select Case LCase(Request("fileyn"))
		    Case "move"
		      'Check and clear the destination
          Set DestFolder = fso.GetFolder(Application("DELETE_SITE_ROOT"))
            For each folder in DestFolder.subfolders
              If Right(HomeDir,Len(folder.name)) = folder.name Then
                fso.deleteFolder Application("DELETE_SITE_ROOT") & folder.name, True
			        End If
			      Next
          'Ok, now move it
			    Set theFolder = fso.GetFolder(HomeDir)
			    theFolder.Move Application("DELETE_SITE_ROOT")
		    Case "delete"
		      'Just delete it
			    fso.DeleteFolder HomeDir, True
		  End Select
	  End If
  End If

  'Delete/Stop the Application Pool
  Select Case Request("apppoolyn")
    Case "delete"
      Set AppPools = GetObject("IIS://" & Application("SERVER") & "/w3svc/AppPools")
      AppPools.delete "IISApplicationPool", Request("appname")
    Case "stop"
      Set AppPool = GetObject("IIS://" & Application("SERVER") & "/w3svc/AppPools/" & Request("appname"))
      AppPool.stop
    Case "nothing"
      'DO NOTHING!
  End Select


If Len(errlev) > 1 Then
  response.redirect "display_services.asp?svc=W3SVC&tc=0&e=" & errlev
Else
  response.redirect "display_services.asp?svc=W3SVC&tc=1"
End If

End Sub


Sub AppProc()
On Error Resume Next
Set ObjSiteRoot = GetObject( "IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/ROOT")
appstat = ObjSiteRoot.AppGetStatus2

  Select Case LCase(Request("ap"))
	Case "unload"
	  ObjSiteRoot.AppUnload
	Case "enable"
		ObjSiteRoot.AppEnable
	Case "disable"
	  ObjSiteRoot.AppDisable
	Case "create"
	  ObjSiteRoot.AppCreate2 POOLED 'Default to pooled, since we don't get a setting in the querystring
		ObjSiteRoot.AppFriendlyName = "Default Application"
		ObjSiteRoot.SetInfo
	Case "remove"
	  ObjSiteRoot.AppDelete
  End Select

  If Err Then
	Response.redirect ("w3svc_site_config.asp?action=app_props&site=" & Request("site")& "&tc=0")
  Else
	Response.redirect ("w3svc_site_config.asp?action=app_props&site=" & Request("site")& "&tc=1")
  End If

End sub

Sub Change_IPDomRestrictions(errs)
On Error Resume Next
  If Request("Site") = 0 Then
    Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/W3SVC")
  Else
    Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/root")
  End If

  Set IIsIPSecurityObj = objSiteRoot.IPSecurity
  'Switch?
  If Len(Request("switch")) Then
   If IIsIPSecurityObj.GrantByDefault = True Then 
     If Request("site") = 0 Then
       errs = errs & "You can not set Deny by Default for the Master WWW!<br>You would lose your connection to this control panel!"
     Else
       IIsIPSecurityObj.GrantByDefault = False
     End If
   Else
     IIsIPSecurityObj.GrantByDefault = True
   End If
   objSiteRoot.IPSecurity = IIsIPSecurityObj
   objSiteRoot.SetInfo

  Else
    Dim NewDomList()
    Dim NewIPList()

    If IIsIPSecurityObj.GrantByDefault = True Then
      If Len(Request("remDom")) Then
        DomList = IIsIPSecurityObj.DomainDeny
        If UBound(DomList) >= 0 Then
          i = UBound(DomList) - Request("DomList").Count
          ReDim NewDomList(i)
          cnt = 0
          For x = 0 To UBound(DomList)
            bFound = False
            For i = 1 to Request("DomList").Count
              If DomList(x) = Request("DomList").Item(i) Then bFound = True
            Next
            If bFound = False Then
              NewDomList(cnt) = DomList(x)
              cnt = cnt + 1
            End If
          Next
        End If
        IIsIPSecurityObj.DomainDeny = NewDomList
        objSiteRoot.IPSecurity = IIsIPSecurityObj
        objSiteRoot.SetInfo
      End If

      If Len(Request("remIP")) Then
        IPList = IIsIPSecurityObj.IPDeny
        If UBound(IPList) >= 0 Then
          i = UBound(IPList) - Request("IPList").Count
          ReDim NewIPList(i)
          cnt = 0
          For x = 0 To UBound(IPList)
            bFound = False
            For i = 1 to Request("IPList").Count
              If IPList(x) = Request("IPList").Item(i) Then bFound = True
            Next
            If bFound = False Then
              NewIPList(cnt) = IPList(x)
              cnt = cnt + 1
            End If
          Next
        End If
        IIsIPSecurityObj.IPDeny = NewIPList
        objSiteRoot.IPSecurity = IIsIPSecurityObj
        objSiteRoot.SetInfo
      End If

      If Len(Request("add")) Then
        If Len(Request("domain")) Then
          DomList = IIsIPSecurityObj.DomainDeny
          ReDim Preserve DomList(UBound(DomList)+1)
          DomList(UBound(DomList)) = Trim(Request("domain"))
          IIsIPSecurityObj.DomainDeny = DomList
          objSiteRoot.IPSecurity = IIsIPSecurityObj
          objSiteRoot.SetInfo
        End If

        If Len(Request("ipadd")) Then
          IPList = IIsIPSecurityObj.IPDeny
          ReDim Preserve IPList(UBound(IPList)+1)
          IPList(UBound(IPList)) = Trim(Request("ipadd")) & ", 255.255.255.255"
          IIsIPSecurityObj.IPDeny = IPList
          objSiteRoot.IPSecurity = IIsIPSecurityObj
          objSiteRoot.SetInfo
        End If

        If Len(Request("netid")) Then
          IPList = IIsIPSecurityObj.IPDeny
          ReDim Preserve IPList(UBound(IPList)+1)
          IPList(UBound(IPList)) = Trim(Request("netid")) & ", " & Trim(Request("subnet"))
          IIsIPSecurityObj.IPDeny = IPList
          objSiteRoot.IPSecurity = IIsIPSecurityObj
          objSiteRoot.SetInfo
        End If

      End If

    Else

      If Len(Request("remDom")) Then
        DomList = IIsIPSecurityObj.DomainGrant
        If UBound(DomList) >= 0 Then
          i = UBound(DomList) - Request("DomList").Count
          ReDim NewDomList(i)
          cnt = 0
          For x = 0 To UBound(DomList)
            bFound = False
            For i = 1 to Request("DomList").Count
              If DomList(x) = Request("DomList").Item(i) Then bFound = True
            Next
            If bFound = False Then
              NewDomList(cnt) = DomList(x)
              cnt = cnt + 1
            End If
          Next
        End If
        IIsIPSecurityObj.DomainGrant = NewDomList
        objSiteRoot.IPSecurity = IIsIPSecurityObj
        objSiteRoot.SetInfo
      End If
    
      If Len(Request("remIP")) Then
        IPList = IIsIPSecurityObj.IPGrant
        If UBound(IPList) >= 0 Then
          i = UBound(IPList) - Request("IPList").Count
          ReDim NewIPList(i)
          cnt = 0
          For x = 0 To UBound(IPList)
            bFound = False
            For i = 1 to Request("IPList").Count
              If IPList(x) = Request("IPList").Item(i) Then bFound = True
            Next
            If bFound = False Then
              NewIPList(cnt) = IPList(x)
              cnt = cnt + 1
            End If
          Next
        End If
        IIsIPSecurityObj.IPGrant = NewIPList
        objSiteRoot.IPSecurity = IIsIPSecurityObj
        objSiteRoot.SetInfo
      End If
    
      If Len(Request("add")) Then

        If Len(Request("domain")) Then
          DomList = IIsIPSecurityObj.DomainGrant
          ReDim Preserve DomList(UBound(DomList)+1)
          DomList(UBound(DomList)) = Trim(Request("domain"))
          IIsIPSecurityObj.DomainGrant = DomList
          objSiteRoot.IPSecurity = IIsIPSecurityObj
          objSiteRoot.SetInfo
        End If

        If Len(Request("ipadd")) Then
          IPList = IIsIPSecurityObj.IPGrant
          ReDim Preserve IPList(UBound(IPList)+1)
          IPList(UBound(IPList)) = Trim(Request("ipadd")) & ", 255.255.255.255"
          IIsIPSecurityObj.IPGrant = IPList
          objSiteRoot.IPSecurity = IIsIPSecurityObj
          objSiteRoot.SetInfo
        End If

        If Len(Request("netid")) Then
          IPList = IIsIPSecurityObj.IPGrant
          ReDim Preserve IPList(UBound(IPList)+1)
          IPList(UBound(IPList)) = Trim(Request("netid")) & ", " & Trim(Request("subnet"))
          IIsIPSecurityObj.IPGrant = IPList
          objSiteRoot.IPSecurity = IIsIPSecurityObj
          objSiteRoot.SetInfo
        End If

      End If

    End If
  End If

  If errs = "" Then
    If err = False Then Errs = "Updated" Else errs = "There was an error!<br>Err: " & err.description
  End If

End Sub

Sub Change_SiteComment(errs)
On Error Resume Next
  Set objSite = GetObject("IIS://" & Application("Server") & "/w3svc/" & Request("site") & "")
    objSite.ServerComment = Request("sitename")
    objSite.SetInfo
  Set objSite = Nothing

  If err Then errs = "There was an error!<br>Err: " & Err.description Else errs = "Updated!"

End Sub

Sub Change_ConnectionTimeout(errs)
On Error Resume Next
  If Request("Site") = 0 Then Set objSite = GetObject("IIS://" & Application("Server") & "/w3svc") Else Set objSite = GetObject("IIS://" & Application("Server") & "/w3svc/" & Request("site") & "")
	objSite.ConnectionTimeout = Request("conntime")
	objSite.SetInfo
  Set objSite = Nothing

  If err Then errs = "There was an error!<br>Err: " & Err.description Else errs = "Updated!"

End Sub

Sub Change_CGITimeout(errs)
On Error Resume Next
  If Request("Site") = 0 Then Set objSite = GetObject("IIS://" & Application("Server") & "/w3svc") Else Set objSite = GetObject("IIS://" & Application("Server") & "/w3svc/" & Request("site") & "")
	objSite.CGITimeout = Request("cgitime")
	objSite.SetInfo
  Set objSite = Nothing

  If err Then errs = "There was an error!<br>Err: " & Err.description Else errs = "Updated!"

End Sub

Sub UpdateScriptMap(errs)
On Error Resume Next
  If Request("site") = 0 Then
    Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/W3SVC")
  Else
    Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/ROOT")
  End If

  ScriptMaps = objSiteRoot.ScriptMaps
  LPos = UBound(ScriptMaps)
  Dim NewScriptMaps()
  ReDim NewScriptMaps(LPos)

  For x = 0 to Ubound(ScriptMaps)
    Script = Split(ScriptMaps(x),",")
    If Script(0) = Request("scripttext") Then
      screngver = 0
      If Request("scripteng") = "yes" Then screngver = screngver + 1
      If Request("verify") = "yes" Then screngver = screngver + 4
      If Request("verb") = "limit" Then verbs = "," & Request("limitverbs")
      NewScript = Request("scripttext") & "," & Request("scriptpath") & "," & screngver & verbs
      NewScriptMaps(x) = NewScript
    Else
      NewScriptMaps(x) = ScriptMaps(x)
    End If
  Next
  objSiteRoot.ScriptMaps = NewScriptMaps
  objSiteRoot.SetInfo
  Set objSiteRoot = Nothing

  If err Then errs = "There was an error!<br>Err: " & Err.description Else errs = "Updated!"

End Sub

Sub AddScriptMap(errs)
' On Error Resume Next
  If Request("site") = 0 Then
    Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/W3SVC")
  Else
    Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/ROOT")
  End If

  ScriptMaps = objSiteRoot.ScriptMaps
  UPos = UBound(ScriptMaps) + 1
  NewScriptMaps = ScriptMaps
  ReDim Preserve NewScriptMaps(UPos)

    screngver = 0
    If Request("scripteng") = "yes" Then screngver = screngver + 1
    If Request("verify") = "yes" Then screngver = screngver + 4
    verbs = ""
    If Request("verb") = "limit" Then verbs = "," & Request("limitverbs")
    
    scrtxt = Request("scripttext")
    If Left(scrtxt,1) <> "." Then scrtxt = "." & scrtxt

    NewScript = scrtxt & "," & Request("scriptpath") & "," & screngver & verbs
    NewScriptMaps(UPos) = NewScript

  objSiteRoot.ScriptMaps = NewScriptMaps
  objSiteRoot.SetInfo
  Set objSiteRoot = Nothing

  If err Then errs = "There was an error!<br>Err: " & Err.description Else errs = "Added!"

End Sub

Sub RemoveScriptMap(errs)
On Error Resume Next
  If Request("site") = 0 Then
    Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/W3SVC")
  Else
    Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/ROOT")
  End If

  ScriptMaps = objSiteRoot.ScriptMaps
  LPos = UBound(ScriptMaps) - Request("CurSM").Count
  Dim NewScriptMaps()
  ReDim NewScriptMaps(LPos)

  cnt = 0
  For x = 0 to Ubound(ScriptMaps)
    bRemove = False
    Script = Split(ScriptMaps(x),",")
    For i = 1 to Request("CurSM").Count
      If Script(0) = Request("CurSM").Item(i) Then bRemove = True
    Next
    If bRemove = False Then
      NewScriptMaps(cnt) = ScriptMaps(x)
      cnt = cnt + 1
    End If
  Next

  objSiteRoot.ScriptMaps = NewScriptMaps
  objSiteRoot.SetInfo

  Set objSiteRoot = Nothing

  If err Then errs = "There was an error!<br>Err: " & Err.description Else errs = "Removed!"

End Sub

Sub Change_MaxConnections(errs)
On Error Resume Next
  If Request("site") = 0 Then
    Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC")
    ServerComment = "Master WWW"
  Else
    Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site"))
    ServerComment = objSite.ServerComment
  End If

  MCValue = Request("MCValue") 'From the form

  Select Case Application("IISVer")
    Case 5
      MCUpperLimit = "2000000000"
    Case 6
      MCUpperLimit = "4294967295"
  End Select

  If MCValue >= 2000000000 Then MCValue = MCUpperLimit

  objSite.MaxConnections = MCValue
  objSite.SetInfo
  Set objSite = Nothing

  If err Then errs = "There was an error!<br>Err: " & Err.description Else errs = "Updated!"

End Sub
 








Sub Change_HTTPRedir(errs)
On Error Resume Next
  If Request("site") = 0 Then errs = "Invalid Site"
  
  Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/ROOT")

  If Len(Request("remove")) Then
    objSiteRoot.PutEx "1", "HTTPRedirect", ""
  Else
    newHTTPRedir = Request("httpredirstr")
    If Request("httpRedirExURL") = "yes" Then newHTTPRedir = newHTTPRedir & ", EXACT_DESTINATION"
    If Request("httpRedirDirBelow") = "yes" Then newHTTPRedir = newHTTPRedir & ", CHILD_ONLY"
    If Request("httpRedirPerm") = "yes" Then newHTTPRedir = newHTTPRedir & ", PERMANENT"
    objSiteRoot.Put "HttpRedirect", newHTTPRedir
    objSiteRoot.SetInfo
  End If

  Set objSiteRoot = Nothing

  If err Then errs = "There was an error!<br>Err: " & Err.description Else errs = "Updated!"

End Sub

Sub Change_DocFoot(errs)
On Error Resume Next
  If Request("site") = 0 Then
    Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/W3SVC")
  Else
    Set objSiteRoot = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/ROOT")
  End If

  If Len(Request("remove")) Then
    objSiteRoot.EnableDocFooter = False
    objSiteRoot.DefaultDocFooter = ""
    objSiteRoot.SetInfo
  Else
    'add check for file exists
    objSiteRoot.EnableDocFooter = True
    objSiteRoot.DefaultDocFooter = "FILE:" & Trim(Request("docfootstr"))
    objSiteRoot.SetInfo
  End If

  Set objSiteRoot = Nothing

  If err Then errs = "There was an error!<br>Err: " & Err.description Else errs = "Updated!"

End Sub


Sub Change_Logging(errs)
On Error Resume Next
  If Request("site") = 0 Then
    Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC")
  Else
    Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site"))
  End If

  If Len(Request("logen")) Then
    'Switch the flag, 1 = Logging enabled, 0 = no logging
    If objSite.LogType = 1 Then objSite.LogType = 0 Else objSite.LogType = 1
  End If

  If Len(Request("switchlogtype")) Then
    objSite.LogPluginClsid = Request("logtype")
  End If


  If Len(Request("commit")) Then
    If Len(Request("rollover")) Then objSite.LogFileLocaltimeRollover = True Else objSite.LogFileLocaltimeRollover = False
    If Len(Request("LogExtFileBytesRecv")) Then objSite.LogExtFileBytesRecv = True Else objSite.LogExtFileBytesRecv = False
    If Len(Request("LogExtFileBytesSent")) Then objSite.LogExtFileBytesSent = True Else objSite.LogExtFileBytesSent = False
    If Len(Request("LogExtFileClientIp")) Then objSite.LogExtFileClientIp = True Else objSite.LogExtFileClientIp = False
    If Len(Request("LogExtFileComputerName")) Then objSite.LogExtFileComputerName = True Else objSite.LogExtFileComputerName = False
    If Len(Request("LogExtFileCookie")) Then objSite.LogExtFileCookie = True Else objSite.LogExtFileCookie = False
    If Len(Request("LogExtFileDate")) Then objSite.LogExtFileDate = True Else objSite.LogExtFileDate = False
    If Application("IISVer") = 6 Then
      If Len(Request("LogExtFileHost")) Then objSite.LogExtFileHost = True Else objSite.LogExtFileHost = False
    End If
    If Len(Request("LogExtFileHttpStatus")) Then objSite.LogExtFileHttpStatus = True Else objSite.LogExtFileHttpStatus = False
    If Application("IISVer") = 6 Then
      If Len(Request("LogExtFileHttpSubStatus")) Then objSite.LogExtFileHttpSubStatus = True Else objSite.LogExtFileHttpSubStatus = False
    End If
    If Len(Request("LogExtFileMethod")) Then objSite.LogExtFileMethod = True Else objSite.LogExtFileMethod = False
    If Len(Request("LogExtFileProtocolVersion")) Then objSite.LogExtFileProtocolVersion = True Else objSite.LogExtFileProtocolVersion = False
    If Len(Request("LogExtFileReferer")) Then objSite.LogExtFileReferer = True Else objSite.LogExtFileReferer = False
    If Len(Request("LogExtFileServerIp")) Then objSite.LogExtFileServerIp = True Else objSite.LogExtFileServerIp = False
    If Len(Request("LogExtFileServerPort")) Then objSite.LogExtFileServerPort = True Else objSite.LogExtFileServerPort = False
    If Len(Request("LogExtFileSiteName")) Then objSite.LogExtFileSiteName = True Else objSite.LogExtFileSiteName = False
    If Len(Request("LogExtFileTime")) Then objSite.LogExtFileTime = True Else objSite.LogExtFileTime = False
    If Len(Request("LogExtFileTimeTaken")) Then objSite.LogExtFileTimeTaken = True Else objSite.LogExtFileTimeTaken = False
    If Len(Request("LogExtFileUriQuery")) Then objSite.LogExtFileUriQuery = True Else objSite.LogExtFileUriQuery = False
    If Len(Request("LogExtFileUriStem")) Then objSite.LogExtFileUriStem = True Else objSite.LogExtFileUriStem = False
    If Len(Request("LogExtFileUserAgent")) Then objSite.LogExtFileUserAgent = True Else objSite.LogExtFileUserAgent = False
    If Len(Request("LogExtFileUserName")) Then objSite.LogExtFileUserName = True Else objSite.LogExtFileUserName = False
    If Len(Request("LogExtFileWin32Status")) Then objSite.LogExtFileWin32Status = True Else objSite.LogExtFileWin32Status = False

    If Len(Request("fileperiod")) Then
      fileperiod = Request("fileperiod")
      If fileperiod = "5" Then fileperiod = "0"
        objSite.LogFilePeriod = fileperiod
        If Request("fileperiod") = "0" Then
          If Request("filesize") < 4096 Then objSite.LogFileTruncateSize = Request("filesize") * 1048576 Else objSite.LogFileTruncateSize = "4294967295"
        End If
        If Request("fileperiod") = "5" Then objSite.LogFileTruncateSize = "4294967295"
    End If

    If Len(Request("LogODBCDataSource")) Then
      objSite.LogODBCDataSource = Request("LogODBCDataSource")
      objSite.LogODBCTableName = Request("LogODBCTableName")
      objSite.LogODBCUserName = Request("LogODBCUserName")
      objSite.LogODBCPassword = Request("LogODBCPassword")
    End If

  End If

  objSite.SetInfo
  Set objSite = Nothing
  If err Then errs = "There was an error!<br>Err: " & Err.description Else errs = "Updated!"

End Sub


%>
