<%
'#################################################################################
'## IIS Admin Control Panel v 1.0
'#################################################################################
'## Copyright (C) 2005 Jake Gardner, Chris Hood
'##  from now on, referred to as "we" or "us"
'##
'##   This is a legally binding agreement between you and us, the developers
'## of the software program ("IIS Admin Control Panel") which you are about to
'## accept through electronic distribution (downloading).  By downloading and
'## using this software you are agreeing and will have agreed to be bound by
'## the terms set forth below.
'##
'##   License Grant and Restrictions. We grant you and you accept a
'## non-exclusive license to use the IIS Admin Control Panel but you do not
'## acquire any rights of ownership or distribution in whole or part. We are
'## the exclusive owners of the IIS Admin Control Panel which is copyrighted.
'## This license permits you to use and modify the IIS Admin Control Panel for
'## your personal or company. You may not rent, lease, sub-license, assign,
'## loan, create a derivative work based on content or otherwise use or
'## transfer use of the Software or any part thereof to others. You may not
'## reverse engineer, reverse compile, disassemble or otherwise modify the
'## Software in any way.  You may not remove any proprietary notices that are
'## provided with or within the software and/or sourcecode.  Neither the
'## Software nor any underlying information or technology may be exported or
'## re-exported into any country to which the United States has prohibited
'## export.
'##
'##   No Warranties. You acknowledge that the software has been provided to you
'## free of charge for your personal use and evaluation. You assume
'## responsibility for the selection of the software to achieve your intended
'## results and for the proper installation, use and results obtained from use
'## of the IIS Admin Control Panel. WE MAKE NO REPRESENTATION OR WARRANTY OF
'## ANY KIND WITH RESPECT TO THE SOFTWARE OR THE RESULTS OBTAINED OR TO BE
'## OBTAINED FROM ITS USE. WE DO NOT WARRANT THAT YOUR USE OF THE SOFTWARE WILL
'## BE UNINTERRUPTED, ERROR-FREE OR VIRUS-FREE.  ALL WARRANTIES, EXPRESS OR
'## IMPLIED, INCLUDING THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
'## PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE HEREBY EXPRESSLY DISCLAIMED.
'## WE EXPRESSLY DISCLAIM ANY IMPLIED WARRANTY THAT ANY OTHER PRODUCT
'## (INCLUDING WITHOUT LIMITATION ANY COPY OF THE SOFTWARE YOU MAY SUBSEQUENTLY
'## PURCHASE) WILL CONFORM TO THE SOFTWARE PROVIDED TO YOU UNDER THIS
'## AGREEMENT.
'##
'##   IN NO EVENT SHALL WE OR THEIR SUPPLIERS OR DISTRIBUTOR(S) OR AGENTS BE
'## LIABLE FOR ANY DAMAGE ARISING OUT OF OR RELATED TO THE USE OF THIS PRODUCT,
'## INCLUDING WITHOUT LIMITATION ACTUAL, DIRECT, SPECIAL, CONSEQUENTIAL,
'## INDIRECT, EXEMPLARY OR PUNITIVE DAMAGES, WHETHER OR NOT SUCH DAMAGES WERE
'## FORESEEABLE AND EVEN IF WE WERE ADVISED THAT SUCH DAMAGES WERE LIKELY OR
'## POSSIBLE.
'##
'## Support can be obtained from our support forums at:
'## http://www.iisactive.com
'##
'## Correspondence and Marketing Questions can be sent to:
'## iacp@iisactive.com
'##
'#################################################################################
%>

<!-- #INCLUDE FILE="common\Functions.inc" -->
<!-- #INCLUDE FILE="common\Functions_Logging.inc" -->
<!-- #INCLUDE FILE="common\IPFuncs.inc" -->
<%
If Len(request("return")) Then Response.Redirect ("manage_SMTPSVC.asp?site=" & Request("site"))
If Len(Request("site")) Then site = Request("site")
%>

<!-- #INCLUDE FILE="common\head.inc" -->
<DIV id="maincontent">

<%
errs = ""
Select Case LCase(Request("action"))
  Case "change_auth" 
    Call Change_Auth()
  Case "change_logdir"
    Call ChangeLogDir()
  Case "change_bmdir"
    Call ChangeBMDir()
  Case "change_ddir"
    Call ChangeDDir()
  Case "change_pudir"
    Call ChangePUDir()
  Case "change_qdir"
    Call ChangeQDir()
  Case "change_smarthost"
    Call ChangeSmartHost()
  Case "change_masqdom"
    Call ChangeMasqDom()
  Case "change_locexp"
    Call ChangeLocExp()
  Case "change_remexp"
    Call ChangeRemExp()
  Case "change_comto"
    Call ChangeComTO()
  Case "change_bad"
    Call ChangeBad()
  Case "change_ndr"
    Call ChangeNDR()
  Case "change_ndrlocexp"
    Call ChangeNDRLocExp()
  Case "change_ndrremexp"
    Call ChangeNDRRemExp()
  Case "auth"
    Call Auth()
  Case "logpath"
    Call LogDir()
  Case "bmdir"
    Call BMDir()
  Case "ddir"
    Call DDir()
  Case "pudir"
    Call PUDir()
  Case "qdir"
    Call QDir()
  Case "smarthost"
    Call SmartHost()
  Case "masqdom"
    Call MasqDom()
  Case "locexp"
    Call LocExp()
  Case "remexp"
    Call RemExp()
  Case "comto"
    Call ComTO()
  Case "bad"
    Call Bad()
  Case "ndr"
    Call NDR()
  Case "ndrlocexp"
    Call NDRLocExp()
  Case "ndrremexp"
    Call NDRRemExp()
  Case "serbind"
    Call ServerBinds(errs)
  Case "change_serbinds"
    Call ChangeSerBinds(errs)
    Call ServerBinds(errs)
  Case "change_logging"
    Call Change_Logging(errs)
    Call Logging(errs)
  Case "logging"
    Call Logging(errs)
End Select

'##Here's where we display the different configuration properties.
Sub Bad()
  Set objSite = GetObject("IIS://" & Application("Server") & "/SmtpSvc/" & Request("site"))
%>
<TABLE width=50%>
<form method="post" action="smtpsvc_site_config.asp?action=change_bad">
<Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TR><TH colspan=2>Manage Postmaster Email Address for:<br><%=objSite.ServerComment%></TH></TR>
  <TR><TH>Current</TH>
	  <TD>
		<%
			If objSite.SendNdrTo = "" OR objSite.SendBadTo = "Postmaster" Then
			response.write "No Postmaster address set!"
		  Else
			response.write objSite.SendBadTo
		  End If
		%>
	  </TD>
  </TR>
  <TR><TH>New</TH><TD><input type="text" name="bad" id="GiveMeFocus" value="<%=objSite.SendBadTo%>"></TD></TR>
  <TR><TD colspan=2>All mail servers should have a Postmaster email address.</TD></TR>
  <TR>
    <TD colspan="2">
      <input type="submit" Value="Commit Modifications">&nbsp;&nbsp;<input type="Submit" name="return" value="Return">
    </TD>
  </TR>
</form>
</table>
<%
End Sub

Sub NDR()
  Set objSite = GetObject("IIS://" & Application("Server") & "/SmtpSvc/" & Request("site"))
%>
<TABLE width="50%">
<form method="post" action="smtpsvc_site_config.asp?action=change_ndr">
<Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TR><TH colspan=2>Manage Non-Delivery Report for:<br><%=objSite.ServerComment%></TH></TR>
  <TR><TH>Current</TH>
	  <TD>
		<%
			If objSite.SendNdrTo = "" Then
			response.write "* No Non-Delivery Report address set!"
		  Else
			response.write objSite.SendNdrTo
		  End If
		%>
	  </TD>
  </TR>
  <TR><TH>New</TH><TD><input type="text" name="ndr" id="GiveMeFocus" value="<%=objSite.SendNdrTo%>"></TD></TR>
  <TR><TD colspan=2>A Non-Delivery Report is a message automatically sent to the original author of any message that cannot be delivered.</TD></TR>
  <TR>
    <TD colspan="2">
      <input type="submit" Value="Commit Modifications">&nbsp;&nbsp;<input type="Submit" name="return" value="Return">
    </TD>
  </TR>
</form>
</table>
<%
End Sub

Sub NDRLocExp()
  Set objSite = GetObject("IIS://" & Application("Server") & "/SmtpSvc/" & Request("site"))
%>
<TABLE width="50%">
<form method="post" action="smtpsvc_site_config.asp?action=change_ndrlocexp">
<Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TR><TH colspan=2>Manage Non-Delivery Report Local Expire for:<br><%=objSite.ServerComment%> </TH></TR>
  <TR><TH>Current</TH><TD><%=objSite.SmtpLocalNDRExpireMinutes%></TD></TR>
  <TR><TH>New</TH><TD><input type="text" name="ndrlocexp" id="GiveMeFocus" value="<%=objSite.SmtpLocalNDRExpireMinutes%>"></TD></TR>
  <TR><TD colspan=2>Please provide the amount of seconds till NDR local deliveries will be forward to the email address specified for NDR's.</TD></TR>
  <TR>
    <TD colspan="2">
      <input type="submit" Value="Commit Modifications">&nbsp;&nbsp;<input type="Submit" name="return" value="Return">
    </TD>
  </TR>
</form>
</table>
<%
End Sub

Sub NDRRemExp()
  Set objSite = GetObject("IIS://" & Application("Server") & "/SmtpSvc/" & Request("site"))
%>
<TABLE width="50%">
<form method="post" action="smtpsvc_site_config.asp?action=change_ndrremexp">
<Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TR><TH colspan=2>Manage Non-Delivery Report Remote Expire for:<br><%=objSite.ServerComment%> </TH></TR>
  <TR><TH>Current</TH><TD><%=objSite.SmtpRemoteNDRExpireMinutes%></TD></TR>
  <TR><TH>New</TH><TD><input type="text" name="ndrremexp" id="GiveMeFocus" value="<%=objSite.SmtpRemoteNDRExpireMinutes%>"></TD></TR>
  <TR><TD colspan=2>Please provide the amount of seconds till NDR remote deliveries will be forward to the email address specified for NDR's.</TD></TR>
  <TR>
    <TD colspan="2">
      <input type="submit" Value="Commit Modifications">&nbsp;&nbsp;<input type="Submit" name="return" value="Return">
    </TD>
  </TR>
</form>
</table>
<%
End Sub

Sub MasqDom()
  Set objSite = GetObject("IIS://" & Application("Server") & "/SmtpSvc/" & Request("site"))
%>
<TABLE width="50%">
<form method="post" action="smtpsvc_site_config.asp?action=change_masqdom">
<Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TR><TH colspan=2>Manage Masquerade Domain for:<br><%=objSite.ServerComment%></TH></TR>
  <TR><TH>Current</TH>
	  <TD>
		<%
			If objSite.MasqueradeDomain = "" Then
			response.write "No Masquerade Domain Set"
		  Else
			response.write objSite.MasqueradeDomain
		  End If
		%>
	  </TD>
  </TR>
  <TR><TH>New</TH><TD><input type="text" name="masqdom" id="GiveMeFocus" value="<%=objSite.MasqueradeDomain%>"></TD></TR>
  <TR><TD colspan=2>The masquerade domain is the domain name substituted in the header of an outgoing message in place of the name of the default local e-mail domain. </TD></TR>
  <TR>
    <TD colspan="2">
      <input type="submit" Value="Commit Modifications">&nbsp;&nbsp;<input type="Submit" name="return" value="Return">
    </TD>
  </TR>
</form>
</table>
<%
End Sub

Sub LocExp()
  Set objSite = GetObject("IIS://" & Application("Server") & "/SmtpSvc/" & Request("site"))
%>
<TABLE width="50%">
<form method="post" action="smtpsvc_site_config.asp?action=change_locexp">
<Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TR><TH colspan=2>Manage SMTP Local Delay Expire for:<br><%=objSite.ServerComment%> </TH></TR>
  <TR><TH>Current</TH><TD><%= objSite.SmtpLocalDelayExpireMinutes%></TD></TR>
  <TR><TH>New</TH><TD><input type="text" name="locexp" id="GiveMeFocus" value="<%=objSite.SmtpLocalDelayExpireMinutes%>"></TD></TR>
  <TR><TD colspan=2>Please provide the amount of seconds till local deliveries will time-out.</TD></TR>
  <TR>
    <TD colspan="2">
      <input type="submit" Value="Commit Modifications">&nbsp;&nbsp;<input type="Submit" name="return" value="Return">
    </TD>
  </TR>
</form>
</table>
<%
End Sub

Sub RemExp()
  Set objSite = GetObject("IIS://" & Application("Server") & "/SmtpSvc/" & Request("site"))
%>
<TABLE width="50%">
<form method="post" action="smtpsvc_site_config.asp?action=change_remexp">
<Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TR><TH colspan=2>Manage Smtp Remote Delay Expire for:<br><%=objSite.ServerComment%></TH></TR>
  <TR><TH>Current</TH><TD><%= objSite.SmtpRemoteDelayExpireMinutes%></TD></TR>
  <TR><TH>New</TH><TD><input type="text" name="remexp" id="GiveMeFocus" value="<%=objSite.SmtpRemoteDelayExpireMinutes%>"></TD></TR>
  <TR><TD colspan=2>Please provide the amount of seconds till remote deliveries will time-out.</TD></TR>
  <TR>
    <TD colspan="2">
      <input type="submit" Value="Commit Modifications">&nbsp;&nbsp;<input type="Submit" name="return" value="Return">
    </TD>
  </TR>
</form>
</table>
<%
End Sub

Sub ComTO()
  Set objSite = GetObject("IIS://" & Application("Server") & "/SmtpSvc/" & Request("site"))
%>
<TABLE width="50%">
<form method="post" action="smtpsvc_site_config.asp?action=change_comto">
<Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TR><TH colspan=2>Manage Connection Timeout for:<br><%=objSite.ServerComment%></TH></TR>
  <TR><TH>Current</TH><TD><%= objSite.ConnectionTimeout%></TD></TR>
  <TR><TH>New</TH><TD><input type="text" name="comto" id="GiveMeFocus" value="<%=objSite.ConnectionTimeout%>"></TD></TR>
  <TR><TD colspan=2>Please provide the amount of seconds till connections will time-out.</TD></TR>
  <TR>
    <TD colspan="2">
      <input type="submit" Value="Commit Modifications">&nbsp;&nbsp;<input type="Submit" name="return" value="Return">
    </TD>
  </TR>
</form>
</table>
<%
End Sub


Sub BMDir()
  Set objSite = GetObject("IIS://" & Application("Server") & "/SmtpSvc/" & Request("site"))
%>
<TABLE width="50%">
<form method="post" action="smtpsvc_site_config.asp?action=change_bmdir">
<Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TR><TH colspan=2>Manage Bad Mail Directory for:<br><%=objSite.ServerComment%></TH></TR>
  <TR><TH>Current</TH><TD><%= objSite.BadMailDirectory%></TD></TR>
  <TR><TH>New</TH><TD><input type="text" name="bmdir" id="GiveMeFocus" value="<%=objSite.BadMailDirectory%>"></TD></TR>
  <TR><TD colspan=2>There is no need for a trailing slash.	If the physical path does not exist the site will not start.</TD></TR>
  <TR>
    <TD colspan="2">
      <input type="submit" Value="Commit Modifications">&nbsp;&nbsp;<input type="Submit" name="return" value="Return">
    </TD>
  </TR>
</form>
</table>
<%
End Sub

Sub DDir()
  Set objSite = GetObject("IIS://" & Application("Server") & "/SmtpSvc/" & Request("site"))
%>
<TABLE width="50%">
<form method="post" action="smtpsvc_site_config.asp?action=change_ddir">
<Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TR><TH colspan=2>Manage Drop Directory for:<br><%=objSite.ServerComment%></TH></TR>
  <TR><TH>Current</TH><TD><%= objSite.DropDirectory%></TD></TR>
  <TR><TH>New</TH><TD><input type="text" name="ddir" id="GiveMeFocus" value="<%=objSite.DropDirectory%>"></TD></TR>
  <TR><TD colspan=2>There is no need for a trailing slash.	If the physical path does not exist the site will not start.</TD></TR>
  <TR>
    <TD colspan="2">
      <input type="submit" Value="Commit Modifications">&nbsp;&nbsp;<input type="Submit" name="return" value="Return">
    </TD>
  </TR>
</form>
</table>
<%
End Sub

Sub PUDir()
  Set objSite = GetObject("IIS://" & Application("Server") & "/SmtpSvc/" & Request("site"))
%>
<TABLE width="50%">
<form method="post" action="smtpsvc_site_config.asp?action=change_pudir">
<Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TR><TH colspan=2>Manage PickUp Directory for:<br><%=objSite.ServerComment%></TH></TR>
  <TR><TH>Current</TH><TD><%= objSite.PickUpDirectory%></TD></TR>
  <TR><TH>New</TH><TD><input type="text" name="pudir" id="GiveMeFocus" value="<%=objSite.PickUpDirectory%>"></TD></TR>
  <TR><TD colspan=2>There is no need for a trailing slash.	If the physical path does not exist the site will not start.</TD></TR>
  <TR>
    <TD colspan="2">
      <input type="submit" Value="Commit Modifications">&nbsp;&nbsp;<input type="Submit" name="return" value="Return">
    </TD>
  </TR>
</form>
</table>
<%
End Sub

Sub QDir()
  Set objSite = GetObject("IIS://" & Application("Server") & "/SmtpSvc/" & Request("site"))
%>
<TABLE width="50%">
<form method="post" action="smtpsvc_site_config.asp?action=change_qdir">
<Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TR><TH colspan=2>Manage Queue Directory for:<br><%=objSite.ServerComment%></TH></TR>
  <TR><TH>Current</TH><TD><%= objSite.QueueDirectory%></TD></TR>
  <TR><TH>New</TH><TD><input type="text" name="qdir" id="GiveMeFocus" value="<%=objSite.QueueDirectory%>"></TD></TR>
  <TR><TD colspan=2>There is no need for a trailing slash.	If the physical path does not exist the site will not start.</TD></TR>
  <TR>
    <TD colspan="2">
      <input type="submit" Value="Commit Modifications">&nbsp;&nbsp;<input type="Submit" name="return" value="Return">
    </TD>
  </TR>
</form>
</table>
<%
End Sub

Sub SmartHost()
  Set objSite = GetObject("IIS://" & Application("Server") & "/SmtpSvc/" & Request("site"))
%>
<TABLE width="50%">
<form method="post" action="smtpsvc_site_config.asp?action=change_smarthost">
<Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TR><TH colspan=2>Manage Smarthost for:<br><%=objSite.ServerComment%></TH></TR>
  <TR>
    <TH>Current</TH>
    <TD>
      <%
			  If objSite.smarthost = "" Then
			    response.write "No Smarthost set"
		    Else
			    response.write objSite.smarthost
		    End If
		  %>
    </TD>
  </TR>
  <TR><TH>New</TH><TD><input type="text" name="sh" id="GiveMeFocus" value="<%=objSite.SmartHost%>"></TD></TR>
  <TR><TD colspan=2>A Smarthost is an SMTP server that receives, from the local SMTP server, all messages destined for remote domains; the smart host is similar to a default SMTP gateway.</TD></TR>
  <TR>
    <TD colspan="2">
      <input type="submit" Value="Commit Modifications">&nbsp;&nbsp;<input type="Submit" name="return" value="Return">
    </TD>
  </TR>
</form>
</table>
<%
End Sub

Sub ServerBinds(errs)
  Set objSite = GetObject("IIS://" & Application("Server") & "/SmtpSvc/" & Request("site"))
  hhip = objSite.ServerBindings
  CurHH = Split(hhip(0),":")
  SelectedValue = CurHH(0)
%>
<form method="post" action="smtpsvc_site_config.asp?action=change_serbinds">
<Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TABLE width="75%">
    <TR><TH colspan=2>Manage Site's IP address and Port</TH></TR>
    <TR><TD colspan="2">&nbsp;<%=errs%></TD></TR>
    <TR>
      <TD><%= ReturnNextFreeIPAddress(SelectedValue) %>&nbsp;:&nbsp;<input type="text" name="Port" size="2" value="<%=CurHH(1)%>"></TD>
      <TD>
        <input type="submit" name="update" value="Update">
      </TD>
    </TR>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <TR><TD colspan="2"><input type="submit" name="return" value="Manage Site"></TD></TR>
  </table>
</form>
<%
End Sub

Sub LogDir()
  Set objSite = GetObject("IIS://" & Application("Server") & "/SmtpSvc/" & Request("site"))
	If objSite.LogFileDirectory = "" Then
	  curld = objSite.LogFileDirectory & "\SmtpSvc" & Request("site")
	Else
	  curld = objSite.LogFileDirectory
	End If
%>
<TABLE width="50%">
<form method="post" action="smtpsvc_site_config.asp?action=change_logdir">
<Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TR><TH colspan=2>Manage Log File Directory for:<br><%=objSite.ServerComment%></TH></TR>
  <TR><TH>Current</TH><TD><%=curld%>\SmtpSvc<%=Request("site")%></TD></TR>
  <TR><TH>New</TH><TD><input type="text" name="newld" id="GiveMeFocus" value="<%=curld%>"size="90%">\SmtpSvc<%=Request("site")%></TD></TR>
  <TR>
	<TD class="config_note" colspan=2>
	  <ul>
		<li>There is no need for a trailing slash.</li>
		<li>%WinDir% is system Enviornment Variable that points to your System Root which is normally "C:\winnt\"</li>
		<li>A directory of "SmtpSvc" with the Metabase ID number will be created automatically, please do not include it. It is a limitation of IIS not this script.</li>
	  </ul>
	</TD>
  </TR>
  <TR>
    <TD colspan="2">
      <input type="submit" Value="Commit Modifications">&nbsp;&nbsp;<input type="Submit" name="return" value="Return">
    </TD>
  </TR>
</form>
</table>
<%
End Sub

Sub Auth()
  Set objSite = GetObject("IIS://" & Application("Server") & "/SmtpSvc/" & Request("site"))
%>
<TABLE width="50%">
  <form method="post" action="smtpsvc_site_config.asp?action=change_auth">
	<Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TR>
	<TH colspan=2>Manage Authentication Methods for:<br><%=objSite.ServerComment%></TH>
  </TR>
  <TR>
	<TH>Current</TH>
	<TD>
	<%
	  Select Case objSite.AuthFlags
		Case 0
		  Response.Write "No Access"
		Case 1
		  Response.Write "Anonymous Only"
		Case 2
		  Response.Write "Basic(Clear Text) Only, No Anonymous"
		Case 3
		  Response.Write "Basic(Clear Text) and Anonymous"
		Case 4
		  Response.Write "NTLM Only"
		Case 5
		  Response.Write "NTLM and Anonymous"
		Case 6
		  Response.Write "Basic and NTLM, No Anonymous"
		Case 7
		  Response.Write "Basic, NTLM, and Anonymous"
		Case Else
		  Response.Write "Error getting AuthFlags" & objSite.AuthFlags
	  End Select
	  %>
	</TD>
  </TR>
  <TR>
	<TH>New</TH>
	<TD>
	 <select name="authlev" id="GiveMeFocus">
	   <OPTION value=0 <%if objSite.AuthFlags = 0 then response.write "SELECTED" %>>No Access</option>
	   <OPTION value=1 <%if objSite.AuthFlags = 1 then response.write "SELECTED" %>>Anonymous Only</option>
	   <OPTION value=2 <%if objSite.AuthFlags = 2 then response.write "SELECTED" %>>Basic(Clear Text) Only, No Anonymous</option>
	   <OPTION value=3 <%if objSite.AuthFlags = 3 then response.write "SELECTED" %>>Basic(Clear Text) and Anonymous</option>
	   <OPTION value=4 <%if objSite.AuthFlags = 4 then response.write "SELECTED" %>>NTLM Only</option>
	   <OPTION value=5 <%if objSite.AuthFlags = 5 then response.write "SELECTED" %>>NTLM and Anonymous</option>
	   <OPTION value=6 <%if objSite.AuthFlags = 6 then response.write "SELECTED" %>>Basic and NTLM, No Anonymous</option>
	   <OPTION value=7 <%if objSite.AuthFlags = 7 then response.write "SELECTED" %>>Basic, NTLM, and Anonymous</option>
	 </select>
	</TD>
  </TR>
  <TR><TD colspan=2>Please make your selection using the dropdown box to select which form(s) of Authentication you would like.</TD></TR>
  <TR>
    <TD colspan="2">
      <input type="submit" Value="Commit Modifications">&nbsp;&nbsp;<input type="Submit" name="return" value="Return">
    </TD>
  </TR>
</form>
</table>
<%
End Sub

Sub Logging(errs)
On Error Resume Next
  If Request("site") = 0 Then
    Set objSite = GetObject("IIS://" & Application("Server") & "/SMTPSVC")
    ServerComment = "Master SMTP"
  Else
    Set objSite = GetObject("IIS://" & Application("Server") & "/SMTPSVC/" & Request("site"))
    ServerComment = objSite.ServerComment
  End If
  Session("svc") = "SMTPSVC"
  
  curLogType = objSite.LogPluginClsid
  If curLogType = "{FF160663-DE82-11CF-BC0A-00AA006111E0}" Then Session("rollover") = objSite.LogFileLocaltimeRollover
  If curLogType <> "{FF16065B-DE82-11CF-BC0A-00AA006111E0}" Then 
    Session("fileperiod") = objSite.LogFilePeriod
    Session("filesize") = objSite.LogFileTruncateSize
  Else
    Session("LogODBCDataSource") = objSite.LogODBCDataSource
    Session("LogODBCTableName") = objSite.LogODBCTableName
    Session("LogODBCUserName") = objSite.LogODBCUserName
    Session("LogODBCPassword") = objSite.LogODBCPassword
  End If

  logen = "enabled"
  logen_button = "<input type=""submit"" name=""logen"" value=""Disable"">"
  If objSite.LogType = 0 Then
    logen = "disabled"
    logen_button = "<input type=""submit"" name=""logen"" value=""Enable"">"
  End If

%>
<form name="theform" method="post" action="smtpsvc_site_config.asp?action=change_logging">
  <Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TABLE>
    <TR><TH colspan="2">Manage <%=ServerComment%> Logging Options</TH></TR>
    <TR><TD colspan="2">&nbsp;<%=errs%></TD></TR>
    <TR><TD>Logging is <%=logen%></TD><TD><%=logen_button%></TD></TR>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <TR><TD><%=GetLogTypes(curLogType)%></TD><TD><input type="submit" name="switchlogtype" value="Switch"></TD></TR>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <%= LogOptionsDisplay(curLogType) %>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <TR><TD colspan="2"><input type="submit" name="commit" Value="Commit Modifications" >&nbsp;&nbsp;<input type="submit" name="return" value="Manage Site"></TD></TR>
  </TABLE>
</form>
<%

End Sub
%>

</DIV>
</Body>
</HTML>

<%
'#########################################
'#########################################
'Below is where the action takes place. All subs will redirect back to the site's display page with a message level.
Sub ChangeBAD()
  Set objSite = GetObject("IIS://" & Application("Server") & "/SmtpSvc/" & Request("site"))
  objSite.SendBadTo = Trim(Request("bad"))
  objSite.SetInfo
  Set objSite = nothing
  Response.Redirect ("manage_SmtpSvc.asp?site=" & Request("site") & "&tc=1")
End Sub
Sub ChangeNDR()
  Set objSite = GetObject("IIS://" & Application("Server") & "/SmtpSvc/" & Request("site"))
  objSite.SendNdrTo = Trim(Request("ndr"))
  objSite.SetInfo
  Set objSite = nothing
  Response.Redirect ("manage_SmtpSvc.asp?site=" & Request("site") & "&tc=1")
End Sub
Sub ChangeNDRLocExp()
  Set objSite = GetObject("IIS://" & Application("Server") & "/SmtpSvc/" & Request("site"))
  objSite.SmtpLocalNDRExpireMinutes = Trim(Request("ndrlocexp"))
  objSite.SetInfo
  Set objSite = nothing
  Response.Redirect ("manage_SmtpSvc.asp?site=" & Request("site") & "&tc=1")
End Sub
Sub ChangeNDRRemExp()
  Set objSite = GetObject("IIS://" & Application("Server") & "/SmtpSvc/" & Request("site"))
  objSite.SmtpRemoteNDRExpireMinutes = Trim(Request("ndrremexp"))
  objSite.SetInfo
  Set objSite = nothing
  Response.Redirect ("manage_SmtpSvc.asp?site=" & Request("site") & "&tc=1")
End Sub
Sub ChangeRelayIP()
  Set objSite = GetObject("IIS://" & Application("Server") & "/SmtpSvc/" & Request("site"))
  objSite.RelayIpList = Trim(Request("relayiplist"))
  objSite.SetInfo
  Set objSite = nothing
  Response.Redirect ("manage_SmtpSvc.asp?site=" & Request("site") & "&tc=1")
End Sub
Sub ChangeMasqDom()
  Set objSite = GetObject("IIS://" & Application("Server") & "/SmtpSvc/" & Request("site"))
  objSite.MasqueradeDomain = Trim(Request("masqdom"))
  objSite.SetInfo
  Set objSite = nothing
  Response.Redirect ("manage_SmtpSvc.asp?site=" & Request("site") & "&tc=1")
End Sub

Sub ChangeLocExp()
  Set objSite = GetObject("IIS://" & Application("Server") & "/SmtpSvc/" & Request("site"))
  objSite.SmtpLocalDelayExpireMinutes = Trim(Request("locexp"))
  objSite.SetInfo
  Set objSite = nothing
  Response.Redirect ("manage_SmtpSvc.asp?site=" & Request("site") & "&tc=1")
End Sub

Sub ChangeRemExp()
  Set objSite = GetObject("IIS://" & Application("Server") & "/SmtpSvc/" & Request("site"))
  objSite.SmtpRemoteDelayExpireMinutes = Trim(Request("remexp"))
  objSite.SetInfo
  Set objSite = nothing
  Response.Redirect ("manage_SmtpSvc.asp?site=" & Request("site") & "&tc=1")
End Sub

Sub ChangeComTO()
  Set objSite = GetObject("IIS://" & Application("Server") & "/SmtpSvc/" & Request("site"))
  objSite.ConnectionTimeout = Trim(Request("comto"))
  objSite.SetInfo
  Set objSite = nothing
  Response.Redirect ("manage_SmtpSvc.asp?site=" & Request("site") & "&tc=1")
End Sub

Sub ChangeBMDir()
  Set objSite = GetObject("IIS://" & Application("Server") & "/SmtpSvc/" & Request("site"))
  objSite.BadMailDirectory = Trim(Request("bmdir"))
  objSite.SetInfo
  Set objSite = nothing
  Response.Redirect ("manage_SmtpSvc.asp?site=" & Request("site") & "&tc=1")
End Sub

Sub ChangeDDir()
  Set objSite = GetObject("IIS://" & Application("Server") & "/SmtpSvc/" & Request("site"))
  objSite.DropDirectory = Trim(Request("ddir"))
  objSite.SetInfo
  Set objSite = nothing
  Response.Redirect ("manage_SmtpSvc.asp?site=" & Request("site") & "&tc=1")
End Sub

Sub ChangePUDir()
  Set objSite = GetObject("IIS://" & Application("Server") & "/SmtpSvc/" & Request("site"))
  objSite.PickUpDirectory = Trim(Request("pudir"))
  objSite.SetInfo
  Set objSite = nothing
  Response.Redirect ("manage_SmtpSvc.asp?site=" & Request("site") & "&tc=1")
End Sub

Sub ChangeQDir()
  Set objSite = GetObject("IIS://" & Application("Server") & "/SmtpSvc/" & Request("site"))
  objSite.QueueDirectory = Trim(Request("qdir"))
  objSite.SetInfo
  Set objSite = nothing
  Response.Redirect ("manage_SmtpSvc.asp?site=" & Request("site") & "&tc=1")
End Sub

Sub ChangeSmartHost()
  Set objSite = GetObject("IIS://" & Application("Server") & "/SmtpSvc/" & Request("site"))
  objSite.SmartHost = Trim(Request("sh"))
  objSite.SetInfo
  Set objSite = nothing
  Response.Redirect ("manage_SmtpSvc.asp?site=" & Request("site") & "&tc=1")
End Sub

Sub ChangeSerBinds(errs)
On Error Resume Next
  Set objSite = GetObject("IIS://" & Application("Server") & "/SmtpSvc/" & Request("site"))
    Dim hhiparr()
    ReDim hhiparr(0)
    hhiparr(0) = Request("IPAdd") & ":" & Request("port") & ":"
    objSite.ServerBindings = hhiparr
    objSite.SetInfo
  Set objSite = nothing
  If err = False Then Errs = "Updated" Else errs = "There was an error!<br>Err: " & err.description
End Sub

Sub ChangeLogDir()
  Set objSite = GetObject("IIS://" & Application("Server") & "/SmtpSvc/" & Request("site"))
  objSite.LogFileDirectory = Trim(Request("newld"))
  objSite.SetInfo
  Set objSite = nothing
  Response.Redirect ("manage_SmtpSvc.asp?site=" & Request("site") & "&tc=1")
End Sub

Sub Change_Auth()
  Set objSite = GetObject("IIS://" & Application("Server") & "/SmtpSvc/" & Request("site") & "/ROOT")
	objSite.AuthFlags = Request("authlev")
		objSite.SetInfo
  Set objSite = Nothing
  Response.Redirect ("manage_SmtpSvc.asp?site=" & Request("site") & "&tc=1")
End Sub

Sub Change_Logging(errs)
On Error Resume Next
  If Request("site") = 0 Then
    Set objSite = GetObject("IIS://" & Application("Server") & "/SMTPSVC")
  Else
    Set objSite = GetObject("IIS://" & Application("Server") & "/SMTPSVC/" & Request("site"))
  End If

  If Len(Request("logen")) Then
    'Switch the flag, 1 = Logging enabled, 0 = no logging
    If objSite.LogType = 1 Then objSite.LogType = 0 Else objSite.LogType = 1
  End If

  If Len(Request("switchlogtype")) Then
    objSite.LogPluginClsid = Request("logtype")
  End If


  If Len(Request("commit")) Then
'     If Len(Request("rollover")) Then objSite.LogFileLocaltimeRollover = True Else objSite.LogFileLocaltimeRollover = False
    If Len(Request("LogExtFileBytesRecv")) Then objSite.LogExtFileBytesRecv = True Else objSite.LogExtFileBytesRecv = False
    If Len(Request("LogExtFileBytesSent")) Then objSite.LogExtFileBytesSent = True Else objSite.LogExtFileBytesSent = False
    If Len(Request("LogExtFileClientIp")) Then objSite.LogExtFileClientIp = True Else objSite.LogExtFileClientIp = False
    If Len(Request("LogExtFileComputerName")) Then objSite.LogExtFileComputerName = True Else objSite.LogExtFileComputerName = False
    If Len(Request("LogExtFileCookie")) Then objSite.LogExtFileCookie = True Else objSite.LogExtFileCookie = False
    If Len(Request("LogExtFileDate")) Then objSite.LogExtFileDate = True Else objSite.LogExtFileDate = False
    If Len(Request("LogExtFileHost")) Then objSite.LogExtFileHost = True Else objSite.LogExtFileHost = False
    If Len(Request("LogExtFileHttpStatus")) Then objSite.LogExtFileHttpStatus = True Else objSite.LogExtFileHttpStatus = False
    If Application("IISVer") = 6 Then
      If Len(Request("LogExtFileHttpSubStatus")) Then objSite.LogExtFileHttpSubStatus = True Else objSite.LogExtFileHttpSubStatus = False
    End If
    If Len(Request("LogExtFileMethod")) Then objSite.LogExtFileMethod = True Else objSite.LogExtFileMethod = False
    If Len(Request("LogExtFileProtocolVersion")) Then objSite.LogExtFileProtocolVersion = True Else objSite.LogExtFileProtocolVersion = False
    If Len(Request("LogExtFileReferer")) Then objSite.LogExtFileReferer = True Else objSite.LogExtFileReferer = False
    If Len(Request("LogExtFileServerIp")) Then objSite.LogExtFileServerIp = True Else objSite.LogExtFileServerIp = False
    If Len(Request("LogExtFileServerPort")) Then objSite.LogExtFileServerPort = True Else objSite.LogExtFileServerPort = False
    If Len(Request("LogExtFileSiteName")) Then objSite.LogExtFileSiteName = True Else objSite.LogExtFileSiteName = False
    If Len(Request("LogExtFileTime")) Then objSite.LogExtFileTime = True Else objSite.LogExtFileTime = False
    If Len(Request("LogExtFileTimeTaken")) Then objSite.LogExtFileTimeTaken = True Else objSite.LogExtFileTimeTaken = False
    If Len(Request("LogExtFileUriQuery")) Then objSite.LogExtFileUriQuery = True Else objSite.LogExtFileUriQuery = False
    If Len(Request("LogExtFileUriStem")) Then objSite.LogExtFileUriStem = True Else objSite.LogExtFileUriStem = False
    If Len(Request("LogExtFileUserAgent")) Then objSite.LogExtFileUserAgent = True Else objSite.LogExtFileUserAgent = False
    If Len(Request("LogExtFileUserName")) Then objSite.LogExtFileUserName = True Else objSite.LogExtFileUserName = False
    If Len(Request("LogExtFileWin32Status")) Then objSite.LogExtFileWin32Status = True Else objSite.LogExtFileWin32Status = False

    If Len(Request("fileperiod")) Then
      fileperiod = Request("fileperiod")
      If fileperiod = "5" Then fileperiod = "0"
        objSite.LogFilePeriod = fileperiod
        If Request("fileperiod") = "0" Then
          If Request("filesize") < 4096 Then objSite.LogFileTruncateSize = Request("filesize") * 1048576 Else objSite.LogFileTruncateSize = "4294967295"
        End If
        If Request("fileperiod") = "5" Then objSite.LogFileTruncateSize = "4294967295"
    End If

    If Len(Request("LogODBCDataSource")) Then
      objSite.LogODBCDataSource = Request("LogODBCDataSource")
      objSite.LogODBCTableName = Request("LogODBCTableName")
      objSite.LogODBCUserName = Request("LogODBCUserName")
      objSite.LogODBCPassword = Request("LogODBCPassword")
    End If

  End If

  objSite.SetInfo
  Set objSite = Nothing
  If err Then errs = "There was an error!<br>Err: " & Err.description Else errs = "Updated!"

End Sub
%>
