<%
'#################################################################################
'## IIS Admin Control Panel v 1.0
'#################################################################################
'## Copyright (C) 2005 Jake Gardner, Chris Hood
'##  from now on, referred to as "we" or "us"
'##
'##   This is a legally binding agreement between you and us, the developers
'## of the software program ("IIS Admin Control Panel") which you are about to
'## accept through electronic distribution (downloading).  By downloading and
'## using this software you are agreeing and will have agreed to be bound by
'## the terms set forth below.
'##
'##   License Grant and Restrictions. We grant you and you accept a
'## non-exclusive license to use the IIS Admin Control Panel but you do not
'## acquire any rights of ownership or distribution in whole or part. We are
'## the exclusive owners of the IIS Admin Control Panel which is copyrighted.
'## This license permits you to use and modify the IIS Admin Control Panel for
'## your personal or company. You may not rent, lease, sub-license, assign,
'## loan, create a derivative work based on content or otherwise use or
'## transfer use of the Software or any part thereof to others. You may not
'## reverse engineer, reverse compile, disassemble or otherwise modify the
'## Software in any way.  You may not remove any proprietary notices that are
'## provided with or within the software and/or sourcecode.  Neither the
'## Software nor any underlying information or technology may be exported or
'## re-exported into any country to which the United States has prohibited
'## export.
'##
'##   No Warranties. You acknowledge that the software has been provided to you
'## free of charge for your personal use and evaluation. You assume
'## responsibility for the selection of the software to achieve your intended
'## results and for the proper installation, use and results obtained from use
'## of the IIS Admin Control Panel. WE MAKE NO REPRESENTATION OR WARRANTY OF
'## ANY KIND WITH RESPECT TO THE SOFTWARE OR THE RESULTS OBTAINED OR TO BE
'## OBTAINED FROM ITS USE. WE DO NOT WARRANT THAT YOUR USE OF THE SOFTWARE WILL
'## BE UNINTERRUPTED, ERROR-FREE OR VIRUS-FREE.  ALL WARRANTIES, EXPRESS OR
'## IMPLIED, INCLUDING THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
'## PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE HEREBY EXPRESSLY DISCLAIMED.
'## WE EXPRESSLY DISCLAIM ANY IMPLIED WARRANTY THAT ANY OTHER PRODUCT
'## (INCLUDING WITHOUT LIMITATION ANY COPY OF THE SOFTWARE YOU MAY SUBSEQUENTLY
'## PURCHASE) WILL CONFORM TO THE SOFTWARE PROVIDED TO YOU UNDER THIS
'## AGREEMENT.
'##
'##   IN NO EVENT SHALL WE OR THEIR SUPPLIERS OR DISTRIBUTOR(S) OR AGENTS BE
'## LIABLE FOR ANY DAMAGE ARISING OUT OF OR RELATED TO THE USE OF THIS PRODUCT,
'## INCLUDING WITHOUT LIMITATION ACTUAL, DIRECT, SPECIAL, CONSEQUENTIAL,
'## INDIRECT, EXEMPLARY OR PUNITIVE DAMAGES, WHETHER OR NOT SUCH DAMAGES WERE
'## FORESEEABLE AND EVEN IF WE WERE ADVISED THAT SUCH DAMAGES WERE LIKELY OR
'## POSSIBLE.
'##
'## Support can be obtained from our support forums at:
'## http://www.iisactive.com
'##
'## Correspondence and Marketing Questions can be sent to:
'## iacp@iisactive.com
'##
'#################################################################################
%>

<!-- #INCLUDE FILE="common\head.inc" -->
<!-- #INCLUDE FILE="common\Functions.inc" -->
<div id="maincontent">
<%
On Error Resume Next
Call Show_Display
If Len(Request.queryString("action")) Then
  Select Case LCase(Request.QueryString("action"))
	Case "show"
	  Call Display_All
	Case "search"
	  Call Show_Search
	Case "showstats"
	  Call Show_Stats
  End Select
End If
If Len(Request.Form("action")) Then
  Select Case LCase(Request.Form("action"))
    Case "dosearch"
      Call Search
    End Select
End If

Sub Show_Display()
%>
<TABLE width="100%">
  <TR><TH colspan="3">Choose an option</TH></TR>
  <TR>
  	<TD><a class="man_link" href="smtpsvc_info.asp?action=show">List all Sites</a></TD>
    <TD><a class="man_link" href="smtpsvc_info.asp?action=search">Search for a Site</a></TD>
    <TD><a class="man_link" href="smtpsvc_info.asp?action=showstats&sitename=_total">Total SMTP Stats</a></TD>
  </TR>
</TABLE>
<%
End Sub

Sub Show_Search()
%>
<form method="POST" tabindex="1">
<input type="hidden" name="action" value="dosearch">
Site: <input type="text" name="site" id="GiveMeFocus">&nbsp;<input type="submit" value="Search">

</form>
<%
End Sub

Sub Search()
Dim objComp, strItem, flag, cnt
Dim ArrBinding, strBinding, ipadd, serverstate
flag = 0

%>
Searching for: "<%=LCase(Request.Form("site"))%>" ...<br>
<TABLE width="75%">
	<TR>
		<TH>Site Name</TH>
		<TH>&nbsp;</TH>
	</TR>
	<%
response.flush

Set objComp = GetObject("IIS://" & Application("Server") & "/SMTPSVC")
	For Each strItem in objComp
	  If isNumeric(strItem.name) Then
	  ArrBindings = strItem.ServerBindings
  		If InStr(LCase(strItem.ServerComment), LCase(Request.Form("site"))) or InStr(LCase(ArrBindings(0)), LCase(Request.Form("site"))) Then
	  		flag = 1
		  	response.write "<tr><tH>" & strItem.ServerComment & "</tH>"
        Response.write "<td><a class=""man_link"" href=smtpsvc_info.asp?action=showstats&sitename="& strItem.Name & ">Show Stats</a></td></TR>"
		  End If
	  End If
	Next
Set objComp = Nothing

If flag = 0 Then Response.write "<TR><TD colspan=""2"">No sites not found.</TD></TR>"
Response.write "</table>"

End Sub

Sub Display_All()
Dim objComp, strItem
Set objComp = GetObject("IIS://" & Application("Server") & "/SMTPSVC")
%>
Retrieving list of sites...
<TABLE width="75%">
	<TR>
		<TH>Site Name</TH>
		<TH>&nbsp;</TH>
	</TR>
	<%
	For Each strItem in objComp
	  If isNumeric(strItem.name) Then
	%>
	<TR>
	  <TH><%=strItem.ServerComment%></TH>
	  <TD><a class="man_link" href="smtpsvc_info.asp?action=showstats&sitename=<%=strItem.Name%>">Show Stats</a></TD>
	</TR>
		<%
		  End If
	Next
Response.write "</table>"
End Sub

Sub Show_Stats

sitename = LCase(Request.QueryString("sitename"))

strComputer = "."
Set objWMIService = GetObject("winmgmts:\\" & strComputer & "\root\cimv2")
Set colItems = objWMIService.ExecQuery("Select * from Win32_PerfRawData_SMTPSVC_SMTPServer",,48)
For Each objItem in colItems
  If LCase(objItem.Name) = sitename Or InStr(Lcase(objItem.Name), sitename) Then

'     set bar = CreateObject("IISSample.PerfCheck.1")
'     If Application("IISVer") = 4 Then
'       www_uptime = bar.counter("\Process(inetinfo)\Elapsed Time")
'     ElseIf Application("IISVer") = 5 or Application("IISVer") = 6 Then
'       www_uptime = bar.counter("\Web Service(_total)\Service Uptime")
'     End If
    Response.write "<TABLE>"
    Response.write "<TR><TH colspan=""2"">Raw Data Statistics for: "& objitem.name &"</TH></TR>"
    Response.write "<TR><TH>AvgRecipientsPermsgReceived:</TH><TD>" & objItem.AvgRecipientsPermsgReceived & "</TD></TR>"
    Response.write "<TR><TH>AvgRecipientsPermsgReceived_Base:</TH><TD>" & objItem.AvgRecipientsPermsgReceived_Base & "</TD></TR>"
    Response.write "<TR><TH>AvgRecipientsPermsgSent:</TH><TD>" & objItem.AvgRecipientsPermsgSent & "</TD></TR>"
    Response.write "<TR><TH>AvgRecipientsPermsgSent_Base:</TH><TD>" & objItem.AvgRecipientsPermsgSent_Base & "</TD></TR>"
    Response.write "<TR><TH>AvgRetriesPermsgDelivered:</TH><TD>" & objItem.AvgRetriesPermsgDelivered & "</TD></TR>"
    Response.write "<TR><TH>AvgRetriesPermsgDelivered_Base:</TH><TD>" & objItem.AvgRetriesPermsgDelivered_Base & "</TD></TR>"
    Response.write "<TR><TH>AvgRetriesPermsgSent:</TH><TD>" & objItem.AvgRetriesPermsgSent & "</TD></TR>"
    Response.write "<TR><TH>AvgRetriesPermsgSent_Base:</TH><TD>" & objItem.AvgRetriesPermsgSent_Base & "</TD></TR>"
    Response.write "<TR><TH>BadmailedMessagesBadPickupFile:</TH><TD>" & objItem.BadmailedMessagesBadPickupFile & "</TD></TR>"
    Response.write "<TR><TH>BadmailedMessagesGeneralFailure:</TH><TD>" & objItem.BadmailedMessagesGeneralFailure & "</TD></TR>"
    Response.write "<TR><TH>BadmailedMessagesHopCountExceeded:</TH><TD>" & objItem.BadmailedMessagesHopCountExceeded & "</TD></TR>"
    Response.write "<TR><TH>BadmailedMessagesNDRofDSN:</TH><TD>" & objItem.BadmailedMessagesNDRofDSN & "</TD></TR>"
    Response.write "<TR><TH>BadmailedMessagesNoRecipients:</TH><TD>" & objItem.BadmailedMessagesNoRecipients & "</TD></TR>"
    Response.write "<TR><TH>BadmailedMessagesTriggeredviaEvent:</TH><TD>" & objItem.BadmailedMessagesTriggeredviaEvent & "</TD></TR>"
    Response.write "<TR><TH>BytesReceivedPersec:</TH><TD>" & objItem.BytesReceivedPersec & "</TD></TR>"
    Response.write "<TR><TH>BytesReceivedTotal:</TH><TD>" & objItem.BytesReceivedTotal & "</TD></TR>"
    Response.write "<TR><TH>BytesSentPersec:</TH><TD>" & objItem.BytesSentPersec & "</TD></TR>"
    Response.write "<TR><TH>BytesSentTotal:</TH><TD>" & objItem.BytesSentTotal & "</TD></TR>"
    Response.write "<TR><TH>BytesTotal:</TH><TD>" & objItem.BytesTotal & "</TD></TR>"
    Response.write "<TR><TH>BytesTotalPersec:</TH><TD>" & objItem.BytesTotalPersec & "</TD></TR>"
    Response.write "<TR><TH>Caption:</TH><TD>" & objItem.Caption & "</TD></TR>"
    Response.write "<TR><TH>ConnectionErrorsPersec:</TH><TD>" & objItem.ConnectionErrorsPersec & "</TD></TR>"
    Response.write "<TR><TH>CurrentMessagesinLocalDelivery:</TH><TD>" & objItem.CurrentMessagesinLocalDelivery & "</TD></TR>"
    Response.write "<TR><TH>Description:</TH><TD>" & objItem.Description & "</TD></TR>"
    Response.write "<TR><TH>DirectoryDropsPersec:</TH><TD>" & objItem.DirectoryDropsPersec & "</TD></TR>"
    Response.write "<TR><TH>DirectoryDropsTotal:</TH><TD>" & objItem.DirectoryDropsTotal & "</TD></TR>"
    Response.write "<TR><TH>DNSQueriesPersec:</TH><TD>" & objItem.DNSQueriesPersec & "</TD></TR>"
    Response.write "<TR><TH>DNSQueriesTotal:</TH><TD>" & objItem.DNSQueriesTotal & "</TD></TR>"
    Response.write "<TR><TH>ETRNMessagesPersec:</TH><TD>" & objItem.ETRNMessagesPersec & "</TD></TR>"
    Response.write "<TR><TH>ETRNMessagesTotal:</TH><TD>" & objItem.ETRNMessagesTotal & "</TD></TR>"
    Response.write "<TR><TH>Frequency_Object:</TH><TD>" & objItem.Frequency_Object & "</TD></TR>"
    Response.write "<TR><TH>Frequency_PerfTime:</TH><TD>" & objItem.Frequency_PerfTime & "</TD></TR>"
    Response.write "<TR><TH>Frequency_Sys100NS:</TH><TD>" & objItem.Frequency_Sys100NS & "</TD></TR>"
    Response.write "<TR><TH>InboundConnectionsCurrent:</TH><TD>" & objItem.InboundConnectionsCurrent & "</TD></TR>"
    Response.write "<TR><TH>InboundConnectionsTotal:</TH><TD>" & objItem.InboundConnectionsTotal & "</TD></TR>"
    Response.write "<TR><TH>LocalQueueLength:</TH><TD>" & objItem.LocalQueueLength & "</TD></TR>"
    Response.write "<TR><TH>LocalRetryQueueLength:</TH><TD>" & objItem.LocalRetryQueueLength & "</TD></TR>"
    Response.write "<TR><TH>MessageBytesReceivedPersec:</TH><TD>" & objItem.MessageBytesReceivedPersec & "</TD></TR>"
    Response.write "<TR><TH>MessageBytesReceivedTotal:</TH><TD>" & objItem.MessageBytesReceivedTotal & "</TD></TR>"
    Response.write "<TR><TH>MessageBytesSentPersec:</TH><TD>" & objItem.MessageBytesSentPersec & "</TD></TR>"
    Response.write "<TR><TH>MessageBytesSentTotal:</TH><TD>" & objItem.MessageBytesSentTotal & "</TD></TR>"
    Response.write "<TR><TH>MessageBytesTotal:</TH><TD>" & objItem.MessageBytesTotal & "</TD></TR>"
    Response.write "<TR><TH>MessageBytesTotalPersec:</TH><TD>" & objItem.MessageBytesTotalPersec & "</TD></TR>"
    Response.write "<TR><TH>MessageDeliveryRetries:</TH><TD>" & objItem.MessageDeliveryRetries & "</TD></TR>"
    Response.write "<TR><TH>MessagesCurrentlyUndeliverable:</TH><TD>" & objItem.MessagesCurrentlyUndeliverable & "</TD></TR>"
    Response.write "<TR><TH>MessagesDeliveredPersec:</TH><TD>" & objItem.MessagesDeliveredPersec & "</TD></TR>"
    Response.write "<TR><TH>MessagesDeliveredTotal:</TH><TD>" & objItem.MessagesDeliveredTotal & "</TD></TR>"
    Response.write "<TR><TH>MessageSendRetries:</TH><TD>" & objItem.MessageSendRetries & "</TD></TR>"
    Response.write "<TR><TH>MessagesPendingRouting:</TH><TD>" & objItem.MessagesPendingRouting & "</TD></TR>"
    Response.write "<TR><TH>MessagesReceivedPersec:</TH><TD>" & objItem.MessagesReceivedPersec & "</TD></TR>"
    Response.write "<TR><TH>MessagesReceivedTotal:</TH><TD>" & objItem.MessagesReceivedTotal & "</TD></TR>"
    Response.write "<TR><TH>MessagesRefusedforAddressObjects:</TH><TD>" & objItem.MessagesRefusedforAddressObjects & "</TD></TR>"
    Response.write "<TR><TH>MessagesRefusedforMailObjects:</TH><TD>" & objItem.MessagesRefusedforMailObjects & "</TD></TR>"
    Response.write "<TR><TH>MessagesRefusedforSize:</TH><TD>" & objItem.MessagesRefusedforSize & "</TD></TR>"
    Response.write "<TR><TH>MessagesSentPersec:</TH><TD>" & objItem.MessagesSentPersec & "</TD></TR>"
    Response.write "<TR><TH>MessagesSentTotal:</TH><TD>" & objItem.MessagesSentTotal & "</TD></TR>"
    Response.write "<TR><TH>NDRsGenerated:</TH><TD>" & objItem.NDRsGenerated & "</TD></TR>"
    Response.write "<TR><TH>NumberofMailFilesOpen:</TH><TD>" & objItem.NumberofMailFilesOpen & "</TD></TR>"
    Response.write "<TR><TH>NumberofQueueFilesOpen:</TH><TD>" & objItem.NumberofQueueFilesOpen & "</TD></TR>"
    Response.write "<TR><TH>OutboundConnectionsCurrent:</TH><TD>" & objItem.OutboundConnectionsCurrent & "</TD></TR>"
    Response.write "<TR><TH>OutboundConnectionsRefused:</TH><TD>" & objItem.OutboundConnectionsRefused & "</TD></TR>"
    Response.write "<TR><TH>OutboundConnectionsTotal:</TH><TD>" & objItem.OutboundConnectionsTotal & "</TD></TR>"
    Response.write "<TR><TH>PercentRecipientsLocal:</TH><TD>" & objItem.PercentRecipientsLocal & "</TD></TR>"
    Response.write "<TR><TH>PercentRecipientsLocal_Base:</TH><TD>" & objItem.PercentRecipientsLocal_Base & "</TD></TR>"
    Response.write "<TR><TH>PercentRecipientsRemote:</TH><TD>" & objItem.PercentRecipientsRemote & "</TD></TR>"
    Response.write "<TR><TH>PercentRecipientsRemote_Base:</TH><TD>" & objItem.PercentRecipientsRemote_Base & "</TD></TR>"
    Response.write "<TR><TH>PickupDirectoryMessagesRetrievedPersec:</TH><TD>" & objItem.PickupDirectoryMessagesRetrievedPersec & "</TD></TR>"
    Response.write "<TR><TH>PickupDirectoryMessagesRetrievedTotal:</TH><TD>" & objItem.PickupDirectoryMessagesRetrievedTotal & "</TD></TR>"
    Response.write "<TR><TH>RemoteQueueLength:</TH><TD>" & objItem.RemoteQueueLength & "</TD></TR>"
    Response.write "<TR><TH>RemoteRetryQueueLength:</TH><TD>" & objItem.RemoteRetryQueueLength & "</TD></TR>"
    Response.write "<TR><TH>RoutingTableLookupsPersec:</TH><TD>" & objItem.RoutingTableLookupsPersec & "</TD></TR>"
    Response.write "<TR><TH>RoutingTableLookupsTotal:</TH><TD>" & objItem.RoutingTableLookupsTotal & "</TD></TR>"
    Response.write "<TR><TH>Timestamp_Object:</TH><TD>" & objItem.Timestamp_Object & "</TD></TR>"
    Response.write "<TR><TH>Timestamp_PerfTime:</TH><TD>" & objItem.Timestamp_PerfTime & "</TD></TR>"
    Response.write "<TR><TH>Timestamp_Sys100NS:</TH><TD>" & objItem.Timestamp_Sys100NS & "</TD></TR>"
    Response.write "<TR><TH>TotalConnectionErrors:</TH><TD>" & objItem.TotalConnectionErrors & "</TD></TR>"
    Response.write "<TR><TH>TotalDSNFailures:</TH><TD>" & objItem.TotalDSNFailures & "</TD></TR>"
    Response.write "<TR><TH>Totalmessagessubmitted:</TH><TD>" & objItem.Totalmessagessubmitted & "</TD></TR>"
    Response.write "</TABLE>"
End If
Next
End Sub
%>

</div>
</body>
</html>
