<%
'#################################################################################
'## IIS Admin Control Panel v 1.0
'#################################################################################
'## Copyright (C) 2005 Jake Gardner, Chris Hood
'##  from now on, referred to as "we" or "us"
'##
'##   This is a legally binding agreement between you and us, the developers
'## of the software program ("IIS Admin Control Panel") which you are about to
'## accept through electronic distribution (downloading).  By downloading and
'## using this software you are agreeing and will have agreed to be bound by
'## the terms set forth below.
'##
'##   License Grant and Restrictions. We grant you and you accept a
'## non-exclusive license to use the IIS Admin Control Panel but you do not
'## acquire any rights of ownership or distribution in whole or part. We are
'## the exclusive owners of the IIS Admin Control Panel which is copyrighted.
'## This license permits you to use and modify the IIS Admin Control Panel for
'## your personal or company. You may not rent, lease, sub-license, assign,
'## loan, create a derivative work based on content or otherwise use or
'## transfer use of the Software or any part thereof to others. You may not
'## reverse engineer, reverse compile, disassemble or otherwise modify the
'## Software in any way.  You may not remove any proprietary notices that are
'## provided with or within the software and/or sourcecode.  Neither the
'## Software nor any underlying information or technology may be exported or
'## re-exported into any country to which the United States has prohibited
'## export.
'##
'##   No Warranties. You acknowledge that the software has been provided to you
'## free of charge for your personal use and evaluation. You assume
'## responsibility for the selection of the software to achieve your intended
'## results and for the proper installation, use and results obtained from use
'## of the IIS Admin Control Panel. WE MAKE NO REPRESENTATION OR WARRANTY OF
'## ANY KIND WITH RESPECT TO THE SOFTWARE OR THE RESULTS OBTAINED OR TO BE
'## OBTAINED FROM ITS USE. WE DO NOT WARRANT THAT YOUR USE OF THE SOFTWARE WILL
'## BE UNINTERRUPTED, ERROR-FREE OR VIRUS-FREE.  ALL WARRANTIES, EXPRESS OR
'## IMPLIED, INCLUDING THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
'## PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE HEREBY EXPRESSLY DISCLAIMED.
'## WE EXPRESSLY DISCLAIM ANY IMPLIED WARRANTY THAT ANY OTHER PRODUCT
'## (INCLUDING WITHOUT LIMITATION ANY COPY OF THE SOFTWARE YOU MAY SUBSEQUENTLY
'## PURCHASE) WILL CONFORM TO THE SOFTWARE PROVIDED TO YOU UNDER THIS
'## AGREEMENT.
'##
'##   IN NO EVENT SHALL WE OR THEIR SUPPLIERS OR DISTRIBUTOR(S) OR AGENTS BE
'## LIABLE FOR ANY DAMAGE ARISING OUT OF OR RELATED TO THE USE OF THIS PRODUCT,
'## INCLUDING WITHOUT LIMITATION ACTUAL, DIRECT, SPECIAL, CONSEQUENTIAL,
'## INDIRECT, EXEMPLARY OR PUNITIVE DAMAGES, WHETHER OR NOT SUCH DAMAGES WERE
'## FORESEEABLE AND EVEN IF WE WERE ADVISED THAT SUCH DAMAGES WERE LIKELY OR
'## POSSIBLE.
'##
'## Support can be obtained from our support forums at:
'## http://www.iisactive.com
'##
'## Correspondence and Marketing Questions can be sent to:
'## iacp@iisactive.com
'##
'#################################################################################
%>


<!-- #INCLUDE FILE="common\head.inc" -->
<div id="maincontent">
<TABLE width="100%">
  <TR><TH colspan="3">ODBC and DSN Management</TH></TR>
  <TR>
  	<TD><a class="man_link" href="odbc.asp?level=user">User DSN's</a></TD>
	  <TD><a class="man_link" href="odbc.asp?level=system">System DSN's</a></TD>
<% '	  <TD><a class="man_link" href="odbc.asp?level=file">File DSN's</a></TD> %>
	  <TD><a class="man_link" href="odbc.asp?level=drivers">Drivers</a></TD>
<% '	  <TD><a class="man_link" href="odbc.asp?level=pool">Connection Pooling</a></TD> %>
  </TR>
  <TR><TH colspan="3">No management functions available at this time!!</TH></TR>
<%
' If Len(Request("tc")) OR Len(Request("e")) OR errmsg <> "" Then
'   If Request("tc") = "1" Then
'     response.write "<tr><th colspan=""" & cs & """>Task Completed!</TH></TR>"
'   Else
'     If errmsg = "" Then errmsg = Request("e")
'     response.write "<tr><th colspan=""" & cs & """>There were errors! " & errmsg & "</TH></TR>"
'   End If
' End If

If Len(Request("level")) Then
  Select Case LCase(Request("level"))
    Case "user"
      Call User_DSNs_Show()
    Case "system"
      Call System_DSNs_Show()
    Case "file"
    Case "drivers"
      Call DSNs_Drivers_Show()
    Case "pool"
  End Select
End If
%>

</TABLE>
<%
Sub User_DSNs_Show()
On Error Resume Next

Const HKCU = &H80000001
const REG_SZ = 1
const REG_EXPAND_SZ = 2
const REG_BINARY = 3
const REG_DWORD = 4
const REG_MULTI_SZ = 7
strComputer = "."
TopLevKey = "Software\ODBC\ODBC.INI\ODBC Data Sources"
Set oReg=GetObject("winmgmts:{impersonationLevel=impersonate}!\\" &_
  strComputer & "\root\default:StdRegProv")
  oReg.EnumValues HKCU, TopLevKey, arrValueNames, arrValueTypes

%>
<FORM method="POST" action="odbc.asp">
  <TABLE width="50%">
    <TR>
      <TH colspan="3">User DSN Management</TH>
    </TR>
    <TR>
      <TH>Name</TH>
      <TH>Type</TH>
      <TH>&nbsp;</TH>
    </TR>
<%
  For i=0 To UBound(arrValueNames)
    oReg.GetStringValue HKCU,TopLevKey,arrValueNames(i),strValue
    Response.write "<TR>"
    Response.write "<TD class=""values"">" & arrValueNames(i) & "</TD>"
    Response.write "<TD class=""values"">" & strValue & "</TD>"
    Response.write "<TD class=""options""><a href=""odbc.asp?action=manage&level=user&name=" & arrValueNames(i) & """>Manage</a></TD>"
    Response.write "</TR>"
Next
%>
  </TABLE>
</FORM>
<%
End Sub

Sub System_DSNs_Show()
On Error Resume Next

const HKLM = &H80000002
const REG_SZ = 1
const REG_EXPAND_SZ = 2
const REG_BINARY = 3
const REG_DWORD = 4
const REG_MULTI_SZ = 7
strComputer = "."
TopLevKey = "SOFTWARE\ODBC\ODBC.INI\ODBC Data Sources"
Set oReg=GetObject("winmgmts:{impersonationLevel=impersonate}!\\" &_
  strComputer & "\root\default:StdRegProv")
  oReg.EnumValues HKLM, TopLevKey, arrValueNames, arrValueTypes

%>
<FORM method="POST" action="odbc.asp">
  <TABLE width="50%">
    <TR>
      <TH colspan="3">System DSN Management</TH>
    </TR>
    <TR>
      <TH>Name</TH>
      <TH>Type</TH>
      <TH>&nbsp;</TH>
    </TR>
<%
  For i=0 To UBound(arrValueNames)
    oReg.GetStringValue HKLM,TopLevKey,arrValueNames(i),strValue
    Response.write "<TR>"
    Response.write "<TD class=""values"">" & arrValueNames(i) & "</TD>"
    Response.write "<TD class=""values"">" & strValue & "</TD>"
    Response.write "<TD class=""options""><a href=""odbc.asp?action=manage&level=system&name=" & arrValueNames(i) & """>Manage</a></TD>"
    Response.write "</TR>"
Next
%>
  </TABLE>
</FORM>
<%
End Sub

Sub DSNs_Drivers_Show()
On Error Resume Next

const HKLM = &H80000002
const REG_SZ = 1
const REG_EXPAND_SZ = 2
const REG_BINARY = 3
const REG_DWORD = 4
const REG_MULTI_SZ = 7
strComputer = "."
TopLevKey = "SOFTWARE\ODBC\ODBCINST.INI\ODBC Drivers"
Set oReg=GetObject("winmgmts:{impersonationLevel=impersonate}!\\" &_
  strComputer & "\root\default:StdRegProv")
  oReg.EnumValues HKLM, TopLevKey, arrValueNames, arrValueTypes

%>
<FORM method="POST" action="odbc.asp">
  <TABLE width="50%">
    <TR>
      <TH colspan="6">DSN Driver Management</TH>
    </TR>
    <TR>
      <TH>Name</TH>
      <TH>Status</TH>
    </TR>
<%
  For i=0 To UBound(arrValueNames)
    oReg.GetStringValue HKLM,TopLevKey,arrValueNames(i),strValue
    Response.write "<TR>"
    Response.write "<TD class=""values"">" & arrValueNames(i) & "</TD>"
    Response.write "<TD class=""values"">" & strValue & "</TD>"
    Response.write "</TR>"
Next
%>
  </TABLE>
</FORM>
<%
End Sub


Function GetKeyPaths(KeyPath)
    oReg.EnumKey HKLM, KeyPath, arrSubKeys
    For Each subkey In arrSubKeys
      response.write "<br>" & PreKey & KeyPath & subkey & "]" & "<br>"
      tmpKeyPath = KeyPath & subkey & "\"
'       EnumKeys()
      GetKeyPaths(tmpKeyPath)
    Next
End Function

Sub EnumKeys(KeyPath)
Set oReg2=GetObject("winmgmts:{impersonationLevel=impersonate}!\\" &_
  strComputer & "\root\default:StdRegProv")
  oReg2.EnumValues HKLM, KeyPath, arrValueNames, arrValueTypes
  For i=0 To UBound(arrValueNames)
    Select Case arrValueTypes(i)
      Case REG_SZ
        oReg.GetStringValue HKLM,KeyPath,arrValueNames(i),strValue
        response.write """" & arrValueNames(i) & """=""" & strValue & """" & "<br>"

      Case REG_EXPAND_SZ
        oReg.GetExpandedStringValue HKLM,KeyPath,arrValueNames(i),strValue
        response.write """" & arrValueNames(i) & """=""" & strValue & "<br>"

      Case REG_BINARY
        oReg.GetBinaryValue HKLM,KeyPath,arrValueNames(i),strValue
        TmpOut = """" & arrValueNames(i) & """="""
        For x = lBound(strValue) to uBound(strValue)
          TmpOut = TmpOut & strValue(x)
        Next
        response.write TmpOut & """" & "<br>"

      Case REG_DWORD
        oReg.GetDWORDValue HKLM,KeyPath,arrValueNames(i),dwValue
        response.write """" & arrValueNames(i) & """=dword:" & dwValue & "<br>"

      Case REG_MULTI_SZ
        oReg.GetMultiStringValue HKLM,KeyPath,arrValueNames(i),arrValues
        TmpOut = """" & arrValueNames(i) & """="""
        For Each strValue In arrValues
          TmpOut = TmpOut & strValue
        Next
        response.write TmpOut & """" & "<br>"

    End Select
  Next
  If err = false then response.write "<br>"
  err.clear
End Sub
%>
</div>
</body>
</html>

