<%
'#################################################################################
'## IIS Admin Control Panel v 1.0
'#################################################################################
'## Copyright (C) 2005 Jake Gardner, Chris Hood
'##  from now on, referred to as "we" or "us"
'##
'##   This is a legally binding agreement between you and us, the developers
'## of the software program ("IIS Admin Control Panel") which you are about to
'## accept through electronic distribution (downloading).  By downloading and
'## using this software you are agreeing and will have agreed to be bound by
'## the terms set forth below.
'##
'##   License Grant and Restrictions. We grant you and you accept a
'## non-exclusive license to use the IIS Admin Control Panel but you do not
'## acquire any rights of ownership or distribution in whole or part. We are
'## the exclusive owners of the IIS Admin Control Panel which is copyrighted.
'## This license permits you to use and modify the IIS Admin Control Panel for
'## your personal or company. You may not rent, lease, sub-license, assign,
'## loan, create a derivative work based on content or otherwise use or
'## transfer use of the Software or any part thereof to others. You may not
'## reverse engineer, reverse compile, disassemble or otherwise modify the
'## Software in any way.  You may not remove any proprietary notices that are
'## provided with or within the software and/or sourcecode.  Neither the
'## Software nor any underlying information or technology may be exported or
'## re-exported into any country to which the United States has prohibited
'## export.
'##
'##   No Warranties. You acknowledge that the software has been provided to you
'## free of charge for your personal use and evaluation. You assume
'## responsibility for the selection of the software to achieve your intended
'## results and for the proper installation, use and results obtained from use
'## of the IIS Admin Control Panel. WE MAKE NO REPRESENTATION OR WARRANTY OF
'## ANY KIND WITH RESPECT TO THE SOFTWARE OR THE RESULTS OBTAINED OR TO BE
'## OBTAINED FROM ITS USE. WE DO NOT WARRANT THAT YOUR USE OF THE SOFTWARE WILL
'## BE UNINTERRUPTED, ERROR-FREE OR VIRUS-FREE.  ALL WARRANTIES, EXPRESS OR
'## IMPLIED, INCLUDING THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
'## PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE HEREBY EXPRESSLY DISCLAIMED.
'## WE EXPRESSLY DISCLAIM ANY IMPLIED WARRANTY THAT ANY OTHER PRODUCT
'## (INCLUDING WITHOUT LIMITATION ANY COPY OF THE SOFTWARE YOU MAY SUBSEQUENTLY
'## PURCHASE) WILL CONFORM TO THE SOFTWARE PROVIDED TO YOU UNDER THIS
'## AGREEMENT.
'##
'##   IN NO EVENT SHALL WE OR THEIR SUPPLIERS OR DISTRIBUTOR(S) OR AGENTS BE
'## LIABLE FOR ANY DAMAGE ARISING OUT OF OR RELATED TO THE USE OF THIS PRODUCT,
'## INCLUDING WITHOUT LIMITATION ACTUAL, DIRECT, SPECIAL, CONSEQUENTIAL,
'## INDIRECT, EXEMPLARY OR PUNITIVE DAMAGES, WHETHER OR NOT SUCH DAMAGES WERE
'## FORESEEABLE AND EVEN IF WE WERE ADVISED THAT SUCH DAMAGES WERE LIKELY OR
'## POSSIBLE.
'##
'## Support can be obtained from our support forums at:
'## http://www.iisactive.com
'##
'## Correspondence and Marketing Questions can be sent to:
'## iacp@iisactive.com
'##
'#################################################################################
%>

<!-- #INCLUDE FILE="common\IPFuncs.inc" -->
<!-- #INCLUDE FILE="common\head.inc" -->
<!-- #INCLUDE FILE="common\Functions.inc" -->
<div id="maincontent">
<%
On Error Resume Next

Call Show_Display
If Len(Request.queryString("action")) Then
  Select Case LCase(Request.QueryString("action"))
	Case "showprocs"
	  Call Show_Processes
	Case "showca"
	  Call ShowCurrent
  End Select
End If

Sub Show_Display
%>
<TABLE width="100%">
  <TR><TH colspan="4">Statistics Services</TH></TR>
  <TR>
    <TD><a class="man_link" href="w3svc_info.asp">WWW Info</a></TD>
    <TD><a class="man_link" href="ftpsvc_info.asp">FTP Info</a></TD>
    <TD><a class="man_link" href="smtpsvc_info.asp">SMTP Info</a></TD>
    <TD><a class="man_link" href="mrtg.asp?action=showprocs&refresh=15">Show Running Proccesses</a></TD>
  </TR>
</TABLE>
<%
End Sub

Sub Show_Processes
Response.write "<TABLE width=""100%"">"
Response.Write "<TR><TH>System Processes (auto reload every " & Request.QueryString("refresh") & " seconds)&nbsp;&nbsp;<a href=""mrtg.asp?action=showprocs"">Stop Reloading</a></TH></TR>"
Response.write "</TABLE>"

Response.write "<TABLE name=""rsTable"" id=""rsTable"" cols=8>"
Response.write "<TR>"
Response.write "<TH><Acronym title=""Sort by Process ID"" onClick=""table_sort(0)"" onMouseOver=""this.style.cursor='hand';"">Process ID</acronym></TH>"
Response.write "<TH><Acronym title=""Sort by Process Name"" onClick=""table_sort(1)"" onMouseOver=""this.style.cursor='hand';"">Process Name</acronym></TH>"
Response.write "<TH><Acronym title=""Sort by Parent Process ID"" onClick=""table_sort(2)"" onMouseOver=""this.style.cursor='hand';"">Parent Process ID</acronym></TH>"
Response.write "<TH><Acronym title=""Sort by Memory Usage"" onClick=""table_sort(3)"" onMouseOver=""this.style.cursor='hand';"">Memory Usage</acronym></TH>"
Response.write "<TH><Acronym title=""Sort by Peak Memory Usage"" onClick=""table_sort(4)"" onMouseOver=""this.style.cursor='hand';"">Peak Memory Usage</acronym></TH>"
Response.write "<TH><Acronym title=""Sort by Page File Usage"" onClick=""table_sort(5)"" onMouseOver=""this.style.cursor='hand';"">Page File Usage</acronym></TH>"
Response.write "<TH><Acronym title=""Sort by Peak Page File Usage"" onClick=""table_sort(6)"" onMouseOver=""this.style.cursor='hand';"">Peak Page File Usage</acronym></TH>"
Response.write "<TH><Acronym title=""Sort by UserModeTime"" onClick=""table_sort(7)"" onMouseOver=""this.style.cursor='hand';"">UserModeTime</acronym></TH>"
Response.write "</TR>"

For Each Process in GetObject("winmgmts:").InstancesOf ("win32_process")

  Pro_WorkingSetSize = Process.WorkingSetSize
    Call FormatUserQuota(Pro_WorkingSetSize)
  Pro_PeakWorkingSetSize = Process.PeakWorkingSetSize
    Call FormatUserQuota(Pro_PeakWorkingSetSize)
  Pro_PageFileUsage = Process.PageFileUsage
    Call FormatUserQuota(Pro_PageFileUsage)
  Pro_PeakPageFileUsage = Process.PeakPageFileUsage
    Call FormatUserQuota(Pro_PeakPageFileUsage)

  Response.write "<TR><TH>" &  Process.ProcessId & "</TH><TD>" &  Process.name & "</TD>"
  Response.write "<TD>" & Process.ParentProcessId & "</TD>"
  Response.write "<TD>" & Pro_WorkingSetSize & "</TD><TD>" & Pro_PeakWorkingSetSize & "</TD>"
  Response.write "<TD>" & Pro_PageFileUsage & "</TD><TD>" & Pro_PeakPageFileUsage & "</TD>"
  Response.write "<TD>" & Process.UserModeTime & "</TD></TR>"
Next
Response.write "</TABLE>"

End Sub

%>

</div>
</body>
</html>
