<%
'#################################################################################
'## IIS Admin Control Panel v 1.0
'#################################################################################
'## Copyright (C) 2005 Jake Gardner, Chris Hood
'##  from now on, referred to as "we" or "us"
'##
'##   This is a legally binding agreement between you and us, the developers
'## of the software program ("IIS Admin Control Panel") which you are about to
'## accept through electronic distribution (downloading).  By downloading and
'## using this software you are agreeing and will have agreed to be bound by
'## the terms set forth below.
'##
'##   License Grant and Restrictions. We grant you and you accept a
'## non-exclusive license to use the IIS Admin Control Panel but you do not
'## acquire any rights of ownership or distribution in whole or part. We are
'## the exclusive owners of the IIS Admin Control Panel which is copyrighted.
'## This license permits you to use and modify the IIS Admin Control Panel for
'## your personal or company. You may not rent, lease, sub-license, assign,
'## loan, create a derivative work based on content or otherwise use or
'## transfer use of the Software or any part thereof to others. You may not
'## reverse engineer, reverse compile, disassemble or otherwise modify the
'## Software in any way.  You may not remove any proprietary notices that are
'## provided with or within the software and/or sourcecode.  Neither the
'## Software nor any underlying information or technology may be exported or
'## re-exported into any country to which the United States has prohibited
'## export.
'##
'##   No Warranties. You acknowledge that the software has been provided to you
'## free of charge for your personal use and evaluation. You assume
'## responsibility for the selection of the software to achieve your intended
'## results and for the proper installation, use and results obtained from use
'## of the IIS Admin Control Panel. WE MAKE NO REPRESENTATION OR WARRANTY OF
'## ANY KIND WITH RESPECT TO THE SOFTWARE OR THE RESULTS OBTAINED OR TO BE
'## OBTAINED FROM ITS USE. WE DO NOT WARRANT THAT YOUR USE OF THE SOFTWARE WILL
'## BE UNINTERRUPTED, ERROR-FREE OR VIRUS-FREE.  ALL WARRANTIES, EXPRESS OR
'## IMPLIED, INCLUDING THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
'## PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE HEREBY EXPRESSLY DISCLAIMED.
'## WE EXPRESSLY DISCLAIM ANY IMPLIED WARRANTY THAT ANY OTHER PRODUCT
'## (INCLUDING WITHOUT LIMITATION ANY COPY OF THE SOFTWARE YOU MAY SUBSEQUENTLY
'## PURCHASE) WILL CONFORM TO THE SOFTWARE PROVIDED TO YOU UNDER THIS
'## AGREEMENT.
'##
'##   IN NO EVENT SHALL WE OR THEIR SUPPLIERS OR DISTRIBUTOR(S) OR AGENTS BE
'## LIABLE FOR ANY DAMAGE ARISING OUT OF OR RELATED TO THE USE OF THIS PRODUCT,
'## INCLUDING WITHOUT LIMITATION ACTUAL, DIRECT, SPECIAL, CONSEQUENTIAL,
'## INDIRECT, EXEMPLARY OR PUNITIVE DAMAGES, WHETHER OR NOT SUCH DAMAGES WERE
'## FORESEEABLE AND EVEN IF WE WERE ADVISED THAT SUCH DAMAGES WERE LIKELY OR
'## POSSIBLE.
'##
'## Support can be obtained from our support forums at:
'## http://www.iisactive.com
'##
'## Correspondence and Marketing Questions can be sent to:
'## iacp@iisactive.com
'##
'#################################################################################


On Error Resume Next
message = ""
If Request("tc") = "1" Then message = "<font color=""#99FFFF"">Task Completed</font>"
If Request("tc") = "0" Then message = "<font color=""#FF3300"">Task Not Completed</font>"

wse_name = CStr(Request("wse"))
errmesg = ""
If Len(Request("wsestate")) Then Call change_wse_state(wse,errmesg,Request("wsestate"))


Set AppPool = GetObject("IIS://" & Application("SERVER") & "/w3svc/AppPools/" & appname)

If err Then Response.Redirect "display_services.asp?action=wse&svc=w3svc&tc=0&e=Web Service Extension Not Found"

Select Case AppPool.AppPoolState
  Case 2
		statshow = "<font color='#00FF00'>( Running )"
		statlink = "<a href=""manage_app_pools.asp?appname=" & Server.URLEncode(AppPool.Name) & "&appstate=Stop"">Stop</a>&nbsp;&nbsp;<a href=""manage_app_pools.asp?appname=" & AppPool.Name & "&appstate=Recycle"">Recycle</a>"
  Case 4
  	statshow = "<font color='#FF0000'>( Stopped )"
		statlink = "<a href=""manage_app_pools.asp?appname=" & Server.URLEncode(AppPool.Name) & "&appstate=Start"">Start</a>"
	Case Else
		statshow = "unknown"
	  statlink = ""
End Select


%>
<!-- #INCLUDE FILE="common\head.inc" -->
<!-- #INCLUDE FILE="common\Functions.inc" -->
<DIV id="maincontent">
<TABLE width="80%">
  <TR>
  	<TH colspan="3">Properties for the <%=AppPool.KeyType%>: <%=AppName%></TH>
  </TR>

  <TR><TH>Property</TH><TH>Current Setting</TH><TH>Options</TH></TR>


  <TR><TH>State</TH>
	  <TD><%= statshow %></TD>
	  <TD><%= statlink %></TD>
  </TR>

  <TR><TH>Recycle by Requests</TH>
    <%
      If AppPool.PeriodicRestartRequests = 0 Then
        AppPRR = "Disabled"
      Else
        AppPRR = AppPool.PeriodicRestartRequests & " Requests"
      End If
    %>
	  <TD><%= AppPRR %></TD>
	  <TD><a class="man_link" href="manage_app_pools_cfg.asp?action=PeriodicRestartRequests&appname=<%=Server.URLEncode(appname)%>">Manage</a></TD>
  </TR>
  
  <TR><TH>Recycle by Time</TH>
    <%
      If AppPool.PeriodicRestartTime = 0 Then
        AppPRT = "Disabled"
      Else
        AppPRT = AppPool.PeriodicRestartTime & " Minutes"
      End If
    %>
	  <TD><%= AppPRT %></TD>
	  <TD><a class="man_link" href="manage_app_pools_cfg.asp?action=PeriodicRestartTime&appname=<%=Server.URLEncode(appname)%>">Manage</a></TD>
  </TR>

  <TR><TH>Recycle by Schedule</TH>
      <%
        PRS = AppPool.PeriodicRestartSchedule
        If Ubound(PRS) >= 0 Then
          PRSDisp = "Times Scheduled"
        Else
          PRSDisp = "No Times Scheduled"
        End If
      %>
	  <TD><%=PRSDisp%></TD>
	  <TD><a class="man_link" href="manage_app_pools_cfg.asp?action=PeriodicRestartSchedule&appname=<%=Server.URLEncode(appname)%>">Manage</a></TD>
  </TR>
  
  <TR><TH>Recycle by Memory Used</TH>
    <%
      If AppPool.PeriodicRestartMemory = 0 Then
        AppPRM = "Disabled"
      Else
        AppPRM =  (AppPool.PeriodicRestartMemory / 1024) & " Megabytes"
      End If
    %>
	  <TD><%=AppPRM%></TD>
	  <TD><a class="man_link" href="manage_app_pools_cfg.asp?action=PeriodicRestartMemory&appname=<%=Server.URLEncode(appname)%>">Manage</a></TD>
  </TR>

  <TR><TH>Recycle by Virtual Memory Used</TH>
    <%
      If AppPool.PeriodicRestartPrivateMemory  = 0 Then
        AppPRPM = "Disabled"
      Else
        AppPRPM =  (AppPool.PeriodicRestartPrivateMemory  / 1024) & " Megabytes"
      End If
    %>
	  <TD><%=AppPRPM%></TD>
	  <TD><a class="man_link" href="manage_app_pools_cfg.asp?action=PeriodicRestartPrivateMemory&appname=<%=Server.URLEncode(appname)%>">Manage</a></TD>
  </TR>

  <TR><TH>Shutdown After Being Idle by Time</TH>
    <%
      If AppPool.IdleTimeout  = 0 Then
        AppIT = "Disabled"
      Else
        AppIT = AppPool.IdleTimeout & " Minutes"
      End If
    %>
	  <TD><%= AppIT %></TD>
	  <TD><a class="man_link" href="manage_app_pools_cfg.asp?action=IdleTimeout&appname=<%=Server.URLEncode(appname)%>">Manage</a></TD>
  </TR>

  <TR><TH>Limit the Request Queue</TH>
    <%
      If AppPool.AppPoolQueueLength  = 65535 Then
        AppQL = "Disabled"
      Else
        AppQL = AppPool.AppPoolQueueLength & " Requests"
      End If
    %>
    <TD><%= AppQL %></TD>
	  <TD><a class="man_link" href="manage_app_pools_cfg.asp?action=AppPoolQueueLength&appname=<%=Server.URLEncode(appname)%>">Manage</a></TD>
  </TR>

  <TR><TH>Limit the CPU</TH>
    <%
      If AppPool.CPULimit  = 0 Then
        AppCL = "Disabled"
      Else
        AppCL = (AppPool.CPULimit / 1000 ) & "%"
      End If
    %>
	  <TD><%= AppCL %></TD>
	  <TD><a class="man_link" href="manage_app_pools_cfg.asp?action=CPULimit&appname=<%=Server.URLEncode(appname)%>">Manage</a></TD>
  </TR>

  <TR><TH>Max Worker Processes</TH>
	  <TD><%= AppPool.MaxProcesses %> Process(es)</TD>
	  <TD><a class="man_link" href="manage_app_pools_cfg.asp?action=MaxProcesses&appname=<%=Server.URLEncode(appname)%>">Manage</a></TD>
  </TR>

  <TR><TH>Pinging Enabled</TH>
    <% If AppPool.PingingEnabled  = False Then AppPE = "Disabled" Else AppPE = "Enabled" %>
	  <TD><%= AppPE %></TD>
	  <TD><a class="man_link" href="manage_app_pools_cfg.asp?action=PingingEnabled&appname=<%=Server.URLEncode(appname)%>">Manage</a></TD>
  </TR>
  <TR><TH>Rapid Fail Protection</TH>
    <% If AppPool.RapidFailProtection  = False Then AppRFP = "Disabled" Else AppRFP = "Enabled" %>
	  <TD><%= AppRFP %></TD>
	  <TD><a class="man_link" href="manage_app_pools_cfg.asp?action=RapidFailProtection&appname=<%=Server.URLEncode(appname)%>">Manage</a></TD>
  </TR>


  <TR><TH>Startup/ShutDown Time Limits</TH>
	  <TD><%= AppPool.StartupTimeLimit %>/<%= AppPool.ShutdownTimeLimit %> Seconds</TD>
	  <TD><a class="man_link" href="manage_app_pools_cfg.asp?action=TimeLimits&appname=<%=Server.URLEncode(appname)%>">Manage</a></TD>
  </TR>

  <TR><TH>Associated Web Sites</TH>
	  <TD>&nbsp;</TD>
	  <TD><a class="man_link" href="manage_app_pools_cfg.asp?action=ShowAssocSites&appname=<%=Server.URLEncode(appname)%>">Manage</a></TD>
  </TR>

  <TR><TH>Delete Application Pool</TH>
	<TD class="values">Delete the Applicatoin Pool.</TD>
	<TD class="options"><a href="manage_app_pools_cfg.asp?action=delete&appname=<%=Server.URLEncode(appname)%>">Delete</a></TD>
  </TR>
  <TR>


  <TR>
	<TH colspan="2"><%=message%></TH>
	<TD><a class="man_link" href="manage_app_pools.asp?appname=<%=Server.URLEncode(appname)%>">Refresh</a></TD>
  </TR>
</table>
<br>

</div>
</body>
</html>


<%
Sub change_wse_state(wse,errmsg,state)
On Error Resume Next
Set providerObj = GetObject("winmgmts://" & Application("SERVER") & "/root/MicrosoftIISv2")
Set IIsObj = providerObj.Get("IIsWebService='W3SVC'")
  wse = CStr(wse)
'   If InStr(wse,"CGI") Then wse = "*.exe"
'   If InStr(wse,"ISAPI") Then wse = "*.dll"
  Select Case state
    Case "enable"
      IIsObj.EnableWebServiceExtension wse
    Case "disable"
      IIsObj.DisableWebServiceExtension wse
  End Select
If err then errmsg = "Error Changing State!<BR>" & err.description & "<BR>wse: " & wse & "<br>state: " & state

End sub
%>
