<%
'#################################################################################
'## IIS Admin Control Panel v 1.0
'#################################################################################
'## Copyright (C) 2005 Jake Gardner, Chris Hood
'##  from now on, referred to as "we" or "us"
'##
'##   This is a legally binding agreement between you and us, the developers
'## of the software program ("IIS Admin Control Panel") which you are about to
'## accept through electronic distribution (downloading).  By downloading and
'## using this software you are agreeing and will have agreed to be bound by
'## the terms set forth below.
'##
'##   License Grant and Restrictions. We grant you and you accept a
'## non-exclusive license to use the IIS Admin Control Panel but you do not
'## acquire any rights of ownership or distribution in whole or part. We are
'## the exclusive owners of the IIS Admin Control Panel which is copyrighted.
'## This license permits you to use and modify the IIS Admin Control Panel for
'## your personal or company. You may not rent, lease, sub-license, assign,
'## loan, create a derivative work based on content or otherwise use or
'## transfer use of the Software or any part thereof to others. You may not
'## reverse engineer, reverse compile, disassemble or otherwise modify the
'## Software in any way.  You may not remove any proprietary notices that are
'## provided with or within the software and/or sourcecode.  Neither the
'## Software nor any underlying information or technology may be exported or
'## re-exported into any country to which the United States has prohibited
'## export.
'##
'##   No Warranties. You acknowledge that the software has been provided to you
'## free of charge for your personal use and evaluation. You assume
'## responsibility for the selection of the software to achieve your intended
'## results and for the proper installation, use and results obtained from use
'## of the IIS Admin Control Panel. WE MAKE NO REPRESENTATION OR WARRANTY OF
'## ANY KIND WITH RESPECT TO THE SOFTWARE OR THE RESULTS OBTAINED OR TO BE
'## OBTAINED FROM ITS USE. WE DO NOT WARRANT THAT YOUR USE OF THE SOFTWARE WILL
'## BE UNINTERRUPTED, ERROR-FREE OR VIRUS-FREE.  ALL WARRANTIES, EXPRESS OR
'## IMPLIED, INCLUDING THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
'## PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE HEREBY EXPRESSLY DISCLAIMED.
'## WE EXPRESSLY DISCLAIM ANY IMPLIED WARRANTY THAT ANY OTHER PRODUCT
'## (INCLUDING WITHOUT LIMITATION ANY COPY OF THE SOFTWARE YOU MAY SUBSEQUENTLY
'## PURCHASE) WILL CONFORM TO THE SOFTWARE PROVIDED TO YOU UNDER THIS
'## AGREEMENT.
'##
'##   IN NO EVENT SHALL WE OR THEIR SUPPLIERS OR DISTRIBUTOR(S) OR AGENTS BE
'## LIABLE FOR ANY DAMAGE ARISING OUT OF OR RELATED TO THE USE OF THIS PRODUCT,
'## INCLUDING WITHOUT LIMITATION ACTUAL, DIRECT, SPECIAL, CONSEQUENTIAL,
'## INDIRECT, EXEMPLARY OR PUNITIVE DAMAGES, WHETHER OR NOT SUCH DAMAGES WERE
'## FORESEEABLE AND EVEN IF WE WERE ADVISED THAT SUCH DAMAGES WERE LIKELY OR
'## POSSIBLE.
'##
'## Support can be obtained from our support forums at:
'## http://www.iisactive.com
'##
'## Correspondence and Marketing Questions can be sent to:
'## iacp@iisactive.com
'##
'#################################################################################


If Len(request("return")) Then Response.Redirect ("manage_W3SVC.asp?site=" & Request("site"))
If Len(request("returnvd")) Then Response.Redirect ("manage_w3svc_vdirs.asp?action=manvdir&site=" & Request("site") & "&vdir=" & Request("vdir"))
If Len(request("returnvdl")) Then Response.Redirect ("manage_w3svc_vdirs.asp?action=vdirs&site=" & Request("site"))
If Len(request("createvd")) Then Response.Redirect ("manage_w3svc_vdirs.asp?action=newvdir&site=" & Request("site"))


If Len(Request("ap")) Then Call AppProc()
If LCase(Request("action")) = "create" Then Call Create_VDir()
If LCase(Request("action")) = "modvdir" Then Call Mod_VDir()
If LCase(Request("action")) = "delvdir" Then Call Del_VDir()

message = ""
If Len(Request("tc")) Then
  Select Case Request("tc")
	Case "1"
	  message = "<TR><TH colspan=""3""><font color=""#99FFFF"">Task Completed</font></TH></TR>"
	Case "0"
	  message = "<TR><TH colspan=""3""><font color=""#FF3300"">Task Not Completed</font></TH></TR>"
  End Select
End If
errs = ""
%>
<!-- #INCLUDE FILE="common\head.inc" -->
<!-- #INCLUDE FILE="common\Functions.inc" -->
<DIV id="maincontent">
<%
If Len(Request("action")) Then
  Select Case LCase(Request("action"))
    Case "mananon"
      Call Manage_Anon()
    Case "vdirs"
      Call Show_VDirs()
    Case "manvdir"
      Call Show_Man_VDirs()
    Case "newvdir"
      Call Show_VDir_Install()
    Case "change_httpredir"
      Call Change_HTTPRedir(errs)
      Call HTTPRedir(errs)
    Case "httpredir"
      Call HTTPRedir(errs)
    Case "change_scriptmap"
      If Len(Request("edit")) Then
        If Request("CurSM").count > 1 Then
          errs = "<SPAN Class=""err"">Please select only one entry to edit at a time.</SPAN>"
          Call ScriptMap(errs)
        Else
          Call EditScriptMap(errs)
        End If
      End If
      If Len(Request("add")) Then
        Call AddScriptMap(errs)
        Call ScriptMap(errs)
      End If
      If Len(Request("rem")) Then
        Call RemoveScriptMap(errs)
        Call ScriptMap(errs)
      End If
    Case "update_scriptmap"
      If Len(Request("manscript")) Then
        Call ScriptMap(errs)
      Else
        Call UpdateScriptMap(errs)
        Call ScriptMap(errs)
      End If
    Case "scriptmap"
      Call ScriptMap(errs)

    Case "change_defdoc"
      Call ChangeDefDoc(errs)
      Call DefDoc(errs)
    Case "defdoc"
      Call DefDoc(errs)

    Case "change_docfoot"
      Call Change_DocFoot(errs)
      Call DocFoot(errs)
    Case "docfoot"
      Call DocFoot(errs)

    Case "change_ipdomrest"
      Call Change_IPDomRestrictions(errs)
      Call IPDomRestrictions(errs)
    Case "ipdomrest"
      Call IPDomRestrictions(errs)
  End Select
End If


Sub Show_VDirs()
On Error Resume Next
  Set objSiteROOT = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/ROOT")

	For each vdir in objSiteROOT
	  fsize = ""
	  err.clear
	  If vdir.Name = "_vti_bin" Then
		  path = Split(vdir.Path, ":")
		  npath = path(0) & "$" & path(1)
		  Call DirSize(vdir.Path,fsize)
		  hd = "<a target=""_blank"" href=""\\" & Application("Server") & "\" & npath & """>" & vdir.path & "</a>"
		Else
  	  If InStr(vdir.Path, ":") = True Then
	  	  path = Split(vdir.Path, ":")
		    npath = path(0) & "$" & path(1)
		    Call DirSize(vdir.Path,fsize)
		    hd = "<a target=""_blank"" href=""\\" & Application("Server") & "\" & npath & """>" & vdir.path & "</a>"
		  Else
		    path = Split(objSiteROOT.Path, ":")
		    p = objSiteROOT.path & "\" & vdir.name
		    Call DirSize(p,fsize)
		    npath = path(0) & "$" & path(1) & "\" & vdir.name
		    hd = "<a target=""_blank"" href=""\\" & Application("Server") & "\" & npath & """>" & objSiteROOT.Path & "\" & vdir.name & "</a>"
	    End If
	    If err Then
		    path = Split(objSiteROOT.Path, ":")
		    p = objSiteROOT.path & "\" & vdir.name
		    Call DirSize(p,fsize)
		    npath = path(0) & "$" & path(1) & "\" & vdir.name
		    hd = "<a target=""_blank"" href=""\\" & Application("Server") & "\" & npath & """>" & objSiteROOT.Path & "\" & vdir.name & "</a>"
      End If
    End If
		vdirlist = vdirlist & "<TR><TH>" & vdir.name & "</TH><TD>" & hd & "&nbsp;&nbsp;(" & fsize & ")</TD>"
		vdirlist = vdirlist & "<TD><a class=""man_link"" href=""manage_w3svc_vdirs.asp?action=manvdir&site="&Request("site")&"&vdir=" & vdir.Name & """>Manage</a></TD>"
		vdirlist = vdirlist & "<TD><a href=""manage_w3svc_vdirs.asp?action=delvdir&site="&Request("site")&"&vdir=" & vdir.Name & """>Delete</a></TD></TR>"
	  err.clear
	Next
%>
<TABLE width="100%">
  <form method="post" action="manage_w3svc_vdirs.asp?action=change_vdir">
	<Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TR><TH colspan="4">Virtual Directories</TH></TR>
  <%=vdirlist%>
  <TR>
    <TH>&nbsp;</TH>
	  <TD>
      <input type="submit" name="createvd" value="Create New Virtual Directory">
      &nbsp;&nbsp;
      <input type="submit" name="return" value="Manage Site">
    </TD>
    <TD colspan="2">&nbsp;</TD>
  </TR>
</table>
</form>

<%
End Sub

Sub Show_Man_VDirs()
On Error resume Next
  Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site"))

  Set VDir = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/ROOT/" & Request("vdir"))

  err.clear
	hd = "<TR><TH>Path</TH><TD colspan=""2""><input type=""text"" name=""vpath"" value=""" & vdir.path &""" size=""100""></TD></TR>"
	If err then hd = ""
	err.clear

%>
<TABLE width="100%">
  <form method="post" action="manage_w3svc_vdirs.asp?action=modvdir">
	<Input type="Hidden" name="site" value="<%=Request("site")%>">
	<Input type="Hidden" name="vdir" value="<%=Request("vdir")%>">
  <TR><TH colspan="3">Manage <%=objSite.ServerComment%>\<%=Request("vdir")%> Virtual Directory</TH></TR>

<%
  If Len(message) Then
    Response.write message
    If Len(Request("errmesg")) Then
      response.write "<TR><TH colspan=""3"" class=""errnote"">"
      response.write Request("errmesg")
      If Request("applev") = 1 Then Response.write "<br>Please verify that the Distributed Transaction Coordinator Service is Running."
      Response.write "</TH></TR>"
    End If
  End If
  %>

  <TR>
    <TH>Name</TH>
    <TD colspan="2"><input type="text" name="vname" value="<%=vdir.name%>" size="25"></TD>
  </TR>

  <%= hd %>

  <TR><TH>HTTP Redirect</TH>
	  <TD class="values">
      <%
        HTTPRedir = vdir.HTTPRedirect
        If HTTPRedir = "" Then
          Response.write "Not Enabled"
        Else
          Response.write "Enabled"
        End If
      %>
    </TD>
	  <TD class="options"><a class="man_link" href="manage_w3svc_vdirs.asp?action=httpredir&site=<%=Request("site")%>&vdir=<%=Request("vdir")%>">Manage</a></TD>
  </TR>

  <TR>
    <TH>Default Documents</TH>
	  <TD>
      <%
        DefDocs = vdir.DefaultDoc
        If InStr(DefDocs,",") Then 
          DefDocArr = Split(DefDocs,",")
          DefDocCnt = UBound(DefDocArr) + 1
        Else
          DefDocCnt = 1
        End If
        Response.write DefDocCnt & " document(s) listed."
      %>
    </TD>
	  <TD><a class="man_link" href="manage_w3svc_vdirs.asp?action=defdoc&site=<%=Request("site")%>&vdir=<%=Request("vdir")%>">Manage</a></TD>
  </TR>

  <TR><TH>Document Footer</TH>
	  <TD class="values">
      <%
        Response.write "Document Footer is "
        If vdir.EnableDocFooter = True Then Response.write "Enabled" Else Response.write "Disabled"
      %>
    </TD>
	  <TD><a class="man_link" href="manage_w3svc_vdirs.asp?action=docfoot&site=<%=Request("site")%>&vdir=<%=Request("vdir")%>">Manage</a></TD>
  </TR>

  <TR><TH>Authentication</TH>
	  <TD class="values">
		<%
		Select Case objSiteRoot.AuthFlags
		  Case 0
			Response.Write "No Access"
		  Case 1
			Response.Write "Anonymous Only"
		  Case 2
			Response.Write "Basic(Clear Text) Only, No Anonymous"
		  Case 3
			Response.Write "Basic(Clear Text) and Anonymous"
		  Case 4
			Response.Write "NTLM Only"
		  Case 5
			Response.Write "NTLM and Anonymous"
		  Case 6
			Response.Write "Basic and NTLM, No Anonymous"
		  Case 7
			Response.Write "Basic, NTLM, and Anonymous"
		  Case Else
			Response.Write "Error getting AuthFlags" & objSiteRoot.AuthFlags
		End Select
	  %>
	</TD>
	  <TD class="options">
	  <a class="man_link" href="w3svc_site_config.asp?action=auth&site=<%=Request.QueryString("site")%>">Manage</a>
	</TD>
  </TR>

  <TR>
	<TH>Authentication</TH>
	  <TD colspan="2">
	  <select name="authlev">
			<option value="0" <% If vdir.authflags=0 Then response.write " SELECTED"%>>No Access</option>
			<option value="1" <% If vdir.authflags=1 Then response.write " SELECTED"%>>Anonymous Only</option>
			<option value="2" <% If vdir.authflags=2 Then response.write " SELECTED"%>>Basic(Clear Text) Only, No Anonymous</option>
			<option value="3" <% If vdir.authflags=3 Then response.write " SELECTED"%>>Basic(Clear Text) and Anonymous</option>
			<option value="4" <% If vdir.authflags=4 Then response.write " SELECTED"%>>NTLM Only</option>
			<option value="5" <% If vdir.authflags=5 Then response.write " SELECTED"%>>NTLM and Anonymous</option>
			<option value="6" <% If vdir.authflags=6 Then response.write " SELECTED"%>>Basic and NTLM, No Anonymous</option>
			<option value="7" <% If vdir.authflags=7 Then response.write " SELECTED"%>>Basic, NTLM, and Anonymous</option>
	  </select>
	</TD>
  </TR>
  <TR>
    <TH>Anonymous User Name</TH>
	  <TD><%=vdir.AnonymousUserName%></TD>
    <TD><a class="man_link" href="manage_w3svc_vdirs.asp?action=mananon&site=<%=Request("site")%>&vdir=<%=Request("vdir")%>">Manage</a></TD>
  </TR>
  <TR>
	  <TH>Access Permissions</TH>
	  <TD colspan="2">
	    <TABLE>
		    <TR>
		      <TD><input type="checkbox" name="Read" value="yes" <% If vdir.AccessRead = True Then Response.write "Checked" %>>Read</TD>
		      <TD><input type="checkbox" name="Write" value="yes" <% If vdir.AccessWrite = True Then Response.write "Checked" %>>Write</TD>
		      <TD><input type="checkbox" name="Script" value="yes" <% If vdir.AccessScript = True Then Response.write "Checked" %>>Script</TD>
	      </TR>
	      <TR>
		      <TD><input type="checkbox" name="DirBrowse" value="yes" <% If vdir.EnableDirBrowsing = True Then Response.write "Checked" %>>DirBrowse</TD>
		      <TD><input type="checkbox" name="Log" value="yes" <% If vdir.DontLog = False Then Response.write "Checked" %>>Log</TD>
		      <TD><input type="checkbox" name="Index" value="yes" <% If vdir.ContentIndexed <> 0 Then Response.write "Checked" %>>Index</TD>
	      </TR>
	    </TABLE>
	  </TD>
  </TR>
  <TR>
	  <TH>Execute Permissions</TH>
	  <TD colspan="2">
		  <select name="exeperms">
		    <option value="1" <% If vdir.AccessFlags = "1" Then response.write " SELECTED" %>>None</option>
		    <option value="513" <% If vdir.AccessFlags = "513" Then response.write " SELECTED" %>>Scripts</option>
		    <option value="517" <% If vdir.AccessFlags = "517" Then response.write " SELECTED" %>>Scripts and Executables</option>
	    </select>
	  </TD>
  </TR>
  <TR>
    <TH>IP Restrictions</TH>
	  <TD>Manage IP/Domain Restrictions</TD>
	  <TD><a class="man_link" href="manage_w3svc_vdirs.asp?action=ipdomrest&site=<%=Request("site")%>&vdir=<%=Request("vdir")%>">Manage</a></TD>
  </TR>


  <TR><TD colspan="3">&nbsp;</TD></TR>
  <TR>
	  <TH>Application Process</TH>
	  <TD colspan="2">
<%
AppProcStat = VDir.AppGetStatus2
If AppProcStat = APP_NOT_CREATED Then
  Response.write "<a href=""manage_w3svc_vdirs.asp?action=manvdir&ap=create&site=" & Request("site") & "&vdir=" & Request("vdir") & """>Create</a>"
ElseIf AppProcStat = APP_DISABLED Then
  Response.write "<a href=""manage_w3svc_vdirs.asp?action=manvdir&ap=remove&site=" & Request("site") & "&vdir=" & Request("vdir") & """>Remove</a>"
Else 'AppProcStat = APP_ENABLED
  Response.write "<a href=""manage_w3svc_vdirs.asp?action=manvdir&ap=unload&site=" & Request("site") & "&vdir=" & Request("vdir") & """>Unload</a>"
  Response.write "&nbsp;|&nbsp;"
  Response.write "<a href=""manage_w3svc_vdirs.asp?action=manvdir&ap=remove&site=" & Request("site") & "&vdir=" & Request("vdir") & """>Remove</a>"
End If
%>
	  </TD>
  </TR>
<%
If AppProcStat = APP_ENABLED OR AppProcStat = APP_DISABLED Then
%>
  <TR>
	  <TH>App. Friendly Name</TH>
	  <TD colspan="2"><input type="text" name="appfname" value="<%=vdir.appfriendlyname%>" size="25"></TD>
  </TR>

<%
If Application("IISVer") = 5 Then
%>
  <TR>
	  <TH>App. Memory Space</TH>
	  <TD colspan="2">
		  <select name="applev">
			  <option value="0" <% If VDir.AppIsolated = "0" Then response.write " SELECTED" %>>Low (IIS Process)</option>
			  <option value="2" <% If VDir.AppIsolated = "2" Then response.write " SELECTED" %>>Medium (Pooled Process)</option>
			  <option value="1" <% If VDir.AppIsolated = "1" Then response.write " SELECTED" %>>High (Isolated)</option>
		  </select>
    </TD>
  </TR>
<%
ElseIf Application("IISVer") = 6 Then
  Set AppPools = GetObject("IIS://" & Application("SERVER") & "/w3svc/AppPools")
  Response.write "<TR><TH rowspan=""2"">App. Memory Space</TH><TD colspan=""2""><select name=""applev"">"
    For Each AppPool in AppPools
      Response.write "<option value=""" & AppPool.Name & """ "
      If VDir.AppPoolId = AppPool.Name Then response.write " SELECTED"
      Response.Write ">" & AppPool.Name & "</option>"
    Next
  	Response.write "</select></TD>"
End If
Response.write "<TR><TD colspan=""2""><a href=""manage_app_pools.asp?appname=" & Server.URLEncode(VDir.AppPoolID) & """>Manage " & VDir.AppPoolID & "</a></TD></TR>"
    %>

  <TR>
	  <TH>Application Options</TH>
	  <TD colspan="2">
	    <TABLE>
			  <TR>
			    <TD><input type="checkbox" name="sessionstate" value="yes" <% If vdir.AspAllowSessionState <> False Then Response.write "Checked" %>>Session State</TD>
			    <TD><input type="checkbox" name="aspbuffer" value="yes" <% If vdir.AspBufferingOn <> False Then Response.write "Checked" %>>Buffering</TD>
			    <TD><input type="checkbox" name="parentpath" value="yes" <% If vdir.AspEnableParentPaths <> False Then Response.write "Checked" %>>Parent Paths</TD>
		    </TR>
		    <TR>
			    <TD colspan="2"><input type="checkbox" name="cdebug" value="yes" <% If vdir.AppAllowClientDebug <> False Then Response.write "Checked" %>>Client Side Debugging</TD>
			    <TD><input type="checkbox" name="sdebug" value="yes" <% If vdir.AppAllowDebugging <> False Then Response.write "Checked" %>>Server Side Debugging</TD>
		    </TR>
		  </TABLE>
	  </TD>
  </TR>
  <TR>
    <TH>Script Mappings</TH>
    <TD>Manage Script Mappings</TD>
	  <TD><a class="man_link" href="manage_w3svc_vdirs.asp?action=scriptmap&site=<%=Request("site")%>&vdir=<%=Request("vdir")%>">Manage</a></TD>
  </TR>
<%
  End If
%>
  <TR><TD colspan="3">&nbsp;</TD></TR>
  <TR><TD colspan="3"><input type="submit" Value="Commit Modifications"></TD></TR>
  <TR><TD colspan="3">&nbsp;</TD></TR>
	<TR><TD colspan="3">&nbsp;<input type="submit" name="return" value="Manage Site">&nbsp;&nbsp;<input type="submit" name="returnvdl" value="List Virtual Directories"></TD></TR>
</table>
</form>
<%
End Sub

Sub Show_VDir_Install
Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site"))
Set objSiteROOT = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/ROOT")
%>
<TABLE width="100%">
<form method="POST" action="manage_w3svc_vdirs.asp?action=create">
<Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TR><TH colspan="2">Create Virtual Directory</TH></TR>
  <TR><TH>Name</TH><TD><input type="text" name="vdirname"></TD></TR>
  <TR><TH>File Path</TH>
	<TD>
	  <input type="text" name="vdir_homedir" value="<%=ObjSiteROOT.Path%>">
	  <br>
	  <input type="checkbox" name="fpathyn" value="yes" Checked>Append Name?
	</TD>
  </TR>
  <TR><TH>Default Documents</TH>
	  <TD><input type="text" name="defdoc" value="<%=ObjSiteROOT.DefaultDoc%>" size="40"></TD>
  </TR>
  <TR><TH>Authentication</TH>
	  <TD>
	  <select name="authlev">
			<option value="0" <% If ObjSiteROOT.authflags=0 Then response.write " SELECTED"%>>No Access</option>
			<option value="1" <% If ObjSiteROOT.authflags=1 Then response.write " SELECTED"%>>Anonymous Only</option>
			<option value="2" <% If ObjSiteROOT.authflags=2 Then response.write " SELECTED"%>>Basic(Clear Text) Only</option>
			<option value="4" <% If ObjSiteROOT.authflags=4 Then response.write " SELECTED"%>>NTLM Only</option>
			<option value="3" <% If ObjSiteROOT.authflags=3 Then response.write " SELECTED"%>>Basic(Clear Text) and Anonymous</option>
			<option value="5" <% If ObjSiteROOT.authflags=5 Then response.write " SELECTED"%>>NTLM and Anonymous</option>
			<option value="6" <% If ObjSiteROOT.authflags=6 Then response.write " SELECTED"%>>Basic, NTLM, and No Anonymous</option>
			<option value="7" <% If ObjSiteROOT.authflags=7 Then response.write " SELECTED"%>>Basic, NTLM, and Anonymous</option>
	  </select>
	</TD>
  </TR>
  <TR>
	<TH>Access Permissions</TH>
	<TD>
	  <TABLE>
		<TR>
		  <TD><input type="checkbox" name="Read" value="yes" <% If ObjSiteROOT.AccessRead = True Then Response.write "Checked" %>>Read</TD>
		  <TD><input type="checkbox" name="Write" value="yes" <% If ObjSiteROOT.AccessWrite = True Then Response.write "Checked" %>>Write</TD>
		  <TD><input type="checkbox" name="Script" value="yes" <% If ObjSiteROOT.AccessScript = True Then Response.write "Checked" %>>Script Source</TD>
	  </TR>
	  <TR>
		<TD><input type="checkbox" name="DirBrowse" value="yes" <% If ObjSiteROOT.EnableDirBrowsing = True Then Response.write "Checked" %>>DirBrowse</TD>
		<TD><input type="checkbox" name="Log" value="yes" <% If ObjSiteROOT.DontLog = False Then Response.write "Checked" %>>Log</TD>
		<TD><input type="checkbox" name="Index" value="yes" <% If ObjSiteROOT.ContentIndexed <> 0 Then Response.write "Checked" %>>Index</TD>
	  </TR>
	</TABLE>
	</TD>
  </TR>
  <TR>
	<TH>Execute Permissions</TH>
	  <TD>
		<select name="exeperms">
		  <option value="1" <% If ObjSiteROOT.AccessFlags = "1" Then response.write " SELECTED" %>>None</option>
		  <option value="513" <% If ObjSiteROOT.AccessFlags = "513" Then response.write " SELECTED" %>>Scripts</option>
		  <option value="517" <% If ObjSiteROOT.AccessFlags = "517" Then response.write " SELECTED" %>>Scripts and Executables</option>
	  </select>
	</TD>
  </TR>
  <TR>
	<TH>Create Application?</TH>
	<TD>
	  <select name="appspyn">
		<option value="yes" SELECTED>Yes</option>
		<option value="no">No</option>
	  </select>
	  <br>
	  If No, the options below are not used.
	</TD>
  </TR>
  <TR>
	<TH>App Friendly Name:</TH>
	<TD>
	  <input type="text" name="appspname" value="Default Application">
		<br>
		<input type="checkbox" name="aspnyn" value="yes">Use Name instead?
	  </TD>
  </TR>
  <TR>
    <TH>App. Memory Space</TH>
    <TD>
    <%
      If Application("IISVer") = 5 Then
    %>
		  <select name="applev">
			  <option value="0">Low (IIS Process)</option>
			  <option value="2" SELECTED>Medium (Pooled Process)</option>
			  <option value="1">High (Isolated)</option>
		  </select>
    <%
      ElseIf Application("IISVer") = 6 Then
        Set AppPools = GetObject("IIS://" & Application("SERVER") & "/w3svc/AppPools")
        Response.write "<select name=""applev"">"
        For Each AppPool in AppPools
          Response.write "<option value=""" & AppPool.Name & """ "
          If AppPool.Name = "DefaultAppPool" Then response.write " SELECTED"
          Response.Write ">" & AppPool.Name & "</option>"
        Next
  	    Response.write "</select>"
      End If
    %>
  	</TD>
  </TR>
  <TR>
	<TH>Application Options</TH>
	  <TD>
	  <TABLE>
			<TR>
			  <TD><input type="checkbox" name="sessionstate" value="yes" <% If ObjSiteROOT.AspAllowSessionState <> False Then Response.write "Checked" %>>Session State</TD>
			  <TD><input type="checkbox" name="aspbuffer" value="yes" <% If ObjSiteROOT.AspBufferingOn <> False Then Response.write "Checked" %>>Buffering</TD>
			  <TD><input type="checkbox" name="parentpath" value="yes" <% If ObjSiteROOT.AspEnableParentPaths <> False Then Response.write "Checked" %>>Parent Paths</TD>
		  </TR>
		  <TR>
			  <TD colspan="2"><input type="checkbox" name="cdebug" value="yes" <% If ObjSiteROOT.AppAllowClientDebug <> False Then Response.write "Checked" %>>Client Side Debugging</TD>
			  <TD><input type="checkbox" name="sdebug" value="yes" <% If ObjSiteROOT.AppAllowDebugging <> False Then Response.write "Checked" %>>Server Side Debugging</TD>
		  </TR>
		</TABLE>
	</TD>
  </TR>
  <TR>
	<TD colspan="2">
	  <input type="submit" value="Create">
	  &nbsp;&nbsp;
	  <input type="submit" name="return" value="Manage Site">
	  &nbsp;&nbsp;
	  <input type="submit" name="returnvdl" value="List Virtual Directories">
	</TD>
  </TR>
</table>

</form>
<%
End Sub

Sub Manage_Anon()
Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site"))
Set objSiteVDir = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/ROOT/"& Request("vdir"))

If Len(Request("sus")) Then
  UserSelect = "<select name=""anonuser"">"
  Set BaseObj = GetObject("WinNT://" & Application("domain") & "/" & Application("Server"))
    BaseObj.Filter = Array("user")
    For Each user in BaseObj
      If InStr(objSiteVDir.AnonymousUserName,user.Name) Then
        UserSelect = UserSelect & "<option value=""" & user.name & """ SELECTED>" & user.name & "</option>"
      Else
        UserSelect = UserSelect & "<option value=""" & user.name & """>" & user.name & "</option>"
      End If
    Next
  Set BaseObj = Nothing
  UserSelect = UserSelect & "</select>"
  UserOption = "<a href=""manage_w3svc_vdirs.asp?action=mananon&site=" & Request("site")
  UserOption = UserOption & "&vdir=" & Request("vdir") & """>Enter User Name</a>"
  PassBox = "Password is auto-syncronized"
Else
  UserSelect = "<input type=""text"" name=""anonuser"" value=""" & objSiteVDir.AnonymousUserName & """ size=""20"">"
  UserOption = "<a href=""manage_w3svc_vdirs.asp?action=mananon&site=" & Request("site")
  UserOption = UserOption & "&vdir=" & Request("vdir") & "&sus=1"">Show Available Users</a>"
  PassBox = "<input type=""text"" name=""anonpass"" value=""" & objSiteVDir.AnonymousUserPass & """>"
End If


%>
<TABLE>
  <form method="post" action="manage_w3svc_vdirs.asp?action=update_anon">
	<Input type="Hidden" name="site" value="<%=Request("site")%>">
	<Input type="Hidden" name="vdir" value="<%=Request("vdir")%>">
  <TR><TH colspan="3">Manage <%=objSite.ServerComment%>\<%=objSiteVDir.Name%> Anonymous User</TH></TR>
  <TR><TD colspan="3">&nbsp;</TD></TR>
  <TR>
    <TH>Username:</TH>
    <TD>
      <p align="left"><%=UserSelect%></P>
    </TD>
    <TD rowspan="2">
      <BR>
      <%=UserOption%>
      <BR><BR>
      <input type="submit" name="man_anon_vd" value="Commit Changes">
      <BR><BR>
    </TD>
  </TR>
  <TR>
    <TH>Password:</TH>
    <TD><p align="left"><%=PassBox%></P></TD>
  </TR>
  <TR><TD colspan="3">&nbsp;</TD></TR>
  <TR>
	  <TD colspan="3">&nbsp;<input type="submit" name="return" value="Manage Site">&nbsp;&nbsp;<input type="submit" name="returnvd" value="Manage Virtual Directory">&nbsp;&nbsp;<input type="submit" name="returnvdl" value="List Virtual Directories">&nbsp;</TD>
  </TR>
</table>
</form>

<%
End Sub

Sub ScriptMap(errs)
    Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site"))
    Set objSiteROOT = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/ROOT/" & Request("vdir"))
    ServerComment = objSite.ServerComment

  ScriptMaps = objSiteROOT.ScriptMaps
  If Ubound(ScriptMaps) <= 9 Then selectsize = Ubound(ScriptMaps) + 1 else selectsize = 10
  SMOut = "<SELECT MULTIPLE Name=""CurSM"" size=""" & selectsize & """>"
  For x = 0 to Ubound(ScriptMaps)
    Script = Split(ScriptMaps(x),",")
	  SMOut = SMOut & "<option value=""" & Script(0) & """>" & Script(0) & "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" & Script(1) & "</option>"
  Next
  SMOut = SMOut & "</SELECT>"

%>
<form name="theform" method="post" action="manage_w3svc_vdirs.asp?action=change_scriptmap">
<Input type="Hidden" name="vdir" value="<%=Request("vdir")%>">
<Input type="Hidden" name="site" value="<%=Request("site")%>">
  <TABLE width="75%">
    <TR><TH colspan=2>Manage <%=ServerComment%>\<%=Request("vdir")%> Script Mappings</TH></TR>
    <TR><TD colspan="2">&nbsp;<%=errs%></TD></TR>
    <TR><TH>Current Entries</TH><TD>&nbsp;</TD></TR>
    <TR>
      <TD><%= SMOut%></TD>
      <TD>
        &nbsp;<input type="submit" name="rem" value="Remove">&nbsp;<BR><BR>
        <input type="submit" name="edit" value="Edit">
      </TD>
    </TR>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <TR><TH>Add an entry</TH><TD>&nbsp;</TD></TR>
    <TR>
      <TD>
       <p align="left">
        Executable: <input type="text" name="scriptpath" size="40"><BR>
        Extension: &nbsp;&nbsp;<input type="text" name="scripttext" size="10"><BR><BR>
        <input type="radio" name="verb" value="all" CHECKED> All Verbs<BR>
        <input type="radio" name="verb" value="limit"> Limit to: <input type="text" name="limitverbs" size="40"><br><BR>
        <input type="checkbox" name="scripteng" value="yes" Checked> Script Engine<br>
        <input type="checkbox" name="verify" value="yes" Checked> Verify that file exists<br>
        </p>
      </TD>
      <TD>
        <input type="submit" name="add" value="Add">
      </TD>
    </TR>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <TR><TD colspan="2"><input type="submit" name="return" value="Manage Site">&nbsp;&nbsp;<input type="submit" name="returnvd" value="Manage Virtual Directory">&nbsp;&nbsp;<input type="submit" name="returnvdl" value="List Virtual Directories">&nbsp;</TD></TR>
  </table>
</form>
<%
End Sub

Sub EditScriptMap(errs)
' On Error Resume Next
    Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site"))
    Set objSiteROOT = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/ROOT/" & Request("vdir"))
    ServerComment = objSite.ServerComment

  ScriptMaps = objSiteROOT.ScriptMaps
  For x = 0 to Ubound(ScriptMaps)
    Script = Split(ScriptMaps(x),",")
    If Script(0) = Request("CurSM") Then Exit For
  Next

  scriptpath = Script(1)
  scripttext = Script(0)
  If Script(2) = 4 or Script(2) = 5 Then verify = "CHECKED"
  If Script(2) = 1 or Script(2) = 5 Then scripteng = "CHECKED"
  If UBound(Script) > 2 Then
    limitverbs = "CHECKED"
    For i = 3 To UBound(Script)
      verbs = verbs & script(i) & ","
    Next
    verbs = Left(verbs,Len(verbs)-1)
  Else
    allverbs = "CHECKED"
  End If

%>
<form name="theform" method="post" action="manage_w3svc_vdirs.asp?action=update_scriptmap">
<Input type="Hidden" name="site" value="<%=Request("site")%>">
<Input type="Hidden" name="vdir" value="<%=Request("vdir")%>">
<Input type="Hidden" name="scripttext" value="<%=scripttext%>">
  <TABLE width="75%">
    <TR><TH colspan=2>Manage <%=ServerComment%> Script Mappings</TH></TR>
    <TR><TD colspan="2">&nbsp;<%=errs%></TD></TR>
    <TR><TH>Edit entry</TH><TD>&nbsp;</TD></TR>
    <TR>
      <TD>
       <p align="left">
        Executable: <input type="text" name="scriptpath" size="40" value="<%=scriptpath%>"><BR>
        Extension: &nbsp;&nbsp;<%=scripttext%><BR><BR>
        <input type="radio" name="verb" value="all" <%=allverbs%>> All Verbs<BR>
        <input type="radio" name="verb" value="limit" <%=limitverbs%>> Limit to: <input type="text" name="limitverbs" size="40" value="<%=verbs%>"><br><BR>
        <input type="checkbox" name="scripteng" value="yes" <%=scripteng%>> Script Engine<br>
        <input type="checkbox" name="verify" value="yes" <%=verify%>> Verify that file exists<br>
        </p>
      </TD>
      <TD>
        <input type="submit" name="update" value="Update">
      </TD>
    </TR>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <TR><TD colspan="2"><input type="submit" name="returnvd" value="Manage Virtual Directory">&nbsp;&nbsp;<input type="submit" name="manscript" value="Manage Script Maps"></TD></TR>
  </table>
</form>
<%
End Sub

Sub DefDoc(errs)
  Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site"))
  Set objSiteVDir = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/ROOT/" & Request("vdir"))
    ServerComment = objSite.ServerComment

  If InStr(objSiteVDir.DefaultDoc,",") Then
    DefDocArr = Split(objSiteVDir.DefaultDoc,",")
  Else
    Dim DefDocArr(0)
    DefDocArr(0) = objSiteVDir.DefaultDoc
  End If

  DefDocOut = "<SELECT MULTIPLE NAME=""defdoc"" size=""" & Ubound(DefDocArr)+1 & """>"
  For x = 0 to UBound(DefDocArr)
    DefDocOut = DefDocOut & "<OPTION Value=""" & DefDocArr(x) & """>" & DefDocArr(x) & "</OPTION>"
  Next
  DefDocOut = DefDocOut & "</SELECT>"
%>

<form name="theform" method="post" action="manage_w3svc_vdirs.asp?action=change_defdoc">

<TABLE width="75%">
  <Input type="Hidden" name="site" value="<%=Request("site")%>">
  <Input type="Hidden" name="vdir" value="<%=Request("vdir")%>">
  <TR><TH colspan=2>Manage Defalt Documents and Ordering for <%=ServerComment%>/<%=Request("vdir")%></TH></TR>
  <TR><TD colspan="2">&nbsp;<%=errs%></TD></TR>
  <TR><TH>Current Default Documents</TH><TD>&nbsp;</TD></TR>
  <TR>
    <TD><%= DefDocOut%></TD>
    <TD>
      <input type="submit" name="moveup" value="Move Up">
      <br><br>
      <input type="submit" name="movedown" value="Move Down">
      <br><br>
      <input type="submit" name="remdefdoc" value="Remove">
    </TD>
  </TR>
  <TR><TH>Add a Document</TH><TD>&nbsp;</TD></TR>
  <TR>
    <TD><input type="text" name="NewDefDoc" id="GiveMeFocus" size="15"></TD>
    <TD>
      <input type="submit" name="adddefdoc" value="Add">
    </TD>
  </TR>

  <TR><TD colspan="2">&nbsp;</TD></TR>
  <TR><TD colspan="2"><input type="submit" name="return" value="Manage Site">&nbsp;&nbsp;<input type="submit" name="returnvd" value="Manage Virtual Directory">&nbsp;&nbsp;<input type="submit" name="returnvdl" value="List Virtual Directories">&nbsp;</TD></TR>
</table>
</form>
<%
End Sub

Sub DocFoot(errs)
On Error Resume Next

  Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site"))
  Set objSiteVDir = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/ROOT/" & Request("vdir"))
  ServerComment = objSite.ServerComment
  If objSiteVDir.EnableDocFooter = True Then
    DocFoot_Current = Right(objSiteVDir.DefaultDocFooter,(Len(objSiteVDir.DefaultDocFooter)-5))
    DocFoot_Message = "Document Footer is currently set to:<BR>" & Right(objSiteVDir.DefaultDocFooter,(Len(objSiteVDir.DefaultDocFooter)-5))
  Else
    DocFoot_Current = ""
    DocFoot_Message = "Document Footer is currently disabled."
  End If

%>
<form name="theform" method="post" action="manage_w3svc_vdirs.asp?action=change_docfoot">
  <Input type="Hidden" name="site" value="<%=Request("site")%>">
  <Input type="Hidden" name="vdir" value="<%=Request("vdir")%>">
  <TABLE>
    <TR><TH colspan="2">Manage <%=ServerComment%>\<%=Request("Vdir")%> Document Footer</TH></TR>
    <TR><TD colspan="2">&nbsp;<%=errs%></TD></TR>
    <TR><TD colspan="2"><%= DocFoot_Message%></TD></TR>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <TR>
      <TD>
        <input type="text" name="docfootstr" id="GiveMeFocus" value="<%=DocFoot_Current%>" size="50"><BR>
      </TD>
      <TD>
        <input type="submit" name="remove" Value="Remove">
        <BR><BR>
        <input type="submit" name="update" Value="Update">
      </TD>
    </TR>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <TR><TD colspan="2"><input type="submit" name="return" value="Manage Site">&nbsp;&nbsp;<input type="submit" name="returnvd" value="Manage Virtual Directory">&nbsp;&nbsp;<input type="submit" name="returnvdl" value="List Virtual Directories">&nbsp;</TD></TR>
  </TABLE>
</form>
<%
End Sub


Sub IPDomRestrictions(errs)
' Set up variables.
  Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site"))
  Set objSiteVDir = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/ROOT/" & Request("vdir"))
  Set IIsIPSecurityObj = objSiteVDir.IPSecurity

If True = IIsIPSecurityObj.GrantByDefault Then
  output = "By Default All IP's and Domains are Granted access"
  SwitchButton = "<input type=""submit"" name=""switch"" value=""Deny by Default"">"

  Set IIsIPSecurityObj = objSiteVDir.IPSecurity
  IPList = IIsIPSecurityObj.IPDeny

  If UBound(IPList) >= 0 Then
    IPListOut = "<SELECT MULTIPLE Name=""IPList"" size=""" & Ubound(IPList) + 1 & """>"
    For x = 0 to Ubound(IPList)
	    IPListOut = IPListOut & "<option value=""" & IPList(x) & """>" & IPList(x) & "</option>"
    Next
    IPListOut = IPListOut & "</SELECT>"
    IPRemButton = "<input type=""submit"" name=""remIP"" value=""Remove"">"
  Else
    IPListOut = "No IP's are being denied"
    IPRemButton = "&nbsp;"
  End If

  DomList = IIsIPSecurityObj.DomainDeny

  If UBound(DomList) >= 0 Then
    DomListOut = "<SELECT MULTIPLE Name=""DomList"" size=""" & Ubound(DomList) + 1 & """>"
    For x = 0 to Ubound(DomList)
	    DomListOut = DomListOut & "<option value=""" & DomList(x) & """>" & DomList(x) & "</option>"
    Next
    DomListOut = DomListOut & "</SELECT>"
    DomRemButton = "<input type=""submit"" name=""remDom"" value=""Remove"">"
  Else
    DomListOut = "No Domains are being denied"
    DomRemButton = "&nbsp;"
  End If

Else

  output = "By Default All IP's and Domains are Denied access"
  SwitchButton = "<input type=""submit"" name=""switch"" value=""Grant by Default"">"

  Set IIsIPSecurityObj = objSiteVDir.IPSecurity
  IPList = IIsIPSecurityObj.IPGrant

  If UBound(IPList) >= 0 Then
    IPListOut = "<SELECT MULTIPLE Name=""IPList"" size=""" & Ubound(IPList) + 1 & """>"
    For x = 0 to Ubound(IPList)
	    IPListOut = IPListOut & "<option value=""" & IPList(x) & """>" & IPList(x) & "</option>"
    Next
    IPListOut = IPListOut & "</SELECT>"
    IPRemButton = "<input type=""submit"" name=""remIP"" value=""Remove"">"
  Else
    IPListOut = "No IP's are being granted access"
    IPRemButton = "&nbsp;"
  End If

  DomList = IIsIPSecurityObj.DomainGrant

  If UBound(DomList) >= 0 Then
    DomListOut = "<SELECT MULTIPLE Name=""DomList"" size=""" & Ubound(DomList) + 1 & """>"
    For x = 0 to Ubound(DomList)
	    DomListOut = DomListOut & "<option value=""" & DomList(x) & """>" & DomList(x) & "</option>"
    Next
    DomListOut = DomListOut & "</SELECT>"
    DomRemButton = "<input type=""submit"" name=""remDom"" value=""Remove"">"
  Else
    DomListOut = "No Domains are being granted access"
    DomRemButton = "&nbsp;"
  End If

End if
%>
  <form method="post" action="manage_w3svc_vdirs.asp?action=change_ipdomrest">
  <Input type="Hidden" name="site" value="<%=Request("site")%>">
  <Input type="Hidden" name="vdir" value="<%=Request("vdir")%>">
  <TABLE>
    <TR><TH colspan="3">Manage <%=objSite.ServerComment%>\<%=Request("vdir")%> IP Address and Domain Restrictions</TH></TR>
    <TR><TD colspan="3">&nbsp;<%=errs%></TD></TR>
    <TR><TH colspan="3"><%=output%></TH></TR>
    <TR><TD colspan="3">Switch to: <%=SwitchButton%></TD></TR>
    <TR><TD colspan="3">&nbsp;</TD></TR>
    <TR>
      <TH colspan="3">Current Entries</TH>
    </TR>
    <TR>
      <TD colspan="2"><%=IPListOut%></TD>
      <TD><%=IPRemButton%></TD>
    </TR>
    <TR>
      <TD colspan="2"><%=DomListOut%></TD>
      <TD><%=DomRemButton%></TD>
    </TR>
    <TR><TD colspan="3">&nbsp;</TD></TR>
    <TR>
      <TH colspan="3">Add an Entry</TH>
    </TR>
    <TR>
      <TH>Single IP</TH>
      <TD>IP Address: <input type="text" name="ipadd" size="15"></TD>
      <TD Rowspan="3">
        <input type="submit" name="add" value="Add">
      </TD>
    </TR>
    <TR>
      <TH>IP Range</TH>
      <TD>Network ID: <input type="text" name="netid" size="15">&nbsp;&nbsp;Subnet: <input type="text" name="subnet" size="15"></TD>
    </TR>
    <TR>
      <TH>Domain Name:</TH>
      <TD>Domain Name: <input type="text" name="domain" size="40"></TD>
    </TR>
    <TR><TD colspan="3">&nbsp;</TD></TR>
    <TR><TD colspan="3"><input type="submit" name="return" value="Manage Site">&nbsp;&nbsp;<input type="submit" name="returnvd" value="Manage Virtual Directory">&nbsp;&nbsp;<input type="submit" name="returnvdl" value="List Virtual Directories">&nbsp;</TD></TR>
  </table>
</form>

<%
End Sub

Sub HTTPRedir(errs)
On Error Resume Next

  Set objSite = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site"))
  Set objSiteVDir = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/ROOT/" & Request("vdir"))

  httpRedirect = objSiteVDir.HTTPRedirect

  Dim httpRedirStr, httpRedirExURL, httpRedirDirBelow, httpRedirPerm
  httpRedirExURL = ""
  httpRedirDirBelow = ""
  httpRedirPerm = ""

  If httpRedirect = "" Then
    httpRedir_Current = "HTTP Redirection is not Enabled"
    httpRedirStr = "http://"
  Else
    httpRedir_Current = "HTTP Redirection is Enabled"
    Dim httRedirValues
    If InStr(httpRedirect,",") Then
      httpRedirValues = Split(httpRedirect,",")
    Else
      ReDim httpRedirValues(0)
      httpRedirValues(0) = httpRedirect
    End If

    httpRedirStr = httpRedirValues(0)
    For i = 1 to UBound(httpRedirValues)
      Select Case Trim(httpRedirValues(i))
        Case "EXACT_DESTINATION"
          httpRedirExURL = "CHECKED"
        Case "CHILD_ONLY"
          httpRedirDirBelow = "CHECKED"
        Case "PERMANENT"
          httpRedirPerm = "CHECKED"
        Case "TEMPORARY"
          httpRedirExURL = ""
      End Select
    Next
  End If

%>
<form name="theform" method="post" action="manage_w3svc_vdirs.asp?action=change_httpredir">
  <Input type="Hidden" name="site" value="<%=Request("site")%>">
  <Input type="Hidden" name="vdir" value="<%=Request("vdir")%>">
  <TABLE>
    <TR><TH colspan="2">Manage <%=objSite.ServerComment%>\<%=Request("vdir")%> HTTP Redirect</TH></TR>
    <TR><TD colspan="2">&nbsp;<%=errs%></TD></TR>
    <TR><TH colspan="2"><%= HTTPRedir_Current%></TH></TR>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <TR>
      <TD>
        <p align="left">
        Redirect To: <input type="text" name="httpredirstr" id="GiveMeFocus" value="<%=httpRedirStr%>" size="40"><BR>
        <BR>
        <input type="checkbox" name="httpRedirExURL" value="yes" <%=httpRedirExURL%>> The Exact URL Entered Above<BR>
        <input type="checkbox" name="httpRedirDirBelow" value="yes" <%=httpRedirDirBelow%>>A directory below URL Entered<BR>
        <input type="checkbox" name="httpRedirPerm" value="yes" <%=httpRedirPerm%>>A permanent Redirection for this resource<BR>
        <BR>
        </P>
      </TD>
      <TD>
        <input type="submit" name="remove" Value="Remove">
        <BR><BR>
        <input type="submit" Value="Update">
      </TD>
    </TR>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <TR><TD colspan="2"><input type="submit" name="return" value="Manage Site">&nbsp;&nbsp;<input type="submit" name="returnvd" value="Manage Virtual Directory">&nbsp;&nbsp;<input type="submit" name="returnvdl" value="List Virtual Directories">&nbsp;</TD></TR>
  </TABLE>
</form>
<%
End Sub





Sub Create_VDir
Set objSiteROOT = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/ROOT")

filepath = Trim(Request("vdir_homedir"))
If Request("fpathyn") = "yes" Then
  If Right(objSiteROOT.Path, 1) = "\" Then
    filepath = objSiteROOT.Path & Trim(Request("vdirname"))
  Else
    filepath = objSiteROOT.Path & "\" & Trim(Request("vdirname"))
  End If
End If

Set fso = CreateObject("Scripting.FileSystemObject")
If fso.FolderExists(filepath) = False Then fso.CreateFolder(filepath)

  Set ObjSiteVDir = objSiteROOT.Create("IIsWebVirtualDir",Trim(Request("vdirname")))
    ObjSiteVDir.Path = filepath
    ObjSiteVDir.EnableDefaultDoc = True

  If LCase(Request("Read")) = "yes" Then
	  objSiteVDir.AccessRead = True
  Else
	  objSiteVDir.AccessRead = False
  End If

  If LCase(Request("Write")) = "yes" Then
	  objSiteVDir.AccessWrite = True
  Else
	  objSiteVDir.AccessWrite = False
  End If

  If LCase(Request("Log")) = "yes" Then
	  objSiteVDir.DontLog = False
  Else
	  objSiteVDir.DontLog = True
  End If

  If LCase(Request("DirBrowse")) = "yes" Then
	  objSiteVDir.EnableDirBrowsing = True
  Else
	  objSiteVDir.EnableDirBrowsing = False
  End If

  If LCase(Request("index")) = "yes" Then
	  objSiteVDir.ContentIndexed = True
  Else
	  objSiteVDir.ContentIndexed = False
  End If

  If LCase(Request("script")) = "yes" and (objSiteVDir.AccessRead = True or objSiteVDir.AccessWrite = True) Then
	  objSiteVDir.AccessScript = True
  Else
	  objSiteVDir.AccessScript = False
  End If

  objSiteVDir.AccessFlags = Request("exeperms")
  objSiteVDir.AuthFlags = Request("authlev")
  objSiteVDir.DefaultDoc = Request("defdoc")
  objSiteVDir.SetInfo

  'App Creation
  If LCase(Request("appspyn")) = "yes" Then

	  objSiteVDir.AppCreate2 Request("applev")
	  'App Created
	  'Now set the properties

  	If LCase(Request("aspnyn")) = "yes" Then
  	  objSiteVDir.AppFriendlyName = Request("vdirname")
  	Else
  	  objSiteVDir.AppFriendlyName = Request("appspname")
  	End If

  	If LCase(Request("sessionstate")) = "yes" Then
  		objSiteVDir.AspAllowSessionState = True
  	Else
  	  objSiteVDir.AspAllowSessionState = False
  	End If

  	If LCase(Request("aspbuffer")) = "yes" Then
  		objSiteVDir.AspBufferingOn = True
  	Else
  	  objSiteVDir.AspBufferingOn = False
  	End If

  	If LCase(Request("parentpath")) = "yes" Then
  		objSiteVDir.AspEnableParentPaths = True
  	Else
  	  objSiteVDir.AspEnableParentPaths = False
  	End If

  	If LCase(Request("cdebug")) = "yes" Then
  		objSiteVDir.AppAllowClientDebug = True
  	Else
  	  objSiteVDir.AppAllowClientDebug = False
  	End If

  	If LCase(Request("sdebug")) = "yes" Then
  		objSiteVDir.AppAllowDebugging = True
  	Else
  	  objSiteVDir.AppAllowDebugging = False
  	End If

  	objSiteVDir.SetInfo

  End If

Response.redirect ("manage_w3svc_vdirs.asp?action=manvdir&site=" & Request("site")& "&vdir=" & Request("vdirname")&"&tc=1")
End Sub

Sub Mod_VDir
On Error Resume Next

Set objSiteVDir = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/ROOT/"& Request("vdir"))
Set objSiteROOT = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/ROOT")

  If Len(Request("vpath")) Then
	  Set fso = CreateObject("Scripting.FileSystemObject")
	    If fso.FolderExists(Trim(Request("vpath"))) = False Then fso.CreateFolder(Trim(Request("vpath")))
	    objSiteVDir.Path = Trim(Request("vpath"))
	  Set fso = Nothing
  End If

  If LCase(Request("Read")) = "yes" Then
	  objSiteVDir.AccessRead = True
  Else
	  objSiteVDir.AccessRead = False
  End If

	If LCase(Request("Write")) = "yes" Then
	  objSiteVDir.AccessWrite = True
	Else
	  objSiteVDir.AccessWrite = False
	End If

	If LCase(Request("Log")) = "yes" Then
	  objSiteVDir.DontLog = False
	Else
	  objSiteVDir.DontLog = True
	End If

	If LCase(Request("DirBrowse")) = "yes" Then
	  objSiteVDir.EnableDirBrowsing = True
	Else
	  objSiteVDir.EnableDirBrowsing = False
	End If

	If LCase(Request("index")) = "yes" Then
	  objSiteVDir.ContentIndexed = True
	Else
	  objSiteVDir.ContentIndexed = False
	End If

  If LCase(Request("script")) = "yes" and (objSiteVDir.AccessRead = True or objSiteVDir.AccessWrite = True) Then
	  objSiteVDir.AccessScript = True
  Else
	  objSiteVDir.AccessScript = False
  End If

  If Len(Request("sessionstate")) Then
    ObjSiteVDir.AuthFlags = Request("authlev")

    If objSiteVDir.AppGetStatus2 <> 2 Then
	  If LCase(Request("sessionstate")) = "yes" Then
	    objSiteVDir.AspAllowSessionState = True
	  Else
	    objSiteVDir.AspAllowSessionState = False
 	  End If

  	If LCase(Request("aspbuffer")) = "yes" Then
  	  objSiteVDir.AspBufferingOn = True
  	Else
  	  objSiteVDir.AspBufferingOn = False
  	End If

  	If LCase(Request("parentpath")) = "yes" Then
  	  objSiteVDir.AspEnableParentPaths = True
  	Else
  	  objSiteVDir.AspEnableParentPaths = False
  	End If

    If LCase(Request("cdebug")) = "yes" Then
      objSiteVDir.AppAllowClientDebug = True
  	Else
  	  objSiteVDir.AppAllowClientDebug = False
  	End If

  	If LCase(Request("sdebug")) = "yes" Then
  	  objSiteVDir.AppAllowDebugging = True
  	Else
  	  objSiteVDir.AppAllowDebugging = False
  	End If
  End If

  If Application("IISVer") = 5 Then
    objSiteVDir.AppFriendlyName = Request("appfname")
    err.clear
    CurAppLev = ObjSiteVDir.AppIsolated
    objSiteVDir.AppCreate2 Request("applev")
    If err then
      objSiteVDir.AppCreate2 CurAppLev
      errmesg = "Unable to change Application level."
    End If
	End If

  If Application("IISVer") = 6 Then
    'Change name
    If objSiteVDir.AppFriendlyName <> Request("appfname") Then objSiteVDir.AppFriendlyName = Request("appfname")
    'Change Pool
    If ObjSiteVDir.AppPoolID <> Request("applev") Then ObjSiteVDir.AppPoolId = Request("applev")
  End If

  End If

  objSiteVDir.SetInfo

  If LCase(Request("vname")) <> LCase(Request("vdir")) Then
    Set MoveObj = ObjSiteROOT.MoveHere(Request("vdir"), Request("vname"))
  End If

  If Err Then
  	Response.redirect ("manage_w3svc_vdirs.asp?action=manvdir&site=" & Request("site")& "&vdir=" & Request("vdir")&"&tc=0&errmesg=" & errmesg & "&applev=" & Request("applev"))
  Else
	  Response.redirect ("manage_w3svc_vdirs.asp?action=manvdir&site=" & Request("site")& "&vdir=" & Request("vdir")&"&tc=1")
  End If

End Sub

Sub Del_VDir
Set objSiteROOT = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/ROOT")
  objSiteROOT.Delete "IIsWebVirtualDir",Request("vdir")
Response.redirect ("manage_w3svc_vdirs.asp?action=vdirs&site=" & Request("site"))
End Sub

Sub AppProc()
On Error Resume Next
Set ObjSiteVdir = GetObject( "IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/ROOT/" & Request("vdir"))
appstat = ObjSiteVdir.AppGetStatus2

  Select Case LCase(Request("ap"))
	Case "unload"
	  ObjSiteVdir.AppUnload
	Case "enable"
		ObjSiteVdir.AppEnable
	Case "disable"
	  ObjSiteVdir.AppDisable
	Case "create"
	  ObjSiteVdir.AppCreate2 POOLED 'Default to pooled, since we don't get a setting in the querystring
		ObjSiteVdir.AppFriendlyName = Request("vdir")
		objSiteVDir.SetInfo
	Case "remove"
	  ObjSiteVdir.AppDelete
  End Select

  If Err Then
	Response.redirect ("manage_w3svc_vdirs.asp?action=manvdir&site=" & Request("site")& "&vdir=" & Request("vdir")&"&tc=0")
  Else
	Response.redirect ("manage_w3svc_vdirs.asp?action=manvdir&site=" & Request("site")& "&vdir=" & Request("vdir")&"&tc=1")
  End If

End sub

Sub UpdateScriptMap(errs)
On Error Resume Next
  Set objSiteROOT = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/ROOT/" & Request("vdir"))

  ScriptMaps = objSiteROOT.ScriptMaps
  LPos = UBound(ScriptMaps)
  Dim NewScriptMaps()
  ReDim NewScriptMaps(LPos)

  For x = 0 to Ubound(ScriptMaps)
    Script = Split(ScriptMaps(x),",")
    If Script(0) = Request("scripttext") Then
      screngver = 0
      If Request("scripteng") = "yes" Then screngver = screngver + 1
      If Request("verify") = "yes" Then screngver = screngver + 4
      If Request("verb") = "limit" Then verbs = "," & Request("limitverbs")
      NewScript = Request("scripttext") & "," & Request("scriptpath") & "," & screngver & verbs
      NewScriptMaps(x) = NewScript
    Else
      NewScriptMaps(x) = ScriptMaps(x)
    End If
  Next
  objSiteROOT.ScriptMaps = NewScriptMaps
  objSiteROOT.SetInfo
  Set objSiteROOT = Nothing

  If err Then errs = "There was an error!<br>Err: " & Err.description Else errs = "Updated!"

End Sub

Sub AddScriptMap(errs)
On Error Resume Next
  Set objSiteROOT = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/ROOT/" & Request("vdir"))

  ScriptMaps = objSiteROOT.ScriptMaps
  LPos = UBound(ScriptMaps) + 1
  NewScriptMaps = ScriptMaps
  ReDim Preserve NewScriptMaps(LPos)

    screngver = 0
    If Request("scripteng") = "yes" Then screngver = screngver + 1
    If Request("verify") = "yes" Then screngver = screngver + 4
    verbs = ""
    If Request("verb") = "limit" Then verbs = "," & Request("limitverbs")
    NewScript = Request("scripttext") & "," & Request("scriptpath") & "," & screngver & verbs
    NewScriptMaps(LPos) = NewScript

  objSiteROOT.ScriptMaps = NewScriptMaps
  objSiteROOT.SetInfo
  Set objSiteROOT = Nothing

  If err Then errs = "There was an error!<br>Err: " & Err.description Else errs = "Added!"

End Sub

Sub RemoveScriptMap(errs)
On Error Resume Next
  Set objSiteROOT = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/ROOT/" & Request("vdir"))

  ScriptMaps = objSiteROOT.ScriptMaps
  LPos = UBound(ScriptMaps) - Request("CurSM").Count
  Dim NewScriptMaps()
  ReDim NewScriptMaps(LPos)

  cnt = 0
  For x = 0 to Ubound(ScriptMaps)
    bRemove = False
    Script = Split(ScriptMaps(x),",")
    For i = 1 to Request("CurSM").Count
      If Script(0) = Request("CurSM").Item(i) Then bRemove = True
    Next
    If bRemove = False Then
      NewScriptMaps(cnt) = ScriptMaps(x)
      cnt = cnt + 1
    End If
  Next

  objSiteROOT.ScriptMaps = NewScriptMaps
  objSiteROOT.SetInfo

  Set objSiteROOT = Nothing

  If err Then errs = "There was an error!<br>Err: " & Err.description Else errs = "Removed!"

End Sub

Sub ChangeDefDoc(errs)
On Error Resume Next

Set objSiteVDir = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/ROOT/" & Request("vdir"))

  If Len(Request("adddefdoc")) Then
    If InStr(objSiteVDir.DefaultDoc,",") Then
      bFound = False
      DefDocArr = Split(objSiteVDir.DefaultDoc,",")
      For x = 0 To Ubound(DefDocArr)
        If DefDocArr(x) = Request("newdefdoc") Then bFound = True
      Next
    Else
      If objSiteVDir.DefaultDoc = Request("newdefdoc") Then bFound = True
    End If
    If bFound Then
      errs = "There was an error!<br>Err: File already in list!"
    Else
      objSiteVDir.DefaultDoc = objSiteVDir.DefaultDoc & "," & Trim(Request("newdefdoc"))
    End If
  End If

  If Len(Request("remdefdoc")) Then
    If InStr(objSiteVDir.DefaultDoc,",") Then
      DefDocArr = Split(objSiteVDir.DefaultDoc,",")
      Dim NewDDArr()
      i = UBound(DefDocArr)-Request("defdoc").Count
      ReDim NewDDArr(i)
      cnt = 0
      For x = 0 To Ubound(DefDocArr)
        bFound = False
        For i = 1 to Request("defdoc").Count
          If DefDocArr(x) = Request("defdoc").Item(i) Then bFound = True
        Next
        If bFound = False Then
          NewDDArr(cnt) = DefDocArr(x)
          cnt = cnt + 1
        End If
      Next
      For x = 0 To Ubound(NewDDArr)
        NewDD = NewDD & "," & NewDDArr(x)
      Next
      NewDD = Right(NewDD,Len(NewDD)-1)
      objSiteVDir.DefaultDoc = NewDD
    Else
      errs = "There was an error!<br>Err: You can't remove the last file!"
    End If
  End If

  If Len(Request("moveup")) or Len(Request("movedown")) Then
    If InStr(objSiteVDir.DefaultDoc,",") Then
      DefDocArr = Split(objSiteVDir.DefaultDoc,",")

      For i = 1 to Request("defdoc").Count
        For x = 0 To Ubound(DefDocArr)
          If DefDocArr(x) = Request("defdoc").Item(i) Then PosA = x
        Next
        'Switch the Positions
        If Len(Request("moveup")) Then
          If PosA = 0 Then
            errs = "There was an error!<br>Err: File at Top of list already!"
          Else
            PosB = CInt(PosA - 1)
          End If
        Else
          If PosA = UBound(DefDocArr) Then
            errs = "There was an error!<br>Err: File at End of list already!"
          Else
            PosB = PosA + 1
          End If
        End If
        If Len(errs) = False Then
          tmpPos = DefDocArr(PosB)
          DefDocArr(PosB) = DefDocArr(PosA)
          DefDocArr(PosA) = tmpPOS
        End If
      Next

      For x = 0 To Ubound(DefDocArr)
        NewDD = NewDD & "," & DefDocArr(x)
      Next
      NewDD = Right(NewDD,Len(NewDD)-1)
      objSiteVDir.DefaultDoc = NewDD
    Else
      errs = "There was an error!<br>Err: There is only 1 file!"
    End If
  End If

  If err Then errs = "There was an error!<br>Err: " & Err.description

  objSiteVDir.SetInfo
  Set objSiteVDir = nothing
End Sub

Sub Change_IPDomRestrictions(errs)
On Error Resume Next
  Set objSiteVDir = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/ROOT/" & Request("vdir"))
  Set IIsIPSecurityObj = objSiteVDir.IPSecurity
  'Switch?
  If Len(Request("switch")) Then
   If IIsIPSecurityObj.GrantByDefault = True Then IIsIPSecurityObj.GrantByDefault = False Else IIsIPSecurityObj.GrantByDefault = True
   objSiteVDir.IPSecurity = IIsIPSecurityObj
   objSiteVDir.SetInfo

  Else
    Dim NewDomList()
    Dim NewIPList()

    If IIsIPSecurityObj.GrantByDefault = True Then
      If Len(Request("remDom")) Then
        DomList = IIsIPSecurityObj.DomainDeny
        If UBound(DomList) >= 0 Then
          i = UBound(DomList) - Request("DomList").Count
          ReDim NewDomList(i)
          cnt = 0
          For x = 0 To UBound(DomList)
            bFound = False
            For i = 1 to Request("DomList").Count
              If DomList(x) = Request("DomList").Item(i) Then bFound = True
            Next
            If bFound = False Then
              NewDomList(cnt) = DomList(x)
              cnt = cnt + 1
            End If
          Next
        End If
        IIsIPSecurityObj.DomainDeny = NewDomList
        objSiteVDir.IPSecurity = IIsIPSecurityObj
        objSiteVDir.SetInfo
      End If

      If Len(Request("remIP")) Then
        IPList = IIsIPSecurityObj.IPDeny
        If UBound(IPList) >= 0 Then
          i = UBound(IPList) - Request("IPList").Count
          ReDim NewIPList(i)
          cnt = 0
          For x = 0 To UBound(IPList)
            bFound = False
            For i = 1 to Request("IPList").Count
              If IPList(x) = Request("IPList").Item(i) Then bFound = True
            Next
            If bFound = False Then
              NewIPList(cnt) = IPList(x)
              cnt = cnt + 1
            End If
          Next
        End If
        IIsIPSecurityObj.IPDeny = NewIPList
        objSiteVDir.IPSecurity = IIsIPSecurityObj
        objSiteVDir.SetInfo
      End If

      If Len(Request("add")) Then
        If Len(Request("domain")) Then
          DomList = IIsIPSecurityObj.DomainDeny
          ReDim Preserve DomList(UBound(DomList)+1)
          DomList(UBound(DomList)) = Trim(Request("domain"))
          IIsIPSecurityObj.DomainDeny = DomList
          objSiteVDir.IPSecurity = IIsIPSecurityObj
          objSiteVDir.SetInfo
        End If

        If Len(Request("ipadd")) Then
          IPList = IIsIPSecurityObj.IPDeny
          ReDim Preserve IPList(UBound(IPList)+1)
          IPList(UBound(IPList)) = Trim(Request("ipadd")) & ", 255.255.255.255"
          IIsIPSecurityObj.IPDeny = IPList
          objSiteVDir.IPSecurity = IIsIPSecurityObj
          objSiteVDir.SetInfo
        End If

        If Len(Request("netid")) Then
          IPList = IIsIPSecurityObj.IPDeny
          ReDim Preserve IPList(UBound(IPList)+1)
          IPList(UBound(IPList)) = Trim(Request("netid")) & ", " & Trim(Request("subnet"))
          IIsIPSecurityObj.IPDeny = IPList
          objSiteVDir.IPSecurity = IIsIPSecurityObj
          objSiteVDir.SetInfo
        End If

      End If

    Else

      If Len(Request("remDom")) Then
        DomList = IIsIPSecurityObj.DomainGrant
        If UBound(DomList) >= 0 Then
          i = UBound(DomList) - Request("DomList").Count
          ReDim NewDomList(i)
          cnt = 0
          For x = 0 To UBound(DomList)
            bFound = False
            For i = 1 to Request("DomList").Count
              If DomList(x) = Request("DomList").Item(i) Then bFound = True
            Next
            If bFound = False Then
              NewDomList(cnt) = DomList(x)
              cnt = cnt + 1
            End If
          Next
        End If
        IIsIPSecurityObj.DomainGrant = NewDomList
        objSiteVDir.IPSecurity = IIsIPSecurityObj
        objSiteVDir.SetInfo
      End If
    
      If Len(Request("remIP")) Then
        IPList = IIsIPSecurityObj.IPGrant
        If UBound(IPList) >= 0 Then
          i = UBound(IPList) - Request("IPList").Count
          ReDim NewIPList(i)
          cnt = 0
          For x = 0 To UBound(IPList)
            bFound = False
            For i = 1 to Request("IPList").Count
              If IPList(x) = Request("IPList").Item(i) Then bFound = True
            Next
            If bFound = False Then
              NewIPList(cnt) = IPList(x)
              cnt = cnt + 1
            End If
          Next
        End If
        IIsIPSecurityObj.IPGrant = NewIPList
        objSiteVDir.IPSecurity = IIsIPSecurityObj
        objSiteVDir.SetInfo
      End If
    
      If Len(Request("add")) Then

        If Len(Request("domain")) Then
          DomList = IIsIPSecurityObj.DomainGrant
          ReDim Preserve DomList(UBound(DomList)+1)
          DomList(UBound(DomList)) = Trim(Request("domain"))
          IIsIPSecurityObj.DomainGrant = DomList
          objSiteVDir.IPSecurity = IIsIPSecurityObj
          objSiteVDir.SetInfo
        End If

        If Len(Request("ipadd")) Then
          IPList = IIsIPSecurityObj.IPGrant
          ReDim Preserve IPList(UBound(IPList)+1)
          IPList(UBound(IPList)) = Trim(Request("ipadd")) & ", 255.255.255.255"
          IIsIPSecurityObj.IPGrant = IPList
          objSiteVDir.IPSecurity = IIsIPSecurityObj
          objSiteVDir.SetInfo
        End If

        If Len(Request("netid")) Then
          IPList = IIsIPSecurityObj.IPGrant
          ReDim Preserve IPList(UBound(IPList)+1)
          IPList(UBound(IPList)) = Trim(Request("netid")) & ", " & Trim(Request("subnet"))
          IIsIPSecurityObj.IPGrant = IPList
          objSiteVDir.IPSecurity = IIsIPSecurityObj
          objSiteVDir.SetInfo
        End If

      End If

    End If
  End If

  If err = False Then Errs = "Updated" Else errs = "There was an error!<br>Err: " & err.description

End Sub

Sub Change_HTTPRedir(errs)
On Error Resume Next

  Set objSiteVDir = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/ROOT/" & Request("vdir"))

  If Len(Request("remove")) Then
    objSiteVDir.PutEx "1", "HTTPRedirect", ""
  Else
    newHTTPRedir = Request("httpredirstr")
    If Request("httpRedirExURL") = "yes" Then newHTTPRedir = newHTTPRedir & ", EXACT_DESTINATION"
    If Request("httpRedirDirBelow") = "yes" Then newHTTPRedir = newHTTPRedir & ", CHILD_ONLY"
    If Request("httpRedirPerm") = "yes" Then newHTTPRedir = newHTTPRedir & ", PERMANENT"
    objSiteVDir.Put "HttpRedirect", newHTTPRedir
    objSiteVDir.SetInfo
  End If

  Set objSiteVDir = Nothing

  If err Then errs = "There was an error!<br>Err: " & Err.description Else errs = "Updated!"

End Sub

Sub Change_DocFoot(errs)
On Error Resume Next
  Set objSiteVDir = GetObject("IIS://" & Application("Server") & "/W3SVC/" & Request("site") & "/ROOT/" & Request("vdir"))

  If Len(Request("remove")) Then
    objSiteVDir.EnableDocFooter = False
    objSiteVDir.DefaultDocFooter = ""
    objSiteVDir.SetInfo
  Else
    'add check for file exists
    objSiteVDir.EnableDocFooter = True
    objSiteVDir.DefaultDocFooter = "FILE:" & Trim(Request("docfootstr"))
    objSiteVDir.SetInfo
  End If

  Set objSiteVDir = Nothing

  If err Then errs = "There was an error!<br>Err: " & Err.description Else errs = "Updated!"

End Sub

%>

