<%
'#################################################################################
'## IIS Admin Control Panel v 1.0
'#################################################################################
'## Copyright (C) 2005 Jake Gardner, Chris Hood
'##  from now on, referred to as "we" or "us"
'##
'##   This is a legally binding agreement between you and us, the developers
'## of the software program ("IIS Admin Control Panel") which you are about to
'## accept through electronic distribution (downloading).  By downloading and
'## using this software you are agreeing and will have agreed to be bound by
'## the terms set forth below.
'##
'##   License Grant and Restrictions. We grant you and you accept a
'## non-exclusive license to use the IIS Admin Control Panel but you do not
'## acquire any rights of ownership or distribution in whole or part. We are
'## the exclusive owners of the IIS Admin Control Panel which is copyrighted.
'## This license permits you to use and modify the IIS Admin Control Panel for
'## your personal or company. You may not rent, lease, sub-license, assign,
'## loan, create a derivative work based on content or otherwise use or
'## transfer use of the Software or any part thereof to others. You may not
'## reverse engineer, reverse compile, disassemble or otherwise modify the
'## Software in any way.  You may not remove any proprietary notices that are
'## provided with or within the software and/or sourcecode.  Neither the
'## Software nor any underlying information or technology may be exported or
'## re-exported into any country to which the United States has prohibited
'## export.
'##
'##   No Warranties. You acknowledge that the software has been provided to you
'## free of charge for your personal use and evaluation. You assume
'## responsibility for the selection of the software to achieve your intended
'## results and for the proper installation, use and results obtained from use
'## of the IIS Admin Control Panel. WE MAKE NO REPRESENTATION OR WARRANTY OF
'## ANY KIND WITH RESPECT TO THE SOFTWARE OR THE RESULTS OBTAINED OR TO BE
'## OBTAINED FROM ITS USE. WE DO NOT WARRANT THAT YOUR USE OF THE SOFTWARE WILL
'## BE UNINTERRUPTED, ERROR-FREE OR VIRUS-FREE.  ALL WARRANTIES, EXPRESS OR
'## IMPLIED, INCLUDING THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
'## PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE HEREBY EXPRESSLY DISCLAIMED.
'## WE EXPRESSLY DISCLAIM ANY IMPLIED WARRANTY THAT ANY OTHER PRODUCT
'## (INCLUDING WITHOUT LIMITATION ANY COPY OF THE SOFTWARE YOU MAY SUBSEQUENTLY
'## PURCHASE) WILL CONFORM TO THE SOFTWARE PROVIDED TO YOU UNDER THIS
'## AGREEMENT.
'##
'##   IN NO EVENT SHALL WE OR THEIR SUPPLIERS OR DISTRIBUTOR(S) OR AGENTS BE
'## LIABLE FOR ANY DAMAGE ARISING OUT OF OR RELATED TO THE USE OF THIS PRODUCT,
'## INCLUDING WITHOUT LIMITATION ACTUAL, DIRECT, SPECIAL, CONSEQUENTIAL,
'## INDIRECT, EXEMPLARY OR PUNITIVE DAMAGES, WHETHER OR NOT SUCH DAMAGES WERE
'## FORESEEABLE AND EVEN IF WE WERE ADVISED THAT SUCH DAMAGES WERE LIKELY OR
'## POSSIBLE.
'##
'## Support can be obtained from our support forums at:
'## http://www.iisactive.com
'##
'## Correspondence and Marketing Questions can be sent to:
'## iacp@iisactive.com
'##
'#################################################################################


If Request.queryString("action") = "go" Then Response.Redirect "manage_user.asp?user=" & Request.queryString("user")

Response.Buffer = True
qdstring = ""

If Len(Request.QueryString("cqd")) Then
  Session("qdrive") = Request.QueryString("cqd")
  Set fso = CreateObject("Scripting.FileSystemObject")
  Set drives = fso.drives
    For each drive in drives
      If drive.drivetype = 2 Then qdstring = qdstring & drive.driveletter & ":"
    Next
  qdrives = Split(qdstring, ":")
  If Ubound(qdrives) > 1 Then
    Session("cqdl") = "Change drive to: "
    Do Until cnt >= Ubound(qdrives)
      If qdrives(cnt) <> Session("qdrive") Then
        Session("cqdl") = Session("cqdl") & "<a href=""manage_quotas.asp?cqd=" & qdrives(cnt) & """>" & qdrives(cnt) & "</a> "
      End If
      cnt = cnt + 1
    Loop
  Else
    Session("cqdl") = ""
  End If
 Set fso = nothing
End If

If Session("qdrive") = "" Then
  Set fso = CreateObject("Scripting.FileSystemObject")
  Set drives = fso.drives
    cnt = 0
    For each drive in drives
      If drive.drivetype = 2 Then
        cnt = cnt + 1
        qdstring = qdstring & drive.driveletter & ":"
        If cnt = 1 Then Session("qdrive") = drive.driveletter
      End If

    Next
  qdrives = Split(qdstring, ":")
  If Ubound(qdrives) > 1 Then
    cnt = 1
    Session("cqdl") = "Change drive to: "
    Do Until cnt >= Ubound(qdrives)
      Session("cqdl") = Session("cqdl") & "<a href=""manage_quotas.asp?cqd=" & qdrives(cnt) & """>" & qdrives(cnt) & "</a> "
      cnt = cnt + 1
    Loop
  Else
    Session("cqdl") = ""
  End If
  Set fso = nothing
End If


%>

<!-- #INCLUDE FILE="common\head.inc" -->
<!-- #INCLUDE FILE="common\Functions.inc" -->
<div id="maincontent">
<TABLE width="100%">
  <TR>
    <TH colspan="3">User Quota Management on drive: <%=Session("qdrive")%>&nbsp;&nbsp;<%=Session("cqdl")%> </TH>
  </TR>
  <TR>
    <TD>
      <a class="man_link" href="manage_quotas.asp?action=showall">Show All Users</a>
    </TD>
    <TD>
      <a class="man_link" href="manage_quotas.asp?action=finduser">Search for a User</a>
    </TD>
    <TD>
      <a class="man_link" href="manage_quotas.asp?action=global">Global Properties</a>
    </TD>
  </TR>
</TABLE>
<%
If Len(Request.QueryString("tc")) Or Len(Request.QueryString("e"))Then
  If Request.QueryString("tc") = "1" Then message = "Task Completed!"
  If Request.QueryString("tc") = "0" Or Request.QueryString("e") > 0 Then
    message = "There were ERRORS! errlev: " & Request.QueryString("e")
  End If
End If

Response.flush

If Len(Request.queryString("action")) Or Len(Request.Form("action")) Then

Select Case LCase(Request.QueryString("action"))
  Case "showall"
      Call Display_All
  Case "finduser"
      Call Show_Search_User
  Case "manuser"
      Call Show_User_QuotaInfo
  Case "global"
      Call Show_global_QuotaInfo
  Case "switch"
      Call Switch_Prop
  Case "addentry"
      Call Add_Entry
  Case "gmods"
      Call Switch_Global_State
  Case "modquota"
      Call QuotaLimit
  Case "modwarn"
      Call Threshold
  Case "globquota"
      Call GlobalQuotaLimit
  Case "globwarn"
      Call GlobalThreshold
End Select

End If

If LCase(Request.QueryString("mod")) = "1" Then Call ChangeQuotaProperties
If LCase(Request.QueryString("mod")) = "2" Then Call ChangeGlobalQuotaProperties


Sub Show_User_QuotaInfo

  Set objUser = GetObject("WinNT://" & Application("domain") & "/" & Application("Server") & "/" & Request.QueryString("user") & ",user")
  Set colDiskQuotas = CreateObject("Microsoft.DiskQuota.1")
    colDiskQuotas.Initialize Session("qdrive") & ":\", True

      Set objUserQuota = colDiskQuotas.FindUser(ObjUser.Name)
        userquota = objUserQuota.QuotaLimit
        ql = objUserQuota.QuotaLimit
        qid = ""
        If userquota = "0" Then
          userquota = colDiskQuotas.DefaultQuotaLimit
          ql = colDiskQuotas.DefaultQuotaLimit
          qid = "No quota entry found, default server quota in effect.<br>"
        End If
      Call FormatUserQuota(userquota)

      QuotaUsed = objUserQuota.QuotaUsed
      qu = objUserQuota.QuotaUsed
      Call FormatUserQuota(QuotaUsed)

      disp_threshold = objUserQuota.QuotaThreshold
      Call FormatUserQuota(disp_threshold)

      pu = FormatPercent(qu / ql)

      If ObjUser.HomeDirectory = "" Then
        homedir = "No directory set"
      Else
        homedir = ObjUser.Homedirectory
      End If
      hdsize = ""
      Call DirSize(homedir,hdsize)
      
      Select Case objUserQuota.AccountStatus
        Case 0
          AccStat = "Account is valid."
        Case 1
          AccStat = "Account information is unavailable."
        Case 2
          AccStat = "Account has been deleted."
        Case 3
          AccStat = "Account is invalid."
        Case 4
          AccStat =  "Account cannot be found."
        Case 5
          AccStat =  "Account information cannot be resolved."
      End Select
%>
<TABLE width="100%">
  <TR>
    <TH colspan="3">Quota Settings for: <%= objUser.Name %></TH>
  </TR>
  <TR><TH>Property</TH><TH>Current Setting</TH><TH>Options</TH></TR>
  <TR><TH>Quota Limit</TH><TD><%=qid%><%=userquota%></TD><TD><a class="man_link" href="manage_quotas.asp?action=modquota&user=<%=objUser.Name%>">Manage</a></TD></TR>
  <TR><TH>Quota Usage</TH><TD><%=QuotaUsed%></TD><TD>-</TD></TR>
  <TR><TH>Warning Level</TH><TD><%=disp_threshold%></TD><TD><a class="man_link" href="manage_quotas.asp?action=modwarn&user=<%=objUser.Name%>">Manage</a></TD></TR>
  <TR><TH>Percent Used</TH><TD><%=pu%></TD><TD>-</TD></TR>
  <TR><TH>Account Status</TH><TD><%=AccStat%></TD><TD>-</TD></TR>
  <TR><TH>Home Directory</TH><TD><%=homedir%>&nbsp;&nbsp;(<%=hdsize%>)</TD><TD><a class="man_link" href="user_config.asp?action=homed&user=<%=objUser.Name%>&return=quota">Manage</a></TD></TR>
  <TR>
    <TH colspan="2"><%=message%></TH>
    <TD><a class="man_link" href="manage_quotas.asp?action=manuser&user=<%=objUser.Name%>">Refresh</a></TD>
  </TR>
</TABLE>


<%
End Sub

Sub Show_Global_QuotaInfo

  Set colDiskQuotas = CreateObject("Microsoft.DiskQuota.1")
    colDiskQuotas.Initialize Session("qdrive") & ":\", True

      userquota = colDiskQuotas.DefaultQuotaLimit
      Call FormatUserQuota(userquota)

      disp_threshold = colDiskQuotas.DefaultQuotaThreshold
      Call FormatUserQuota(disp_threshold)

      qsml0 = "<a class=""man_link"" href=""manage_quotas.asp?action=gmods&state=0"">Disable</a>"
      qsml1 = "<a class=""man_link"" href=""manage_quotas.asp?action=gmods&state=1"">Enable but don't enforce</a>"
      qsml2 = "<a class=""man_link"" href=""manage_quotas.asp?action=gmods&state=2"">Enable and enforce</a>"
      
      If colDiskQuotas.QuotaState = 2 Then
        qstate = "Enabled and enforced"
        qsml = qsml1 & "<BR>" & qsml0
      ElseIf colDiskQuotas.QuotaState = 1 Then
        qstate = "Enabled but not enforced"
        qsml = qsml2 & "<BR>" & qsml0
      Else
        qstate = "Disabled"
        qsml = qsml2 & "<BR>" & qsml1
      End If

      lwl = "Turn Off"
      If colDiskQuotas.LogQuotaThreshold = False Then lwl = "Turn On"
      lvl = "Turn Off"
      If colDiskQuotas.LogQuotaLimit = False Then lvl = "Turn On"

%>
<TABLE width="100%">
  <TR>
    <TH colspan="3">Global Quota Settings</TH>
  </TR>
  <TR><TH>Property</TH><TH>Current Setting</TH><TH>Options</TH></TR>
  <TR><TH>Quota State</TH><TD><%=qstate%></TD><TD><%=qsml%></TD></TR>
  <TR><TH>Default Quota Limit</TH><TD><%=qid%><%=userquota%></TD><TD><a class="man_link" href="manage_quotas.asp?action=globquota">Manage</a></TD></TR>
  <TR><TH>Default Warning Level</TH><TD><%=disp_threshold%></TD><TD><a class="man_link" href="manage_quotas.asp?action=globwarn">Manage</a></TD></TR>
  <TR><TH>Log Warnings</TH><TD><%=colDiskQuotas.LogQuotaThreshold%></TD><TD><a class="man_link" href="manage_quotas.asp?action=switch&prop=logwarn"><%=lwl%></a></TD></TR>
  <TR><TH>Log Violations</TH><TD><%=colDiskQuotas.LogQuotaLimit%></TD><TD><a class="man_link" href="manage_quotas.asp?action=switch&prop=logvio"><%=lvl%></a></TD></TR>
  <TR>
    <TH colspan="2"><%=message%></TH>
    <TD><a class="man_link" href="manage_quotas.asp?action=global">Refresh</a></TD>
  </TR>
</TABLE>
<%

End Sub

Sub Display_All
On Error Resume Next
Server.ScriptTimeout = 1200

  Response.write "<br>Calculating... Please be patient, this can take awhile.<BR>"

  Set colDiskQuotas = CreateObject("Microsoft.DiskQuota.1")
  colDiskQuotas.Initialize Session("qdrive") & ":\", True
  If err Then
    Response.write "<br>Error connecting to Quota Manager.<br>Description: " & err.description
    Response.End
  End If
  err.clear

    If colDiskQuotas.QuotaState = 2 Then
      qstate = "Enabled and enforced"
    ElseIf colDiskQuotas.QuotaState = 1 Then
      qstate = "Enabled but not enforced"
    Else
      qstate = "Disabled"
      qsc = 1
    End If
   default_quota = colDiskQuotas.DefaultQuotaLimit

If err Then
  Response.Write "Quota System has not been enabled yet or there was a fatal error.  Do you want to view the Global Quota System properties? "
  Response.write "<a href=""manage_quotas.asp?action=global"">Manage</a>"
  Resposne.End
Else
  Call FormatUserQuota(default_quota)
  If err Then
    Response.write "<br>Error formatting default quota value.<br>Description: " & err.description
    default_quota = "n/a"
  Else
    Response.write "Default drive quota is set at " & default_quota & ". "
  End If
  err.clear
  Response.write "Quotas are currently: " & qstate & ".<BR>"

  %>
    <table width="100%" name="rsTable" id="rsTable" cols=5>
      <tr>
        <TH><Acronym title="Sort by Username" onClick="table_sort(0)" onMouseOver="this.style.cursor='hand';"><&nbsp;UserName&nbsp;></acronym></TH>
        <TH><Acronym title="Sort by Quota" onClick="table_sort(1)" onMouseOver="this.style.cursor='hand';"><&nbsp;Quota&nbsp;></acronym></TH>
        <TH><Acronym title="Sort by Usage" onClick="table_sort(2)" onMouseOver="this.style.cursor='hand';"><&nbsp;Usage&nbsp;></acronym></TH>
        <TH><Acronym title="Sort by Home Directory" onClick="table_sort(3)" onMouseOver="this.style.cursor='hand';"><&nbsp;HomeDir&nbsp;></acronym></TH>
        <TH>&nbsp;</TH>
      </tr>
  <%
  Response.Flush

    Set BaseObj = GetObject("WinNT://" & Application("Server"))
    BaseObj.Filter = Array("User")
    For Each user in BaseObj

      If User.HomeDirectory = "" Then
        homedir = "No directory set"
      Else
        homedir = User.Homedirectory
      End If
      fsize = ""
      Call DirSize(homedir,fsize)

      Set objUserQuota = colDiskQuotas.FindUser(User.Name)
        userquota = objUserQuota.QuotaLimit
      If userquota = "0" Then userquota = colDiskQuotas.DefaultQuotaLimit
        Call FormatUserQuota(userquota)
      QuotaUsed = objUserQuota.QuotaUsed
        Call FormatUserQuota(QuotaUsed)

      Response.write "<TR>"
      Response.write "<TD>" & user.name & "</td>"
      Response.write "<TD> " & userquota & " </td>"
      Response.write "<TD> " & QuotaUsed & " </td>"
      Response.write "<TD>" & HomeDir & " (" & fsize & ")</td>"
      Response.write "<TD><a class=""man_link"" href=""manage_quotas.asp?action=manuser&user=" & user.name & """>Manage</a></td></tr>"
    Next
    response.write "</table>"
End If
End Sub

Sub Show_Search_User
%>
<TABLE>
<form method="POST">
<input type="hidden" name="action" value="searchuser">
<TR><TH colspan="3">Quota Entry Search</TH></TR>
<TR><TH>User:</TH><TD><input type="text" name="username" id="GiveMeFocus"></TD><TD><input type="submit" value="Search"></TD></TR>
<TR><TD colspan="3">&nbsp;</TD></TR>
</form>
</TABLE>
<%
If LCase(Request.Form("action")) = "searchuser" Then Call Search_User
End Sub

Sub Search_User
On Error Resume Next
Server.ScriptTimeout = 1200

  sstr = Trim(Request.Form("username"))
  Response.write "Searching for: """ & sstr & """ ... Please be patient, this can take awhile.<BR>"

  Set colDiskQuotas = CreateObject("Microsoft.DiskQuota.1")
  colDiskQuotas.Initialize Session("qdrive") & ":\", True
  If err Then
    Response.write "<br>Error connecting to Quota Manager.<br>Description: " & err.description
    Response.End
  End If
  err.clear

    If colDiskQuotas.QuotaState = 2 Then
      qstate = "Enabled and enforced"
    ElseIf colDiskQuotas.QuotaState = 1 Then
      qstate = "Enabled but not enforced"
    Else
      qstate = "Disabled"
      qsc = 1
    End If
   default_quota = colDiskQuotas.DefaultQuotaLimit

If default_quota = "-1" or err Then
  Response.Write "Quota System has not been enabled yet or there was a fatal error.  Do you want to view the Global Quota System properties? "
  Response.write "<a href=""manage_quotas.asp?action=global"">Manage</a>"
  Resposne.End
Else
  Call FormatUserQuota(default_quota)
  If err Then
    Response.write "<br>Error formatting default quota value.<br>Description: " & err.description
    default_quota = "n/a"
  Else
    Response.write "Default drive quota is set at " & default_quota & ". "
  End If
  err.clear
  Response.write "Quotas are currently: " & qstate & ".<BR>"

  %>
    <table width="100%" name="rsTable" id="rsTable" cols=5>
      <tr>
        <TH><Acronym title="Sort by Username" onClick="table_sort(0)" onMouseOver="this.style.cursor='hand';"><&nbsp;UserName&nbsp;></acronym></TH>
        <TH><Acronym title="Sort by Quota" onClick="table_sort(1)" onMouseOver="this.style.cursor='hand';"><&nbsp;Quota&nbsp;></acronym></TH>
        <TH><Acronym title="Sort by Usage" onClick="table_sort(2)" onMouseOver="this.style.cursor='hand';"><&nbsp;Usage&nbsp;></acronym></TH>
        <TH><Acronym title="Sort by Home Directory" onClick="table_sort(3)" onMouseOver="this.style.cursor='hand';"><&nbsp;HomeDir&nbsp;></acronym></TH>
        <TH>&nbsp;</TH>
      </tr>
  <%
  Response.Flush


flag = 0
Set BaseObj = GetObject("WinNT://" & Application("domain") & "/" & Application("Server"))
  BaseObj.Filter = Array("user")
  For Each user in BaseObj
    If InStr(LCase(user.name),(sstr)) or InStr(LCase(user.FullName),(sstr)) or InStr(LCase(user.description),(sstr)) Then
      flag = 1
      If User.HomeDirectory = "" Then
        homedir = "No directory set"
      Else
        homedir = User.Homedirectory
      End If
      fsize = ""
      Call DirSize(homedir,fsize)

      Set objUserQuota = colDiskQuotas.FindUser(User.Name)
      userquota = objUserQuota.QuotaLimit
      If userquota = "0" Then userquota = colDiskQuotas.DefaultQuotaLimit
      Call FormatUserQuota(userquota)
      QuotaUsed = objUserQuota.QuotaUsed
      Call FormatUserQuota(QuotaUsed)

      Response.write "<TR>"
      Response.write "<TD>" & user.name & "</td>"
      Response.write "<TD> " & userquota & " </td>"
      Response.write "<TD> " & QuotaUsed & " </td>"
      Response.write "<TD>" & HomeDir & " (" & fsize & ")</td>"
      Response.write "<TD><a class=""man_link"" href=""manage_quotas.asp?action=manuser&user=" & user.name & """>Manage</a></td></tr>"
    End If
  Next
  If flag = 0 Then
    response.write "<tr><td colspan=""5"">No users found</td></tr>"
  End If
  response.write "</table>"

End If

End Sub



'''''''''''''''''''''''''''''''''
'Modification subs
'''''''''''''''''''''''''''''''''

Sub Switch_Prop
  Set colDiskQuotas = CreateObject("Microsoft.DiskQuota.1")
  colDiskQuotas.Initialize Session("qdrive") & ":\", True
  Select Case LCase(Request.QueryString("prop"))
    Case "logwarn"
      If colDiskQuotas.LogQuotaThreshold = False Then
        colDiskQuotas.LogQuotaThreshold = True
      Else
        colDiskQuotas.LogQuotaThreshold = False
      End If
    Case "logvio"
      If colDiskQuotas.LogQuotaLimit = False Then
        colDiskQuotas.LogQuotaLimit = True
      Else
        colDiskQuotas.LogQuotaLimit = False
      End If
  End Select

Call Show_global_QuotaInfo

End Sub

Sub Switch_Global_State
  Set colDiskQuotas = CreateObject("Microsoft.DiskQuota.1")
  colDiskQuotas.Initialize Session("qdrive") & ":\", True
  Select Case LCase(Request.QueryString("state"))
    Case "0"
      colDiskQuotas.QuotaState = 0
    Case "1"
      colDiskQuotas.QuotaState = 1
    Case "2"
      colDiskQuotas.QuotaState = 2
  End Select

Call Show_global_QuotaInfo

End Sub

Sub ChangeQuotaProperties()
  Set colDiskQuotas = CreateObject("Microsoft.DiskQuota.1")
    colDiskQuotas.Initialize Session("qdrive") & ":\", True
    Set objUserQuota = colDiskQuotas.FindUser(Request.QueryString("user"))
    If LCase(Request.QueryString("action")) = "cqlimit" Then objUserQuota.QuotaLimit = Request.QueryString("newql")
    If LCase(Request.QueryString("action")) = "cqthreshold" Then objUserQuota.QuotaThreshold = Request.QueryString("newqt")

  Call Show_User_QuotaInfo
End Sub

Sub ChangeGlobalQuotaProperties()
  Set colDiskQuotas = CreateObject("Microsoft.DiskQuota.1")
    colDiskQuotas.Initialize Session("qdrive") & ":\", True
    If LCase(Request.QueryString("action")) = "gqlimit" Then colDiskQuotas.DefaultQuotaLimit = Request.QueryString("newgql")
    If LCase(Request.QueryString("action")) = "gqthreshold" Then colDiskQuotas.DefaultQuotaThreshold = Request.QueryString("newgqt")

Call Show_global_QuotaInfo
End Sub

Sub QuotaLimit()
  Set colDiskQuotas = CreateObject("Microsoft.DiskQuota.1")
    colDiskQuotas.Initialize Session("qdrive") & ":\", True
    Set objUserQuota = colDiskQuotas.FindUser(Request.QueryString("user"))
%>
<TABLE>
<form method="GET">
<input type="hidden" name="action" value="cqlimit">
<input type="hidden" name="mod" value="1">
<Input type="Hidden" name="user" value="<%=Request.QueryString("user")%>">
  <TR><TH colspan=2>Manage users's Quota Limit</TH></TR>
  <TR><TH>Current</TH><TD><%=objUserQuota.QuotaLimit%></TD></TR>
  <TR><TH>New</TH><TD><input type="text" name="newql" value="<%=objUserQuota.QuotaLimit%>"></TD></TR>
</table>
<input type="submit" Value="Commit Modifications">&nbsp;&nbsp;<input type="submit" name="return" value="Return">
</Form>
</TABLE>

<%
End Sub

Sub Threshold()
  Set colDiskQuotas = CreateObject("Microsoft.DiskQuota.1")
    colDiskQuotas.Initialize Session("qdrive") & ":\", True
    Set objUserQuota = colDiskQuotas.FindUser(Request.QueryString("user"))
%>
<TABLE>
<form method="GET">
<input type="hidden" name="action" value="cqthreshold">
<input type="hidden" name="mod" value="1">
<Input type="Hidden" name="user" value="<%=Request.QueryString("user")%>">
  <TR><TH colspan=2>Manage users's Quota Threshold</TH></TR>
  <TR><TH>Current</TH><TD><%=objUserQuota.QuotaThreshold%></TD></TR>
  <TR><TH>New</TH><TD><input type="text" name="newqt" value="<%=objUserQuota.QuotaThreshold%>"></TD></TR>
</table>
<input type="submit" Value="Commit Modifications">&nbsp;&nbsp;<input type="submit" name="return" value="Return">
</Form>
</TABLE>
<%
End Sub

Sub GlobalQuotaLimit()
  Set colDiskQuotas = CreateObject("Microsoft.DiskQuota.1")
    colDiskQuotas.Initialize Session("qdrive") & ":\", True
%>
<TABLE>
<form method="GET">
<input type="hidden" name="action" value="gqlimit">
<input type="hidden" name="mod" value="2">
  <TR><TH colspan="2">Manage the default users's Quota Limit</TH></TR>
  <TR><TH>Current</TH><TD><%=colDiskQuotas.DefaultQuotaLimit%></TD></TR>
  <TR><TH>New</TH><TD><input type="text" name="newgql" value="<%=colDiskQuotas.DefaultQuotaLimit%>"></TD></TR>
  <TR><TD colspan="2"><input type="submit" Value="Commit Modifications">&nbsp;&nbsp;<input type="submit" name="return" value="Return"></TD></TR>
</Form>
</TABLE>
<%
End Sub

Sub GlobalThreshold()
  Set colDiskQuotas = CreateObject("Microsoft.DiskQuota.1")
    colDiskQuotas.Initialize Session("qdrive") & ":\", True
%>
<TABLE>
<form method="GET">
<input type="hidden" name="action" value="gqthreshold">
<input type="hidden" name="mod" value="2">
  <TR><TH colspan=2>Manage default Quota Threshold</TH></TR>
  <TR><TH>Current</TH><TD><%=colDiskQuotas.DefaultQuotaThreshold%></TD></TR>
  <TR><TH>New</TH><TD><input type="text" name="newgqt" value="<%=colDiskQuotas.DefaultQuotaThreshold%>"></TD></TR>
  <TR><TD colspan="2"><input type="submit" Value="Commit Modifications">&nbsp;&nbsp;<input type="submit" name="return" value="Return"></TD></TR>
</Form>
</TABLE>
<%
End Sub
%>
</div>
</HTML>
</BODY>
