<%
'#################################################################################
'## IIS Admin Control Panel v 1.0
'#################################################################################
'## Copyright (C) 2005 Jake Gardner, Chris Hood
'##  from now on, referred to as "we" or "us"
'##
'##   This is a legally binding agreement between you and us, the developers
'## of the software program ("IIS Admin Control Panel") which you are about to
'## accept through electronic distribution (downloading).  By downloading and
'## using this software you are agreeing and will have agreed to be bound by
'## the terms set forth below.
'##
'##   License Grant and Restrictions. We grant you and you accept a
'## non-exclusive license to use the IIS Admin Control Panel but you do not
'## acquire any rights of ownership or distribution in whole or part. We are
'## the exclusive owners of the IIS Admin Control Panel which is copyrighted.
'## This license permits you to use and modify the IIS Admin Control Panel for
'## your personal or company. You may not rent, lease, sub-license, assign,
'## loan, create a derivative work based on content or otherwise use or
'## transfer use of the Software or any part thereof to others. You may not
'## reverse engineer, reverse compile, disassemble or otherwise modify the
'## Software in any way.  You may not remove any proprietary notices that are
'## provided with or within the software and/or sourcecode.  Neither the
'## Software nor any underlying information or technology may be exported or
'## re-exported into any country to which the United States has prohibited
'## export.
'##
'##   No Warranties. You acknowledge that the software has been provided to you
'## free of charge for your personal use and evaluation. You assume
'## responsibility for the selection of the software to achieve your intended
'## results and for the proper installation, use and results obtained from use
'## of the IIS Admin Control Panel. WE MAKE NO REPRESENTATION OR WARRANTY OF
'## ANY KIND WITH RESPECT TO THE SOFTWARE OR THE RESULTS OBTAINED OR TO BE
'## OBTAINED FROM ITS USE. WE DO NOT WARRANT THAT YOUR USE OF THE SOFTWARE WILL
'## BE UNINTERRUPTED, ERROR-FREE OR VIRUS-FREE.  ALL WARRANTIES, EXPRESS OR
'## IMPLIED, INCLUDING THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
'## PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE HEREBY EXPRESSLY DISCLAIMED.
'## WE EXPRESSLY DISCLAIM ANY IMPLIED WARRANTY THAT ANY OTHER PRODUCT
'## (INCLUDING WITHOUT LIMITATION ANY COPY OF THE SOFTWARE YOU MAY SUBSEQUENTLY
'## PURCHASE) WILL CONFORM TO THE SOFTWARE PROVIDED TO YOU UNDER THIS
'## AGREEMENT.
'##
'##   IN NO EVENT SHALL WE OR THEIR SUPPLIERS OR DISTRIBUTOR(S) OR AGENTS BE
'## LIABLE FOR ANY DAMAGE ARISING OUT OF OR RELATED TO THE USE OF THIS PRODUCT,
'## INCLUDING WITHOUT LIMITATION ACTUAL, DIRECT, SPECIAL, CONSEQUENTIAL,
'## INDIRECT, EXEMPLARY OR PUNITIVE DAMAGES, WHETHER OR NOT SUCH DAMAGES WERE
'## FORESEEABLE AND EVEN IF WE WERE ADVISED THAT SUCH DAMAGES WERE LIKELY OR
'## POSSIBLE.
'##
'## Support can be obtained from our support forums at:
'## http://www.iisactive.com
'##
'## Correspondence and Marketing Questions can be sent to:
'## iacp@iisactive.com
'##
'#################################################################################
%>

<!-- #INCLUDE FILE="common\head.inc" -->
<DIV id="maincontent">
<TABLE width="100%">
  <TR><TH colspan="4">Metabase Management</TH></TR>
  <TR>
	  <TD><a class="man_link" href="manage_metabase.asp?action=show">Show Backups</a></TD>
	  <TD><a class="man_link" href="manage_metabase.asp?action=makebu">Make a Backup</a></TD>
	  <% If Application("IISVer") = 6 Then %>
	  <TD><a class="man_link" href="manage_metabase.asp?action=history">Show History</a></TD>
    <TD><a class="man_link" href="manage_metabase.asp?action=settings">Settings</a></TD>
    <% End If %>
  </TR>
</TABLE>

<%

If Len(Request("action")) Then action = LCase(Request("action"))
If Len(Request("return")) Then action = "settings"

Select Case action
  Case "show"
    Show_MetaBase(0)
  Case "history"
    Show_History(0)
  Case "makebu"
    Show_MakeBU
  Case "settings"
    Show_Settings("")
  Case "createbu"
    Show_MetaBase(Do_MakeBU)
  Case "restore"
    Show_MetaBase(Do_Restore)
  Case "del"
    Show_MetaBase(Do_Delete)
  Case "switcheh"
    Show_Settings(SwitchEH)
  Case "switcheewr"
    Show_Settings(SwitchEEWR)
  Case "manmhf"
    Manage_MHF("")
  Case "change_mhf"
    Manage_MHF(Change_MHF)
  Case "change_maxband"
    If Len(Request.Form("MB")) Then MaxBandwidth("") Else MaxBandwidth(Change_MaxBandwidth)
  Case "maxband"
    Call MaxBandwidth("")
End Select





Sub Show_MetaBase(tc)
	On Error Resume Next
  Set objIIS = GetObject("IIS://" & Application("Server"))
%>

<BR>
<TABLE width="100%">
  <TR>
  	<TH colspan="6">Current Backups</TH>
  </TR>
  <TR>
	<TH>Index</TH>
	<TH>Version</TH>
	<TH>Name</TH>
	<TH>GMT Date</TH>
	<TH colspan="2">&nbsp;</TH>
  </TR>
	<%
	Index = 0
	Do While True
	  objIIS.EnumBackups "", Index, Version, Name, GMTDate
	  If Err.number <> 0 Then Exit do
	  Response.Write "<TR><TD>" & Index & "</TD><TD>" & Version & "</TD>"
	  Response.Write "<TD>" & Name & "</TD><TD>" & GMTDate & "</TD>"
	  Response.Write "<TD><a href=""manage_metabase.asp?action=del&name=" & name & "&ver=" & Version & """>Delete</a></TD>"
'		Response.Write "<TD><a href=""manage_metabase.asp?action=restore&name=" & name & "&ver=" & Version & """>Restore</a></TD>"
	  Response.Write "</TR>"
	  Index = Index + 1
	Loop

	If tc <> 0 Then
	  response.write "<TR><TH colspan=""6"">"
	If tc = 1 Then response.write "<font color=""#99FFFF"">Metabase Backed Up</font>"
	If tc = 2 Then response.write "<font color=""#99FFFF"">Back Up Deleted</font>"
	If tc = 3 Then response.write "<font color=""#99FFFF"">Metabase Restored</font>"
	  response.write "</TH></TR>"
	End If
response.write "</table>"
End Sub

Sub Show_History(tc)
	On Error Resume Next

	set locatorObj = CreateObject("WbemScripting.SWbemLocator")
  set providerObj = GetObject("winmgmts://" & Application("Server") & "/root/MicrosoftIISv2")
  set NodeObj = providerObj.Get("IIsComputer='LM'")
%>
<BR>
<TABLE width="100%">
  <TR>
  	<TH colspan="6">Current Backups</TH>
  </TR>
  <TR>
	<TH>Index</TH>
	<TH>Max Version</TH>
	<TH>Min Version</TH>
	<TH>GMT Date</TH>
	<TH colspan="2">&nbsp;</TH>
  </TR>
<%
	Index = 0
	Do While True
	  NodeObj.EnumHistory "", MajVersion, MinVersion, GMTDate, Index
	  If Err.number <> 0 Then Exit do
	  Response.Write "<TR><TD>" & Index & "</TD><TD>" & MaxVersion & "</TD>"
	  Response.Write "<TD>" & MinVersion & "</TD><TD>" & FormatDate(GMTDate) & "</TD>"
	  Response.Write "<TD><a href=""manage_metabase.asp?action=del&name=" & name & "&ver=" & Version & """>Delete</a></TD>"
'		Response.Write "<TD><a href=""manage_metabase.asp?action=restore&name=" & name & "&ver=" & Version & """>Restore</a></TD>"
	  Response.Write "</TR>"
	  Index = Index + 1
	Loop


	If tc <> 0 Then
	  response.write "<TR><TH colspan=""6"">"
	If tc = 1 Then response.write "<font color=""#99FFFF"">Metabase Backed Up</font>"
	If tc = 2 Then response.write "<font color=""#99FFFF"">Back Up Deleted</font>"
	If tc = 3 Then response.write "<font color=""#99FFFF"">Metabase Restored</font>"
	  response.write "</TH></TR>"
	End If
response.write "</table>"
End Sub

Sub Show_MakeBU
BK = "Backup-" & Right("00" & DatePart("m",Date()),2) & "-" & Right("00" & DatePart("d",Date()),2)
%>
<BR>
<form method="post" action="manage_metabase.asp?action=createbu">
<TABLE>
  <TR>
	<TH colspan="3">Create Backup</TH>
  </TR>
  <TR>
	<TH>Name:</TH><TD><input type=text name="buname" id="GiveMeFocus" value="<%=BK%>"></TD><TD><input type=Submit name="Submit" value="Create"></TD>
  </TR>
</table>

</Form>
<%
End Sub

Sub Show_Settings(errs)
Set objIIS = GetObject("IIS://" & Application("Server"))
%>
<BR>
<TABLE width="100%">
  <TR><TH colspan="3">Metabase Settings</TH></TR>
  <TR>
	  <TH>Property</TH>
	  <TH>Current Setting</TH>
	  <TH>Options</TH>
  </TR>
  <TR>
    <TH>Edit While Running</TH>
    <%
      If objIIS.EnableEditWhileRunning = 1 Then
        eewr_display = "Enabled"
        eewr_option = "Disable"
      Else
        eewr_display = "Disabled"
        eewr_option = "Enable"
      End If
    %>
    <TD class="values"><%=eewr_display%></TD>
    <TD class="options"><a class="man_link" href="manage_metabase.asp?action=switcheewr"><%=eewr_option%></a></TD>
  </TR>
  <TR>
    <TH>Keep History</TH>
    <%
      If objIIS.EnableHistory = 1 Then
        eh_display = "Enabled"
        eh_option = "Disable"
      Else
        eh_display = "Disabled"
        eh_option = "Enable"
      End If
    %>
    <TD class="values"><%=eh_display%></TD>
    <TD class="options"><a class="man_link" href="manage_metabase.asp?action=switcheh"><%=eh_option%></a></TD>
  </TR>
  <TR>
    <TH>History Files</TH>
    <TD class="values">Maximum History Files to keep: <%=objIIS.MaxHistoryFiles%></TD>
    <TD class="options"><a class="man_link" href="manage_metabase.asp?action=manmhf">Manage</a></TD>
  </TR>

  <TR><TH>Max Bandwidth</TH>
	  <TD class="values">
      <%
        maxband = objIIS.MaxBandwidth
        Select Case Application("IISVer")
          Case 5
            If maxband = -1 or maxband = 2000000000 Then maxBandDisplay = "Unlimited" Else maxBandDisplay = CInt(maxband / 1024) & " kb/s"
          Case 6
            If maxband > 33553408 Then maxband = 4294967295
            Select Case maxband
              Case -1
                maxBandDisplay = "Unlimited"
              Case 4294967295
                maxBandDisplay = "Unlimited"
              Case Else
                maxBandDisplay = (maxband / 1024) & " kb/s"
            End select
        End Select
        Response.write maxBandDisplay
      %>
    </TD>
	  <TD class="options"><a class="man_link" href="manage_metabase.asp?action=maxband">Manage</a></TD>
  </TR>


</TABLE>
<%
End Sub


Sub Manage_MHF(errs)
Set objIIS = GetObject("IIS://" & Application("Server"))
%>
<BR>
	<form method="POST" action="manage_metabase.asp">
	<Input Type=Hidden Name=action Value="change_mhf">
<TABLE>
  <TR><TH colspan="2">Maximum History Files to Keep</TH></TR>
  <% If Len(errs) Then %>
  <TR><TD colspan="2"><%=Errs%></TD></TR>
  <% End If %>
  <TR><TH>Current</TH><TD><%=objIIS.MaxHistoryFiles%></TD></TR>
  <TR><TH>New</TH><TD><input type="text" name="newmhf" id="GiveMeFocus" value="<%=objIIS.MaxHistoryFiles%>" size="10"></TD></TR>
  <TR><TH>&nbsp;</TH><TD><input type="submit" Value="Commit Modifications">&nbsp;&nbsp;<input type="submit" name="return" value="Return to Settings"></TD></TR>
</TABLE>
</form>
<%

End Sub

Sub MaxBandwidth(errs)
  Set objIIS = GetObject("IIS://" & Application("Server") & "/W3SVC")
  maxband = objIIS.MaxBandwidth

  Select Case Application("IISVer")
    Case "5"
      MaxBandUlimit = "2000000000"
    Case "6"
      MaxBandUlimit = "4294967295"
  End Select


  If maxband = -1 or maxband >= maxbandUlimit Then
    If Len(Request("MB")) Then 'Turn ON/OFF value entry textbox
      If Request("MBFlag") = 0 Then
        showhide = 0
        'By default set to 1024 if switching FROM unlimited
        maxbandUlimit = "1024"
      Else
        showhide = 1
      End If
    Else
      showhide = 1
    End If
  Else 'not unlimited
    If Len(Request("MB")) Then 'Turn ON/OFF value entry textbox
      If Request("MBFlag") = 0 Then
        showhide = 0
        maxbandUlimit = maxband / 1024
      Else
        showhide = 1
'         maxbandUlimit = maxband
      End If
    Else
      showhide = 0
      maxbandUlimit = maxband / 1024
    End If
  End If

  Select Case ShowHide
    Case 0 'Show
      maxbandDisplay = "<TD>" & maxbandUlimit & " kb/s</TD>"
      maxbandButton = "<TD><input type=""submit"" name=""MB"" value=""Switch to Unlimited""></TD></TR>"
      maxbandValue = "<TR><TH>Enter a value</TH><TD>&nbsp;</TD></TR>"
      maxbandValue = maxbandValue & "<TR><TD><input type=""text"" name=""MBValue"" value=""" & maxbandUlimit & """></TD>"
      maxbandValue = maxbandValue & "<TD><input type=""submit"" name""MBUpdate"" value=""Update""></TD></TR>"
      maxbandValue = maxbandValue & "<Input type=""Hidden"" name=""MBFlag"" value=""1"">"

    Case 1 'Hide
      maxbandDisplay = "<TR><TD>Unlimited</TD>"
      maxbandButton = "<TD><input type=""submit"" name=""MB"" value=""Enter a Value""></TD></TR>"
      maxbandButton = maxbandButton & "<TR><TD colspan=""2"">&nbsp;</TD></TR><TR><TD>&nbsp;</TD>"
      maxbandButton = maxbandButton & "<TD><input type=""submit"" name""MBUpdate"" value=""Update""></TD></TR>"
      maxbandValue = "<Input type=""Hidden"" name=""MBValue"" value=""" & maxbandUlimit & """><Input type=""Hidden"" name=""MBFlag"" value=""0"">"

  End Select

%>
<form name="theform" method="post" action="manage_metabase.asp?action=change_maxband">
  <TABLE>
    <TR><TH colspan="2">Manage Max Bandwidth</TH></TR>
    <% If Len(errs) Then %>
    <TR><TD colspan="2"><%=errs%></TD></TR>
    <% End If %>
    <TR><TH>Current Bandwidth</TH><TD>&nbsp;</TD></TR>
    <%= MaxBandDisplay%><%=MaxBandButton%>
    <%=MaxBandValue%>
    <TR><TD colspan="2">&nbsp;</TD></TR>
    <TR><TD colspan="2"><input type="submit" name="return" value="Return"></TD></TR>
  </TABLE>
</form>
<%
End Sub

%>
</div>
</body>
</html>



<%
Function Do_MakeBU
'On Error Resume Next
iFlags = (MD_BACKUP_SAVE_FIRST or MD_BACKUP_FORCE_BACKUP)
  Set objIIS = GetObject("IIS://" & Application("Server"))
  If Len(Request.Form("password")) Then
	objIIS.BackupWithPassword Request.Form("buname"), MD_BACKUP_NEXT_VERSION, iFlags, Request.Form("password")
  Else
	objIIS.Backup Request.Form("buname"), MD_BACKUP_NEXT_VERSION, iFlags
  End If
  Do_MakeBU = 1
End Function

Function Do_Restore
  Set objIIS = GetObject("IIS://" & Application("Server"))
	objIIS.Restore Request.QueryString("name"), Request.QueryString("ver"), 0
'	If Len(Request.Form("password")) Then
'	  ComputerObj.RestoreWithPassword Request.Form("buname"), Request.Form("version"), 0, Request.Form("password")
'	Else
'	  ComputerObj.Restore Request.Form("buname"), Request.Form("version"), 0
'	End If
  Do_Restore = 3
End Function

Function Do_Delete
  Set objIIS = GetObject("IIS://" & Application("Server"))
	objIIS.DeleteBackup Request.QueryString("name"), Request.QueryString("ver")
  Do_Delete = 2
End Function

Function SwitchEEWR
  Set objIIS = GetObject("IIS://" & Application("Server"))
  If objIIS.EnableEditWhileRunning = 1 Then objIIS.EnableEditWhileRunning = 0 Else objIIS.EnableEditWhileRunning = 1
  objIIS.SetInfo
  If err Then SwitchEEWR = err.description Else SwitchEEWR = ""
End Function

Function SwitchEH
  Set objIIS = GetObject("IIS://" & Application("Server"))
  If objIIS.EnableHistory = 1 Then objIIS.EnableHistory = 0 Else objIIS.EnableHistory = 1
  objIIS.SetInfo
  If err Then SwitchEH = err.description Else SwitchEH = ""
End Function

Function Change_MHF
  Set objIIS = GetObject("IIS://" & Application("Server"))
    objIIS.MaxHistoryFiles = Request("newmhf")
    objIIS.SetInfo
  If err Then Change_MHF = err.description Else Change_MHF = ""
End Function



Function Change_MaxBandwidth
On Error Resume Next
  Set objIIS = GetObject("IIS://" & Application("Server"))

  MBValue = Request("MBValue") 'From the form

  Select Case Application("IISVer")
    Case 5
      MBUpperLimit = "2000000000"
      If MBValue >= 2000000000 Then MBValue = MBUpperLimit
    Case 6
      MBUpperLimit = "4294967295"
      If MBValue > 33553408 Then MBValue = MBUpperLimit
  End Select
    If MBValue < MBUpperLimit Then MBValue = MBValue * 1024


  objIIS.MaxBandwidth = MBValue
  objIIS.SetInfo
  Set objIIS = Nothing

  If err Then Change_MaxBandwidth = "There was an error!<br>Err: " & Err.description Else Change_MaxBandwidth = "Updated!"

End Function

Function FormatDate(GMTDate)
On error resume Next
  DMY = Left(GMTDate,8)
  y = Left(DMY,4)
  d = Right(DMY,2)
  m = Right(DMY,4)
  m = Left(m,2)
  DMY = m & "/" & d & "/" & y
'
  TmpArr = Split(GMTDate,".")
  HMS = Right(TmpArr(0),6)

  h = Left(HMS,2)
  s = Right(HMS,2)
  m = Right(HMS,4)
  m = Left(m,2)
  HMS = (h) & ":" & m & ":" & s

  FormatDate = DMY & " " & FormatDateTime(HMS)
'   FormatDate = DMY & " " & HMS
  If err then
    FormatDate = DMY & " " & HMS
    err.clear
  End If


End Function

%>
