<%
'#################################################################################
'## IIS Admin Control Panel v 1.0
'#################################################################################
'## Copyright (C) 2005 Jake Gardner, Chris Hood
'##  from now on, referred to as "we" or "us"
'##
'##   This is a legally binding agreement between you and us, the developers
'## of the software program ("IIS Admin Control Panel") which you are about to
'## accept through electronic distribution (downloading).  By downloading and
'## using this software you are agreeing and will have agreed to be bound by
'## the terms set forth below.
'##
'##   License Grant and Restrictions. We grant you and you accept a
'## non-exclusive license to use the IIS Admin Control Panel but you do not
'## acquire any rights of ownership or distribution in whole or part. We are
'## the exclusive owners of the IIS Admin Control Panel which is copyrighted.
'## This license permits you to use and modify the IIS Admin Control Panel for
'## your personal or company. You may not rent, lease, sub-license, assign,
'## loan, create a derivative work based on content or otherwise use or
'## transfer use of the Software or any part thereof to others. You may not
'## reverse engineer, reverse compile, disassemble or otherwise modify the
'## Software in any way.  You may not remove any proprietary notices that are
'## provided with or within the software and/or sourcecode.  Neither the
'## Software nor any underlying information or technology may be exported or
'## re-exported into any country to which the United States has prohibited
'## export.
'##
'##   No Warranties. You acknowledge that the software has been provided to you
'## free of charge for your personal use and evaluation. You assume
'## responsibility for the selection of the software to achieve your intended
'## results and for the proper installation, use and results obtained from use
'## of the IIS Admin Control Panel. WE MAKE NO REPRESENTATION OR WARRANTY OF
'## ANY KIND WITH RESPECT TO THE SOFTWARE OR THE RESULTS OBTAINED OR TO BE
'## OBTAINED FROM ITS USE. WE DO NOT WARRANT THAT YOUR USE OF THE SOFTWARE WILL
'## BE UNINTERRUPTED, ERROR-FREE OR VIRUS-FREE.  ALL WARRANTIES, EXPRESS OR
'## IMPLIED, INCLUDING THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
'## PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE HEREBY EXPRESSLY DISCLAIMED.
'## WE EXPRESSLY DISCLAIM ANY IMPLIED WARRANTY THAT ANY OTHER PRODUCT
'## (INCLUDING WITHOUT LIMITATION ANY COPY OF THE SOFTWARE YOU MAY SUBSEQUENTLY
'## PURCHASE) WILL CONFORM TO THE SOFTWARE PROVIDED TO YOU UNDER THIS
'## AGREEMENT.
'##
'##   IN NO EVENT SHALL WE OR THEIR SUPPLIERS OR DISTRIBUTOR(S) OR AGENTS BE
'## LIABLE FOR ANY DAMAGE ARISING OUT OF OR RELATED TO THE USE OF THIS PRODUCT,
'## INCLUDING WITHOUT LIMITATION ACTUAL, DIRECT, SPECIAL, CONSEQUENTIAL,
'## INDIRECT, EXEMPLARY OR PUNITIVE DAMAGES, WHETHER OR NOT SUCH DAMAGES WERE
'## FORESEEABLE AND EVEN IF WE WERE ADVISED THAT SUCH DAMAGES WERE LIKELY OR
'## POSSIBLE.
'##
'## Support can be obtained from our support forums at:
'## http://www.iisactive.com
'##
'## Correspondence and Marketing Questions can be sent to:
'## iacp@iisactive.com
'##
'#################################################################################


On Error Resume Next

disperr = ""
If LCase(Request.QueryString("action")) = "delete" Then Call Remove_Group
If Len(request("group")) Then GroupName = Request("group")

If GroupName <> "" Then Set GroupObj = GetObject("WinNT://" & Application("domain") & "/" & Application("Server") & "/" & GroupName & ",group" )
Set BaseObj = GetObject("WinNT://" & Application("domain") & "/" & Application("Server"))

If Len(Request.QueryString("action")) Then

  'Build the ADsPath, needed for Active Directory & NON-AD compatibility
  Set TempObj = GetObject("WinNT://" & Application("domain") & "/" & Application("Server") & "/Administrators,group" )
    For each user in TempObj.members
      If InStr(LCase(user.ADsPath),"administrator") Then
        baseAdsPath = Left(user.AdsPath,(Len(user.ADsPath)-13))
        Exit For
      End If
    Next

	For i = 1 To Request.Form("user").Count
    UserPath = baseADsPath & request.form("user")(i)
	  Select Case LCase(Request.QueryString("action"))
		Case "add"
		  GroupObj.Add(UserPath)
		Case "remove"
		  GroupObj.Remove(UserPath)
	  End Select

	  If err then disperr = disperr & "ERROR: #" & err.number & " > " & err.description & " USER: " & user & " ADSIPATH: " & UserPath & "<BR>"
	  err.clear

	Next
End If

Sub BuildLists(groupname,memberlist,nonmemberlist)
  'Build the ADsPath, needed for Active Directory & NON-AD compatibility
  Set TempObj = GetObject("WinNT://" & Application("domain") & "/" & Application("Server") & "/Administrators,group" )
    For each user in TempObj.members
      If InStr(LCase(user.ADsPath),"administrator") Then
        baseAdsPath = Left(user.AdsPath,(Len(user.ADsPath)-Len("administrator")))
        Exit For
      End If
    Next

  memberlist = "<select multiple name=""user"" size=""10"">" & vbcrlf
  nonmemberlist = "<select multiple name=""user"" size=""10"">" & vbcrlf

Set GroupObj = GetObject("WinNT://" & Application("domain") & "/" & Application("Server") & "/" & GroupName & ",group" )
Set Baseobj = GetObject("WinNT://" & Application("domain") & "/" & Application("Server"))
  BaseObj.Filter = Array("User")

	For Each User in BaseObj
	  UsrAdsPath = baseAdsPath & User.Name
		If GroupObj.IsMember(UsrADsPath) Then
		  memberlist = memberlist & "<option value=""" & User.Name & """>" & User.Name & "</option>" & vbcrlf
		Else
		  nonmemberlist = nonmemberlist & "<option value=""" & User.Name & """>" & User.Name & "</option>" & vbcrlf
		End If
	Next

  memberlist = memberlist & "</select>" & vbcrlf
  nonmemberlist = nonmemberlist & "</select>" & vbcrlf

End Sub

Sub Remove_Group()
Set objServer = GetObject("WinNT://" & Application("Server"))
  objServer.Delete "group", Request.QueryString("group")
Response.Redirect "display_usergroup.asp"
End Sub

%>
<!-- #INCLUDE FILE="common/head.inc" -->
<SCRIPT LANGUAGE="JavaScript">
<!--
function checkSelect(input) {
  if (input.selectedIndex == 0) {
	alert("Please select a group.");
  return false;
  }
return true;
}
//-->
</script>

<DIV id="maincontent">

<TABLE width="100%">
  <TR>
	  <TH colspan="7">User and Group Services</TH>
  </TR>
  <TR>
  	<TD>
	    <a class="man_link" href="display_usergroup.asp?action=showuser">Show All Users</a>
	  </TD>
	  <TD>
	    <a class="man_link" href="display_usergroup.asp?action=finduser">Search for a User</a>
	  </TD>
	  <TD>
	    <a class="man_link" href="newuser.asp">New User</a>
	  </TD>
	  <TD rowspan="2">
	    <a class="man_link" href="manage_quotas.asp">Quota Manager</a>
	  </TD>
  </TR>
  <TR>
	  <TD>
	    <a class="man_link" href="display_usergroup.asp?action=showgroup">Show All Groups</a>
	  </TD>
	  <TD>
	    <a class="man_link" href="display_usergroup.asp?action=findgroup">Search for a Group</a>
	  </TD>
	  <TD>
	    <a class="man_link" href="newgroup.asp">New Group</a>
	  </TD>
  </TR>
</TABLE>

<TABLE width="75%">
  <TR><TH colspan="3">Group Membership for: <%=GroupName%></th></tr>

<% If GroupName = "" Then %>

  <TR>
	<TD>
	  <form method="POST" action="manage_group.asp" onSubmit="return checkSelect(this.group) ; ">
		<select name="group">
		<%
		  strFilter = Array("Group")
		  BaseObj.Filter= strFilter
		  Response.write "<option>---- Select a Group ----</option>" & vbcrlf
		  For Each Member in BaseObj
			Response.write "<option value=""" & member.name & """>" & Member.Name & "</option>" & vbcrlf
		  Next
		%>
		</select>
		<input type="submit" value="Manage">
	  </form>
	  </td>
  </tr>

<%
Else
  memberlist = ""
  nonmemberlist = ""
  server.ScriptTimeout = 300
  Call BuildLists(groupname, memberlist, nonmemberlist)
%>

  <tr>
	<TH>Not Members</TH>
	<TD>&nbsp;</td>
	<TH>Members</TH>
  </tr>
  <tr>
	<TD>
	  <form method="post" action="manage_group.asp?action=add&group=<%=GroupName%>">
	  <%=NonMemberList %>
	</td>
	<TD>
	  <input type="submit" value="Add ->">
	  </form>
	  <form method="post" action="manage_group.asp?action=remove&group=<%=GroupName%>">
	  <input type="submit" value="<- Remove">
	</td>
	<TD>
	  <%=MemberList %>
	  </form>
	</td>
  </tr>
  <tr>
	<TD colspan="3">
	  <form method="POST" action="manage_group.asp" onSubmit="return checkSelect(this.group);">
		<select name="group">
	  <%
		BaseObj.Filter= Array("Group")
		Response.write "<option>---- Select a Group ----</option>" & vbcrlf
		For Each Member in BaseObj
		  Response.write "<option value=""" & member.name & """>" & Member.Name & "</option>" & vbcrlf
		Next
	  %>
	  </select>
		<input type="submit" value="Manage">
		</form>
	</td>
  </tr>
  <TR>
	<TH>Delete Group</TH>
	  <TD class="values">This will Delete the Group not the Users!<BR> If you plan on using this group in the future, just remove the users for now.</TD>
	<TD class="options"><a class="man_link" href="manage_group.asp?action=delete&group=<%=GroupName%>">Delete</a></TD>
  </TR>
  <% If disperr <> "" Then Response.Write "<TR><TD colspan=""3"">" & disperr & "</TD></TR>" %>
</table>

<%
End If


%>

</DIV>
</BODY>
</HTML>
